/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.builder.JavaBuilder;

public class ReferenceCollection {
    char[][][] qualifiedNameReferences;
    char[][] simpleNameReferences;
    static final char[][][] WellKnownQualifiedNames = new char[][][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION, TypeConstants.JAVA_LANG_THROWABLE, TypeConstants.JAVA_LANG_OBJECT, TypeConstants.JAVA_LANG, new char[][]{TypeConstants.JAVA}, new char[][]{{'o', 'r', 'g'}}, new char[][]{{'c', 'o', 'm'}}, CharOperation.NO_CHAR_CHAR};
    static final char[][] WellKnownSimpleNames = new char[][]{TypeConstants.JAVA_LANG_RUNTIMEEXCEPTION[2], TypeConstants.JAVA_LANG_THROWABLE[2], TypeConstants.JAVA_LANG_OBJECT[2], TypeConstants.JAVA, TypeConstants.LANG, {'o', 'r', 'g'}, {'c', 'o', 'm'}};
    static final char[][][] EmptyQualifiedNames = new char[0][][];
    static final char[][] EmptySimpleNames = CharOperation.NO_CHAR_CHAR;
    static final int MaxQualifiedNames = 7;
    static ArrayList[] InternedQualifiedNames = new ArrayList[7];
    static final int MaxSimpleNames = 30;
    static ArrayList[] InternedSimpleNames = new ArrayList[30];

    static {
        int i = 0;
        while (i < 7) {
            ReferenceCollection.InternedQualifiedNames[i] = new ArrayList(37);
            ++i;
        }
        i = 0;
        while (i < 30) {
            ReferenceCollection.InternedSimpleNames[i] = new ArrayList(11);
            ++i;
        }
    }

    public ReferenceCollection(char[][][] qualifiedNameReferences, char[][] simpleNameReferences) {
        this.qualifiedNameReferences = ReferenceCollection.internQualifiedNames(qualifiedNameReferences);
        this.simpleNameReferences = ReferenceCollection.internSimpleNames(simpleNameReferences, true);
    }

    boolean includes(char[] simpleName) {
        int i = 0;
        int l = this.simpleNameReferences.length;
        while (i < l) {
            if (simpleName == this.simpleNameReferences[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    boolean includes(char[][] qualifiedName) {
        int i = 0;
        int l = this.qualifiedNameReferences.length;
        while (i < l) {
            if (qualifiedName == this.qualifiedNameReferences[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean includes(char[][][] qualifiedNames, char[][] simpleNames) {
        if (simpleNames == null || qualifiedNames == null) {
            if (simpleNames == null && qualifiedNames == null) {
                if (JavaBuilder.DEBUG) {
                    System.out.println("Found well known match");
                }
                return true;
            }
            if (qualifiedNames == null) {
                int i = 0;
                int l = simpleNames.length;
                while (i < l) {
                    if (this.includes(simpleNames[i])) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found match in well known package to " + new String(simpleNames[i]));
                        }
                        return true;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                int l = qualifiedNames.length;
                while (i < l) {
                    char[][] qualifiedName = qualifiedNames[i];
                    if (qualifiedName.length == 1 ? this.includes(qualifiedName[0]) : this.includes(qualifiedName)) {
                        if (JavaBuilder.DEBUG) {
                            System.out.println("Found well known match in " + CharOperation.toString(qualifiedName));
                        }
                        return true;
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            int l = simpleNames.length;
            while (i < l) {
                if (this.includes(simpleNames[i])) {
                    int j = 0;
                    int m = qualifiedNames.length;
                    while (j < m) {
                        char[][] qualifiedName = qualifiedNames[j];
                        if (qualifiedName.length == 1 ? this.includes(qualifiedName[0]) : this.includes(qualifiedName)) {
                            if (JavaBuilder.DEBUG) {
                                System.out.println("Found match in " + CharOperation.toString(qualifiedName) + " to " + new String(simpleNames[i]));
                            }
                            return true;
                        }
                        ++j;
                    }
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    public static char[][][] internQualifiedNames(ArrayList qualifiedStrings) {
        if (qualifiedStrings == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedStrings.size();
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] result = new char[length][][];
        int i = 0;
        while (i < length) {
            result[i] = CharOperation.splitOn('/', ((String)qualifiedStrings.get(i)).toCharArray());
            ++i;
        }
        return ReferenceCollection.internQualifiedNames(result);
    }

    static char[][][] internQualifiedNames(char[][][] qualifiedNames) {
        if (qualifiedNames == null) {
            return EmptyQualifiedNames;
        }
        int length = qualifiedNames.length;
        if (length == 0) {
            return EmptyQualifiedNames;
        }
        char[][][] keepers = new char[length][][];
        int index = 0;
        int i = 0;
        while (i < length) {
            block9: {
                char[][] qualifiedName = qualifiedNames[i];
                int qLength = qualifiedName.length;
                int j = 0;
                int m = WellKnownQualifiedNames.length;
                while (j < m) {
                    char[][] wellKnownName = WellKnownQualifiedNames[j];
                    if (qLength > wellKnownName.length) break;
                    if (!CharOperation.equals(qualifiedName, wellKnownName)) {
                        ++j;
                        continue;
                    }
                    break block9;
                }
                ArrayList internedNames = InternedQualifiedNames[qLength <= 7 ? qLength - 1 : 0];
                int j2 = 0;
                int m2 = internedNames.size();
                while (j2 < m2) {
                    char[][] internedName = (char[][])internedNames.get(j2);
                    if (CharOperation.equals(qualifiedName, internedName)) {
                        keepers[index++] = internedName;
                        break block9;
                    }
                    ++j2;
                }
                qualifiedName = ReferenceCollection.internSimpleNames(qualifiedName, false);
                internedNames.add(qualifiedName);
                keepers[index++] = qualifiedName;
            }
            ++i;
        }
        if (length > index) {
            if (length == 0) {
                return EmptyQualifiedNames;
            }
            char[][][] cArray = keepers;
            keepers = new char[index][][];
            System.arraycopy(cArray, 0, keepers, 0, index);
        }
        return keepers;
    }

    public static char[][] internSimpleNames(ArrayList simpleStrings) {
        if (simpleStrings == null) {
            return EmptySimpleNames;
        }
        int length = simpleStrings.size();
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] result = new char[length][];
        int i = 0;
        while (i < length) {
            result[i] = ((String)simpleStrings.get(i)).toCharArray();
            ++i;
        }
        return ReferenceCollection.internSimpleNames(result, true);
    }

    static char[][] internSimpleNames(char[][] simpleNames, boolean removeWellKnown) {
        if (simpleNames == null) {
            return EmptySimpleNames;
        }
        int length = simpleNames.length;
        if (length == 0) {
            return EmptySimpleNames;
        }
        char[][] keepers = new char[length][];
        int index = 0;
        int i = 0;
        while (i < length) {
            block10: {
                char[] name = simpleNames[i];
                int sLength = name.length;
                int j = 0;
                int m = WellKnownSimpleNames.length;
                while (j < m) {
                    char[] wellKnownName = WellKnownSimpleNames[j];
                    if (sLength > wellKnownName.length) break;
                    if (CharOperation.equals(name, wellKnownName)) {
                        if (!removeWellKnown) {
                            keepers[index++] = WellKnownSimpleNames[j];
                        }
                        break block10;
                    }
                    ++j;
                }
                ArrayList internedNames = InternedSimpleNames[sLength < 30 ? sLength : 0];
                int j2 = 0;
                int m2 = internedNames.size();
                while (j2 < m2) {
                    char[] internedName = (char[])internedNames.get(j2);
                    if (CharOperation.equals(name, internedName)) {
                        keepers[index++] = internedName;
                        break block10;
                    }
                    ++j2;
                }
                internedNames.add(name);
                keepers[index++] = name;
            }
            ++i;
        }
        if (length > index) {
            if (index == 0) {
                return EmptySimpleNames;
            }
            char[][] cArray = keepers;
            keepers = new char[index][];
            System.arraycopy(cArray, 0, keepers, 0, index);
        }
        return keepers;
    }
}

