/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.jdom.IDOMMethod;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;
import org.eclipse.jdt.internal.core.SourceMethodElementInfo;
import org.eclipse.jdt.internal.core.Util;

class SourceMethod
extends Member
implements IMethod {
    protected String[] fParameterTypes;
    protected static final String[] fgEmptyList = new String[0];

    protected SourceMethod(IType parent, String name, String[] parameterTypes) {
        super(9, parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
        this.fParameterTypes = parameterTypes == null ? fgEmptyList : parameterTypes;
    }

    public boolean equals(Object o) {
        return super.equals(o) && Util.equalArraysOrNull(this.fParameterTypes, ((SourceMethod)o).fParameterTypes);
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        if (node.getNodeType() == 6) {
            IDOMMethod m = (IDOMMethod)node;
            if (this.isConstructor()) {
                return (m.isConstructor() || m.getName().equals(this.getElementName())) && this.signatureEquals(m);
            }
            return super.equalsDOMNode(node) && this.signatureEquals(m);
        }
        return false;
    }

    public String[] getExceptionTypes() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] exs = info.getExceptionTypeNames();
        return CompilationUnitStructureRequestor.convertTypeNamesToSigs(exs);
    }

    public String getHandleMemento() {
        StringBuffer buff = new StringBuffer(((JavaElement)this.getParent()).getHandleMemento());
        buff.append(this.getHandleMementoDelimiter());
        buff.append(this.getElementName());
        int i = 0;
        while (i < this.fParameterTypes.length) {
            buff.append(this.getHandleMementoDelimiter());
            buff.append(this.fParameterTypes[i]);
            ++i;
        }
        return buff.toString();
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public int getNumberOfParameters() {
        return this.fParameterTypes == null ? 0 : this.fParameterTypes.length;
    }

    public String[] getParameterNames() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        char[][] names = info.getArgumentNames();
        if (names == null || names.length == 0) {
            return fgEmptyList;
        }
        String[] strings = new String[names.length];
        int i = 0;
        while (i < names.length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    public String[] getParameterTypes() {
        return this.fParameterTypes;
    }

    public String getReturnType() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return Signature.createTypeSignature(info.getReturnTypeName(), false);
    }

    public String getSignature() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.getSignature();
    }

    public boolean isConstructor() throws JavaModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    public boolean isMainMethod() throws JavaModelException {
        return this.isMainMethod(this);
    }

    public boolean isSimilar(IMethod method) {
        return this.areSimilarMethods(this.getElementName(), this.getParameterTypes(), method.getElementName(), method.getParameterTypes(), null);
    }

    public String readableName() {
        int length;
        StringBuffer buffer = new StringBuffer(super.readableName());
        buffer.append('(');
        String[] parameterTypes = this.getParameterTypes();
        if (parameterTypes != null && (length = parameterTypes.length) > 0) {
            int i = 0;
            while (i < length) {
                buffer.append(Signature.toString(parameterTypes[i]));
                if (i < length - 1) {
                    buffer.append(", ");
                }
                ++i;
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected boolean signatureEquals(IDOMMethod method) throws JavaModelException {
        String[] otherTypes = method.getParameterTypes();
        String[] types = this.getParameterTypes();
        boolean ok = true;
        if (otherTypes == null || otherTypes.length == 0) {
            ok = types == null || types.length == 0;
        } else if (types != null) {
            ok = otherTypes.length == types.length;
        } else {
            return false;
        }
        if (ok && types != null) {
            int i = 0;
            while (i < types.length) {
                String otherType = Signature.createTypeSignature(otherTypes[i].toCharArray(), false);
                if (!types[i].equals(otherType)) {
                    ok = false;
                    break;
                }
                ++i;
            }
        }
        return ok;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                int length;
                if (Flags.isStatic(this.getFlags())) {
                    buffer.append("static ");
                }
                if (!this.isConstructor()) {
                    buffer.append(Signature.toString(this.getReturnType()));
                    buffer.append(' ');
                }
                buffer.append(this.getElementName());
                buffer.append('(');
                String[] parameterTypes = this.getParameterTypes();
                if (parameterTypes != null && (length = parameterTypes.length) > 0) {
                    int i = 0;
                    while (i < length) {
                        buffer.append(Signature.toString(parameterTypes[i]));
                        if (i < length - 1) {
                            buffer.append(", ");
                        }
                        ++i;
                    }
                }
                buffer.append(')');
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

