/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.Serializer;
import org.apache.xml.serialize.SerializerFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.eval.IEvaluationContext;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.compiler.util.ObjectVector;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.DeltaProcessor;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProjectElementInfo;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SetClasspathOperation;
import org.eclipse.jdt.internal.core.SourceMapper;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.eval.EvaluationContextWrapper;
import org.eclipse.jdt.internal.eval.EvaluationContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JavaProject
extends Openable
implements IJavaProject,
IProjectNature {
    protected static final boolean IS_CASE_SENSITIVE = !new File("Temp").equals(new File("temp"));
    protected static final String[] NO_PREREQUISITES = new String[0];
    protected IProject fProject;
    public static final String CLASSPATH_FILENAME = ".classpath";
    public static final String PREF_FILENAME = ".jprefs";
    public static final IClasspathEntry[] INVALID_CLASSPATH = new IClasspathEntry[0];
    private static final String CUSTOM_DEFAULT_OPTION_VALUE = "#\r\n\r#custom-non-empty-default-value#\r\n\r#";

    public static IPath canonicalizedPath(IPath externalPath) {
        IPath result;
        if (externalPath == null) {
            return null;
        }
        if (IS_CASE_SENSITIVE) {
            return externalPath;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return externalPath;
        }
        if (workspace.getRoot().findMember(externalPath) != null) {
            return externalPath;
        }
        Path canonicalPath = null;
        try {
            canonicalPath = new Path(new File(externalPath.toOSString()).getCanonicalPath());
        }
        catch (IOException e) {
            return externalPath;
        }
        int canonicalLength = canonicalPath.segmentCount();
        if (canonicalLength == 0) {
            return externalPath;
        }
        if (externalPath.isAbsolute()) {
            result = canonicalPath;
        } else {
            int externalLength = externalPath.segmentCount();
            if (canonicalLength >= externalLength) {
                result = canonicalPath.removeFirstSegments(canonicalLength - externalLength);
            } else {
                return externalPath;
            }
        }
        if (externalPath.getDevice() == null) {
            result = result.setDevice(null);
        }
        return result;
    }

    public JavaProject() {
        super(2, null, null);
    }

    public JavaProject(IProject project, IJavaElement parent) {
        super(2, parent, project.getName());
        this.fProject = project;
    }

    protected void addToBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand javaCommand = this.getJavaCommand(description);
        if (javaCommand == null) {
            ICommand command = description.newCommand();
            command.setBuilderName(builderID);
            this.setJavaCommand(description, command);
        }
    }

    protected void closing(Object info) throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i] instanceof JarPackageFragmentRoot) {
                ((JarPackageFragmentRoot)roots[i]).setSourceAttachmentProperty(null);
            }
            ++i;
        }
        super.closing(info);
    }

    private void computeExpandedClasspath(JavaProject initialProject, boolean ignoreUnresolvedVariable, boolean generateMarkerOnError, HashSet visitedProjects, ObjectVector accumulatedEntries) throws JavaModelException {
        if (visitedProjects.contains(this)) {
            return;
        }
        visitedProjects.add(this);
        if (generateMarkerOnError && !this.equals(initialProject)) {
            generateMarkerOnError = false;
        }
        IClasspathEntry[] immediateClasspath = this.getResolvedClasspath(ignoreUnresolvedVariable, generateMarkerOnError);
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        int i = 0;
        int length = immediateClasspath.length;
        while (i < length) {
            IClasspathEntry entry = immediateClasspath[i];
            boolean isInitialProject = this.equals(initialProject);
            if (isInitialProject || entry.isExported()) {
                IProject projRsc;
                IResource member;
                accumulatedEntries.add(entry);
                if (entry.getEntryKind() == 2 && (member = workspaceRoot.findMember(entry.getPath())) != null && member.getType() == 4 && JavaProject.hasJavaNature(projRsc = (IProject)member)) {
                    JavaProject project = (JavaProject)JavaCore.create(projRsc);
                    project.computeExpandedClasspath(initialProject, ignoreUnresolvedVariable, generateMarkerOnError, visitedProjects, accumulatedEntries);
                }
            }
            ++i;
        }
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IClasspathEntry[] resolvedClasspath, boolean retrieveExportedRoots) throws JavaModelException {
        ObjectVector accumulatedRoots = new ObjectVector();
        this.computePackageFragmentRoots(resolvedClasspath, accumulatedRoots, new HashSet(5), true, true, retrieveExportedRoots);
        Object[] rootArray = new IPackageFragmentRoot[accumulatedRoots.size()];
        accumulatedRoots.copyInto(rootArray);
        return rootArray;
    }

    public IPackageFragmentRoot[] computePackageFragmentRoots(IClasspathEntry resolvedEntry) {
        try {
            return this.computePackageFragmentRoots(new IClasspathEntry[]{resolvedEntry}, false);
        }
        catch (JavaModelException e) {
            return new IPackageFragmentRoot[0];
        }
    }

    public void computePackageFragmentRoots(IClasspathEntry resolvedEntry, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws JavaModelException {
        String rootID = ((ClasspathEntry)resolvedEntry).rootID();
        if (rootIDs.contains(rootID)) {
            return;
        }
        IPath projectPath = this.getProject().getFullPath();
        IPath entryPath = resolvedEntry.getPath();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        switch (resolvedEntry.getEntryKind()) {
            case 3: {
                if (!projectPath.isPrefixOf(entryPath)) break;
                if (checkExistency) {
                    Object target = JavaModel.getTarget(workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (!(target instanceof IFolder) && !(target instanceof IProject)) break;
                    accumulatedRoots.add(this.getPackageFragmentRoot((IResource)target));
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getFolderPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 1: {
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                if (checkExistency) {
                    Object target = JavaModel.getTarget(workspaceRoot, entryPath, checkExistency);
                    if (target == null) {
                        return;
                    }
                    if (target instanceof IResource) {
                        IResource resource = (IResource)target;
                        IPackageFragmentRoot root = this.getPackageFragmentRoot(resource);
                        if (root == null) break;
                        accumulatedRoots.add(root);
                        rootIDs.add(rootID);
                        break;
                    }
                    if (!((File)target).isFile() || !Util.isArchiveFileName(entryPath.lastSegment())) break;
                    accumulatedRoots.add(new JarPackageFragmentRoot(entryPath, (IJavaProject)this));
                    rootIDs.add(rootID);
                    break;
                }
                IPackageFragmentRoot root = this.getPackageFragmentRoot(entryPath);
                if (root == null) break;
                accumulatedRoots.add(root);
                rootIDs.add(rootID);
                break;
            }
            case 2: {
                IProject requiredProjectRsc;
                if (!retrieveExportedRoots) {
                    return;
                }
                if (!insideOriginalProject && !resolvedEntry.isExported()) {
                    return;
                }
                IResource member = workspaceRoot.findMember(entryPath);
                if (member == null || member.getType() != 4 || !JavaProject.hasJavaNature(requiredProjectRsc = (IProject)member)) break;
                rootIDs.add(rootID);
                JavaProject requiredProject = (JavaProject)JavaCore.create(requiredProjectRsc);
                requiredProject.computePackageFragmentRoots(requiredProject.getResolvedClasspath(true), accumulatedRoots, rootIDs, false, checkExistency, retrieveExportedRoots);
            }
        }
    }

    public void computePackageFragmentRoots(IClasspathEntry[] resolvedClasspath, ObjectVector accumulatedRoots, HashSet rootIDs, boolean insideOriginalProject, boolean checkExistency, boolean retrieveExportedRoots) throws JavaModelException {
        if (insideOriginalProject) {
            rootIDs.add(this.rootID());
        }
        int i = 0;
        int length = resolvedClasspath.length;
        while (i < length) {
            this.computePackageFragmentRoots(resolvedClasspath[i], accumulatedRoots, rootIDs, insideOriginalProject, checkExistency, retrieveExportedRoots);
            ++i;
        }
    }

    public String computeSharedPropertyFileName(QualifiedName qName) {
        return String.valueOf('.') + qName.getLocalName();
    }

    public void configure() throws CoreException {
        this.addToBuildSpec("org.eclipse.jdt.core.javabuilder");
    }

    public boolean contains(IResource resource) {
        IPath output;
        IClasspathEntry[] classpath;
        try {
            classpath = this.getResolvedClasspath(true);
            output = this.getOutputLocation();
        }
        catch (JavaModelException e) {
            return false;
        }
        IPath fullPath = resource.getFullPath();
        IPath innerMostOutput = output.isPrefixOf(fullPath) ? output : null;
        IClasspathEntry innerMostEntry = null;
        int j = 0;
        int cpLength = classpath.length;
        while (j < cpLength) {
            IPath entryOutput;
            IClasspathEntry entry = classpath[j];
            IPath entryPath = entry.getPath();
            if ((innerMostEntry == null || innerMostEntry.getPath().isPrefixOf(entryPath)) && entryPath.isPrefixOf(fullPath)) {
                innerMostEntry = entry;
            }
            if ((entryOutput = classpath[j].getOutputLocation()) != null && entryOutput.isPrefixOf(fullPath)) {
                innerMostOutput = entryOutput;
            }
            ++j;
        }
        if (innerMostEntry != null) {
            if (innerMostOutput != null && innerMostOutput.segmentCount() > 1 && innerMostEntry.getPath().segmentCount() == 1) {
                return false;
            }
            if (resource instanceof IFolder) {
                return true;
            }
            switch (innerMostEntry.getEntryKind()) {
                case 3: {
                    return !Util.isClassFileName(fullPath.lastSegment());
                }
                case 1: {
                    return !Util.isJavaFileName(fullPath.lastSegment());
                }
            }
        }
        return innerMostOutput == null;
    }

    IMarker createClasspathProblemMarker(IJavaModelStatus status) {
        int severity;
        IMarker marker = null;
        String[] arguments = new String[]{};
        boolean isCycleProblem = false;
        boolean isClasspathFileFormatProblem = false;
        switch (status.getCode()) {
            case 1001: {
                isCycleProblem = true;
                if ("error".equals(this.getOption("org.eclipse.jdt.core.circularClasspath", true))) {
                    severity = 2;
                    break;
                }
                severity = 1;
                break;
            }
            case 1000: {
                isClasspathFileFormatProblem = true;
                severity = 2;
                break;
            }
            default: {
                IPath path = status.getPath();
                if (path != null) {
                    arguments = new String[]{path.toString()};
                }
                severity = "error".equals(this.getOption("org.eclipse.jdt.core.incompleteClasspath", true)) ? 2 : 1;
            }
        }
        try {
            marker = this.getProject().createMarker("org.eclipse.jdt.core.buildpath_problem");
            marker.setAttributes(new String[]{"message", "severity", "location", "cycleDetected", "classpathFileFormat", "id", "arguments"}, new Object[]{status.getMessage(), new Integer(severity), Util.bind("classpath.buildPath"), isCycleProblem ? "true" : "false", isClasspathFileFormatProblem ? "true" : "false", new Integer(status.getCode()), Util.getProblemArgumentsForMarker(arguments)});
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return marker;
    }

    protected OpenableElementInfo createElementInfo() {
        return new JavaProjectElementInfo();
    }

    protected IClasspathEntry[] decodeClasspath(String xmlClasspath, boolean createMarker, boolean logProblems) {
        ArrayList<IClasspathEntry> paths = new ArrayList<IClasspathEntry>();
        IClasspathEntry defaultOutput = null;
        try {
            Element cpElement;
            if (xmlClasspath == null) {
                return null;
            }
            StringReader reader = new StringReader(xmlClasspath);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    cpElement = parser.parse(new InputSource(reader)).getDocumentElement();
                }
                catch (SAXException e) {
                    throw new IOException(Util.bind("file.badFormat"));
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(Util.bind("file.badFormat"));
                }
            }
            catch (Throwable throwable) {
                Object var9_16 = null;
                reader.close();
                throw throwable;
            }
            Object var9_17 = null;
            reader.close();
            if (!cpElement.getNodeName().equalsIgnoreCase("classpath")) {
                throw new IOException(Util.bind("file.badFormat"));
            }
            NodeList list = cpElement.getElementsByTagName("classpathentry");
            int length = list.getLength();
            int i = 0;
            while (i < length) {
                IClasspathEntry entry;
                Node node = list.item(i);
                if (node.getNodeType() == 1 && (entry = ClasspathEntry.elementDecode((Element)node, this)) != null) {
                    if (entry.getContentKind() == 10) {
                        defaultOutput = entry;
                    } else {
                        paths.add(entry);
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.xmlFormatError", this.getElementName(), e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_CLASSPATH;
        }
        catch (Assert.AssertionFailedException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.illegalEntryInClasspathFile", this.getElementName(), e.getMessage())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will mark classpath as invalid");
            }
            return INVALID_CLASSPATH;
        }
        int pathSize = paths.size();
        if (pathSize > 0 || defaultOutput != null) {
            IClasspathEntry[] entries = new IClasspathEntry[pathSize + (defaultOutput == null ? 0 : 1)];
            paths.toArray(entries);
            if (defaultOutput != null) {
                entries[pathSize] = defaultOutput;
            }
            return entries;
        }
        return null;
    }

    public void deconfigure() throws CoreException {
        this.removeFromBuildSpec("org.eclipse.jdt.core.javabuilder");
    }

    protected IClasspathEntry[] defaultClasspath() throws JavaModelException {
        return new IClasspathEntry[]{JavaCore.newSourceEntry(this.getProject().getFullPath())};
    }

    protected IPath defaultOutputLocation() throws JavaModelException {
        return this.getProject().getFullPath().append("bin");
    }

    protected String encodeClasspath(IClasspathEntry[] classpath, IPath outputLocation, boolean useLineSeparator) throws JavaModelException {
        DocumentImpl document = new DocumentImpl();
        Element cpElement = document.createElement("classpath");
        document.appendChild(cpElement);
        int i = 0;
        while (i < classpath.length) {
            cpElement.appendChild(((ClasspathEntry)classpath[i]).elementEncode(document, this.getProject().getFullPath()));
            ++i;
        }
        if (outputLocation != null) {
            outputLocation = outputLocation.removeFirstSegments(1);
            outputLocation = outputLocation.makeRelative();
            Element oElement = document.createElement("classpathentry");
            oElement.setAttribute("kind", ClasspathEntry.kindToString(10));
            oElement.setAttribute("path", outputLocation.toString());
            cpElement.appendChild(oElement);
        }
        try {
            ByteArrayOutputStream s = new ByteArrayOutputStream();
            OutputFormat format = new OutputFormat();
            if (useLineSeparator) {
                format.setIndenting(true);
                format.setLineSeparator(System.getProperty("line.separator"));
            } else {
                format.setPreserveSpace(true);
            }
            Serializer serializer = SerializerFactory.getSerializerFactory("xml").makeSerializer(new OutputStreamWriter((OutputStream)s, "UTF8"), format);
            serializer.asDOMSerializer().serialize(document);
            return s.toString("UTF8");
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaProject)) {
            return false;
        }
        JavaProject other = (JavaProject)o;
        return this.getProject().equals(other.getProject()) && this.fOccurrenceCount == other.fOccurrenceCount;
    }

    public boolean exists() {
        if (!JavaProject.hasJavaNature(this.fProject)) {
            return false;
        }
        return super.exists();
    }

    public IJavaElement findElement(IPath path) throws JavaModelException {
        if (path == null || path.isAbsolute()) {
            throw new JavaModelException(new JavaModelStatus(979, path));
        }
        try {
            String extension = path.getFileExtension();
            if (extension == null) {
                String packageName = path.toString().replace('/', '.');
                IPackageFragment[] pkgFragments = this.getNameLookup().findPackageFragments(packageName, false);
                if (pkgFragments == null) {
                    return null;
                }
                int i = 0;
                int length = pkgFragments.length;
                while (i < length) {
                    IPackageFragment pkgFragment = pkgFragments[i];
                    if (this.equals(pkgFragment.getParent().getParent())) {
                        return pkgFragment;
                    }
                    ++i;
                }
                return pkgFragments[0];
            }
            if (extension.equalsIgnoreCase("java") || extension.equalsIgnoreCase("class")) {
                IPath packagePath = path.removeLastSegments(1);
                String packageName = packagePath.toString().replace('/', '.');
                String typeName = path.lastSegment();
                typeName = typeName.substring(0, typeName.length() - extension.length() - 1);
                String qualifiedName = null;
                qualifiedName = packageName.length() > 0 ? String.valueOf(packageName) + "." + typeName : typeName;
                IType type = this.getNameLookup().findType(qualifiedName, false, 6);
                if (type != null) {
                    return type.getParent();
                }
                return null;
            }
            return null;
        }
        catch (JavaModelException e) {
            if (e.getStatus().getCode() == 969) {
                return null;
            }
            throw e;
        }
    }

    public IPackageFragment findPackageFragment(IPath path) throws JavaModelException {
        return this.findPackageFragment0(JavaProject.canonicalizedPath(path));
    }

    public IPackageFragment findPackageFragment0(IPath path) throws JavaModelException {
        return this.getNameLookup().findPackageFragment(path);
    }

    public IPackageFragmentRoot findPackageFragmentRoot(IPath path) throws JavaModelException {
        return this.findPackageFragmentRoot0(JavaProject.canonicalizedPath(path));
    }

    public IPackageFragmentRoot findPackageFragmentRoot0(IPath path) throws JavaModelException {
        IPackageFragmentRoot[] allRoots = this.getAllPackageFragmentRoots();
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(Util.bind("path.mustBeAbsolute"));
        }
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragmentRoot classpathRoot = allRoots[i];
            if (classpathRoot.getPath().equals(path)) {
                return classpathRoot;
            }
            ++i;
        }
        return null;
    }

    public IPackageFragmentRoot[] findPackageFragmentRoots(IClasspathEntry entry) {
        try {
            IClasspathEntry[] classpath = this.getRawClasspath();
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                if (classpath[i].equals(entry)) {
                    return this.computePackageFragmentRoots(this.getResolvedClasspath(new IClasspathEntry[]{entry}, null, true, false, null), false);
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return new IPackageFragmentRoot[0];
    }

    public IType findType(String fullyQualifiedName) throws JavaModelException {
        IType type = this.getNameLookup().findType(fullyQualifiedName, false, 6);
        if (type == null) {
            int lastDot = fullyQualifiedName.lastIndexOf(46);
            if (lastDot == -1) {
                return null;
            }
            type = this.findType(fullyQualifiedName.substring(0, lastDot));
            if (type != null && !(type = type.getType(fullyQualifiedName.substring(lastDot + 1))).exists()) {
                return null;
            }
        }
        return type;
    }

    public IType findType(String packageName, String typeQualifiedName) throws JavaModelException {
        return this.getNameLookup().findType(typeQualifiedName, packageName, false, 6);
    }

    protected void flushClasspathProblemMarkers(boolean flushCycleMarkers, boolean flushClasspathFormatMarkers) {
        try {
            IProject project = this.getProject();
            if (project.exists()) {
                IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    if (flushCycleMarkers && flushClasspathFormatMarkers) {
                        marker.delete();
                    } else {
                        String cycleAttr = (String)marker.getAttribute("cycleDetected");
                        String classpathFileFormatAttr = (String)marker.getAttribute("classpathFileFormat");
                        if (flushCycleMarkers == (cycleAttr != null && cycleAttr.equals("true")) && flushClasspathFormatMarkers == (classpathFileFormatAttr != null && classpathFileFormatAttr.equals("true"))) {
                            marker.delete();
                        }
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        boolean validInfo;
        block7: {
            validInfo = false;
            try {
                if (this.getProject().isOpen()) {
                    JavaModelManager.getJavaModelManager().putInfo(this, info);
                    this.updatePackageFragmentRoots();
                    IClasspathEntry[] resolvedClasspath = this.getResolvedClasspath(true);
                    int i = 0;
                    int length = resolvedClasspath.length;
                    while (i < length) {
                        IClasspathEntry entry = resolvedClasspath[i];
                        if (entry.getEntryKind() == 1) {
                            HashMap externalTimeStamps;
                            IPath path = entry.getPath();
                            Object target = JavaModel.getTarget(ResourcesPlugin.getWorkspace().getRoot(), path, true);
                            if (target instanceof File && (externalTimeStamps = JavaModelManager.getJavaModelManager().deltaProcessor.externalTimeStamps).get(path) == null) {
                                long timestamp = DeltaProcessor.getTimeStamp((File)target);
                                externalTimeStamps.put(path, new Long(timestamp));
                            }
                        }
                        ++i;
                    }
                    validInfo = true;
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                if (!validInfo) {
                    JavaModelManager.getJavaModelManager().removeInfo(this);
                }
                throw throwable;
            }
            Object var15_16 = null;
            if (validInfo) break block7;
            JavaModelManager.getJavaModelManager().removeInfo(this);
        }
        return validInfo;
    }

    public IPackageFragmentRoot[] getAllPackageFragmentRoots() throws JavaModelException {
        return this.computePackageFragmentRoots(this.getResolvedClasspath(true), true);
    }

    public IClasspathEntry getClasspathEntryFor(IPath path) throws JavaModelException {
        IClasspathEntry[] entries = this.getExpandedClasspath(true);
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals(path)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    public IMarker getCycleMarker() {
        try {
            IProject project = this.getProject();
            if (project.exists()) {
                IMarker[] markers = project.findMarkers("org.eclipse.jdt.core.buildpath_problem", false, 0);
                int i = 0;
                int length = markers.length;
                while (i < length) {
                    IMarker marker = markers[i];
                    String cycleAttr = (String)marker.getAttribute("cycleDetected");
                    if (cycleAttr != null && cycleAttr.equals("true")) {
                        return marker;
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return null;
    }

    public IClasspathEntry[] getExpandedClasspath(boolean ignoreUnresolvedVariable) throws JavaModelException {
        return this.getExpandedClasspath(ignoreUnresolvedVariable, false);
    }

    public IClasspathEntry[] getExpandedClasspath(boolean ignoreUnresolvedVariable, boolean generateMarkerOnError) throws JavaModelException {
        ObjectVector accumulatedEntries = new ObjectVector();
        this.computeExpandedClasspath(this, ignoreUnresolvedVariable, generateMarkerOnError, new HashSet(5), accumulatedEntries);
        Object[] expandedPath = new IClasspathEntry[accumulatedEntries.size()];
        accumulatedEntries.copyInto(expandedPath);
        return expandedPath;
    }

    protected char getHandleMementoDelimiter() {
        return '=';
    }

    private ICommand getJavaCommand(IProjectDescription description) throws CoreException {
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.jdt.core.javabuilder")) {
                return commands[i];
            }
            ++i;
        }
        return null;
    }

    protected JavaProjectElementInfo getJavaProjectElementInfo() throws JavaModelException {
        return (JavaProjectElementInfo)this.getElementInfo();
    }

    public NameLookup getNameLookup() throws JavaModelException {
        JavaProjectElementInfo info;
        JavaProjectElementInfo javaProjectElementInfo = info = this.getJavaProjectElementInfo();
        synchronized (javaProjectElementInfo) {
            NameLookup nameLookup = info.getNameLookup();
            if (nameLookup == null) {
                nameLookup = new NameLookup(this);
                info.setNameLookup(nameLookup);
            }
            return nameLookup;
        }
    }

    public Object[] getNonJavaResources() throws JavaModelException {
        return ((JavaProjectElementInfo)this.getElementInfo()).getNonJavaResources(this);
    }

    public String getOption(String optionName, boolean inheritJavaCoreOptions) {
        if (JavaModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = this.getPreferences();
            if (preferences == null || preferences.isDefault(optionName)) {
                return inheritJavaCoreOptions ? JavaCore.getOption(optionName) : null;
            }
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public Map getOptions(boolean inheritJavaCoreOptions) {
        String propertyName;
        int i;
        Hashtable options = inheritJavaCoreOptions ? JavaCore.getOptions() : new Hashtable(5);
        Preferences preferences = this.getPreferences();
        if (preferences == null) {
            return options;
        }
        HashSet optionNames = JavaModelManager.OptionNames;
        if (inheritJavaCoreOptions) {
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            i = 0;
            while (i < defaultPropertyNames.length) {
                propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName).trim());
                }
                ++i;
            }
        }
        String[] propertyNames = preferences.propertyNames();
        i = 0;
        while (i < propertyNames.length) {
            propertyName = propertyNames[i];
            if (optionNames.contains(propertyName)) {
                options.put(propertyName, preferences.getString(propertyName).trim());
            }
            ++i;
        }
        return options;
    }

    public IPath getOutputLocation() throws JavaModelException {
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.fProject);
        IPath outputLocation = perProjectInfo.outputLocation;
        if (outputLocation != null) {
            return outputLocation;
        }
        this.getRawClasspath();
        outputLocation = perProjectInfo.outputLocation;
        if (outputLocation == null) {
            return this.defaultOutputLocation();
        }
        return outputLocation;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IPath path) {
        if (!path.isAbsolute()) {
            path = this.getPath().append(path);
        }
        int segmentCount = path.segmentCount();
        switch (segmentCount) {
            case 0: {
                return null;
            }
            case 1: {
                return this.getPackageFragmentRoot(this.getProject());
            }
        }
        if (Util.isArchiveFileName(path.lastSegment())) {
            IResource resource = this.getProject().getWorkspace().getRoot().findMember(path);
            if (resource != null && resource.getType() == 2) {
                return this.getPackageFragmentRoot(resource);
            }
            return this.getPackageFragmentRoot0(path);
        }
        return this.getPackageFragmentRoot(this.getProject().getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getFolderPackageFragmentRoot(IPath path) {
        if (path.segmentCount() == 1) {
            return this.getPackageFragmentRoot(this.getProject());
        }
        return this.getPackageFragmentRoot(this.getProject().getWorkspace().getRoot().getFolder(path));
    }

    public IPackageFragmentRoot getPackageFragmentRoot(IResource resource) {
        switch (resource.getType()) {
            case 1: {
                if (Util.isArchiveFileName(resource.getName())) {
                    return new JarPackageFragmentRoot(resource, (IJavaProject)this);
                }
                return null;
            }
            case 2: {
                return new PackageFragmentRoot(resource, this, resource.getName());
            }
            case 4: {
                return new PackageFragmentRoot(resource, this, "");
            }
        }
        return null;
    }

    public IPackageFragmentRoot getPackageFragmentRoot(String jarPath) {
        return this.getPackageFragmentRoot0(JavaProject.canonicalizedPath(new Path(jarPath)));
    }

    public IPackageFragmentRoot getPackageFragmentRoot0(IPath jarPath) {
        return new JarPackageFragmentRoot(jarPath, (IJavaProject)this);
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots() throws JavaModelException {
        IJavaElement[] children = this.getChildren();
        int length = children.length;
        IPackageFragmentRoot[] roots = new IPackageFragmentRoot[length];
        System.arraycopy(children, 0, roots, 0, length);
        return roots;
    }

    public IPackageFragmentRoot[] getPackageFragmentRoots(IClasspathEntry entry) {
        return this.findPackageFragmentRoots(entry);
    }

    protected IPackageFragmentRoot[] getPackageFragmentRoots(IPath path) throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getAllPackageFragmentRoots();
        ArrayList<IPackageFragmentRoot> matches = new ArrayList<IPackageFragmentRoot>();
        int i = 0;
        while (i < roots.length) {
            if (path.isPrefixOf(roots[i].getPath())) {
                matches.add(roots[i]);
            }
            ++i;
        }
        IPackageFragmentRoot[] copy = new IPackageFragmentRoot[matches.size()];
        matches.toArray(copy);
        return copy;
    }

    public IPackageFragment[] getPackageFragments() throws JavaModelException {
        IPackageFragmentRoot[] roots = this.getPackageFragmentRoots();
        return this.getPackageFragmentsInRoots(roots);
    }

    public IPackageFragment[] getPackageFragmentsInRoots(IPackageFragmentRoot[] roots) {
        ArrayList<IJavaElement> frags = new ArrayList<IJavaElement>();
        int i = 0;
        while (i < roots.length) {
            IPackageFragmentRoot root = roots[i];
            try {
                IJavaElement[] rootFragments = root.getChildren();
                int j = 0;
                while (j < rootFragments.length) {
                    frags.add(rootFragments[j]);
                    ++j;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        IPackageFragment[] fragments = new IPackageFragment[frags.size()];
        frags.toArray(fragments);
        return fragments;
    }

    public IPath getPath() {
        return this.getProject().getFullPath();
    }

    public IProject getProject() {
        return this.fProject;
    }

    public Preferences getPreferences() {
        IProject project = this.getProject();
        if (!JavaProject.hasJavaNature(project)) {
            return null;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(project, true);
        Preferences preferences = perProjectInfo.preferences;
        if (preferences != null) {
            return preferences;
        }
        preferences = this.loadPreferences();
        if (preferences == null) {
            preferences = new Preferences();
        }
        perProjectInfo.preferences = preferences;
        return preferences;
    }

    public IClasspathEntry[] getRawClasspath() throws JavaModelException {
        IClasspathEntry entry;
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.fProject);
        IClasspathEntry[] classpath = perProjectInfo.classpath;
        if (classpath != null) {
            return classpath;
        }
        classpath = this.readClasspathFile(false, true);
        IPath outputLocation = null;
        if (classpath != null && classpath.length > 0 && (entry = classpath[classpath.length - 1]).getContentKind() == 10) {
            outputLocation = entry.getPath();
            IClasspathEntry[] copy = new IClasspathEntry[classpath.length - 1];
            System.arraycopy(classpath, 0, copy, 0, copy.length);
            classpath = copy;
        }
        if (classpath == null) {
            return this.defaultClasspath();
        }
        perProjectInfo.classpath = classpath;
        perProjectInfo.outputLocation = outputLocation;
        return classpath;
    }

    public String[] getRequiredProjectNames() throws JavaModelException {
        return this.projectPrerequisites(this.getResolvedClasspath(true));
    }

    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry) throws JavaModelException {
        return this.getResolvedClasspath(ignoreUnresolvedEntry, false);
    }

    public IClasspathEntry[] getResolvedClasspath(boolean ignoreUnresolvedEntry, boolean generateMarkerOnError) throws JavaModelException {
        IClasspathEntry[] infoPath;
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModelManager.PerProjectInfo perProjectInfo = manager.getPerProjectInfoCheckExistence(this.fProject);
        if (ignoreUnresolvedEntry && !generateMarkerOnError && perProjectInfo != null && (infoPath = perProjectInfo.lastResolvedClasspath) != null) {
            return infoPath;
        }
        HashMap reverseMap = perProjectInfo == null ? null : new HashMap(5);
        IClasspathEntry[] resolvedPath = this.getResolvedClasspath(this.getRawClasspath(), generateMarkerOnError ? this.getOutputLocation() : null, ignoreUnresolvedEntry, generateMarkerOnError, reverseMap);
        if (perProjectInfo != null) {
            if (perProjectInfo.classpath == null && generateMarkerOnError && JavaProject.hasJavaNature(this.fProject)) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
            }
            perProjectInfo.lastResolvedClasspath = resolvedPath;
            perProjectInfo.resolvedPathToRawEntries = reverseMap;
        }
        return resolvedPath;
    }

    public IClasspathEntry[] getResolvedClasspath(IClasspathEntry[] classpathEntries, IPath projectOutputLocation, boolean ignoreUnresolvedEntry, boolean generateMarkerOnError, Map reverseMap) throws JavaModelException {
        IJavaModelStatus status;
        if (generateMarkerOnError) {
            this.flushClasspathProblemMarkers(false, false);
        }
        int length = classpathEntries.length;
        ArrayList<IClasspathEntry> resolvedEntries = new ArrayList<IClasspathEntry>();
        int i = 0;
        while (i < length) {
            IClasspathEntry rawEntry = classpathEntries[i];
            status = null;
            if (generateMarkerOnError || !ignoreUnresolvedEntry) {
                status = JavaConventions.validateClasspathEntry(this, rawEntry, false);
                if (generateMarkerOnError && !status.isOK()) {
                    this.createClasspathProblemMarker(status);
                }
            }
            switch (rawEntry.getEntryKind()) {
                case 4: {
                    IPath resolvedPath;
                    IClasspathEntry resolvedEntry = JavaCore.getResolvedClasspathEntry(rawEntry);
                    if (resolvedEntry == null) {
                        if (ignoreUnresolvedEntry) break;
                        throw new JavaModelException(status);
                    }
                    if (reverseMap != null && reverseMap.get(resolvedPath = resolvedEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(resolvedEntry);
                    break;
                }
                case 5: {
                    IPath resolvedPath;
                    IClasspathContainer container = JavaCore.getClasspathContainer(rawEntry.getPath(), this);
                    if (container == null) {
                        if (ignoreUnresolvedEntry) break;
                        throw new JavaModelException(status);
                    }
                    IClasspathEntry[] containerEntries = container.getClasspathEntries();
                    if (containerEntries == null) break;
                    int j = 0;
                    int containerLength = containerEntries.length;
                    while (j < containerLength) {
                        IJavaModelStatus containerStatus;
                        IClasspathEntry cEntry = containerEntries[j];
                        if (generateMarkerOnError && !(containerStatus = JavaConventions.validateClasspathEntry(this, cEntry, false)).isOK()) {
                            this.createClasspathProblemMarker(containerStatus);
                        }
                        if (rawEntry.isExported()) {
                            cEntry = new ClasspathEntry(cEntry.getContentKind(), cEntry.getEntryKind(), cEntry.getPath(), cEntry.getExclusionPatterns(), cEntry.getSourceAttachmentPath(), cEntry.getSourceAttachmentRootPath(), cEntry.getOutputLocation(), true);
                        }
                        if (reverseMap != null && reverseMap.get(resolvedPath = cEntry.getPath()) == null) {
                            reverseMap.put(resolvedPath, rawEntry);
                        }
                        resolvedEntries.add(cEntry);
                        ++j;
                    }
                    break;
                }
                default: {
                    IPath resolvedPath;
                    if (reverseMap != null && reverseMap.get(resolvedPath = rawEntry.getPath()) == null) {
                        reverseMap.put(resolvedPath, rawEntry);
                    }
                    resolvedEntries.add(rawEntry);
                }
            }
            ++i;
        }
        IClasspathEntry[] resolvedPath = new IClasspathEntry[resolvedEntries.size()];
        resolvedEntries.toArray(resolvedPath);
        if (generateMarkerOnError && projectOutputLocation != null && !(status = JavaConventions.validateClasspath(this, resolvedPath, projectOutputLocation)).isOK()) {
            this.createClasspathProblemMarker(status);
        }
        return resolvedPath;
    }

    public IResource getResource() {
        return this.getProject();
    }

    public ISearchableNameEnvironment getSearchableNameEnvironment() throws JavaModelException {
        JavaProjectElementInfo info = this.getJavaProjectElementInfo();
        if (info.getSearchableEnvironment() == null) {
            info.setSearchableEnvironment(new SearchableEnvironment(this));
        }
        return info.getSearchableEnvironment();
    }

    public String getSharedProperty(String key) throws CoreException {
        String property = null;
        IFile rscFile = this.getProject().getFile(key);
        if (rscFile.exists()) {
            property = new String(Util.getResourceContentsAsByteArray(rscFile));
        }
        return property;
    }

    public SourceMapper getSourceMapper() {
        return null;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return this.getProject();
    }

    public boolean hasBuildState() {
        return JavaModelManager.getJavaModelManager().getLastBuiltState(this.getProject(), null) != null;
    }

    public boolean hasClasspathCycle(IClasspathEntry[] preferredClasspath) {
        HashSet cycleParticipants = new HashSet();
        this.updateCycleParticipants(preferredClasspath, new ArrayList(2), cycleParticipants, ResourcesPlugin.getWorkspace().getRoot(), new HashSet(2));
        return !cycleParticipants.isEmpty();
    }

    public boolean hasCycleMarker() {
        return this.getCycleMarker() != null;
    }

    public int hashCode() {
        return this.fProject.hashCode();
    }

    public static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public boolean hasSource() {
        IClasspathEntry[] entries;
        try {
            entries = this.getRawClasspath();
        }
        catch (JavaModelException e) {
            return true;
        }
        int i = 0;
        int max = entries.length;
        while (i < max) {
            if (entries[i].getEntryKind() == 3) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isClasspathEqualsTo(IClasspathEntry[] newClasspath, IPath newOutputLocation, IClasspathEntry[] otherClasspathWithOutput) throws JavaModelException {
        int length;
        if (otherClasspathWithOutput != null && otherClasspathWithOutput.length > 0 && (length = otherClasspathWithOutput.length) == newClasspath.length + 1) {
            int i = 0;
            while (i < length - 1) {
                if (!otherClasspathWithOutput[i].equals(newClasspath[i])) {
                    return false;
                }
                ++i;
            }
            IClasspathEntry output = otherClasspathWithOutput[length - 1];
            if (output.getContentKind() == 10 && output.getPath().equals(newOutputLocation)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOnClasspath(IJavaElement element) {
        IPath path = element.getPath();
        switch (element.getElementType()) {
            case 3: {
                if (((IPackageFragmentRoot)element).isArchive()) break;
                path = path.append("*");
                break;
            }
            case 4: {
                if (((IPackageFragmentRoot)element.getParent()).isArchive()) break;
                path = path.append("*");
            }
        }
        return this.isOnClasspath(path);
    }

    private boolean isOnClasspath(IPath path) {
        IClasspathEntry[] classpath;
        try {
            classpath = this.getResolvedClasspath(true);
        }
        catch (JavaModelException e) {
            return false;
        }
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getPath().isPrefixOf(path) && !Util.isExcluded(path, ((ClasspathEntry)entry).fullExclusionPatternChars())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isOnClasspath(IResource resource) {
        IPath path = resource.getFullPath();
        if (resource.getType() == 2) {
            path = path.append("*");
        }
        return this.isOnClasspath(path);
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Preferences loadPreferences() {
        block9: {
            preferences = new Preferences();
            projectMetaLocation = this.getProject().getPluginWorkingLocation(JavaCore.getPlugin().getDescriptor());
            if (projectMetaLocation == null) return null;
            prefFile = projectMetaLocation.append(".jprefs").toFile();
            if (prefFile.exists() == false) return null;
            in = null;
            try {
                try {
                    in = new BufferedInputStream(new FileInputStream(prefFile));
                    preferences.load(in);
                    var8_5 = preferences;
                    var6_6 = null;
                    if (in == null) return var8_5;
                }
                catch (IOException var5_12) {
                    break block9;
                }
            }
            catch (Throwable var7_13) {
                var6_7 = null;
                if (in == null) throw var7_13;
                try {
                    in.close();
                    throw var7_13;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var7_13;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 110->118)] { 
lbl30:
            // 1 sources

            in.close();
            return var8_5;
lbl32:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var8_5;
        }
        var6_8 = null;
        if (in == null) return null;
        try {}
        catch (IOException e) {
            return null;
        }
        in.close();
        return null;
    }

    public IEvaluationContext newEvaluationContext() {
        return new EvaluationContextWrapper(new EvaluationContext(), this);
    }

    public ITypeHierarchy newTypeHierarchy(IRegion region, IProgressMonitor monitor) throws JavaModelException {
        if (region == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullRegion"));
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(null, region, (IJavaProject)this, true);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IType type, IRegion region, IProgressMonitor monitor) throws JavaModelException {
        if (type == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullFocusType"));
        }
        if (region == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullRegion"));
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation(type, region, (IJavaProject)this, true);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    protected void openWhenClosed(IProgressMonitor pm) throws JavaModelException {
        if (!this.fProject.isOpen()) {
            throw this.newNotPresentException();
        }
        super.openWhenClosed(pm);
    }

    public String[] projectPrerequisites(IClasspathEntry[] entries) throws JavaModelException {
        ArrayList<String> prerequisites = new ArrayList<String>();
        entries = this.getResolvedClasspath(entries, null, true, false, null);
        int i = 0;
        int length = entries.length;
        while (i < length) {
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 2) {
                prerequisites.add(entry.getPath().lastSegment());
            }
            ++i;
        }
        int size = prerequisites.size();
        if (size == 0) {
            return NO_PREREQUISITES;
        }
        String[] result = new String[size];
        prerequisites.toArray(result);
        return result;
    }

    protected IClasspathEntry[] readClasspathFile(boolean createMarker, boolean logProblems) {
        try {
            String xmlClasspath = this.getSharedProperty(CLASSPATH_FILENAME);
            if (xmlClasspath == null) {
                return null;
            }
            return this.decodeClasspath(xmlClasspath, createMarker, logProblems);
        }
        catch (CoreException e) {
            if (createMarker && this.getProject().isAccessible()) {
                this.createClasspathProblemMarker(new JavaModelStatus(1000, Util.bind("classpath.cannotReadClasspathFile", this.getElementName())));
            }
            if (logProblems) {
                Util.log(e, "Exception while retrieving " + this.getPath() + "/.classpath, will revert to default classpath");
            }
            return null;
        }
    }

    protected void removeFromBuildSpec(String builderID) throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals(builderID)) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.getProject().setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return project;
    }

    public String rootID() {
        return "[PRJ]" + this.getProject().getFullPath();
    }

    public boolean saveClasspath(IClasspathEntry[] newClasspath, IPath newOutputLocation) throws JavaModelException {
        if (!this.getProject().exists()) {
            return false;
        }
        IClasspathEntry[] fileEntries = this.readClasspathFile(false, false);
        if (fileEntries != null && this.isClasspathEqualsTo(newClasspath, newOutputLocation, fileEntries)) {
            return false;
        }
        try {
            this.setSharedProperty(CLASSPATH_FILENAME, this.encodeClasspath(newClasspath, newOutputLocation, true));
            return true;
        }
        catch (CoreException e) {
            throw new JavaModelException(e);
        }
    }

    private void savePreferences(Preferences preferences) {
        block13: {
            IProject project = this.getProject();
            if (!JavaProject.hasJavaNature(project)) {
                return;
            }
            if (preferences == null || !preferences.needsSaving() && preferences.propertyNames().length != 0) {
                return;
            }
            File prefFile = project.getPluginWorkingLocation(JavaCore.getPlugin().getDescriptor()).append(PREF_FILENAME).toFile();
            if (preferences.propertyNames().length == 0) {
                if (prefFile.exists()) {
                    prefFile.delete();
                }
                return;
            }
            BufferedOutputStream out = null;
            try {
                try {
                    out = new BufferedOutputStream(new FileOutputStream(prefFile));
                    preferences.store(out, null);
                }
                catch (IOException iOException) {}
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            Object var6_8 = null;
            if (out == null) break block13;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {}
        }
    }

    private void setJavaCommand(IProjectDescription description, ICommand newCommand) throws CoreException {
        ICommand[] newCommands;
        ICommand[] oldCommands = description.getBuildSpec();
        ICommand oldJavaCommand = this.getJavaCommand(description);
        if (oldJavaCommand == null) {
            newCommands = new ICommand[oldCommands.length + 1];
            System.arraycopy(oldCommands, 0, newCommands, 1, oldCommands.length);
            newCommands[0] = newCommand;
        } else {
            int i = 0;
            int max = oldCommands.length;
            while (i < max) {
                if (oldCommands[i] == oldJavaCommand) {
                    oldCommands[i] = newCommand;
                    break;
                }
                ++i;
            }
            newCommands = oldCommands;
        }
        description.setBuildSpec(newCommands);
        this.getProject().setDescription(description, null);
    }

    public void setOptions(Map newOptions) {
        Preferences preferences = new Preferences();
        this.setPreferences(preferences);
        if (newOptions != null) {
            Iterator keys = newOptions.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (!JavaModelManager.OptionNames.contains(key)) continue;
                String value = (String)newOptions.get(key);
                preferences.setDefault(key, CUSTOM_DEFAULT_OPTION_VALUE);
                preferences.setValue(key, value);
            }
        }
        this.savePreferences(preferences);
    }

    public void setOutputLocation(IPath path, IProgressMonitor monitor) throws JavaModelException {
        if (path == null) {
            throw new IllegalArgumentException(Util.bind("path.nullpath"));
        }
        if (path.equals(this.getOutputLocation())) {
            return;
        }
        this.setRawClasspath(SetClasspathOperation.ReuseClasspath, path, monitor);
    }

    public void setPreferences(Preferences preferences) {
        IProject project = this.getProject();
        if (!JavaProject.hasJavaNature(project)) {
            return;
        }
        JavaModelManager.PerProjectInfo perProjectInfo = JavaModelManager.getJavaModelManager().getPerProjectInfo(project, true);
        perProjectInfo.preferences = preferences;
    }

    public void setProject(IProject project) {
        this.fProject = project;
        this.fParent = JavaModelManager.getJavaModelManager().getJavaModel();
        this.fName = project.getName();
    }

    public void setRawClasspath(IClasspathEntry[] entries, IPath outputLocation, IProgressMonitor monitor) throws JavaModelException {
        this.setRawClasspath(entries, outputLocation, monitor, true, this.getResolvedClasspath(true), true, true);
    }

    public void setRawClasspath(IClasspathEntry[] newEntries, IPath newOutputLocation, IProgressMonitor monitor, boolean canChangeResource, IClasspathEntry[] oldResolvedPath, boolean needValidation, boolean needSave) throws JavaModelException {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            IClasspathEntry[] newRawPath = newEntries;
            if (newRawPath == null) {
                newRawPath = this.defaultClasspath();
            }
            SetClasspathOperation op = new SetClasspathOperation(this, oldResolvedPath, newRawPath, newOutputLocation, canChangeResource, needValidation, needSave);
            JavaElement.runOperation(op, monitor);
        }
        catch (JavaModelException e) {
            manager.flush();
            throw e;
        }
    }

    public void setRawClasspath(IClasspathEntry[] entries, IProgressMonitor monitor) throws JavaModelException {
        this.setRawClasspath(entries, SetClasspathOperation.ReuseOutputLocation, monitor, true, this.getResolvedClasspath(true), true, true);
    }

    protected void setRawClasspath0(IClasspathEntry[] rawEntries) throws JavaModelException {
        JavaModelManager.PerProjectInfo info;
        JavaModelManager.PerProjectInfo perProjectInfo = info = JavaModelManager.getJavaModelManager().getPerProjectInfoCheckExistence(this.fProject);
        synchronized (perProjectInfo) {
            if (rawEntries != null) {
                info.classpath = rawEntries;
            }
            info.lastResolvedClasspath = null;
            info.resolvedPathToRawEntries = null;
        }
    }

    public void setSharedProperty(String key, String value) throws CoreException {
        IFile rscFile = this.getProject().getFile(key);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(value.getBytes());
        if (rscFile.exists()) {
            if (rscFile.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{rscFile}, null);
            }
            rscFile.setContents(inputStream, 1, null);
        } else {
            rscFile.create((InputStream)inputStream, 1, null);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void updateAllCycleMarkers() throws JavaModelException {
        manager = JavaModelManager.getJavaModelManager();
        projects = manager.getJavaModel().getJavaProjects();
        workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        cycleParticipants = new HashSet<E>();
        traversed = new HashSet<E>();
        length = projects.length;
        prereqChain = new ArrayList<E>();
        i = 0;
        while (i < length) {
            project = (JavaProject)projects[i];
            if (!traversed.contains(project.getPath())) {
                prereqChain.clear();
                project.updateCycleParticipants(null, prereqChain, cycleParticipants, workspaceRoot, traversed);
            }
            ++i;
        }
        i = 0;
        while (i < length) {
            project = (JavaProject)projects[i];
            if (cycleParticipants.contains(project.getPath())) {
                cycleMarker = project.getCycleMarker();
                circularCPOption = project.getOption("org.eclipse.jdt.core.circularClasspath", true);
                v0 = circularCPSeverity = "error".equals(circularCPOption) != false ? 2 : 1;
                if (cycleMarker != null) {
                    try {
                        existingSeverity = (Integer)cycleMarker.getAttribute("severity");
                        if (existingSeverity == circularCPSeverity) ** GOTO lbl35
                        cycleMarker.setAttribute("severity", circularCPSeverity);
                    }
                    catch (CoreException e) {
                        throw new JavaModelException(e);
                    }
                } else {
                    project.createClasspathProblemMarker(new JavaModelStatus(1001, project));
                }
            } else {
                project.flushClasspathProblemMarkers(true, false);
            }
lbl35:
            // 4 sources

            ++i;
        }
    }

    public void updateCycleParticipants(IClasspathEntry[] preferredClasspath, ArrayList prereqChain, HashSet cycleParticipants, IWorkspaceRoot workspaceRoot, HashSet traversed) {
        IPath path = this.getPath();
        prereqChain.add(path);
        traversed.add(path);
        try {
            IClasspathEntry[] classpath = preferredClasspath == null ? this.getResolvedClasspath(true) : preferredClasspath;
            int i = 0;
            int length = classpath.length;
            while (i < length) {
                IClasspathEntry entry = classpath[i];
                if (entry.getEntryKind() == 2) {
                    IResource member;
                    int index;
                    IPath prereqProjectPath = entry.getPath();
                    int n = index = cycleParticipants.contains(prereqProjectPath) ? 0 : prereqChain.indexOf(prereqProjectPath);
                    if (index >= 0) {
                        int size = prereqChain.size();
                        while (index < size) {
                            cycleParticipants.add(prereqChain.get(index));
                            ++index;
                        }
                    } else if (!traversed.contains(prereqProjectPath) && (member = workspaceRoot.findMember(prereqProjectPath)) != null && member.getType() == 4) {
                        JavaProject project = (JavaProject)JavaCore.create((IProject)member);
                        project.updateCycleParticipants(null, prereqChain, cycleParticipants, workspaceRoot, traversed);
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        ((AbstractCollection)prereqChain).remove(path);
    }

    public void updatePackageFragmentRoots() {
        if (this.isOpen()) {
            try {
                JavaProjectElementInfo info = this.getJavaProjectElementInfo();
                IClasspathEntry[] classpath = this.getResolvedClasspath(true);
                NameLookup lookup = info.getNameLookup();
                if (lookup != null) {
                    block9: {
                        IPackageFragmentRoot[] oldRoots = lookup.fPackageFragmentRoots;
                        IPackageFragmentRoot[] newRoots = this.computePackageFragmentRoots(classpath, true);
                        if (oldRoots.length == newRoots.length) {
                            int i = 0;
                            int length = oldRoots.length;
                            while (i < length) {
                                if (oldRoots[i].equals(newRoots[i])) {
                                    ++i;
                                    continue;
                                }
                                break block9;
                            }
                            return;
                        }
                    }
                    info.setNameLookup(null);
                }
                info.setNonJavaResources(null);
                info.setChildren(this.computePackageFragmentRoots(classpath, false));
            }
            catch (JavaModelException e) {
                try {
                    this.close();
                }
                catch (JavaModelException javaModelException) {
                    // empty catch block
                }
            }
        }
    }
}

