/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.Util;

public class HandleFactory {
    private String lastPkgFragmentRootPath;
    private IPackageFragmentRoot lastPkgFragmentRoot;
    private Map packageHandles;
    private IWorkspace workspace;
    private JavaModel javaModel;

    public HandleFactory(IWorkspace workspace) {
        this.workspace = workspace;
        this.javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public Openable createOpenable(String resourcePath, IJavaSearchScope scope) {
        String simpleName;
        int lastSlash;
        String packageName;
        IPackageFragment pkgFragment;
        int separatorIndex = resourcePath.indexOf("|");
        if (separatorIndex > -1) {
            String classFilePath;
            int lastSlash2;
            String packageName2;
            IPackageFragment pkgFragment2;
            String jarPath = resourcePath.substring(0, separatorIndex);
            if (!jarPath.equals(this.lastPkgFragmentRootPath)) {
                IPackageFragmentRoot root = this.getJarPkgFragmentRoot(jarPath, scope);
                if (root == null) {
                    return null;
                }
                this.lastPkgFragmentRootPath = jarPath;
                this.lastPkgFragmentRoot = root;
                this.packageHandles = new HashMap(5);
            }
            if ((pkgFragment2 = (IPackageFragment)this.packageHandles.get(packageName2 = (lastSlash2 = (classFilePath = resourcePath.substring(separatorIndex + 1)).lastIndexOf(47)) > -1 ? classFilePath.substring(0, lastSlash2).replace('/', '.') : "")) == null) {
                pkgFragment2 = this.lastPkgFragmentRoot.getPackageFragment(packageName2);
                this.packageHandles.put(packageName2, pkgFragment2);
            }
            IClassFile classFile = pkgFragment2.getClassFile(classFilePath.substring(lastSlash2 + 1));
            return (Openable)((Object)classFile);
        }
        int length = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || (length = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(length) != '/') {
            IPackageFragmentRoot root = this.getPkgFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.getPath().toString();
            this.packageHandles = new HashMap(5);
        }
        if ((pkgFragment = (IPackageFragment)this.packageHandles.get(packageName = (lastSlash = resourcePath.lastIndexOf(47)) > (length = this.lastPkgFragmentRootPath.length()) ? resourcePath.substring(length + 1, lastSlash).replace('/', '.') : "")) == null) {
            pkgFragment = this.lastPkgFragmentRoot.getPackageFragment(packageName);
            this.packageHandles.put(packageName, pkgFragment);
        }
        if (Util.isJavaFileName(simpleName = resourcePath.substring(lastSlash + 1))) {
            ICompilationUnit unit = pkgFragment.getCompilationUnit(simpleName);
            return (Openable)((Object)unit);
        }
        IClassFile classFile = pkgFragment.getClassFile(simpleName);
        return (Openable)((Object)classFile);
    }

    private IPackageFragmentRoot getJarPkgFragmentRoot(String jarPathString, IJavaSearchScope scope) {
        IJavaProject[] projects;
        Path jarPath = new Path(jarPathString);
        Object target = JavaModel.getTarget(this.workspace.getRoot(), jarPath, false);
        if (target instanceof IFile) {
            IFile jarFile = (IFile)target;
            IJavaProject javaProject = this.javaModel.getJavaProject(jarFile);
            try {
                IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                int j = 0;
                int entryCount = classpathEntries.length;
                while (j < entryCount) {
                    if (classpathEntries[j].getPath().equals(jarPath)) {
                        return javaProject.getPackageFragmentRoot(jarFile);
                    }
                    ++j;
                }
            }
            catch (JavaModelException j) {
                // empty catch block
            }
        }
        if (scope != null) {
            IPackageFragmentRoot root;
            IPath[] enclosingProjectsAndJars = scope.enclosingProjectsAndJars();
            int length = enclosingProjectsAndJars.length;
            projects = new IJavaProject[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                IPath path = enclosingProjectsAndJars[i];
                if (!Util.isArchiveFileName(path.lastSegment())) {
                    projects[index++] = this.javaModel.getJavaProject(path.segment(0));
                }
                ++i;
            }
            if (index < length) {
                IJavaProject[] iJavaProjectArray = projects;
                projects = new IJavaProject[index];
                System.arraycopy(iJavaProjectArray, 0, projects, 0, index);
            }
            if ((root = this.getJarPkgFragmentRoot(jarPath, target, projects)) != null) {
                return root;
            }
        }
        try {
            projects = this.javaModel.getJavaProjects();
        }
        catch (JavaModelException e) {
            return null;
        }
        return this.getJarPkgFragmentRoot(jarPath, target, projects);
    }

    private IPackageFragmentRoot getJarPkgFragmentRoot(IPath jarPath, Object target, IJavaProject[] projects) {
        int i = 0;
        int projectCount = projects.length;
        while (i < projectCount) {
            try {
                JavaProject javaProject = (JavaProject)projects[i];
                IClasspathEntry[] classpathEntries = javaProject.getResolvedClasspath(true);
                int j = 0;
                int entryCount = classpathEntries.length;
                while (j < entryCount) {
                    if (classpathEntries[j].getPath().equals(jarPath)) {
                        if (target instanceof IFile) {
                            return javaProject.getPackageFragmentRoot((IFile)target);
                        }
                        return javaProject.getPackageFragmentRoot0(jarPath);
                    }
                    ++j;
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }

    private IPackageFragmentRoot getPkgFragmentRoot(String pathString) {
        Path path = new Path(pathString);
        IProject[] projects = this.workspace.getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            try {
                IProject project = projects[i];
                if (project.isAccessible() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                    IJavaProject javaProject = this.javaModel.getJavaProject(project);
                    IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                    int j = 0;
                    int rootCount = roots.length;
                    while (j < rootCount) {
                        PackageFragmentRoot root = (PackageFragmentRoot)roots[j];
                        if (root.getPath().isPrefixOf(path) && !Util.isExcluded(path, root.fullExclusionPatternChars())) {
                            return root;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++i;
        }
        return null;
    }
}

