/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryField;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.ClassFileInfo;
import org.eclipse.jdt.internal.core.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.Initializer;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public class BinaryType
extends BinaryMember
implements IType {
    private static final IField[] NO_FIELDS = new IField[0];
    private static final IMethod[] NO_METHODS = new IMethod[0];
    private static final IType[] NO_TYPES = new IType[0];
    private static final IInitializer[] NO_INITIALIZERS = new IInitializer[0];
    private static final String[] NO_STRINGS = new String[0];

    protected BinaryType(IJavaElement parent, String name) {
        super(7, parent, name);
        Assert.isTrue(name.indexOf(46) == -1);
    }

    public void close() throws JavaModelException {
        block10: {
            Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
            if (info == null) break block10;
            boolean wasVerbose = false;
            try {
                ClassFileInfo cfi;
                if (JavaModelManager.VERBOSE) {
                    System.out.println("CLOSING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
                    wasVerbose = true;
                    JavaModelManager.VERBOSE = false;
                }
                if ((cfi = this.getClassFileInfo()).hasReadBinaryChildren()) {
                    try {
                        IJavaElement[] children = this.getChildren();
                        int i = 0;
                        int size = children.length;
                        while (i < size) {
                            JavaElement child = (JavaElement)children[i];
                            if (child instanceof BinaryType) {
                                ((IOpenable)((Object)child.getParent())).close();
                            } else {
                                child.close();
                            }
                            ++i;
                        }
                    }
                    catch (JavaModelException javaModelException) {
                        // empty catch block
                    }
                }
                this.closing(info);
                JavaModelManager.getJavaModelManager().removeInfo(this);
                if (JavaModelManager.VERBOSE) {
                    System.out.println("-> Package cache size = " + JavaModelManager.getJavaModelManager().cache.pkgSize());
                    System.out.println("-> Openable cache filling ratio = " + JavaModelManager.getJavaModelManager().cache.openableFillingRatio() + "%");
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                JavaModelManager.VERBOSE = wasVerbose;
                throw throwable;
            }
            Object var8_11 = null;
            JavaModelManager.VERBOSE = wasVerbose;
        }
    }

    protected void closing(Object info) throws JavaModelException {
        ClassFileInfo cfi = this.getClassFileInfo();
        cfi.removeBinaryChildren();
        if (JavaModelManager.VERBOSE) {
            System.out.println("-> Package cache size = " + JavaModelManager.getJavaModelManager().cache.pkgSize());
            System.out.println("-> Openable cache filling ratio = " + JavaModelManager.getJavaModelManager().cache.openableFillingRatio() + "%");
        }
    }

    public void codeComplete(char[] snippet, int insertion, int position, char[][] localVariableTypeNames, char[][] localVariableNames, int[] localVariableModifiers, boolean isStatic, ICompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            throw new IllegalArgumentException(Util.bind("codeAssist.nullRequestor"));
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        SearchableEnvironment environment = (SearchableEnvironment)project.getSearchableNameEnvironment();
        NameLookup nameLookup = project.getNameLookup();
        CompletionEngine engine = new CompletionEngine(environment, new CompletionRequestorWrapper(requestor, nameLookup), project.getOptions(true), project);
        String source = this.getClassFile().getSource();
        if (source != null && insertion > -1 && insertion < source.length()) {
            String encoding = project.getOption("org.eclipse.jdt.core.encoding", true);
            char[] prefix = CharOperation.concat(source.substring(0, insertion).toCharArray(), new char[]{'{'});
            char[] suffix = CharOperation.concat(new char[]{'}'}, source.substring(insertion).toCharArray());
            char[] fakeSource = CharOperation.concat(prefix, snippet, suffix);
            BasicCompilationUnit cu = new BasicCompilationUnit(fakeSource, null, this.getElementName(), encoding);
            engine.complete(cu, prefix.length + position, prefix.length);
        } else {
            engine.complete(this, snippet, position, localVariableTypeNames, localVariableNames, localVariableModifiers, isStatic);
        }
    }

    public IField createField(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IInitializer createInitializer(String contents, IJavaElement sibling, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IMethod createMethod(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IType createType(String contents, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(976, this));
    }

    public IMethod[] findMethods(IMethod method) {
        try {
            return this.findMethods(method, this.getMethods());
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public IJavaElement[] getChildren() throws JavaModelException {
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        ClassFileInfo cfi = this.getClassFileInfo();
        return cfi.getBinaryChildren();
    }

    protected ClassFileInfo getClassFileInfo() throws JavaModelException {
        ClassFile cf = (ClassFile)this.fParent;
        return (ClassFileInfo)cf.getElementInfo();
    }

    public IType getDeclaringType() {
        IClassFile classFile = this.getClassFile();
        if (classFile.isOpen()) {
            try {
                char[] enclosingTypeName = ((IBinaryType)this.getElementInfo()).getEnclosingTypeName();
                if (enclosingTypeName == null) {
                    return null;
                }
                enclosingTypeName = ClassFile.unqualifiedName(enclosingTypeName);
                if (classFile.getElementName().length() > enclosingTypeName.length + 1 && Character.isDigit(classFile.getElementName().charAt(enclosingTypeName.length + 1))) {
                    return null;
                }
                return this.getPackageFragment().getClassFile(String.valueOf(new String(enclosingTypeName)) + ".class").getType();
            }
            catch (JavaModelException npe) {
                return null;
            }
        }
        String classFileName = classFile.getElementName();
        int lastDollar = -1;
        int i = 0;
        int length = classFileName.length();
        while (i < length) {
            char c = classFileName.charAt(i);
            if (Character.isDigit(c) && lastDollar == i - 1) {
                return null;
            }
            if (c == '$') {
                lastDollar = i;
            }
            ++i;
        }
        if (lastDollar == -1) {
            return null;
        }
        String enclosingName = classFileName.substring(0, lastDollar);
        String enclosingClassFileName = String.valueOf(enclosingName) + ".class";
        return new BinaryType(this.getPackageFragment().getClassFile(enclosingClassFileName), enclosingName.substring(enclosingName.lastIndexOf(36) + 1));
    }

    public IField getField(String name) {
        return new BinaryField(this, name);
    }

    public IField[] getFields() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(8);
        int size = list.size();
        if (size == 0) {
            return NO_FIELDS;
        }
        IField[] array = new IField[size];
        list.toArray(array);
        return array;
    }

    public int getFlags() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.getModifiers();
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName('$');
    }

    public String getFullyQualifiedName(char enclosingTypeSeparator) {
        String packageName = this.getPackageFragment().getElementName();
        if (packageName.equals("")) {
            return this.getTypeQualifiedName(enclosingTypeSeparator);
        }
        return String.valueOf(packageName) + '.' + this.getTypeQualifiedName(enclosingTypeSeparator);
    }

    public IInitializer getInitializer(int occurrenceCount) {
        return new Initializer(this, occurrenceCount);
    }

    public IInitializer[] getInitializers() {
        return NO_INITIALIZERS;
    }

    public IMethod getMethod(String name, String[] parameterTypeSignatures) {
        return new BinaryMethod(this, name, parameterTypeSignatures);
    }

    public IMethod[] getMethods() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(9);
        int size = list.size();
        if (size == 0) {
            return NO_METHODS;
        }
        IMethod[] array = new IMethod[size];
        list.toArray(array);
        return array;
    }

    public IPackageFragment getPackageFragment() {
        IJavaElement parent = this.fParent;
        while (parent != null) {
            if (parent.getElementType() == 4) {
                return (IPackageFragment)parent;
            }
            parent = parent.getParent();
        }
        Assert.isTrue(false);
        return null;
    }

    public String getSuperclassName() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[] superclassName = info.getSuperclassName();
        if (superclassName == null) {
            return null;
        }
        return new String(ClassFile.translatedName(superclassName));
    }

    public String[] getSuperInterfaceNames() throws JavaModelException {
        int length;
        IBinaryType info = (IBinaryType)this.getElementInfo();
        char[][] names = info.getInterfaceNames();
        if (names == null || (length = names.length) == 0) {
            return NO_STRINGS;
        }
        names = ClassFile.translatedNames(names);
        String[] strings = new String[length];
        int i = 0;
        while (i < length) {
            strings[i] = new String(names[i]);
            ++i;
        }
        return strings;
    }

    public IType getType(String name) {
        IClassFile classFile = this.getPackageFragment().getClassFile(String.valueOf(this.getTypeQualifiedName()) + "$" + name + ".class");
        return new BinaryType(classFile, name);
    }

    public String getTypeQualifiedName() {
        return this.getTypeQualifiedName('$');
    }

    public String getTypeQualifiedName(char enclosingTypeSeparator) {
        IType declaringType = this.getDeclaringType();
        if (declaringType == null) {
            String classFileName = this.getClassFile().getElementName();
            if (classFileName.indexOf(36) == -1) {
                return this.fName;
            }
            return classFileName.substring(0, classFileName.lastIndexOf(46));
        }
        return String.valueOf(declaringType.getTypeQualifiedName(enclosingTypeSeparator)) + enclosingTypeSeparator + this.fName;
    }

    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        int size = list.size();
        if (size == 0) {
            return NO_TYPES;
        }
        IType[] array = new IType[size];
        list.toArray(array);
        return array;
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean isAnonymous() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isAnonymous();
    }

    public boolean isClass() throws JavaModelException {
        return !this.isInterface();
    }

    public boolean isInterface() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isInterface();
    }

    public boolean isLocal() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isLocal();
    }

    public boolean isMember() throws JavaModelException {
        IBinaryType info = (IBinaryType)this.getElementInfo();
        return info.isMember();
    }

    public ITypeHierarchy loadTypeHierachy(InputStream input, IProgressMonitor monitor) throws JavaModelException {
        return TypeHierarchy.load(this, input);
    }

    public ITypeHierarchy newSupertypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newSupertypeHierarchy(null, monitor);
    }

    public ITypeHierarchy newSupertypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), false);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IProgressMonitor monitor) throws JavaModelException {
        return this.newTypeHierarchy((IWorkingCopy[])null, monitor);
    }

    public ITypeHierarchy newTypeHierarchy(IWorkingCopy[] workingCopies, IProgressMonitor monitor) throws JavaModelException {
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, workingCopies, SearchEngine.createWorkspaceScope(), true);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    public ITypeHierarchy newTypeHierarchy(IJavaProject project, IProgressMonitor monitor) throws JavaModelException {
        if (project == null) {
            throw new IllegalArgumentException(Util.bind("hierarchy.nullProject"));
        }
        CreateTypeHierarchyOperation op = new CreateTypeHierarchyOperation((IType)this, null, project, true);
        JavaElement.runOperation(op, monitor);
        return op.getResult();
    }

    protected void removeInfo() {
        Object info = JavaModelManager.getJavaModelManager().peekAtInfo(this);
        if (info != null) {
            try {
                IJavaElement[] children = this.getChildren();
                int i = 0;
                int size = children.length;
                while (i < size) {
                    JavaElement child = (JavaElement)children[i];
                    child.removeInfo();
                    ++i;
                }
            }
            catch (JavaModelException children) {
                // empty catch block
            }
            JavaModelManager.getJavaModelManager().removeInfo(this);
            try {
                ClassFileInfo cfi = this.getClassFileInfo();
                cfi.removeBinaryChildren();
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
    }

    public String[][] resolveType(String typeName) throws JavaModelException {
        return null;
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                if (this.isInterface()) {
                    buffer.append("interface ");
                } else {
                    buffer.append("class ");
                }
                buffer.append(this.getElementName());
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

