/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.core.BinaryMember;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.Member;

class BinaryField
extends BinaryMember
implements IField {
    protected BinaryField(IType parent, String name) {
        super(8, parent, name);
    }

    public Object getConstant() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return Member.convertConstant(info.getConstant());
    }

    public int getFlags() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return info.getModifiers();
    }

    protected char getHandleMementoDelimiter() {
        return '^';
    }

    public String getTypeSignature() throws JavaModelException {
        IBinaryField info = (IBinaryField)this.getElementInfo();
        return new String(ClassFile.translatedName(info.getTypeName()));
    }

    protected void toStringInfo(int tab, StringBuffer buffer, Object info) {
        buffer.append(this.tabString(tab));
        if (info == null) {
            buffer.append(this.getElementName());
            buffer.append(" (not open)");
        } else if (info == JavaElement.NO_INFO) {
            buffer.append(this.getElementName());
        } else {
            try {
                buffer.append(Signature.toString(this.getTypeSignature()));
                buffer.append(" ");
                buffer.append(this.getElementName());
            }
            catch (JavaModelException e) {
                buffer.append("<JavaModelException in toString of " + this.getElementName());
            }
        }
    }
}

