/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblem
implements ProblemSeverities,
IProblem {
    private char[] fileName;
    private int id;
    private int startPosition;
    private int endPosition;
    private int line;
    private int severity;
    private String[] arguments;
    private String message;

    public DefaultProblem(char[] originatingFileName, String message, int id, String[] stringArguments, int severity, int startPosition, int endPosition, int line) {
        this.fileName = originatingFileName;
        this.message = message;
        this.id = id;
        this.arguments = stringArguments;
        this.severity = severity;
        this.startPosition = startPosition;
        this.endPosition = endPosition;
        this.line = line;
    }

    public String errorReportSource(ICompilationUnit compilationUnit) {
        char c;
        if (this.startPosition > this.endPosition || this.startPosition <= 0 && this.endPosition <= 0) {
            return Util.bind("problem.noSourceInformation");
        }
        int SPACE = 32;
        int MARK = 94;
        int TAB = 9;
        char[] source = compilationUnit.getContents();
        int begin = this.startPosition >= source.length ? source.length - 1 : this.startPosition;
        int relativeStart = 0;
        int end = this.endPosition >= source.length ? source.length - 1 : this.endPosition;
        int relativeEnd = 0;
        relativeStart = 0;
        while (begin != 0 && source[begin - 1] != '\n' && source[begin - 1] != '\r') {
            --begin;
            ++relativeStart;
        }
        relativeEnd = 0;
        while (end + 1 < source.length && source[end + 1] != '\r' && source[end + 1] != '\n') {
            ++end;
            ++relativeEnd;
        }
        char[] extract = new char[end - begin + 1];
        System.arraycopy(source, begin, extract, 0, extract.length);
        int trimLeftIndex = 0;
        while ((c = extract[trimLeftIndex++]) == '\t' || c == ' ') {
        }
        char[] cArray = extract;
        extract = new char[extract.length - trimLeftIndex + 1];
        System.arraycopy(cArray, trimLeftIndex - 1, extract, 0, extract.length);
        relativeStart -= trimLeftIndex;
        int pos = 0;
        char[] underneath = new char[extract.length];
        int i = 0;
        while (i <= relativeStart) {
            underneath[pos++] = extract[i] == '\t' ? 9 : 32;
            ++i;
        }
        i = this.startPosition;
        while (i <= (this.endPosition >= source.length ? source.length - 1 : this.endPosition)) {
            underneath[pos++] = 94;
            ++i;
        }
        char[] cArray2 = underneath;
        underneath = new char[pos];
        System.arraycopy(cArray2, 0, underneath, 0, pos);
        return " " + Util.bind("problem.atLine", String.valueOf(this.line)) + "\n\t" + new String(extract) + "\n\t" + new String(underneath);
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public int getID() {
        return this.id;
    }

    public String getMessage() {
        return this.message;
    }

    public char[] getOriginatingFileName() {
        return this.fileName;
    }

    public int getSourceEnd() {
        return this.endPosition;
    }

    public int getSourceLineNumber() {
        return this.line;
    }

    public int getSourceStart() {
        return this.startPosition;
    }

    public boolean isError() {
        return (this.severity & 1) != 0;
    }

    public boolean isWarning() {
        return (this.severity & 1) == 0;
    }

    public void setSourceEnd(int sourceEnd) {
        this.endPosition = sourceEnd;
    }

    public void setSourceLineNumber(int lineNumber) {
        this.line = lineNumber;
    }

    public void setSourceStart(int sourceStart) {
        this.startPosition = sourceStart;
    }

    public String toString() {
        String s = "Pb(" + (this.id & 0xFFFFFF) + ") ";
        if (this.message != null) {
            s = String.valueOf(s) + this.message;
        } else if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                s = String.valueOf(s) + " " + this.arguments[i];
                ++i;
            }
        }
        return s;
    }
}

