/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;

public class MethodDeclaration
extends AbstractMethodDeclaration {
    public TypeReference returnType;

    public MethodDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            TypeBinding returnType;
            if (this.binding == null) {
                return;
            }
            if (this.binding.isPrivate() && !this.binding.isPrivateUsed() && !classScope.referenceCompilationUnit().compilationResult.hasSyntaxError()) {
                this.scope.problemReporter().unusedPrivateMethod(this);
            }
            if (this.binding.isAbstract() || this.binding.isNative()) {
                return;
            }
            ExceptionHandlingFlowContext methodContext = new ExceptionHandlingFlowContext(initializationContext, this, this.binding.thrownExceptions, this.scope, FlowInfo.DEAD_END);
            if (this.statements != null) {
                boolean didAlreadyComplain = false;
                int i = 0;
                int count = this.statements.length;
                while (i < count) {
                    Statement stat = this.statements[i];
                    if (!flowInfo.complainIfUnreachable(stat, this.scope, didAlreadyComplain)) {
                        flowInfo = stat.analyseCode(this.scope, methodContext, flowInfo);
                    } else {
                        didAlreadyComplain = true;
                    }
                    ++i;
                }
            }
            if ((returnType = this.binding.returnType) == BaseTypes.VoidBinding || this.isAbstract()) {
                this.needFreeReturn = flowInfo.isReachable();
            } else if (flowInfo != FlowInfo.DEAD_END) {
                this.scope.problemReporter().shouldReturn(returnType, this);
            }
        }
        catch (AbortMethod e) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parse(this, unit);
    }

    public void resolveStatements() {
        if (this.returnType != null && this.binding != null) {
            this.returnType.resolvedType = this.binding.returnType;
        }
        if (this.binding != null && this.isTypeUseDeprecated(this.binding.returnType, this.scope)) {
            this.scope.problemReporter().deprecatedType(this.binding.returnType, this.returnType);
        }
        if (CharOperation.equals(this.scope.enclosingSourceType().sourceName, this.selector)) {
            this.scope.problemReporter().methodWithConstructorName(this);
        }
        if (!this.scope.enclosingSourceType().isInterface()) {
            if ((this.modifiers & 0x1000000) != 0) {
                if ((this.modifiers & 0x100) == 0 && (this.modifiers & 0x400) == 0) {
                    this.scope.problemReporter().methodNeedingAbstractModifier(this);
                }
            } else if ((this.modifiers & 0x100) != 0 || (this.modifiers & 0x400) != 0) {
                this.scope.problemReporter().methodNeedingNoBody(this);
            }
        }
        super.resolveStatements();
    }

    public String returnTypeToString(int tab) {
        if (this.returnType == null) {
            return "";
        }
        return String.valueOf(this.returnType.toString(tab)) + " ";
    }

    public void traverse(IAbstractSyntaxTreeVisitor visitor, ClassScope classScope) {
        if (visitor.visit(this, classScope)) {
            int i;
            if (this.returnType != null) {
                this.returnType.traverse(visitor, this.scope);
            }
            if (this.arguments != null) {
                int argumentLength = this.arguments.length;
                i = 0;
                while (i < argumentLength) {
                    this.arguments[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.thrownExceptions != null) {
                int thrownExceptionsLength = this.thrownExceptions.length;
                i = 0;
                while (i < thrownExceptionsLength) {
                    this.thrownExceptions[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, classScope);
    }
}

