/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import java.io.File;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.ClasspathVariableInitializer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IRegion;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.Assert;
import org.eclipse.jdt.internal.core.BatchOperation;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.ClasspathEntry;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.Region;
import org.eclipse.jdt.internal.core.SetClasspathOperation;
import org.eclipse.jdt.internal.core.Util;

public final class JavaCore
extends Plugin
implements IExecutableExtension {
    private static Plugin JAVA_CORE_PLUGIN = null;
    public static final String PLUGIN_ID = "org.eclipse.jdt.core";
    public static final String BUILDER_ID = "org.eclipse.jdt.core.javabuilder";
    public static final String MODEL_ID = "org.eclipse.jdt.core.javamodel";
    public static final String NATURE_ID = "org.eclipse.jdt.core.javanature";
    protected static final String ATT_HANDLE_ID = "org.eclipse.jdt.internal.core.JavaModelManager.handleId";
    public static final String COMPILER_LOCAL_VARIABLE_ATTR = "org.eclipse.jdt.core.compiler.debug.localVariable";
    public static final String COMPILER_LINE_NUMBER_ATTR = "org.eclipse.jdt.core.compiler.debug.lineNumber";
    public static final String COMPILER_SOURCE_FILE_ATTR = "org.eclipse.jdt.core.compiler.debug.sourceFile";
    public static final String COMPILER_CODEGEN_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.codegen.unusedLocal";
    public static final String COMPILER_CODEGEN_TARGET_PLATFORM = "org.eclipse.jdt.core.compiler.codegen.targetPlatform";
    public static final String COMPILER_PB_UNREACHABLE_CODE = "org.eclipse.jdt.core.compiler.problem.unreachableCode";
    public static final String COMPILER_PB_INVALID_IMPORT = "org.eclipse.jdt.core.compiler.problem.invalidImport";
    public static final String COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD = "org.eclipse.jdt.core.compiler.problem.overridingPackageDefaultMethod";
    public static final String COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME = "org.eclipse.jdt.core.compiler.problem.methodWithConstructorName";
    public static final String COMPILER_PB_DEPRECATION = "org.eclipse.jdt.core.compiler.problem.deprecation";
    public static final String COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE = "org.eclipse.jdt.core.compiler.problem.deprecationInDeprecatedCode";
    public static final String COMPILER_PB_HIDDEN_CATCH_BLOCK = "org.eclipse.jdt.core.compiler.problem.hiddenCatchBlock";
    public static final String COMPILER_PB_UNUSED_LOCAL = "org.eclipse.jdt.core.compiler.problem.unusedLocal";
    public static final String COMPILER_PB_UNUSED_PARAMETER = "org.eclipse.jdt.core.compiler.problem.unusedParameter";
    public static final String COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenImplementingAbstract";
    public static final String COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE = "org.eclipse.jdt.core.compiler.problem.unusedParameterWhenOverridingConcrete";
    public static final String COMPILER_PB_UNUSED_IMPORT = "org.eclipse.jdt.core.compiler.problem.unusedImport";
    public static final String COMPILER_PB_SYNTHETIC_ACCESS_EMULATION = "org.eclipse.jdt.core.compiler.problem.syntheticAccessEmulation";
    public static final String COMPILER_PB_NON_NLS_STRING_LITERAL = "org.eclipse.jdt.core.compiler.problem.nonExternalizedStringLiteral";
    public static final String COMPILER_PB_ASSERT_IDENTIFIER = "org.eclipse.jdt.core.compiler.problem.assertIdentifier";
    public static final String COMPILER_PB_STATIC_ACCESS_RECEIVER = "org.eclipse.jdt.core.compiler.problem.staticAccessReceiver";
    public static final String COMPILER_PB_NO_EFFECT_ASSIGNMENT = "org.eclipse.jdt.core.compiler.problem.noEffectAssignment";
    public static final String COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD = "org.eclipse.jdt.core.compiler.problem.incompatibleNonInheritedInterfaceMethod";
    public static final String COMPILER_PB_UNUSED_PRIVATE_MEMBER = "org.eclipse.jdt.core.compiler.problem.unusedPrivateMember";
    public static final String COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION = "org.eclipse.jdt.core.compiler.problem.noImplicitStringConversion";
    public static final String COMPILER_PB_MAX_PER_UNIT = "org.eclipse.jdt.core.compiler.maxProblemPerUnit";
    public static final String COMPILER_SOURCE = "org.eclipse.jdt.core.compiler.source";
    public static final String COMPILER_COMPLIANCE = "org.eclipse.jdt.core.compiler.compliance";
    public static final String COMPILER_TASK_PRIORITIES = "org.eclipse.jdt.core.compiler.taskPriorities";
    public static final String COMPILER_TASK_PRIORITY_HIGH = "HIGH";
    public static final String COMPILER_TASK_PRIORITY_LOW = "LOW";
    public static final String COMPILER_TASK_PRIORITY_NORMAL = "NORMAL";
    public static final String COMPILER_TASK_TAGS = "org.eclipse.jdt.core.compiler.taskTags";
    public static final String CORE_JAVA_BUILD_ORDER = "org.eclipse.jdt.core.computeJavaBuildOrder";
    public static final String CORE_JAVA_BUILD_RESOURCE_COPY_FILTER = "org.eclipse.jdt.core.builder.resourceCopyExclusionFilter";
    public static final String CORE_JAVA_BUILD_DUPLICATE_RESOURCE = "org.eclipse.jdt.core.builder.duplicateResourceTask";
    public static final String CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER = "org.eclipse.jdt.core.builder.cleanOutputFolder";
    public static final String CORE_INCOMPLETE_CLASSPATH = "org.eclipse.jdt.core.incompleteClasspath";
    public static final String CORE_CIRCULAR_CLASSPATH = "org.eclipse.jdt.core.circularClasspath";
    public static final String CORE_JAVA_BUILD_INVALID_CLASSPATH = "org.eclipse.jdt.core.builder.invalidClasspath";
    public static final String CORE_ENCODING = "org.eclipse.jdt.core.encoding";
    public static final String CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS = "org.eclipse.jdt.core.classpath.exclusionPatterns";
    public static final String CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS = "org.eclipse.jdt.core.classpath.multipleOutputLocations";
    public static final String DEFAULT_TASK_TAG = "TODO";
    public static final String DEFAULT_TASK_PRIORITY = "NORMAL";
    public static final String FORMATTER_NEWLINE_OPENING_BRACE = "org.eclipse.jdt.core.formatter.newline.openingBrace";
    public static final String FORMATTER_NEWLINE_CONTROL = "org.eclipse.jdt.core.formatter.newline.controlStatement";
    public static final String FORMATTER_NEWLINE_ELSE_IF = "org.eclipse.jdt.core.formatter.newline.elseIf";
    public static final String FORMATTER_NEWLINE_EMPTY_BLOCK = "org.eclipse.jdt.core.formatter.newline.emptyBlock";
    public static final String FORMATTER_CLEAR_BLANK_LINES = "org.eclipse.jdt.core.formatter.newline.clearAll";
    public static final String FORMATTER_LINE_SPLIT = "org.eclipse.jdt.core.formatter.lineSplit";
    public static final String FORMATTER_COMPACT_ASSIGNMENT = "org.eclipse.jdt.core.formatter.style.assignment";
    public static final String FORMATTER_TAB_CHAR = "org.eclipse.jdt.core.formatter.tabulation.char";
    public static final String FORMATTER_TAB_SIZE = "org.eclipse.jdt.core.formatter.tabulation.size";
    public static final String FORMATTER_SPACE_CASTEXPRESSION = "org.eclipse.jdt.core.formatter.space.castexpression";
    public static final String CODEASSIST_VISIBILITY_CHECK = "org.eclipse.jdt.core.codeComplete.visibilityCheck";
    public static final String CODEASSIST_IMPLICIT_QUALIFICATION = "org.eclipse.jdt.core.codeComplete.forceImplicitQualification";
    public static final String CODEASSIST_FIELD_PREFIXES = "org.eclipse.jdt.core.codeComplete.fieldPrefixes";
    public static final String CODEASSIST_STATIC_FIELD_PREFIXES = "org.eclipse.jdt.core.codeComplete.staticFieldPrefixes";
    public static final String CODEASSIST_LOCAL_PREFIXES = "org.eclipse.jdt.core.codeComplete.localPrefixes";
    public static final String CODEASSIST_ARGUMENT_PREFIXES = "org.eclipse.jdt.core.codeComplete.argumentPrefixes";
    public static final String CODEASSIST_FIELD_SUFFIXES = "org.eclipse.jdt.core.codeComplete.fieldSuffixes";
    public static final String CODEASSIST_STATIC_FIELD_SUFFIXES = "org.eclipse.jdt.core.codeComplete.staticFieldSuffixes";
    public static final String CODEASSIST_LOCAL_SUFFIXES = "org.eclipse.jdt.core.codeComplete.localSuffixes";
    public static final String CODEASSIST_ARGUMENT_SUFFIXES = "org.eclipse.jdt.core.codeComplete.argumentSuffixes";
    public static final String GENERATE = "generate";
    public static final String DO_NOT_GENERATE = "do not generate";
    public static final String PRESERVE = "preserve";
    public static final String OPTIMIZE_OUT = "optimize out";
    public static final String VERSION_1_1 = "1.1";
    public static final String VERSION_1_2 = "1.2";
    public static final String VERSION_1_3 = "1.3";
    public static final String VERSION_1_4 = "1.4";
    public static final String ABORT = "abort";
    public static final String ERROR = "error";
    public static final String WARNING = "warning";
    public static final String IGNORE = "ignore";
    public static final String COMPUTE = "compute";
    public static final String INSERT = "insert";
    public static final String DO_NOT_INSERT = "do not insert";
    public static final String PRESERVE_ONE = "preserve one";
    public static final String CLEAR_ALL = "clear all";
    public static final String NORMAL = "normal";
    public static final String COMPACT = "compact";
    public static final String TAB = "tab";
    public static final String SPACE = "space";
    public static final String ENABLED = "enabled";
    public static final String DISABLED = "disabled";
    public static final String CLEAN = "clean";

    public JavaCore(IPluginDescriptor pluginDescriptor) {
        super(pluginDescriptor);
        JAVA_CORE_PLUGIN = this;
    }

    public static void addElementChangedListener(IElementChangedListener listener) {
        JavaCore.addElementChangedListener(listener, 5);
    }

    public static void addElementChangedListener(IElementChangedListener listener, int eventMask) {
        JavaModelManager.getJavaModelManager().addElementChangedListener(listener, eventMask);
    }

    public static void addJavaElementMarkerAttributes(Map attributes, IJavaElement element) {
        if (element instanceof IMember) {
            element = ((IMember)element).getClassFile();
        }
        if (attributes != null && element != null) {
            attributes.put(ATT_HANDLE_ID, element.getHandleIdentifier());
        }
    }

    public void configureJavaElementMarker(IMarker marker, IJavaElement element) throws CoreException {
        if (element instanceof IMember) {
            element = ((IMember)element).getClassFile();
        }
        if (marker != null && element != null) {
            marker.setAttribute(ATT_HANDLE_ID, element.getHandleIdentifier());
        }
    }

    public static IJavaElement create(String handleIdentifier) {
        if (handleIdentifier == null) {
            return null;
        }
        try {
            return JavaModelManager.getJavaModelManager().getHandleFromMemento(handleIdentifier);
        }
        catch (JavaModelException e) {
            return null;
        }
    }

    public static IJavaElement create(IFile file) {
        return JavaModelManager.create(file, null);
    }

    public static IJavaElement create(IFolder folder) {
        return JavaModelManager.create(folder, null);
    }

    public static IJavaProject create(IProject project) {
        if (project == null) {
            return null;
        }
        JavaModel javaModel = JavaModelManager.getJavaModelManager().getJavaModel();
        return javaModel.getJavaProject(project);
    }

    public static IJavaElement create(IResource resource) {
        return JavaModelManager.create(resource, null);
    }

    public static IJavaModel create(IWorkspaceRoot root) {
        if (root == null) {
            return null;
        }
        return JavaModelManager.getJavaModelManager().getJavaModel();
    }

    public static IClassFile createClassFileFrom(IFile file) {
        return JavaModelManager.createClassFileFrom(file, null);
    }

    public static ICompilationUnit createCompilationUnitFrom(IFile file) {
        return JavaModelManager.createCompilationUnitFrom(file, null);
    }

    public static IPackageFragmentRoot createJarPackageFragmentRootFrom(IFile file) {
        return JavaModelManager.createJarPackageFragmentRootFrom(file, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IClasspathContainer getClasspathContainer(final IPath containerPath, final IJavaProject project) throws JavaModelException {
        boolean ok;
        IClasspathContainer container;
        block12: {
            IClasspathContainer iClasspathContainer;
            block11: {
                container = JavaModelManager.containerGet(project, containerPath);
                if (container == JavaModelManager.ContainerInitializationInProgress) {
                    return null;
                }
                if (container != null) return container;
                final ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer(containerPath.segment(0));
                if (initializer == null) {
                    if (!JavaModelManager.CP_RESOLVE_VERBOSE) return container;
                    System.out.println("CPContainer INIT - no initializer found for: " + project.getElementName() + "] " + containerPath);
                    return container;
                }
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPContainer INIT - triggering initialization of: [" + project.getElementName() + "] " + containerPath + " using initializer: " + initializer);
                    new Exception("FAKE exception for dumping current CPContainer ([" + project.getElementName() + "] " + containerPath + ")INIT invocation stack trace").printStackTrace();
                }
                JavaModelManager.containerPut(project, containerPath, JavaModelManager.ContainerInitializationInProgress);
                ok = false;
                try {
                    Platform.run(new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Util.log(exception, "Exception occurred in classpath container initializer: " + initializer);
                        }

                        public void run() throws Exception {
                            initializer.initialize(containerPath, project);
                        }
                    });
                    container = JavaModelManager.containerGet(project, containerPath);
                    if (container == JavaModelManager.ContainerInitializationInProgress) {
                        iClasspathContainer = null;
                        Object var5_6 = null;
                        if (ok) return iClasspathContainer;
                        break block11;
                    }
                    ok = true;
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    if (ok) throw throwable;
                    JavaModelManager.containerPut(project, containerPath, null);
                    throw throwable;
                }
            }
            JavaModelManager.containerPut(project, containerPath, null);
            return iClasspathContainer;
        }
        Object var5_8 = null;
        if (!ok) {
            JavaModelManager.containerPut(project, containerPath, null);
        }
        if (!JavaModelManager.CP_RESOLVE_VERBOSE) return container;
        System.out.print("CPContainer INIT - after resolution: [" + project.getElementName() + "] " + containerPath + " --> ");
        if (container == null) {
            System.out.println("{unbound}");
            return container;
        }
        System.out.print("container: " + container.getDescription() + " {");
        IClasspathEntry[] entries = container.getClasspathEntries();
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                if (i > 0) {
                    System.out.println(", ");
                }
                System.out.println(entries[i]);
                ++i;
            }
        }
        System.out.println("}");
        return container;
    }

    public static ClasspathContainerInitializer getClasspathContainerInitializer(String containerID) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("classpathContainerInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    String initializerID = configElements[j].getAttribute("id");
                    if (initializerID != null && initializerID.equals(containerID)) {
                        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                            System.out.println("CPContainer INIT - found initializer: " + containerID + " --> " + configElements[j].getAttribute("class"));
                        }
                        try {
                            Object execExt = configElements[j].createExecutableExtension("class");
                            if (execExt instanceof ClasspathContainerInitializer) {
                                return (ClasspathContainerInitializer)execExt;
                            }
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static IPath getClasspathVariable(final String variableName) {
        boolean ok;
        IPath variablePath;
        block9: {
            IPath iPath;
            block8: {
                variablePath = JavaModelManager.variableGet(variableName);
                if (variablePath == JavaModelManager.VariableInitializationInProgress) {
                    return null;
                }
                if (variablePath != null) {
                    return variablePath;
                }
                final ClasspathVariableInitializer initializer = JavaCore.getClasspathVariableInitializer(variableName);
                if (initializer == null) {
                    if (!JavaModelManager.CP_RESOLVE_VERBOSE) return variablePath;
                    System.out.println("CPVariable INIT - no initializer found for: " + variableName);
                    return variablePath;
                }
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPVariable INIT - triggering initialization of: " + variableName + " using initializer: " + initializer);
                    new Exception("FAKE exception for dumping current CPVariable (" + variableName + ")INIT invocation stack trace").printStackTrace();
                }
                JavaModelManager.variablePut(variableName, JavaModelManager.VariableInitializationInProgress);
                ok = false;
                try {
                    Platform.run(new ISafeRunnable(){

                        public void handleException(Throwable exception) {
                            Util.log(exception, "Exception occurred in classpath variable initializer: " + initializer + " while initializing variable: " + variableName);
                        }

                        public void run() throws Exception {
                            initializer.initialize(variableName);
                        }
                    });
                    variablePath = JavaModelManager.variableGet(variableName);
                    if (variablePath == JavaModelManager.VariableInitializationInProgress) {
                        iPath = null;
                        Object var4_5 = null;
                        if (ok) return iPath;
                        break block8;
                    }
                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                        System.out.println("CPVariable INIT - after initialization: " + variableName + " --> " + variablePath);
                    }
                    ok = true;
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (ok) throw throwable;
                    JavaModelManager.variablePut(variableName, null);
                    throw throwable;
                }
            }
            JavaModelManager.variablePut(variableName, null);
            return iPath;
        }
        Object var4_7 = null;
        if (ok) return variablePath;
        JavaModelManager.variablePut(variableName, null);
        return variablePath;
    }

    public static ClasspathVariableInitializer getClasspathVariableInitializer(String variable) {
        Plugin jdtCorePlugin = JavaCore.getPlugin();
        if (jdtCorePlugin == null) {
            return null;
        }
        IExtensionPoint extension = jdtCorePlugin.getDescriptor().getExtensionPoint("classpathVariableInitializer");
        if (extension != null) {
            IExtension[] extensions = extension.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IConfigurationElement[] configElements = extensions[i].getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    try {
                        String varAttribute = configElements[j].getAttribute("variable");
                        if (variable.equals(varAttribute)) {
                            Object execExt;
                            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                                System.out.println("CPVariable INIT - found initializer: " + variable + " --> " + configElements[j].getAttribute("class"));
                            }
                            if ((execExt = configElements[j].createExecutableExtension("class")) instanceof ClasspathVariableInitializer) {
                                return (ClasspathVariableInitializer)execExt;
                            }
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                    ++j;
                }
                ++i;
            }
        }
        return null;
    }

    public static String[] getClasspathVariableNames() {
        return JavaModelManager.variableNames();
    }

    public static Hashtable getDefaultOptions() {
        Hashtable<String, String> defaultOptions = new Hashtable<String, String>(10);
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        HashSet optionNames = JavaModelManager.OptionNames;
        String[] defaultPropertyNames = preferences.defaultPropertyNames();
        int i = 0;
        while (i < defaultPropertyNames.length) {
            String propertyName = defaultPropertyNames[i];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i;
        }
        String[] propertyNames = preferences.propertyNames();
        int i2 = 0;
        while (i2 < propertyNames.length) {
            String propertyName = propertyNames[i2];
            if (optionNames.contains(propertyName)) {
                defaultOptions.put(propertyName, preferences.getDefaultString(propertyName));
            }
            ++i2;
        }
        defaultOptions.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        return defaultOptions;
    }

    public static JavaCore getJavaCore() {
        return (JavaCore)JavaCore.getPlugin();
    }

    public static String getOption(String optionName) {
        if (CORE_ENCODING.equals(optionName)) {
            return ResourcesPlugin.getEncoding();
        }
        if (JavaModelManager.OptionNames.contains(optionName)) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            return preferences.getString(optionName).trim();
        }
        return null;
    }

    public static Hashtable getOptions() {
        Hashtable<String, String> options = new Hashtable<String, String>(10);
        Plugin plugin = JavaCore.getPlugin();
        if (plugin != null) {
            Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
            HashSet optionNames = JavaModelManager.OptionNames;
            String[] defaultPropertyNames = preferences.defaultPropertyNames();
            int i = 0;
            while (i < defaultPropertyNames.length) {
                String propertyName = defaultPropertyNames[i];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getDefaultString(propertyName));
                }
                ++i;
            }
            String[] propertyNames = preferences.propertyNames();
            int i2 = 0;
            while (i2 < propertyNames.length) {
                String propertyName = propertyNames[i2];
                if (optionNames.contains(propertyName)) {
                    options.put(propertyName, preferences.getString(propertyName).trim());
                }
                ++i2;
            }
            options.put(CORE_ENCODING, ResourcesPlugin.getEncoding());
        }
        return options;
    }

    public static Plugin getPlugin() {
        return JAVA_CORE_PLUGIN;
    }

    public static IClasspathEntry getResolvedClasspathEntry(IClasspathEntry entry) {
        String fileName;
        File externalFile;
        IResource resolvedResource;
        if (entry.getEntryKind() != 4) {
            return entry;
        }
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath resolvedPath = JavaCore.getResolvedVariablePath(entry.getPath());
        if (resolvedPath == null) {
            return null;
        }
        Object target = JavaModel.getTarget(workspaceRoot, resolvedPath, false);
        if (target == null) {
            return null;
        }
        if (target instanceof IResource && (resolvedResource = (IResource)target) != null) {
            switch (resolvedResource.getType()) {
                case 4: {
                    return JavaCore.newProjectEntry(resolvedPath, entry.isExported());
                }
                case 1: {
                    if (!Util.isArchiveFileName(resolvedResource.getName())) break;
                    return JavaCore.newLibraryEntry(resolvedPath, JavaCore.getResolvedVariablePath(entry.getSourceAttachmentPath()), JavaCore.getResolvedVariablePath(entry.getSourceAttachmentRootPath()), entry.isExported());
                }
                case 2: {
                    return JavaCore.newLibraryEntry(resolvedPath, JavaCore.getResolvedVariablePath(entry.getSourceAttachmentPath()), JavaCore.getResolvedVariablePath(entry.getSourceAttachmentRootPath()), entry.isExported());
                }
            }
        }
        if (target instanceof File && ((externalFile = (File)target).isFile() ? (fileName = externalFile.getName().toLowerCase()).endsWith(".jar") || fileName.endsWith(".zip") : resolvedPath.isAbsolute())) {
            return JavaCore.newLibraryEntry(resolvedPath, JavaCore.getResolvedVariablePath(entry.getSourceAttachmentPath()), JavaCore.getResolvedVariablePath(entry.getSourceAttachmentRootPath()), entry.isExported());
        }
        return null;
    }

    public static IPath getResolvedVariablePath(IPath variablePath) {
        if (variablePath == null) {
            return null;
        }
        int count = variablePath.segmentCount();
        if (count == 0) {
            return null;
        }
        String variableName = variablePath.segment(0);
        IPath resolvedPath = JavaCore.getClasspathVariable(variableName);
        if (resolvedPath == null) {
            return null;
        }
        if (count > 1) {
            resolvedPath = resolvedPath.append(variablePath.removeFirstSegments(1));
        }
        return resolvedPath;
    }

    public static IWorkingCopy[] getSharedWorkingCopies(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = BufferManager.getDefaultBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = JavaModelManager.getJavaModelManager().sharedWorkingCopies).get(factory)) == null) {
            return JavaModelManager.NoWorkingCopy;
        }
        Collection copies = perFactoryWorkingCopies.values();
        IWorkingCopy[] result = new IWorkingCopy[copies.size()];
        copies.toArray(result);
        return result;
    }

    protected void initializeDefaultPluginPreferences() {
        Preferences preferences = this.getPluginPreferences();
        HashSet optionNames = JavaModelManager.OptionNames;
        preferences.setDefault(COMPILER_LOCAL_VARIABLE_ATTR, GENERATE);
        optionNames.add(COMPILER_LOCAL_VARIABLE_ATTR);
        preferences.setDefault(COMPILER_LINE_NUMBER_ATTR, GENERATE);
        optionNames.add(COMPILER_LINE_NUMBER_ATTR);
        preferences.setDefault(COMPILER_SOURCE_FILE_ATTR, GENERATE);
        optionNames.add(COMPILER_SOURCE_FILE_ATTR);
        preferences.setDefault(COMPILER_CODEGEN_UNUSED_LOCAL, PRESERVE);
        optionNames.add(COMPILER_CODEGEN_UNUSED_LOCAL);
        preferences.setDefault(COMPILER_CODEGEN_TARGET_PLATFORM, VERSION_1_1);
        optionNames.add(COMPILER_CODEGEN_TARGET_PLATFORM);
        preferences.setDefault(COMPILER_PB_UNREACHABLE_CODE, ERROR);
        optionNames.add(COMPILER_PB_UNREACHABLE_CODE);
        preferences.setDefault(COMPILER_PB_INVALID_IMPORT, ERROR);
        optionNames.add(COMPILER_PB_INVALID_IMPORT);
        preferences.setDefault(COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD, WARNING);
        optionNames.add(COMPILER_PB_OVERRIDING_PACKAGE_DEFAULT_METHOD);
        preferences.setDefault(COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME, WARNING);
        optionNames.add(COMPILER_PB_METHOD_WITH_CONSTRUCTOR_NAME);
        preferences.setDefault(COMPILER_PB_DEPRECATION, WARNING);
        optionNames.add(COMPILER_PB_DEPRECATION);
        preferences.setDefault(COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE, DISABLED);
        optionNames.add(COMPILER_PB_DEPRECATION_IN_DEPRECATED_CODE);
        preferences.setDefault(COMPILER_PB_HIDDEN_CATCH_BLOCK, WARNING);
        optionNames.add(COMPILER_PB_HIDDEN_CATCH_BLOCK);
        preferences.setDefault(COMPILER_PB_UNUSED_LOCAL, IGNORE);
        optionNames.add(COMPILER_PB_UNUSED_LOCAL);
        preferences.setDefault(COMPILER_PB_UNUSED_PARAMETER, IGNORE);
        optionNames.add(COMPILER_PB_UNUSED_PARAMETER);
        preferences.setDefault(COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT, DISABLED);
        optionNames.add(COMPILER_PB_UNUSED_PARAMETER_WHEN_IMPLEMENTING_ABSTRACT);
        preferences.setDefault(COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE, DISABLED);
        optionNames.add(COMPILER_PB_UNUSED_PARAMETER_WHEN_OVERRIDING_CONCRETE);
        preferences.setDefault(COMPILER_PB_UNUSED_IMPORT, WARNING);
        optionNames.add(COMPILER_PB_UNUSED_IMPORT);
        preferences.setDefault(COMPILER_PB_UNUSED_PRIVATE_MEMBER, IGNORE);
        optionNames.add(COMPILER_PB_UNUSED_PRIVATE_MEMBER);
        preferences.setDefault(COMPILER_PB_SYNTHETIC_ACCESS_EMULATION, IGNORE);
        optionNames.add(COMPILER_PB_SYNTHETIC_ACCESS_EMULATION);
        preferences.setDefault(COMPILER_PB_NON_NLS_STRING_LITERAL, IGNORE);
        optionNames.add(COMPILER_PB_NON_NLS_STRING_LITERAL);
        preferences.setDefault(COMPILER_PB_ASSERT_IDENTIFIER, IGNORE);
        optionNames.add(COMPILER_PB_ASSERT_IDENTIFIER);
        preferences.setDefault(COMPILER_PB_STATIC_ACCESS_RECEIVER, WARNING);
        optionNames.add(COMPILER_PB_STATIC_ACCESS_RECEIVER);
        preferences.setDefault(COMPILER_PB_NO_EFFECT_ASSIGNMENT, WARNING);
        optionNames.add(COMPILER_PB_NO_EFFECT_ASSIGNMENT);
        preferences.setDefault(COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD, WARNING);
        optionNames.add(COMPILER_PB_INCOMPATIBLE_NON_INHERITED_INTERFACE_METHOD);
        preferences.setDefault(COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION, WARNING);
        optionNames.add(COMPILER_PB_CHAR_ARRAY_IN_STRING_CONCATENATION);
        preferences.setDefault(COMPILER_TASK_TAGS, DEFAULT_TASK_TAG);
        optionNames.add(COMPILER_TASK_TAGS);
        preferences.setDefault(COMPILER_TASK_PRIORITIES, "NORMAL");
        optionNames.add(COMPILER_TASK_PRIORITIES);
        preferences.setDefault(COMPILER_SOURCE, VERSION_1_3);
        optionNames.add(COMPILER_SOURCE);
        preferences.setDefault(COMPILER_COMPLIANCE, VERSION_1_3);
        optionNames.add(COMPILER_COMPLIANCE);
        preferences.setDefault(COMPILER_PB_MAX_PER_UNIT, "100");
        optionNames.add(COMPILER_PB_MAX_PER_UNIT);
        preferences.setDefault(CORE_JAVA_BUILD_RESOURCE_COPY_FILTER, "");
        optionNames.add(CORE_JAVA_BUILD_RESOURCE_COPY_FILTER);
        preferences.setDefault(CORE_JAVA_BUILD_INVALID_CLASSPATH, ABORT);
        optionNames.add(CORE_JAVA_BUILD_INVALID_CLASSPATH);
        preferences.setDefault(CORE_JAVA_BUILD_DUPLICATE_RESOURCE, WARNING);
        optionNames.add(CORE_JAVA_BUILD_DUPLICATE_RESOURCE);
        preferences.setDefault(CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER, CLEAN);
        optionNames.add(CORE_JAVA_BUILD_CLEAN_OUTPUT_FOLDER);
        preferences.setDefault(CORE_JAVA_BUILD_ORDER, IGNORE);
        optionNames.add(CORE_JAVA_BUILD_ORDER);
        preferences.setDefault(CORE_CIRCULAR_CLASSPATH, ERROR);
        optionNames.add(CORE_CIRCULAR_CLASSPATH);
        preferences.setDefault(CORE_INCOMPLETE_CLASSPATH, ERROR);
        optionNames.add(CORE_INCOMPLETE_CLASSPATH);
        preferences.setDefault(CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS, ENABLED);
        optionNames.add(CORE_ENABLE_CLASSPATH_EXCLUSION_PATTERNS);
        preferences.setDefault(CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS, ENABLED);
        optionNames.add(CORE_ENABLE_CLASSPATH_MULTIPLE_OUTPUT_LOCATIONS);
        optionNames.add(CORE_ENCODING);
        preferences.setDefault(FORMATTER_NEWLINE_OPENING_BRACE, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_OPENING_BRACE);
        preferences.setDefault(FORMATTER_NEWLINE_CONTROL, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_CONTROL);
        preferences.setDefault(FORMATTER_CLEAR_BLANK_LINES, PRESERVE_ONE);
        optionNames.add(FORMATTER_CLEAR_BLANK_LINES);
        preferences.setDefault(FORMATTER_NEWLINE_ELSE_IF, DO_NOT_INSERT);
        optionNames.add(FORMATTER_NEWLINE_ELSE_IF);
        preferences.setDefault(FORMATTER_NEWLINE_EMPTY_BLOCK, INSERT);
        optionNames.add(FORMATTER_NEWLINE_EMPTY_BLOCK);
        preferences.setDefault(FORMATTER_LINE_SPLIT, "80");
        optionNames.add(FORMATTER_LINE_SPLIT);
        preferences.setDefault(FORMATTER_COMPACT_ASSIGNMENT, NORMAL);
        optionNames.add(FORMATTER_COMPACT_ASSIGNMENT);
        preferences.setDefault(FORMATTER_TAB_CHAR, TAB);
        optionNames.add(FORMATTER_TAB_CHAR);
        preferences.setDefault(FORMATTER_TAB_SIZE, "4");
        optionNames.add(FORMATTER_TAB_SIZE);
        preferences.setDefault(FORMATTER_SPACE_CASTEXPRESSION, INSERT);
        optionNames.add(FORMATTER_SPACE_CASTEXPRESSION);
        preferences.setDefault(CODEASSIST_VISIBILITY_CHECK, DISABLED);
        optionNames.add(CODEASSIST_VISIBILITY_CHECK);
        preferences.setDefault(CODEASSIST_IMPLICIT_QUALIFICATION, DISABLED);
        optionNames.add(CODEASSIST_IMPLICIT_QUALIFICATION);
        preferences.setDefault(CODEASSIST_FIELD_PREFIXES, "");
        optionNames.add(CODEASSIST_FIELD_PREFIXES);
        preferences.setDefault(CODEASSIST_STATIC_FIELD_PREFIXES, "");
        optionNames.add(CODEASSIST_STATIC_FIELD_PREFIXES);
        preferences.setDefault(CODEASSIST_LOCAL_PREFIXES, "");
        optionNames.add(CODEASSIST_LOCAL_PREFIXES);
        preferences.setDefault(CODEASSIST_ARGUMENT_PREFIXES, "");
        optionNames.add(CODEASSIST_ARGUMENT_PREFIXES);
        preferences.setDefault(CODEASSIST_FIELD_SUFFIXES, "");
        optionNames.add(CODEASSIST_FIELD_SUFFIXES);
        preferences.setDefault(CODEASSIST_STATIC_FIELD_SUFFIXES, "");
        optionNames.add(CODEASSIST_STATIC_FIELD_SUFFIXES);
        preferences.setDefault(CODEASSIST_LOCAL_SUFFIXES, "");
        optionNames.add(CODEASSIST_LOCAL_SUFFIXES);
        preferences.setDefault(CODEASSIST_ARGUMENT_SUFFIXES, "");
        optionNames.add(CODEASSIST_ARGUMENT_SUFFIXES);
    }

    public static boolean isReferencedBy(IJavaElement element, IMarker marker) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (element == null) {
            return false;
        }
        if (marker == null) {
            return false;
        }
        String markerHandleId = (String)marker.getAttribute(ATT_HANDLE_ID);
        if (markerHandleId == null) {
            return false;
        }
        IJavaElement markerElement = JavaCore.create(markerHandleId);
        while (true) {
            IType enclosingType;
            if (element.equals(markerElement)) {
                return true;
            }
            if (!(markerElement instanceof IClassFile) || (enclosingType = ((IClassFile)markerElement).getType().getDeclaringType()) == null) break;
            markerElement = enclosingType.getClassFile();
        }
        return false;
    }

    public static boolean isReferencedBy(IJavaElement element, IMarkerDelta markerDelta) throws CoreException {
        if (element instanceof IMember) {
            IMember member = (IMember)element;
            element = member.isBinary() ? member.getClassFile() : member.getCompilationUnit();
        }
        if (element == null) {
            return false;
        }
        if (markerDelta == null) {
            return false;
        }
        String markerDeltarHandleId = (String)markerDelta.getAttribute(ATT_HANDLE_ID);
        if (markerDeltarHandleId == null) {
            return false;
        }
        IJavaElement markerElement = JavaCore.create(markerDeltarHandleId);
        while (true) {
            IType enclosingType;
            if (element.equals(markerElement)) {
                return true;
            }
            if (!(markerElement instanceof IClassFile) || (enclosingType = ((IClassFile)markerElement).getType().getDeclaringType()) == null) break;
            markerElement = enclosingType.getClassFile();
        }
        return false;
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath) {
        return JavaCore.newContainerEntry(containerPath, false);
    }

    public static IClasspathEntry newContainerEntry(IPath containerPath, boolean isExported) {
        if (containerPath == null || containerPath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal classpath container path: '" + containerPath.makeRelative().toString() + "', must have at least one segment (containerID+hints)");
        }
        return new ClasspathEntry(1, 5, containerPath, ClasspathEntry.NO_EXCLUSION_PATTERNS, null, null, null, isExported);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return JavaCore.newLibraryEntry(path, sourceAttachmentPath, sourceAttachmentRootPath, false);
    }

    public static IClasspathEntry newLibraryEntry(IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        return new ClasspathEntry(2, 1, JavaProject.canonicalizedPath(path), ClasspathEntry.NO_EXCLUSION_PATTERNS, sourceAttachmentPath, sourceAttachmentRootPath, null, isExported);
    }

    public static IClasspathEntry newProjectEntry(IPath path) {
        return JavaCore.newProjectEntry(path, false);
    }

    public static IClasspathEntry newProjectEntry(IPath path, boolean isExported) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        return new ClasspathEntry(1, 2, path, ClasspathEntry.NO_EXCLUSION_PATTERNS, null, null, null, isExported);
    }

    public static IRegion newRegion() {
        return new Region();
    }

    public static IClasspathEntry newSourceEntry(IPath path) {
        return JavaCore.newSourceEntry(path, ClasspathEntry.NO_EXCLUSION_PATTERNS, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns) {
        return JavaCore.newSourceEntry(path, exclusionPatterns, null);
    }

    public static IClasspathEntry newSourceEntry(IPath path, IPath[] exclusionPatterns, IPath specificOutputLocation) {
        if (!path.isAbsolute()) {
            Assert.isTrue(false, "Path for IClasspathEntry must be absolute");
        }
        if (exclusionPatterns == null) {
            Assert.isTrue(false, "Exclusion pattern set cannot be null");
        }
        return new ClasspathEntry(1, 3, path, exclusionPatterns, null, null, specificOutputLocation, false);
    }

    public static IClasspathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath sourceAttachmentRootPath) {
        return JavaCore.newVariableEntry(variablePath, variableSourceAttachmentPath, sourceAttachmentRootPath, false);
    }

    public static IClasspathEntry newVariableEntry(IPath variablePath, IPath variableSourceAttachmentPath, IPath variableSourceAttachmentRootPath, boolean isExported) {
        if (variablePath == null || variablePath.segmentCount() < 1) {
            Assert.isTrue(false, "Illegal classpath variable path: '" + variablePath.makeRelative().toString() + "', must have at least one segment");
        }
        return new ClasspathEntry(1, 4, variablePath, ClasspathEntry.NO_EXCLUSION_PATTERNS, variableSourceAttachmentPath, variableSourceAttachmentRootPath, null, isExported);
    }

    public static void removeClasspathVariable(String variableName) {
        JavaCore.removeClasspathVariable(variableName, null);
    }

    public static void removeClasspathVariable(String variableName, IProgressMonitor monitor) {
        try {
            JavaCore.updateVariableValues(new String[]{variableName}, new IPath[1], monitor);
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
    }

    public static void removeElementChangedListener(IElementChangedListener listener) {
        JavaModelManager.getJavaModelManager().removeElementChangedListener(listener);
    }

    public static void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace.isTreeLocked()) {
            new BatchOperation(action).run(monitor);
        } else {
            workspace.run(new BatchOperation(action), monitor);
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void setClasspathContainer(final IPath containerPath, IJavaProject[] affectedProjects, IClasspathContainer[] respectiveContainers, IProgressMonitor monitor) throws JavaModelException {
        block29: {
            if (affectedProjects.length != respectiveContainers.length) {
                Assert.isTrue(false, "Projects and containers collections should have the same size");
            }
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                System.out.println("CPContainer SET  - setting container: [" + containerPath + "] for projects: {" + Util.toString(affectedProjects, new Util.Displayable(){

                    public String displayString(Object o) {
                        return ((IJavaProject)o).getElementName();
                    }
                }) + "} with values: " + Util.toString(respectiveContainers, new Util.Displayable(){

                    public String displayString(Object o) {
                        return ((IClasspathContainer)o).getDescription();
                    }
                }));
            }
            projectLength = affectedProjects.length;
            modifiedProjects = new IJavaProject[projectLength];
            System.arraycopy(affectedProjects, 0, modifiedProjects, 0, projectLength);
            oldResolvedPaths = new IClasspathEntry[projectLength][];
            remaining = 0;
            i = 0;
            while (i < projectLength) {
                if (monitor != null && monitor.isCanceled()) {
                    return;
                }
                affectedProject = affectedProjects[i];
                newContainer = respectiveContainers[i];
                if (newContainer == null) {
                    newContainer = JavaModelManager.ContainerInitializationInProgress;
                }
                found = false;
                if (JavaProject.hasJavaNature(affectedProject.getProject())) {
                    rawClasspath = affectedProject.getRawClasspath();
                    j = 0;
                    cpLength = rawClasspath.length;
                    while (j < cpLength) {
                        entry = rawClasspath[j];
                        if (entry.getEntryKind() == 5 && entry.getPath().equals(containerPath)) {
                            found = true;
                            break;
                        }
                        ++j;
                    }
                }
                if (!found) {
                    modifiedProjects[i] = null;
                    JavaModelManager.containerPut(affectedProject, containerPath, newContainer);
                } else {
                    oldContainer = JavaModelManager.containerGet(affectedProject, containerPath);
                    if (oldContainer == JavaModelManager.ContainerInitializationInProgress) {
                        previousContainerValues = (Map)JavaModelManager.PreviousSessionContainers.get(affectedProject);
                        if (previousContainerValues != null) {
                            previousContainer = (IClasspathContainer)previousContainerValues.get(containerPath);
                            if (previousContainer != null) {
                                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                                    System.out.println("CPContainer INIT - reentering access to project container: [" + affectedProject.getElementName() + "] " + containerPath + " during its initialization, will see previous value: " + previousContainer.getDescription());
                                }
                                JavaModelManager.containerPut(affectedProject, containerPath, previousContainer);
                            }
                            oldContainer = null;
                        } else {
                            oldContainer = null;
                        }
                    }
                    if (oldContainer != null && oldContainer.equals(respectiveContainers[i])) {
                        modifiedProjects[i] = null;
                    } else {
                        ++remaining;
                        oldResolvedPaths[i] = affectedProject.getResolvedClasspath(true);
                        JavaModelManager.containerPut(affectedProject, containerPath, newContainer);
                    }
                }
                ++i;
            }
            if (remaining == 0) {
                return;
            }
            try {
                try {
                    JavaCore.run(new IWorkspaceRunnable(){

                        public void run(IProgressMonitor monitor) throws CoreException {
                            int i = 0;
                            while (i < projectLength) {
                                if (monitor != null && monitor.isCanceled()) {
                                    return;
                                }
                                JavaProject affectedProject = (JavaProject)modifiedProjects[i];
                                if (affectedProject != null) {
                                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                                        System.out.println("CPContainer SET  - updating affected project: [" + affectedProject.getElementName() + "] due to setting container: " + containerPath);
                                    }
                                    affectedProject.setRawClasspath(affectedProject.getRawClasspath(), SetClasspathOperation.ReuseOutputLocation, monitor, !ResourcesPlugin.getWorkspace().isTreeLocked(), oldResolvedPaths[i], false, false);
                                }
                                ++i;
                            }
                        }
                    }, monitor);
                    break block29;
                }
                catch (CoreException e) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                        System.out.println("CPContainer SET  - FAILED DUE TO EXCEPTION: " + containerPath);
                        e.printStackTrace();
                    }
                    if (e instanceof JavaModelException) {
                        throw (JavaModelException)e;
                    }
                    throw new JavaModelException(e);
                }
            }
            catch (Throwable var10_12) {
                var9_10 = null;
                i = 0;
                ** while (i < projectLength)
            }
lbl-1000:
            // 1 sources

            {
                if (respectiveContainers[i] == null) {
                    JavaModelManager.containerPut(affectedProjects[i], containerPath, null);
                }
                ++i;
                continue;
            }
lbl79:
            // 1 sources

            throw var10_12;
        }
        var9_10 = null;
        i = 0;
        while (i < projectLength) {
            if (respectiveContainers[i] == null) {
                JavaModelManager.containerPut(affectedProjects[i], containerPath, null);
            }
            ++i;
        }
    }

    public static void setClasspathVariable(String variableName, IPath path) throws JavaModelException {
        JavaCore.setClasspathVariable(variableName, path, null);
    }

    public static void setClasspathVariable(String variableName, IPath path, IProgressMonitor monitor) throws JavaModelException {
        if (path == null) {
            Assert.isTrue(false, "Variable path cannot be null");
        }
        JavaCore.setClasspathVariables(new String[]{variableName}, new IPath[]{path}, monitor);
    }

    public static void setClasspathVariables(String[] variableNames, IPath[] paths, IProgressMonitor monitor) throws JavaModelException {
        if (variableNames.length != paths.length) {
            Assert.isTrue(false, "Variable names and paths collections should have the same size");
        }
        JavaCore.updateVariableValues(variableNames, paths, monitor);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) throws CoreException {
    }

    public static void setOptions(Hashtable newOptions) {
        Preferences preferences = JavaCore.getPlugin().getPluginPreferences();
        if (newOptions == null) {
            newOptions = JavaCore.getDefaultOptions();
        }
        Enumeration keys = newOptions.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (!JavaModelManager.OptionNames.contains(key) || key.equals(CORE_ENCODING)) continue;
            String value = (String)newOptions.get(key);
            preferences.setValue(key, value);
        }
        JavaCore.getPlugin().savePluginPreferences();
    }

    public void shutdown() {
        this.savePluginPreferences();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        workspace.removeResourceChangeListener(JavaModelManager.getJavaModelManager().deltaProcessor);
        workspace.removeSaveParticipant(this);
        JavaModelManager.getJavaModelManager().shutdown();
    }

    private void startIndexing() {
        JavaModelManager.getJavaModelManager().getIndexManager().reset();
    }

    public void startup() {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.configurePluginDebugOptions();
            JavaCore.getPlugin().getStateLocation();
            JavaCore.getPlugin().getPluginPreferences().addPropertyChangeListener(new JavaModelManager.PluginPreferencesListener());
            manager.loadVariablesAndContainers();
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            workspace.addResourceChangeListener(manager.deltaProcessor, 31);
            this.startIndexing();
            workspace.addSaveParticipant(this, manager);
        }
        catch (CoreException workspace) {
        }
        catch (RuntimeException e) {
            manager.shutdown();
            throw e;
        }
    }

    private static void updateVariableValues(String[] variableNames, IPath[] variablePaths, IProgressMonitor monitor) throws JavaModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (JavaModelManager.CP_RESOLVE_VERBOSE) {
            System.out.println("CPVariable SET  - setting variables: {" + Util.toString(variableNames) + "} with values: " + Util.toString(variablePaths));
        }
        int varLength = variableNames.length;
        final HashMap<IJavaProject, IClasspathEntry[]> affectedProjects = new HashMap<IJavaProject, IClasspathEntry[]>(5);
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        JavaModel model = manager.getJavaModel();
        int discardCount = 0;
        int i = 0;
        while (i < varLength) {
            String variableName = variableNames[i];
            IPath oldPath = JavaModelManager.variableGet(variableName);
            if (oldPath == JavaModelManager.VariableInitializationInProgress) {
                IPath previousPath = (IPath)JavaModelManager.PreviousSessionVariables.get(variableName);
                if (previousPath != null) {
                    if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                        System.out.println("CPVariable INIT - reentering access to variable: " + variableName + " during its initialization, will see previous value: " + previousPath);
                    }
                    JavaModelManager.variablePut(variableName, previousPath);
                }
                oldPath = null;
            }
            if (oldPath != null && oldPath.equals(variablePaths[i])) {
                variableNames[i] = null;
                ++discardCount;
            }
            ++i;
        }
        if (discardCount > 0) {
            if (discardCount == varLength) {
                return;
            }
            int changedLength = varLength - discardCount;
            String[] changedVariableNames = new String[changedLength];
            IPath[] changedVariablePaths = new IPath[changedLength];
            int i2 = 0;
            int index = 0;
            while (i2 < varLength) {
                if (variableNames[i2] != null) {
                    changedVariableNames[index] = variableNames[i2];
                    changedVariablePaths[index] = variablePaths[i2];
                    ++index;
                }
                ++i2;
            }
            variableNames = changedVariableNames;
            variablePaths = changedVariablePaths;
            varLength = changedLength;
        }
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        if (model != null) {
            IJavaProject[] projects = model.getJavaProjects();
            int i3 = 0;
            int projectLength = projects.length;
            while (i3 < projectLength) {
                IJavaProject project = projects[i3];
                IClasspathEntry[] classpath = project.getRawClasspath();
                int j = 0;
                int cpLength = classpath.length;
                block5: while (j < cpLength) {
                    IClasspathEntry entry = classpath[j];
                    int k = 0;
                    while (k < varLength) {
                        String variableName = variableNames[k];
                        if (entry.getEntryKind() == 4) {
                            IPath sourceRootPath;
                            if (variableName.equals(entry.getPath().segment(0))) {
                                affectedProjects.put(project, project.getResolvedClasspath(true));
                                break block5;
                            }
                            IPath sourcePath = entry.getSourceAttachmentPath();
                            if (sourcePath != null && variableName.equals(sourcePath.segment(0)) || (sourceRootPath = entry.getSourceAttachmentRootPath()) != null && variableName.equals(sourceRootPath.segment(0))) {
                                affectedProjects.put(project, project.getResolvedClasspath(true));
                                break block5;
                            }
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i3;
            }
        }
        i = 0;
        while (i < varLength) {
            JavaModelManager.variablePut(variableNames[i], variablePaths[i]);
            ++i;
        }
        Object[] dbgVariableNames = variableNames;
        if (!affectedProjects.isEmpty()) {
            try {
                JavaCore.run(new IWorkspaceRunnable((String[])dbgVariableNames){
                    private final /* synthetic */ String[] val$dbgVariableNames;
                    {
                        this.val$dbgVariableNames = stringArray;
                    }

                    public void run(IProgressMonitor monitor) throws CoreException {
                        Iterator projectsToUpdate = affectedProjects.keySet().iterator();
                        while (projectsToUpdate.hasNext()) {
                            if (monitor != null && monitor.isCanceled()) {
                                return;
                            }
                            JavaProject project = (JavaProject)projectsToUpdate.next();
                            if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                                System.out.println("CPVariable SET  - updating affected project: [" + project.getElementName() + "] due to setting variables: " + Util.toString(this.val$dbgVariableNames));
                            }
                            project.setRawClasspath(project.getRawClasspath(), SetClasspathOperation.ReuseOutputLocation, null, !ResourcesPlugin.getWorkspace().isTreeLocked(), (IClasspathEntry[])affectedProjects.get(project), false, false);
                        }
                    }
                }, monitor);
            }
            catch (CoreException e) {
                if (JavaModelManager.CP_RESOLVE_VERBOSE) {
                    System.out.println("CPVariable SET  - FAILED DUE TO EXCEPTION: " + Util.toString(dbgVariableNames));
                    e.printStackTrace();
                }
                if (e instanceof JavaModelException) {
                    throw (JavaModelException)e;
                }
                throw new JavaModelException(e);
            }
        }
    }
}

