/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeSet;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.NotificationManager;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.localstore.CoreFileSystemLibrary;
import org.eclipse.core.internal.localstore.FileSystemResourceManager;
import org.eclipse.core.internal.properties.PropertyManager;
import org.eclipse.core.internal.resources.AliasManager;
import org.eclipse.core.internal.resources.ComputeProjectOrder;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Folder;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.LinkDescription;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.MarkerManager;
import org.eclipse.core.internal.resources.MoveDeleteHook;
import org.eclipse.core.internal.resources.NatureManager;
import org.eclipse.core.internal.resources.OS;
import org.eclipse.core.internal.resources.PathVariableManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectDescription;
import org.eclipse.core.internal.resources.ProjectDescriptionReader;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.Resource;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceInfo;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.RootInfo;
import org.eclipse.core.internal.resources.SaveManager;
import org.eclipse.core.internal.resources.Synchronizer;
import org.eclipse.core.internal.resources.WorkManager;
import org.eclipse.core.internal.resources.WorkspaceDescription;
import org.eclipse.core.internal.resources.WorkspacePreferences;
import org.eclipse.core.internal.resources.WorkspaceRoot;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.internal.watson.ElementTreeIterator;
import org.eclipse.core.internal.watson.IElementContentVisitor;
import org.eclipse.core.internal.watson.IPathRequestor;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFileModificationValidator;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceLock;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.TeamHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;

public class Workspace
extends PlatformObject
implements IWorkspace,
ICoreConstants {
    protected WorkspacePreferences description;
    protected LocalMetaArea localMetaArea;
    protected boolean openFlag = false;
    protected ElementTree tree;
    protected ElementTree operationTree;
    protected SaveManager saveManager;
    protected BuildManager buildManager;
    protected NatureManager natureManager;
    protected NotificationManager notificationManager;
    protected FileSystemResourceManager fileSystemManager;
    protected PathVariableManager pathVariableManager;
    protected PropertyManager propertyManager;
    protected MarkerManager markerManager;
    protected WorkManager workManager;
    protected AliasManager aliasManager;
    protected long nextNodeId = 1L;
    protected long nextModificationStamp = 0L;
    protected long nextMarkerId = 0L;
    protected Synchronizer synchronizer;
    protected IProject[] buildOrder = null;
    protected boolean forceBuild = false;
    protected IWorkspaceRoot defaultRoot = new WorkspaceRoot(Path.ROOT, this);
    protected final HashSet lifecycleListeners = new HashSet(10);
    protected static final String REFRESH_ON_STARTUP = "-refresh";
    protected boolean shouldValidate = true;
    protected IFileModificationValidator validator = null;
    protected IMoveDeleteHook moveDeleteHook = null;
    protected TeamHook teamHook = null;
    public static boolean DEBUG = false;
    protected boolean treeLocked;
    protected volatile boolean overrideTreeLock = false;
    protected boolean crashed = false;

    public Workspace() {
        this.localMetaArea = new LocalMetaArea();
        this.tree = new ElementTree();
        this.tree.immutable();
        this.treeLocked = true;
        this.tree.setTreeData(this.newElement(8));
    }

    public void addLifecycleListener(ILifecycleListener listener) {
        this.lifecycleListeners.add(listener);
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        this.notificationManager.addListener(listener, 7);
    }

    public void addResourceChangeListener(IResourceChangeListener listener, int eventMask) {
        this.notificationManager.addListener(listener, eventMask);
    }

    public ISavedState addSaveParticipant(Plugin plugin, ISaveParticipant participant) throws CoreException {
        Assert.isNotNull(plugin, "Plugin must not be null");
        Assert.isNotNull(participant, "Participant must not be null");
        return this.saveManager.addParticipant(plugin, participant);
    }

    public void beginOperation(boolean createNewTree) throws CoreException {
        WorkManager workManager = this.getWorkManager();
        workManager.incrementNestedOperations();
        if (!workManager.isBalanced()) {
            Assert.isTrue(false, "Operation was not prepared.");
        }
        if (this.isTreeLocked() && createNewTree) {
            String message = Policy.bind("resources.cannotModify");
            throw new ResourceException(380, null, message, null);
        }
        if (workManager.getPreparedOperationDepth() > 1) {
            if (createNewTree && this.tree.isImmutable()) {
                this.newWorkingTree();
            }
            return;
        }
        if (createNewTree) {
            this.operationTree = this.tree;
            this.newWorkingTree();
        }
    }

    private void broadcastChanges(ElementTree currentTree, int type, boolean lockTree, boolean updateState, IProgressMonitor monitor) {
        if (this.operationTree == null) {
            return;
        }
        monitor.subTask(ICoreConstants.MSG_RESOURCES_UPDATING);
        this.notificationManager.broadcastChanges(currentTree, type, lockTree, updateState);
    }

    protected void broadcastEvent(LifecycleEvent event) throws CoreException {
        Iterator it = this.lifecycleListeners.iterator();
        while (it.hasNext()) {
            ILifecycleListener listener = (ILifecycleListener)it.next();
            listener.handleEvent(event);
        }
    }

    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, Policy.opWork);
            try {
                this.prepareOperation();
                this.beginOperation(true);
                this.getBuildManager().build(trigger, Policy.subMonitorFor(monitor, Policy.opWork));
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (this.tree.isImmutable()) {
                    this.newWorkingTree();
                }
                this.getWorkManager().avoidAutoBuild();
                this.endOperation(false, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            Object var3_5 = null;
            if (this.tree.isImmutable()) {
                this.newWorkingTree();
            }
            this.getWorkManager().avoidAutoBuild();
            this.endOperation(false, Policy.subMonitorFor(monitor, Policy.buildWork));
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            monitor.done();
            throw throwable;
        }
        Object var5_8 = null;
        monitor.done();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void checkpoint(boolean build) {
        boolean immutable = true;
        try {
            try {
                if (!this.getWorkManager().isCurrentOperation()) {
                    Object var3_3 = null;
                    if (immutable) return;
                    this.newWorkingTree();
                    return;
                }
                immutable = this.tree.isImmutable();
                this.broadcastChanges(this.tree, 8, false, false, Policy.monitorFor(null));
                if (build && this.isAutoBuilding()) {
                    this.getBuildManager().build(9, Policy.monitorFor(null));
                }
                this.broadcastChanges(this.tree, 16, false, false, Policy.monitorFor(null));
                this.broadcastChanges(this.tree, 1, true, true, Policy.monitorFor(null));
                this.getMarkerManager().resetMarkerDeltas();
            }
            catch (CoreException coreException) {}
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (immutable) throw throwable;
            this.newWorkingTree();
            throw throwable;
        }
        Object var3_5 = null;
        if (immutable) return;
        this.newWorkingTree();
    }

    public static boolean clear(java.io.File root) {
        boolean result = Workspace.clearChildren(root);
        try {
            if (root.exists()) {
                result &= root.delete();
            }
        }
        catch (Exception exception) {
            result = false;
        }
        return result;
    }

    public static boolean clearChildren(java.io.File root) {
        String[] list;
        boolean result = true;
        if (root.isDirectory() && (list = root.list()) != null) {
            int i = 0;
            while (i < list.length) {
                result &= Workspace.clear(new java.io.File(root, list[i]));
                ++i;
            }
        }
        return result;
    }

    public void close(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String msg = Policy.bind("resources.closing.0");
            int rootCount = this.tree.getChildCount(Path.ROOT);
            monitor.beginTask(msg, rootCount + 2);
            monitor.subTask(msg);
            try {
                this.prepareOperation();
                if (this.isOpen()) {
                    this.beginOperation(true);
                    IProject[] projects = this.getRoot().getProjects();
                    int i = 0;
                    while (i < projects.length) {
                        this.broadcastEvent(LifecycleEvent.newEvent(1, projects[i]));
                        monitor.worked(1);
                        ++i;
                    }
                    this.deleteResource(this.getRoot());
                    this.openFlag = false;
                }
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                this.shutdown(Policy.subMonitorFor(monitor, 2, 2));
                throw throwable;
            }
            Object var6_8 = null;
            this.shutdown(Policy.subMonitorFor(monitor, 2, 2));
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            monitor.done();
            throw throwable;
        }
        Object var8_11 = null;
        monitor.done();
    }

    public IProject[][] computePrerequisiteOrder(IProject[] targets) {
        return this.computePrerequisiteOrder1(targets);
    }

    private IProject[][] computePrerequisiteOrder1(IProject[] projects) {
        IProject project;
        IWorkspace.ProjectOrder r = this.computeProjectOrder(projects);
        if (!r.hasCycles) {
            return new IProject[][]{r.projects, new IProject[0]};
        }
        HashSet<IProject> bad = new HashSet<IProject>();
        HashSet<IProject> keepers = new HashSet<IProject>(Arrays.asList(r.projects));
        int i = 0;
        while (i < r.knots.length) {
            IProject[] knot = r.knots[i];
            int j = 0;
            while (j < knot.length) {
                project = knot[j];
                if (keepers.contains(project)) {
                    bad.add(project);
                }
                ++j;
            }
            ++i;
        }
        IProject[] result2 = new IProject[bad.size()];
        bad.toArray(result2);
        LinkedList<IProject> p = new LinkedList<IProject>();
        p.addAll(Arrays.asList(r.projects));
        ListIterator it = p.listIterator();
        while (it.hasNext()) {
            project = (IProject)it.next();
            if (!bad.contains(project)) continue;
            it.remove();
        }
        IProject[] result1 = new IProject[p.size()];
        p.toArray(result1);
        return new IProject[][]{result1, result2};
    }

    public IWorkspace.ProjectOrder computeProjectOrder(IProject[] projects) {
        IWorkspace.ProjectOrder fullProjectOrder = this.computeFullProjectOrder();
        int accessibleCount = 0;
        int i = 0;
        while (i < projects.length) {
            if (projects[i].isAccessible()) {
                ++accessibleCount;
            }
            ++i;
        }
        if (accessibleCount == fullProjectOrder.projects.length) {
            return fullProjectOrder;
        }
        HashSet<IProject> keepers = new HashSet<IProject>(Arrays.asList(projects));
        ArrayList<IProject> reducedProjects = new ArrayList<IProject>(fullProjectOrder.projects.length);
        int i2 = 0;
        while (i2 < fullProjectOrder.projects.length) {
            IProject project = fullProjectOrder.projects[i2];
            if (keepers.contains(project)) {
                reducedProjects.add(project);
            }
            ++i2;
        }
        IProject[] p1 = new IProject[reducedProjects.size()];
        reducedProjects.toArray(p1);
        ArrayList<IProject[]> reducedKnots = new ArrayList<IProject[]>(fullProjectOrder.knots.length);
        int i3 = 0;
        while (i3 < fullProjectOrder.knots.length) {
            IProject[] knot = fullProjectOrder.knots[i3];
            ArrayList<IProject> x = new ArrayList<IProject>(knot.length);
            int j = 0;
            while (j < knot.length) {
                IProject project = knot[j];
                if (keepers.contains(project)) {
                    x.add(project);
                }
                ++j;
            }
            if (x.size() > 1) {
                reducedKnots.add(x.toArray(new IProject[x.size()]));
            }
            ++i3;
        }
        IProject[][] k1 = new IProject[reducedKnots.size()][];
        reducedKnots.toArray((T[])k1);
        return new IWorkspace.ProjectOrder(p1, k1.length > 0, k1);
    }

    private IWorkspace.ProjectOrder computeFullProjectOrder() {
        TreeSet<IProject> allAccessibleProjects = new TreeSet<IProject>(new Comparator(){

            public int compare(Object x, Object y) {
                IProject px = (IProject)x;
                IProject py = (IProject)y;
                return py.getName().compareTo(px.getName());
            }
        });
        IProject[] allProjects = this.getRoot().getProjects();
        ArrayList<IProject[]> edges = new ArrayList<IProject[]>(allProjects.length);
        int i = 0;
        while (i < allProjects.length) {
            IProject project = allProjects[i];
            if (project.isAccessible()) {
                allAccessibleProjects.add(project);
                IProject[] refs = null;
                try {
                    refs = project.getReferencedProjects();
                }
                catch (CoreException coreException) {}
                int j = 0;
                while (j < refs.length) {
                    IProject ref = refs[j];
                    if (ref.isAccessible() && !ref.equals(project)) {
                        edges.add(new IProject[]{project, ref});
                    }
                    ++j;
                }
            }
            ++i;
        }
        IWorkspace.ProjectOrder fullProjectOrder = ComputeProjectOrder.computeProjectOrder(allAccessibleProjects, edges);
        return fullProjectOrder;
    }

    public IStatus copy(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IStatus iStatus;
        monitor = Policy.monitorFor(monitor);
        try {
            int opWork = Math.max(resources.length, 1);
            int totalWork = Policy.totalWork * opWork / Policy.opWork;
            String message = Policy.bind("resources.copying.0");
            monitor.beginTask(message, totalWork);
            Assert.isLegal(resources != null);
            if (resources.length == 0) {
                ResourceStatus resourceStatus = ResourceStatus.OK_STATUS;
                Object var17_10 = null;
                monitor.done();
                return resourceStatus;
            }
            resources = (IResource[])resources.clone();
            IPath parentPath = null;
            message = Policy.bind("resources.copyProblem");
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            try {
                try {
                    this.prepareOperation();
                    this.beginOperation(true);
                    int i = 0;
                    while (i < resources.length) {
                        block19: {
                            Policy.checkCanceled(monitor);
                            IResource resource = resources[i];
                            if (resource == null || Workspace.isDuplicate(resources, i)) {
                                monitor.worked(1);
                            } else {
                                if (parentPath == null) {
                                    parentPath = resource.getFullPath().removeLastSegments(1);
                                }
                                if (parentPath.equals(resource.getFullPath().removeLastSegments(1))) {
                                    try {
                                        IPath destinationPath = destination.append(resource.getName());
                                        IStatus requirements = ((Resource)resource).checkCopyRequirements(destinationPath, resource.getType(), updateFlags);
                                        if (requirements.isOK()) {
                                            try {
                                                resource.copy(destinationPath, updateFlags, Policy.subMonitorFor(monitor, 1));
                                            }
                                            catch (CoreException e) {
                                                status.merge(e.getStatus());
                                            }
                                            break block19;
                                        }
                                        monitor.worked(1);
                                        status.merge(requirements);
                                    }
                                    catch (CoreException e) {
                                        monitor.worked(1);
                                        status.merge(e.getStatus());
                                    }
                                } else {
                                    monitor.worked(1);
                                    message = Policy.bind("resources.notChild", resources[i].getFullPath().toString(), parentPath.toString());
                                    status.merge(new ResourceStatus(76, resources[i].getFullPath(), message));
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (OperationCanceledException e) {
                    this.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var15_23 = null;
                this.endOperation(true, Policy.subMonitorFor(monitor, totalWork - opWork));
                throw throwable;
            }
            Object var15_24 = null;
            this.endOperation(true, Policy.subMonitorFor(monitor, totalWork - opWork));
            if (status.matches(4)) {
                throw new ResourceException(status);
            }
            iStatus = status.isOK() ? ResourceStatus.OK_STATUS : (IStatus)status;
        }
        catch (Throwable throwable) {
            Object var17_12 = null;
            monitor.done();
            throw throwable;
        }
        Object var17_11 = null;
        monitor.done();
        return iStatus;
    }

    public IStatus copy(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        return this.copy(resources, destination, updateFlags, monitor);
    }

    protected void copyTree(IResource source, IPath destination, int depth, int updateFlags, boolean keepSyncInfo) throws CoreException {
        IResource destinationResource = this.getRoot().findMember(destination, true);
        if (destinationResource == null) {
            int destinationType = source.getType() == 1 ? 1 : (destination.segmentCount() == 1 ? 4 : 2);
            destinationResource = this.newResource(destination, destinationType);
        }
        ResourceInfo sourceInfo = ((Resource)source).getResourceInfo(true, false);
        if (destinationResource.getType() != source.getType()) {
            sourceInfo = (ResourceInfo)sourceInfo.clone();
            sourceInfo.setType(destinationResource.getType());
        }
        ResourceInfo newInfo = this.createResource(destinationResource, sourceInfo, false, false, keepSyncInfo);
        long nodeid = ((Resource)source).getResourceInfo(true, false).getNodeId();
        newInfo.setNodeId(nodeid);
        ResourceInfo oldInfo = ((Resource)source).getResourceInfo(true, false);
        newInfo.setFlags(newInfo.getFlags() | oldInfo.getFlags() & 2);
        if (source.isLinked()) {
            LinkDescription linkDescription;
            if ((updateFlags & 0x20) != 0) {
                newInfo.set(65536);
                linkDescription = new LinkDescription(destinationResource, source.getRawLocation());
            } else {
                newInfo.clear(65536);
                linkDescription = null;
            }
            Project project = (Project)destinationResource.getProject();
            project.internalGetDescription().setLinkLocation(destinationResource.getName(), linkDescription);
            project.writeDescription(updateFlags);
        }
        if (depth == 0 || source.getType() == 1) {
            return;
        }
        if (depth == 1) {
            depth = 0;
        }
        IResource[] children = ((IContainer)source).members(2);
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            IPath childPath = destination.append(child.getName());
            this.copyTree(child, childPath, depth, updateFlags, keepSyncInfo);
            ++i;
        }
    }

    public int countResources(IPath root, int depth, final boolean phantom) {
        if (!this.tree.includes(root)) {
            return 0;
        }
        switch (depth) {
            case 0: {
                return 1;
            }
            case 1: {
                return 1 + this.tree.getChildCount(root);
            }
            case 2: {
                final int[] count = new int[1];
                IElementContentVisitor visitor = new IElementContentVisitor(){

                    public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                        if (phantom || !((ResourceInfo)elementContents).isSet(8)) {
                            count[0] = count[0] + 1;
                        }
                        return true;
                    }
                };
                new ElementTreeIterator(this.tree, root).iterate(visitor);
                return count[0];
            }
        }
        return 0;
    }

    public ResourceInfo createResource(IResource resource, ResourceInfo info, boolean phantom, boolean overwrite) throws CoreException {
        return this.createResource(resource, info, phantom, overwrite, false);
    }

    public ResourceInfo createResource(IResource resource, ResourceInfo info, boolean phantom, boolean overwrite, boolean keepSyncInfo) throws CoreException {
        info = info == null ? this.newElement(resource.getType()) : (ResourceInfo)info.clone();
        ResourceInfo original = this.getResourceInfo(resource.getFullPath(), true, false);
        if (phantom) {
            info.set(8);
            info.setModificationStamp(-1L);
        }
        if (original == null) {
            if (!keepSyncInfo) {
                info.setSyncInfo(null);
            }
            this.tree.createElement(resource.getFullPath(), info);
        } else if (overwrite || !phantom && original.isSet(8)) {
            if (!keepSyncInfo) {
                info.setSyncInfo(original.getSyncInfo(true));
            }
            info.set(4096);
            this.tree.setElementData(resource.getFullPath(), info);
        } else {
            String message = Policy.bind("resources.mustNotExist", resource.getFullPath().toString());
            throw new ResourceException(367, resource.getFullPath(), message, null);
        }
        return info;
    }

    public ResourceInfo createResource(IResource resource, boolean phantom) throws CoreException {
        return this.createResource(resource, null, phantom, false);
    }

    public ResourceInfo createResource(IResource resource, boolean phantom, boolean overwrite) throws CoreException {
        return this.createResource(resource, null, phantom, overwrite);
    }

    public static WorkspaceDescription defaultWorkspaceDescription() {
        return new WorkspaceDescription("Workspace");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus delete(IResource[] resources, int updateFlags, IProgressMonitor monitor) throws CoreException {
        MultiStatus multiStatus;
        monitor = Policy.monitorFor(monitor);
        try {
            int opWork = Math.max(resources.length, 1);
            int totalWork = Policy.totalWork * opWork / Policy.opWork;
            String message = Policy.bind("resources.deleting.0");
            monitor.beginTask(message, totalWork);
            message = Policy.bind("resources.deleteProblem");
            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            if (resources.length == 0) {
                MultiStatus multiStatus2 = result;
                Object var15_9 = null;
                monitor.done();
                return multiStatus2;
            }
            resources = (IResource[])resources.clone();
            try {
                try {
                    this.prepareOperation();
                    this.beginOperation(true);
                    int i = 0;
                    while (true) {
                        block13: {
                            if (i >= resources.length) {
                                if (!result.matches(4)) break;
                                throw new ResourceException(result);
                            }
                            Policy.checkCanceled(monitor);
                            Resource resource = (Resource)resources[i];
                            if (resource == null) {
                                monitor.worked(1);
                            } else {
                                try {
                                    resource.delete(updateFlags, Policy.subMonitorFor(monitor, 1));
                                }
                                catch (CoreException e) {
                                    ResourceInfo info = resource.getResourceInfo(false, false);
                                    if (!resource.exists(resource.getFlags(info), false)) break block13;
                                    message = Policy.bind("resources.couldnotDelete", resource.getFullPath().toString());
                                    result.merge(new ResourceStatus(273, resource.getFullPath(), message));
                                    result.merge(e.getStatus());
                                }
                            }
                        }
                        ++i;
                    }
                    multiStatus = result;
                    Object var12_18 = null;
                }
                catch (OperationCanceledException e) {
                    this.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var12_19 = null;
                this.endOperation(true, Policy.subMonitorFor(monitor, totalWork - opWork));
                throw throwable;
            }
            this.endOperation(true, Policy.subMonitorFor(monitor, totalWork - opWork));
        }
        catch (Throwable throwable) {
            Object var15_11 = null;
            monitor.done();
            throw throwable;
        }
        Object var15_10 = null;
        monitor.done();
        return multiStatus;
    }

    public IStatus delete(IResource[] resources, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        return this.delete(resources, updateFlags |= 2, monitor);
    }

    public void deleteMarkers(IMarker[] markers) throws CoreException {
        Assert.isNotNull(markers);
        if (markers.length == 0) {
            return;
        }
        markers = (IMarker[])markers.clone();
        try {
            this.prepareOperation();
            this.beginOperation(true);
            int i = 0;
            while (i < markers.length) {
                if (markers[i] != null && markers[i].getResource() != null) {
                    this.markerManager.removeMarker(markers[i].getResource(), markers[i].getId());
                }
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.endOperation(false, null);
            throw throwable;
        }
        Object var3_5 = null;
        this.endOperation(false, null);
    }

    void deleteResource(IResource resource) {
        IPath path = resource.getFullPath();
        if (path.equals(Path.ROOT)) {
            IProject[] children = this.getRoot().getProjects();
            int i = 0;
            while (i < children.length) {
                this.tree.deleteElement(children[i].getFullPath());
                ++i;
            }
        } else {
            this.tree.deleteElement(path);
        }
    }

    public void dumpStats() {
        EventStats.dumpStats();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void endOperation(boolean build, IProgressMonitor monitor) throws CoreException {
        WorkManager workManager;
        block12: {
            block11: {
                workManager = this.getWorkManager();
                try {
                    workManager.setBuild(build);
                    if (workManager.getPreparedOperationDepth() > 1) {
                        Object var10_4 = null;
                        break block11;
                    }
                    try {
                        Assert.isTrue(!this.isTreeLocked() || !workManager.shouldBuild(), "The tree should not be locked.");
                        Assert.isTrue(workManager.getPreparedOperationDepth() > 0, "Mismatched begin/endOperation");
                        workManager.rebalanceNestedOperations();
                        OperationCanceledException cancel = null;
                        CoreException signal = null;
                        monitor = Policy.monitorFor(monitor);
                        monitor.subTask(ICoreConstants.MSG_RESOURCES_UPDATING);
                        boolean hasTreeChanges = this.operationTree != null && ElementTree.hasChanges(this.tree, this.operationTree, ResourceComparator.getComparator(false), true);
                        this.broadcastChanges(this.tree, 8, false, false, Policy.monitorFor(null));
                        if (this.isAutoBuilding() && this.shouldBuild(hasTreeChanges)) {
                            try {
                                this.getBuildManager().build(9, monitor);
                            }
                            catch (OperationCanceledException e) {
                                cancel = e;
                            }
                            catch (CoreException sig) {
                                signal = sig;
                            }
                        }
                        this.broadcastChanges(this.tree, 16, false, false, Policy.monitorFor(null));
                        this.broadcastChanges(this.tree, 1, true, true, Policy.monitorFor(null));
                        this.getMarkerManager().resetMarkerDeltas();
                        this.tree.immutable();
                        this.saveManager.snapshotIfNeeded(hasTreeChanges);
                        monitor.subTask("");
                        if (cancel != null) {
                            throw cancel;
                        }
                        if (signal != null) {
                            throw signal;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        this.tree.immutable();
                        this.operationTree = null;
                        throw throwable;
                    }
                    Object var8_14 = null;
                    this.tree.immutable();
                    this.operationTree = null;
                    break block12;
                }
                catch (Throwable throwable) {
                    Object var10_5 = null;
                    workManager.checkOut();
                    throw throwable;
                }
            }
            workManager.checkOut();
            return;
        }
        Object var10_6 = null;
        workManager.checkOut();
    }

    protected void flushBuildOrder() {
        if (this.description.getBuildOrder(false) == null) {
            this.buildOrder = null;
        }
    }

    public void forgetSavedTree(String pluginId) {
        Assert.isNotNull(pluginId, "PluginId must not be null");
        this.saveManager.forgetSavedTree(pluginId);
    }

    public AliasManager getAliasManager() {
        return this.aliasManager;
    }

    public BuildManager getBuildManager() {
        return this.buildManager;
    }

    public IProject[] getBuildOrder() {
        if (this.buildOrder != null) {
            return this.buildOrder;
        }
        String[] order = this.description.getBuildOrder(false);
        if (order != null) {
            ArrayList<IProject> projectList = new ArrayList<IProject>(order.length);
            int i = 0;
            while (i < order.length) {
                IProject project = this.getRoot().getProject(order[i]);
                if (project.isAccessible()) {
                    projectList.add(project);
                }
                ++i;
            }
            this.buildOrder = new IProject[projectList.size()];
            projectList.toArray(this.buildOrder);
        } else {
            this.buildOrder = this.computeFullProjectOrder().projects;
        }
        return this.buildOrder;
    }

    public Map getDanglingReferences() {
        IProject[] projects = this.getRoot().getProjects();
        HashMap<IProject, IProject[]> result = new HashMap<IProject, IProject[]>(projects.length);
        int i = 0;
        while (i < projects.length) {
            Project project = (Project)projects[i];
            if (project.isAccessible()) {
                IProject[] refs = project.internalGetDescription().getReferencedProjects(false);
                ArrayList<IProject> dangling = new ArrayList<IProject>(refs.length);
                int j = 0;
                while (j < refs.length) {
                    if (!refs[i].exists()) {
                        dangling.add(refs[i]);
                    }
                    ++j;
                }
                if (!dangling.isEmpty()) {
                    result.put(projects[i], dangling.toArray(new IProject[dangling.size()]));
                }
            }
            ++i;
        }
        return result;
    }

    public IWorkspaceDescription getDescription() {
        WorkspaceDescription workingCopy = Workspace.defaultWorkspaceDescription();
        this.description.copyTo(workingCopy);
        return workingCopy;
    }

    public ElementTree getElementTree() {
        return this.tree;
    }

    public FileSystemResourceManager getFileSystemManager() {
        return this.fileSystemManager;
    }

    public MarkerManager getMarkerManager() {
        return this.markerManager;
    }

    public LocalMetaArea getMetaArea() {
        return this.localMetaArea;
    }

    protected IMoveDeleteHook getMoveDeleteHook() {
        if (this.moveDeleteHook == null) {
            this.initializeMoveDeleteHook();
        }
        return this.moveDeleteHook;
    }

    public IProjectNatureDescriptor getNatureDescriptor(String natureId) {
        return this.natureManager.getNatureDescriptor(natureId);
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        return this.natureManager.getNatureDescriptors();
    }

    public NatureManager getNatureManager() {
        return this.natureManager;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public IPathVariableManager getPathVariableManager() {
        return this.pathVariableManager;
    }

    public PropertyManager getPropertyManager() {
        return this.propertyManager;
    }

    public ResourceInfo getResourceInfo(IPath path, boolean phantom, boolean mutable) {
        try {
            if (path.segmentCount() == 0) {
                ResourceInfo info = (ResourceInfo)this.tree.getTreeData();
                Assert.isNotNull(info, "Tree root info must never be null");
                return info;
            }
            ResourceInfo result = null;
            if (!this.tree.includes(path)) {
                return null;
            }
            result = mutable ? (ResourceInfo)this.tree.openElementData(path) : (ResourceInfo)this.tree.getElementData(path);
            if (result != null && !phantom && result.isSet(8)) {
                return null;
            }
            return result;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public IWorkspaceRoot getRoot() {
        return this.defaultRoot;
    }

    public SaveManager getSaveManager() {
        return this.saveManager;
    }

    public ISynchronizer getSynchronizer() {
        return this.synchronizer;
    }

    protected TeamHook getTeamHook() {
        if (this.teamHook == null) {
            this.initializeTeamHook();
        }
        return this.teamHook;
    }

    public WorkManager getWorkManager() throws CoreException {
        if (this.workManager == null) {
            String message = Policy.bind("resources.shutdown");
            throw new ResourceException(new ResourceStatus(566, null, message));
        }
        return this.workManager;
    }

    protected void initializeValidator() {
        this.shouldValidate = false;
        IConfigurationElement[] configs = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "fileModificationValidator");
        if (configs == null || configs.length == 0) {
            return;
        }
        if (configs.length > 1) {
            ResourceStatus status = new ResourceStatus(4, 1, null, Policy.bind("resources.oneValidator"), null);
            ResourcesPlugin.getPlugin().getLog().log(status);
            return;
        }
        try {
            IConfigurationElement config = configs[0];
            this.validator = (IFileModificationValidator)config.createExecutableExtension("class");
            this.shouldValidate = true;
        }
        catch (CoreException e) {
            ResourceStatus status = new ResourceStatus(4, 1, null, Policy.bind("resources.initValidator"), (Throwable)e);
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeMoveDeleteHook() {
        block9: {
            block8: {
                try {
                    IConfigurationElement[] configs;
                    block11: {
                        block10: {
                            configs = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "moveDeleteHook");
                            if (configs == null) break block10;
                            if (configs.length != 0) break block11;
                        }
                        Object var4_2 = null;
                        if (this.moveDeleteHook != null) return;
                        this.moveDeleteHook = new MoveDeleteHook();
                        return;
                    }
                    if (configs.length > 1) {
                        ResourceStatus status = new ResourceStatus(4, 1, null, Policy.bind("resources.oneHook"), null);
                        ResourcesPlugin.getPlugin().getLog().log(status);
                        break block8;
                    }
                    try {
                        IConfigurationElement config = configs[0];
                        this.moveDeleteHook = (IMoveDeleteHook)config.createExecutableExtension("class");
                    }
                    catch (CoreException e) {
                        ResourceStatus status = new ResourceStatus(4, 1, null, Policy.bind("resources.initHook"), (Throwable)e);
                        ResourcesPlugin.getPlugin().getLog().log(status);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (this.moveDeleteHook != null) throw throwable;
                    this.moveDeleteHook = new MoveDeleteHook();
                    throw throwable;
                }
            }
            Object var4_3 = null;
            if (this.moveDeleteHook != null) return;
            this.moveDeleteHook = new MoveDeleteHook();
            return;
        }
        Object var4_5 = null;
        if (this.moveDeleteHook != null) return;
        this.moveDeleteHook = new MoveDeleteHook();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initializeTeamHook() {
        block9: {
            block8: {
                block7: {
                    try {
                        IConfigurationElement[] configs;
                        block11: {
                            block10: {
                                configs = Platform.getPluginRegistry().getConfigurationElementsFor("org.eclipse.core.resources", "teamHook");
                                if (configs == null) break block10;
                                if (configs.length != 0) break block11;
                            }
                            Object var4_2 = null;
                            if (this.teamHook != null) return;
                            break block7;
                        }
                        if (configs.length > 1) {
                            ResourceStatus status = new ResourceStatus(4, 1, null, Policy.bind("resources.oneTeamHook"), null);
                            ResourcesPlugin.getPlugin().getLog().log(status);
                            break block8;
                        }
                        try {
                            IConfigurationElement config = configs[0];
                            this.teamHook = (TeamHook)config.createExecutableExtension("class");
                        }
                        catch (CoreException e) {
                            ResourceStatus status = new ResourceStatus(4, 1, null, Policy.bind("resources.initTeamHook"), (Throwable)e);
                            ResourcesPlugin.getPlugin().getLog().log(status);
                        }
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        if (this.teamHook != null) throw throwable;
                        this.teamHook = new TeamHook(){};
                        throw throwable;
                    }
                }
                this.teamHook = new /* invalid duplicate definition of identical inner class */;
                return;
            }
            Object var4_3 = null;
            if (this.teamHook != null) return;
            this.teamHook = new /* invalid duplicate definition of identical inner class */;
            return;
        }
        Object var4_5 = null;
        if (this.teamHook != null) return;
        this.teamHook = new /* invalid duplicate definition of identical inner class */;
    }

    public WorkspaceDescription internalGetDescription() {
        return this.description;
    }

    public boolean isAutoBuilding() {
        return this.description.isAutoBuilding();
    }

    private static boolean isDuplicate(Object[] array, int position) {
        if (array == null || position >= array.length) {
            return false;
        }
        int j = position - 1;
        while (j >= 0) {
            if (array[j].equals(array[position])) {
                return true;
            }
            --j;
        }
        return false;
    }

    public boolean isOpen() {
        return this.openFlag;
    }

    protected boolean isOverlapping(IPath location1, IPath location2, boolean bothDirections) {
        IPath one = location1;
        IPath two = location2;
        if (!CoreFileSystemLibrary.isCaseSensitive()) {
            one = new Path(location1.toOSString().toLowerCase());
            two = new Path(location2.toOSString().toLowerCase());
        }
        return one.isPrefixOf(two) || bothDirections && two.isPrefixOf(one);
    }

    public boolean isTreeLocked() {
        if (this.overrideTreeLock) {
            return false;
        }
        return this.treeLocked;
    }

    protected void linkTrees(IPath path, ElementTree[] newTrees) throws CoreException {
        this.tree = this.tree.mergeDeltaChain(path, newTrees);
    }

    public IProjectDescription loadProjectDescription(IPath path) throws CoreException {
        ProjectDescription result = null;
        IOException e = null;
        try {
            result = new ProjectDescriptionReader().read(path);
            if (result != null) {
                IPath user = path.removeLastSegments(1);
                IPath platform = Platform.getLocation().append(result.getName());
                if (!user.toFile().equals(platform.toFile())) {
                    result.setLocation(user);
                }
            }
        }
        catch (IOException ex) {
            e = ex;
        }
        if (result == null || e != null) {
            String message = Policy.bind("resources.errorReadProject", path.toOSString());
            Status status = new Status(4, "org.eclipse.core.resources", 567, message, e);
            throw new ResourceException(status);
        }
        return result;
    }

    public IStatus move(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        IStatus iStatus;
        monitor = Policy.monitorFor(monitor);
        try {
            int opWork = Math.max(resources.length, 1);
            int totalWork = Policy.totalWork * opWork / Policy.opWork;
            String message = Policy.bind("resources.moving.0");
            monitor.beginTask(message, totalWork);
            Assert.isLegal(resources != null);
            if (resources.length == 0) {
                ResourceStatus resourceStatus = ResourceStatus.OK_STATUS;
                Object var16_10 = null;
                monitor.done();
                return resourceStatus;
            }
            resources = (IResource[])resources.clone();
            IPath parentPath = null;
            message = Policy.bind("resources.moveProblem");
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            try {
                try {
                    this.prepareOperation();
                    this.beginOperation(true);
                    int i = 0;
                    while (i < resources.length) {
                        block19: {
                            Policy.checkCanceled(monitor);
                            Resource resource = (Resource)resources[i];
                            if (resource == null || Workspace.isDuplicate(resources, i)) {
                                monitor.worked(1);
                            } else {
                                if (parentPath == null) {
                                    parentPath = resource.getFullPath().removeLastSegments(1);
                                }
                                if (parentPath.equals(resource.getFullPath().removeLastSegments(1))) {
                                    try {
                                        IStatus requirements = resource.checkMoveRequirements(destination.append(resource.getName()), resource.getType(), updateFlags);
                                        if (requirements.isOK()) {
                                            try {
                                                resource.move(destination.append(resource.getName()), updateFlags, Policy.subMonitorFor(monitor, 1));
                                            }
                                            catch (CoreException e) {
                                                status.merge(e.getStatus());
                                            }
                                            break block19;
                                        }
                                        monitor.worked(1);
                                        status.merge(requirements);
                                    }
                                    catch (CoreException e) {
                                        monitor.worked(1);
                                        status.merge(e.getStatus());
                                    }
                                } else {
                                    monitor.worked(1);
                                    message = Policy.bind("resources.notChild", resource.getFullPath().toString(), parentPath.toString());
                                    status.merge(new ResourceStatus(76, resource.getFullPath(), message));
                                }
                            }
                        }
                        ++i;
                    }
                }
                catch (OperationCanceledException e) {
                    this.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var14_22 = null;
                this.endOperation(true, Policy.subMonitorFor(monitor, totalWork - opWork));
                throw throwable;
            }
            Object var14_23 = null;
            this.endOperation(true, Policy.subMonitorFor(monitor, totalWork - opWork));
            if (status.matches(4)) {
                throw new ResourceException(status);
            }
            iStatus = status.isOK() ? (IStatus)ResourceStatus.OK_STATUS : (IStatus)status;
        }
        catch (Throwable throwable) {
            Object var16_12 = null;
            monitor.done();
            throw throwable;
        }
        Object var16_11 = null;
        monitor.done();
        return iStatus;
    }

    public IStatus move(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int updateFlags = force ? 1 : 0;
        return this.move(resources, destination, updateFlags |= 2, monitor);
    }

    void move(Resource source, IPath destination, int depth, int updateFlags, boolean keepSyncInfo) throws CoreException {
        this.copyTree(source, destination, depth, updateFlags, keepSyncInfo);
        source.fixupAfterMoveSource();
    }

    protected ResourceInfo newElement(int type) {
        ResourceInfo result = null;
        switch (type) {
            case 1: 
            case 2: {
                result = new ResourceInfo();
                break;
            }
            case 4: {
                result = new ProjectInfo();
                break;
            }
            case 8: {
                result = new RootInfo();
            }
        }
        result.setNodeId(this.nextNodeId());
        result.setModificationStamp(this.nextModificationStamp());
        result.setType(type);
        return result;
    }

    public IProjectDescription newProjectDescription(String projectName) {
        ProjectDescription result = new ProjectDescription();
        result.setName(projectName);
        return result;
    }

    public Resource newResource(IPath path, int type) {
        switch (type) {
            case 2: {
                if (path.segmentCount() < 2) {
                    String message = "Path must include project and resource name: " + path.toString();
                    Assert.isLegal(false, message);
                }
                return new Folder(path.makeAbsolute(), this);
            }
            case 1: {
                if (path.segmentCount() < 2) {
                    String message = "Path must include project and resource name: " + path.toString();
                    Assert.isLegal(false, message);
                }
                return new File(path.makeAbsolute(), this);
            }
            case 4: {
                return (Resource)((Object)this.getRoot().getProject(path.lastSegment()));
            }
            case 8: {
                return (Resource)((Object)this.getRoot());
            }
        }
        Assert.isLegal(false);
        return null;
    }

    public ElementTree newWorkingTree() {
        this.tree = this.tree.newEmptyDelta();
        return this.tree;
    }

    protected long nextMarkerId() {
        return this.nextMarkerId++;
    }

    public long nextModificationStamp() {
        return this.nextModificationStamp++;
    }

    public long nextNodeId() {
        return this.nextNodeId++;
    }

    public IStatus open(IProgressMonitor monitor) throws CoreException {
        String message = Policy.bind("resources.workspaceOpen");
        Assert.isTrue(!this.isOpen(), message);
        if (!this.getMetaArea().hasSavedWorkspace()) {
            message = Policy.bind("resources.readWorkspaceMeta");
            throw new ResourceException(567, Platform.getLocation(), message, null);
        }
        this.description = new WorkspacePreferences();
        this.description.setDefaults(Workspace.defaultWorkspaceDescription());
        WorkspaceDescription oldDescription = this.getMetaArea().readOldWorkspace();
        if (oldDescription != null) {
            this.description.copyFrom(oldDescription);
            ResourcesPlugin.getPlugin().savePluginPreferences();
        }
        this.localMetaArea.locationFor(this.getRoot()).toFile().mkdirs();
        boolean oldBuildFlag = this.description.isAutoBuilding();
        try {
            this.description.setAutoBuilding(false);
            IProgressMonitor nullMonitor = Policy.monitorFor(null);
            this.startup(nullMonitor);
            this.notificationManager.startup(null);
            this.openFlag = true;
            if (this.crashed || this.refreshRequested()) {
                try {
                    this.getRoot().refreshLocal(2, null);
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    Object var7_9 = null;
                    this.description.setAutoBuilding(oldBuildFlag);
                    return iStatus;
                }
            }
            ResourceStatus resourceStatus = ResourceStatus.OK_STATUS;
            Object var7_10 = null;
            this.description.setAutoBuilding(oldBuildFlag);
            return resourceStatus;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            this.description.setAutoBuilding(oldBuildFlag);
            throw throwable;
        }
    }

    public void prepareOperation() throws CoreException {
        this.getWorkManager().checkIn();
        if (!this.isOpen()) {
            String message = Policy.bind("resources.workspaceClosed");
            throw new ResourceException(76, null, message, null);
        }
    }

    protected boolean refreshRequested() {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if (args[i].equalsIgnoreCase(REFRESH_ON_STARTUP)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        this.notificationManager.removeListener(listener);
    }

    public void removeSaveParticipant(Plugin plugin) {
        Assert.isNotNull(plugin, "Plugin must not be null");
        this.saveManager.removeParticipant(plugin);
    }

    public void run(IWorkspaceRunnable job, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(null, Policy.totalWork);
            try {
                try {
                    this.prepareOperation();
                    this.beginOperation(true);
                    job.run(Policy.subMonitorFor(monitor, Policy.opWork, 4));
                }
                catch (OperationCanceledException e) {
                    this.getWorkManager().operationCanceled();
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.endOperation(false, Policy.subMonitorFor(monitor, Policy.buildWork));
                throw throwable;
            }
            Object var4_6 = null;
            this.endOperation(false, Policy.subMonitorFor(monitor, Policy.buildWork));
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            monitor.done();
            throw throwable;
        }
        Object var6_9 = null;
        monitor.done();
    }

    public IStatus save(boolean full, IProgressMonitor monitor) throws CoreException {
        ResourceStatus resourceStatus;
        if (full) {
            if (this.getWorkManager().getCurrentOperationThread() == Thread.currentThread()) {
                String message = Policy.bind("resources.saveOp");
                throw new ResourceException(76, null, message, null);
            }
            return this.saveManager.save(1, null, monitor);
        }
        try {
            this.prepareOperation();
            this.beginOperation(false);
            this.saveManager.requestSnapshot();
            String message = Policy.bind("resources.snapRequest");
            resourceStatus = new ResourceStatus(0, message);
            Object var4_6 = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.endOperation(false, null);
            throw throwable;
        }
        this.endOperation(false, null);
        return resourceStatus;
    }

    public void setCrashed(boolean value) {
        this.crashed = value;
    }

    public void setDescription(IWorkspaceDescription value) throws CoreException {
        WorkspaceDescription newDescription = (WorkspaceDescription)value;
        String[] newOrder = newDescription.getBuildOrder(false);
        if (this.description.getBuildOrder(false) != null || newOrder != null) {
            this.buildOrder = null;
        }
        if (!this.description.isAutoBuilding() && newDescription.isAutoBuilding()) {
            this.forceBuild = true;
        }
        this.description.copyFrom(newDescription);
        Policy.setupAutoBuildProgress(this.description.isAutoBuilding());
        ResourcesPlugin.getPlugin().savePluginPreferences();
    }

    public void setTreeLocked(boolean locked) {
        this.treeLocked = locked;
    }

    public void setWorkspaceLock(WorkspaceLock lock) {
        this.workManager.setWorkspaceLock(lock);
    }

    private boolean shouldBuild(boolean hasTreeChanges) throws CoreException {
        if (this.forceBuild) {
            this.forceBuild = false;
            return true;
        }
        return hasTreeChanges && this.getWorkManager().shouldBuild();
    }

    protected void shutdown(IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            IManager[] managers = new IManager[]{this.buildManager, this.notificationManager, this.propertyManager, this.pathVariableManager, this.fileSystemManager, this.markerManager, this.saveManager, this.workManager, this.aliasManager};
            monitor.beginTask(null, managers.length);
            String message = Policy.bind("resources.shutdownProblems");
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, message, null);
            int i = 0;
            while (i < managers.length) {
                IManager manager = managers[i];
                if (manager == null) {
                    monitor.worked(1);
                } else {
                    try {
                        manager.shutdown(Policy.subMonitorFor(monitor, 1));
                    }
                    catch (Exception e) {
                        message = Policy.bind("resources.shutdownProblems");
                        status.add(new Status(4, "org.eclipse.core.resources", 566, message, e));
                    }
                }
                ++i;
            }
            this.buildManager = null;
            this.notificationManager = null;
            this.propertyManager = null;
            this.pathVariableManager = null;
            this.fileSystemManager = null;
            this.markerManager = null;
            this.synchronizer = null;
            this.saveManager = null;
            this.workManager = null;
            if (!status.isOK()) {
                throw new CoreException(status);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            monitor.done();
            throw throwable;
        }
        Object var8_10 = null;
        monitor.done();
    }

    public String[] sortNatureSet(String[] natureIds) {
        return this.natureManager.sortNatureSet(natureIds);
    }

    protected void startup(IProgressMonitor monitor) throws CoreException {
        this.workManager = new WorkManager(this);
        this.workManager.startup(null);
        this.fileSystemManager = new FileSystemResourceManager(this);
        this.fileSystemManager.startup(monitor);
        this.propertyManager = new PropertyManager(this);
        this.propertyManager.startup(monitor);
        this.pathVariableManager = new PathVariableManager(this);
        this.pathVariableManager.startup(null);
        this.natureManager = new NatureManager();
        this.natureManager.startup(null);
        this.buildManager = new BuildManager(this);
        this.buildManager.startup(null);
        this.notificationManager = new NotificationManager(this);
        this.notificationManager.startup(null);
        this.markerManager = new MarkerManager(this);
        this.markerManager.startup(null);
        this.synchronizer = new Synchronizer(this);
        this.saveManager = new SaveManager(this);
        this.saveManager.startup(null);
        this.aliasManager = new AliasManager(this);
        this.aliasManager.startup(null);
        this.treeLocked = false;
    }

    public String toDebugString() {
        final StringBuffer buffer = new StringBuffer("\nDump of " + this.toString() + ":\n");
        buffer.append("  parent: " + this.tree.getParent());
        IElementContentVisitor visitor = new IElementContentVisitor(){

            public boolean visitElement(ElementTree tree, IPathRequestor requestor, Object elementContents) {
                buffer.append("\n  " + requestor.requestPath() + ": " + elementContents);
                return true;
            }
        };
        new ElementTreeIterator(this.tree, Path.ROOT).iterate(visitor);
        return buffer.toString();
    }

    public void updateModificationStamp(ResourceInfo info) {
        info.setModificationStamp(this.nextModificationStamp());
    }

    public IStatus validateEdit(final IFile[] files, final Object context) {
        if (!this.shouldValidate) {
            String message = Policy.bind("resources.readOnly2");
            MultiStatus result = new MultiStatus("org.eclipse.core.resources", 0, message, null);
            int i = 0;
            while (i < files.length) {
                if (files[i].isReadOnly()) {
                    IPath filePath = files[i].getFullPath();
                    message = Policy.bind("resources.readOnly", filePath.toString());
                    result.add(new ResourceStatus(272, filePath, message));
                }
                ++i;
            }
            return result.isOK() ? ResourceStatus.OK_STATUS : (IStatus)result;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return ResourceStatus.OK_STATUS;
        }
        final IStatus[] status = new IStatus[1];
        ISafeRunnable body = new ISafeRunnable(){

            public void run() throws Exception {
                status[0] = Workspace.this.validator.validateEdit(files, context);
            }

            public void handleException(Throwable exception) {
                status[0] = new ResourceStatus(4, null, Policy.bind("resources.errorValidator"), exception);
            }
        };
        Platform.run(body);
        return status[0];
    }

    public IStatus validateLinkLocation(IResource resource, IPath unresolvedLocation) {
        IPath testLocation;
        if (ResourcesPlugin.getPlugin().getPluginPreferences().getBoolean("description.disableLinking")) {
            String message = Policy.bind("links.workspaceVeto", resource.getName());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        IContainer parent = resource.getParent();
        if (parent == null || parent.getType() != 4) {
            String message = Policy.bind("links.parentNotProject", resource.getName());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        if (!parent.isAccessible()) {
            String message = Policy.bind("links.parentNotAccessible", resource.getFullPath().toString());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        IPath location = this.getPathVariableManager().resolvePath(unresolvedLocation);
        String[] natureIds = ((Project)parent).internalGetDescription().getNatureIds();
        IStatus result = this.getNatureManager().validateLinkCreation(natureIds);
        if (!result.isOK()) {
            return result;
        }
        result = resource.getType() == 1 ? this.getTeamHook().validateCreateLink((IFile)resource, 0, location) : this.getTeamHook().validateCreateLink((IFolder)resource, 0, location);
        if (!result.isOK()) {
            return result;
        }
        if (location.isEmpty()) {
            String message = Policy.bind("links.noPath");
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        int segmentCount = location.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            result = this.validateName(location.segment(i), resource.getType());
            if (!result.isOK()) {
                return result;
            }
            ++i;
        }
        if (location.isAbsolute() && location.getDevice() == null) {
            location = new Path(location.toFile().getAbsolutePath());
        }
        if (this.isOverlapping(location, testLocation = this.getMetaArea().getLocation(), true)) {
            String message = Policy.bind("links.invalidLocation", location.toOSString());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        testLocation = resource.getProject().getLocation();
        if (testLocation != null && this.isOverlapping(location, testLocation, false)) {
            String message = Policy.bind("links.locationOverlapsProject", location.toOSString());
            return new ResourceStatus(77, resource.getFullPath(), message);
        }
        if (!location.isAbsolute()) {
            String message = Policy.bind("pathvar.undefined", location.toOSString(), location.segment(0));
            return new ResourceStatus(333, resource.getFullPath(), message);
        }
        IProject[] projects = this.getRoot().getProjects();
        int i2 = 0;
        while (i2 < projects.length) {
            IProject project = projects[i2];
            ProjectDescription desc = ((Project)project).internalGetDescription();
            testLocation = desc.getLocation();
            if (testLocation != null && this.isOverlapping(location, testLocation, true)) {
                String message = Policy.bind("links.overlappingResource", location.toOSString());
                return new ResourceStatus(235, resource.getFullPath(), message);
            }
            if (project.isOpen()) {
                IResource[] children = null;
                try {
                    children = project.members();
                }
                catch (CoreException coreException) {}
                if (children != null) {
                    int j = 0;
                    while (j < children.length) {
                        if (children[j].isLinked() && (testLocation = children[j].getLocation()) != null && this.isOverlapping(location, testLocation, true)) {
                            String message = Policy.bind("links.overlappingResource", location.toOSString());
                            return new ResourceStatus(235, resource.getFullPath(), message);
                        }
                        ++j;
                    }
                }
            }
            ++i2;
        }
        return ResourceStatus.OK_STATUS;
    }

    public IStatus validateName(String segment, int type) {
        if (segment == null) {
            String message = Policy.bind("resources.nameNull");
            return new ResourceStatus(77, null, message);
        }
        if (segment.length() == 0) {
            String message = Policy.bind("resources.nameEmpty");
            return new ResourceStatus(77, null, message);
        }
        if (Character.isWhitespace(segment.charAt(0)) || Character.isWhitespace(segment.charAt(segment.length() - 1))) {
            String message = Policy.bind("resources.invalidWhitespace", segment);
            return new ResourceStatus(77, null, message);
        }
        if (segment.endsWith(".")) {
            String message = Policy.bind("resources.invalidDot", segment);
            return new ResourceStatus(77, null, message);
        }
        char[] chars = OS.INVALID_RESOURCE_CHARACTERS;
        int i = 0;
        while (i < chars.length) {
            if (segment.indexOf(chars[i]) != -1) {
                String message = Policy.bind("resources.invalidCharInName", String.valueOf(chars[i]), segment);
                return new ResourceStatus(77, null, message);
            }
            ++i;
        }
        if (!OS.isNameValid(segment)) {
            String message = Policy.bind("resources.invalidName", segment);
            return new ResourceStatus(77, null, message);
        }
        return ResourceStatus.OK_STATUS;
    }

    public IStatus validateNatureSet(String[] natureIds) {
        return this.natureManager.validateNatureSet(natureIds);
    }

    public IStatus validatePath(String path, int type) {
        if (path == null) {
            String message = Policy.bind("resources.pathNull");
            return new ResourceStatus(77, null, message);
        }
        if (path.indexOf(58) != -1) {
            String message = Policy.bind("resources.invalidCharInPath", String.valueOf(':'), path);
            return new ResourceStatus(77, null, message);
        }
        Path testPath = new Path(path);
        if (testPath.isRoot()) {
            String message = Policy.bind("resources.invalidRoot");
            return new ResourceStatus(77, null, message);
        }
        if (!testPath.isAbsolute()) {
            String message = Policy.bind("resources.mustBeAbsolute", path);
            return new ResourceStatus(77, null, message);
        }
        int numberOfSegments = testPath.segmentCount();
        if ((type & 4) != 0) {
            if (numberOfSegments == 1) {
                return this.validateName(testPath.segment(0), 4);
            }
            if (type == 4) {
                String message = Policy.bind("resources.projectPath", path);
                return new ResourceStatus(77, null, message);
            }
        }
        if ((type & 3) != 0) {
            if (numberOfSegments >= 2) {
                IStatus status = this.validateName(testPath.segment(0), 4);
                if (!status.isOK()) {
                    return status;
                }
                int fileFolderType = type &= 0xFFFFFFFB;
                int segmentCount = testPath.segmentCount();
                int i = 1;
                while (i < segmentCount) {
                    status = this.validateName(testPath.segment(i), fileFolderType);
                    if (!status.isOK()) {
                        return status;
                    }
                    ++i;
                }
                return ResourceStatus.OK_STATUS;
            }
            String message = Policy.bind("resources.resourcePath", path);
            return new ResourceStatus(77, null, message);
        }
        String message = Policy.bind("resources.invalidPath", path);
        return new ResourceStatus(77, null, message);
    }

    public IStatus validateProjectLocation(IProject context, IPath unresolvedLocation) {
        IPath defaultDefaultLocation;
        if (unresolvedLocation == null) {
            return ResourceStatus.OK_STATUS;
        }
        IPath location = this.getPathVariableManager().resolvePath(unresolvedLocation);
        int segmentCount = location.segmentCount();
        int i = 0;
        while (i < segmentCount) {
            IStatus result = this.validateName(location.segment(i), 4);
            if (!result.isOK()) {
                return result;
            }
            ++i;
        }
        if (!location.isAbsolute()) {
            String message = location.segmentCount() > 0 ? Policy.bind("pathvar.undefined", location.toOSString(), location.segment(0)) : Policy.bind("links.noPath");
            return new ResourceStatus(379, null, message);
        }
        if (location.getDevice() == null) {
            location = new Path(location.toFile().getAbsolutePath());
        }
        if (this.isOverlapping(location, defaultDefaultLocation = Platform.getLocation(), true)) {
            String message = Policy.bind("resources.overlapLocal", location.toString(), defaultDefaultLocation.toString());
            return new ResourceStatus(77, null, message);
        }
        IProject[] projects = this.getRoot().getProjects();
        int j = 0;
        while (j < projects.length) {
            IProject project = projects[j];
            ProjectDescription desc = ((Project)project).internalGetDescription();
            IPath definedLocalLocation = desc.getLocation();
            if (!(definedLocalLocation == null || project.equals(context) && definedLocalLocation.equals(location) || !this.isOverlapping(location, definedLocalLocation, true))) {
                String message = Policy.bind("resources.overlapLocal", location.toString(), definedLocalLocation.toString());
                return new ResourceStatus(77, null, message);
            }
            ++j;
        }
        if (context.exists() && context.isOpen()) {
            IResource[] children = null;
            try {
                children = context.members();
            }
            catch (CoreException coreException) {}
            if (children != null) {
                int i2 = 0;
                while (i2 < children.length) {
                    IPath testLocation;
                    if (children[i2].isLinked() && (testLocation = children[i2].getLocation()) != null && this.isOverlapping(testLocation, location, false)) {
                        String message = Policy.bind("links.locationOverlapsLink", location.toOSString());
                        return new ResourceStatus(235, context.getFullPath(), message);
                    }
                    ++i2;
                }
            }
        }
        return ResourceStatus.OK_STATUS;
    }

    protected void validateSave(final IFile file) throws CoreException {
        if (!this.shouldValidate) {
            return;
        }
        if (this.validator == null) {
            this.initializeValidator();
        }
        if (this.validator == null) {
            return;
        }
        final IStatus[] status = new IStatus[1];
        ISafeRunnable body = new ISafeRunnable(){

            public void run() throws Exception {
                status[0] = Workspace.this.validator.validateSave(file);
            }

            public void handleException(Throwable exception) {
                status[0] = new ResourceStatus(4, null, Policy.bind("resources.errorValidator"), exception);
            }
        };
        Platform.run(body);
        if (!status[0].isOK()) {
            throw new ResourceException(status[0]);
        }
    }
}

