/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.internal.dtree.DeltaDataTree;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuilderPersistentInfo;
import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.ICoreConstants;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.ProjectInfo;
import org.eclipse.core.internal.resources.ResourceException;
import org.eclipse.core.internal.resources.ResourceStatus;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Assert;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class BuildManager
implements ICoreConstants,
IManager,
ILifecycleListener {
    protected Workspace workspace;
    protected boolean building = false;
    private long timeStamp = -1L;
    protected ElementTree currentTree;
    protected ElementTree lastBuiltTree;
    protected InternalBuilder currentBuilder;
    protected DeltaDataTree currentDelta;
    protected boolean rebuildRequested = false;
    protected final ArrayList builtProjects = new ArrayList();
    protected final DeltaCache deltaCache = new DeltaCache();

    public BuildManager(Workspace workspace) {
        this.workspace = workspace;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void basicBuild(int trigger, IncrementalProjectBuilder builder, Map args, MultiStatus status, IProgressMonitor monitor) {
        try {
            block8: {
                block7: {
                    this.currentBuilder = builder;
                    this.currentBuilder.clearForgetLastBuiltState();
                    this.lastBuiltTree = this.currentBuilder.getLastBuiltTree();
                    boolean fullBuild = trigger == 6 || this.lastBuiltTree == null;
                    this.currentTree = fullBuild ? null : this.workspace.getElementTree();
                    try {
                        if (!fullBuild && !this.needsBuild(this.currentBuilder)) {
                            Object var9_7 = null;
                            this.hookEndBuild(builder);
                            ElementTree lastTree = this.workspace.getElementTree();
                            lastTree.immutable();
                            if (!this.currentBuilder.wasForgetStateRequested()) {
                                this.currentBuilder.setLastBuiltTree(lastTree);
                            }
                            break block7;
                        }
                        String name = this.currentBuilder.getLabel();
                        String message = name != null ? Policy.bind("events.invoking.2", name, builder.getProject().getFullPath().toString()) : Policy.bind("events.invoking.1", builder.getProject().getFullPath().toString());
                        monitor.subTask(message);
                        this.hookStartBuild(builder, trigger);
                        Platform.run(this.getSafeRunnable(trigger, args, status, monitor));
                        break block8;
                    }
                    catch (Throwable throwable) {
                        Object var9_8 = null;
                        this.hookEndBuild(builder);
                        ElementTree lastTree = this.workspace.getElementTree();
                        lastTree.immutable();
                        if (this.currentBuilder.wasForgetStateRequested()) throw throwable;
                        this.currentBuilder.setLastBuiltTree(lastTree);
                        throw throwable;
                    }
                }
                Object var12_13 = null;
                this.currentBuilder = null;
                this.currentTree = null;
                this.lastBuiltTree = null;
                this.currentDelta = null;
                return;
            }
            Object var9_9 = null;
            this.hookEndBuild(builder);
            ElementTree lastTree = this.workspace.getElementTree();
            lastTree.immutable();
            if (!this.currentBuilder.wasForgetStateRequested()) {
                this.currentBuilder.setLastBuiltTree(lastTree);
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            this.currentBuilder = null;
            this.currentTree = null;
            this.lastBuiltTree = null;
            this.currentDelta = null;
            throw throwable;
        }
        Object var12_15 = null;
        this.currentBuilder = null;
        this.currentTree = null;
        this.lastBuiltTree = null;
        this.currentDelta = null;
    }

    protected void basicBuild(final IProject project, final int trigger, final MultiStatus status, final IProgressMonitor monitor) {
        if (!project.isAccessible()) {
            return;
        }
        final ICommand[] commands = ((Project)project).internalGetDescription().getBuildSpec(false);
        if (commands.length == 0) {
            return;
        }
        ISafeRunnable code = new ISafeRunnable(){

            public void run() throws Exception {
                BuildManager.this.basicBuild(project, trigger, commands, status, monitor);
            }

            public void handleException(Throwable e) {
                if (e instanceof OperationCanceledException) {
                    throw (OperationCanceledException)e;
                }
                String message = e.getMessage();
                if (message == null) {
                    message = Policy.bind("events.unknown", e.getClass().getName(), BuildManager.this.currentBuilder.getClass().getName());
                }
                status.add(new Status(2, "org.eclipse.core.resources", 566, message, e));
            }
        };
        Platform.run(code);
    }

    protected void basicBuild(IProject project, int trigger, String builderName, Map args, MultiStatus status, IProgressMonitor monitor) {
        IncrementalProjectBuilder builder = null;
        try {
            builder = this.getBuilder(builderName, project, status);
            if (!this.validateNature(builder, builderName)) {
                builder.setLastBuiltTree(null);
                return;
            }
        }
        catch (CoreException e) {
            status.add(e.getStatus());
            return;
        }
        this.basicBuild(trigger, builder, args, status, monitor);
    }

    protected void basicBuild(IProject project, int trigger, ICommand[] commands, MultiStatus status, IProgressMonitor monitor) {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("events.building.1", project.getFullPath().toString());
            monitor.beginTask(message, Math.max(1, commands.length));
            int i = 0;
            while (i < commands.length) {
                IProgressMonitor sub = Policy.subMonitorFor(monitor, 1);
                BuildCommand command = (BuildCommand)commands[i];
                this.basicBuild(project, trigger, command.getBuilderName(), command.getArguments(false), status, sub);
                Policy.checkCanceled(monitor);
                ++i;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            monitor.done();
            throw throwable;
        }
        Object var10_12 = null;
        monitor.done();
    }

    public void build(int trigger, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            monitor.beginTask(ICoreConstants.MSG_EVENTS_BUILDING_0, Policy.totalWork);
            if (!this.canRun(trigger)) {
                Object var9_3 = null;
                monitor.done();
                return;
            }
            try {
                this.building = true;
                IProject[] ordered = this.workspace.getBuildOrder();
                HashSet<IProject> leftover = new HashSet<IProject>(Arrays.asList(this.workspace.getRoot().getProjects()));
                leftover.removeAll(Arrays.asList(ordered));
                IProject[] unordered = ((AbstractCollection)leftover).toArray(new IProject[leftover.size()]);
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 75, ICoreConstants.MSG_EVENTS_ERRORS, null);
                this.basicBuildLoop(ordered, unordered, trigger, status, monitor);
                if (!status.isOK()) {
                    throw new ResourceException(status);
                }
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                this.building = false;
                this.builtProjects.clear();
                this.deltaCache.flush();
                throw throwable;
            }
            Object var7_12 = null;
            this.building = false;
            this.builtProjects.clear();
            this.deltaCache.flush();
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            monitor.done();
            throw throwable;
        }
        Object var9_5 = null;
        monitor.done();
    }

    protected void basicBuildLoop(IProject[] ordered, IProject[] unordered, int trigger, MultiStatus status, IProgressMonitor monitor) {
        int maxIterations;
        int projectWork = ordered.length + unordered.length;
        if (projectWork > 0) {
            projectWork = Policy.totalWork / projectWork;
        }
        if ((maxIterations = this.workspace.getDescription().getMaxBuildIterations()) <= 0) {
            maxIterations = 1;
        }
        this.rebuildRequested = true;
        int iter = 0;
        while (this.rebuildRequested && iter < maxIterations) {
            this.rebuildRequested = false;
            this.builtProjects.clear();
            int i = 0;
            while (i < ordered.length) {
                if (ordered[i].isAccessible()) {
                    this.basicBuild(ordered[i], trigger, status, Policy.subMonitorFor(monitor, projectWork));
                    this.builtProjects.add(ordered[i]);
                }
                ++i;
            }
            i = 0;
            while (i < unordered.length) {
                if (unordered[i].isAccessible()) {
                    this.basicBuild(unordered[i], trigger, status, Policy.subMonitorFor(monitor, projectWork));
                    this.builtProjects.add(unordered[i]);
                }
                ++i;
            }
            trigger = 10;
            ++iter;
        }
    }

    public void build(IProject project, int trigger, IProgressMonitor monitor) throws CoreException {
        try {
            if (!this.canRun(trigger)) {
                Object var5_4 = null;
                this.building = false;
                this.deltaCache.flush();
                return;
            }
            this.building = true;
            MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, ICoreConstants.MSG_EVENTS_ERRORS, null);
            this.basicBuild(project, trigger, status, monitor);
            if (!status.isOK()) {
                throw new ResourceException(status);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.building = false;
            this.deltaCache.flush();
            throw throwable;
        }
        Object var5_6 = null;
        this.building = false;
        this.deltaCache.flush();
    }

    public void build(IProject project, int kind, String builderName, Map args, IProgressMonitor monitor) throws CoreException {
        monitor = Policy.monitorFor(monitor);
        try {
            String message = Policy.bind("events.building.1", project.getFullPath().toString());
            monitor.beginTask(message, 1);
            if (!this.canRun(kind)) {
                Object var10_7 = null;
                monitor.done();
                this.deltaCache.flush();
                return;
            }
            try {
                this.building = true;
                MultiStatus status = new MultiStatus("org.eclipse.core.resources", 566, ICoreConstants.MSG_EVENTS_ERRORS, null);
                this.basicBuild(project, kind, builderName, args, status, Policy.subMonitorFor(monitor, 1));
                if (!status.isOK()) {
                    throw new ResourceException(status);
                }
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.building = false;
                throw throwable;
            }
            Object var8_13 = null;
            this.building = false;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            monitor.done();
            this.deltaCache.flush();
            throw throwable;
        }
        Object var10_9 = null;
        monitor.done();
        this.deltaCache.flush();
    }

    protected boolean canRun(int trigger) {
        return !this.building;
    }

    protected IProject[] computeUnorderedProjects(IProject[] ordered) {
        HashSet<IProject> leftover = new HashSet<IProject>(Arrays.asList(this.workspace.getRoot().getProjects()));
        leftover.removeAll(Arrays.asList(ordered));
        IProject[] unordered = ((AbstractCollection)leftover).toArray(new IProject[leftover.size()]);
        return unordered;
    }

    public Map createBuildersPersistentInfo(IProject project) throws CoreException {
        Map oldInfos = this.getBuildersPersistentInfo(project);
        ICommand[] buildCommands = ((Project)project).internalGetDescription().getBuildSpec(false);
        if (buildCommands.length == 0) {
            return null;
        }
        HashMap<String, BuilderPersistentInfo> newInfos = new HashMap<String, BuilderPersistentInfo>(buildCommands.length * 2);
        Hashtable instantiatedBuilders = this.getBuilders(project);
        int i = 0;
        while (i < buildCommands.length) {
            ElementTree oldTree;
            String builderName = buildCommands[i].getBuilderName();
            BuilderPersistentInfo info = null;
            IncrementalProjectBuilder builder = (IncrementalProjectBuilder)instantiatedBuilders.get(builderName);
            if (builder == null) {
                if (oldInfos != null) {
                    info = (BuilderPersistentInfo)oldInfos.get(builderName);
                }
            } else if (!(builder instanceof MissingBuilder) && (oldTree = builder.getLastBuiltTree()) != null) {
                info = new BuilderPersistentInfo();
                info.setProjectName(project.getName());
                info.setBuilderName(builderName);
                info.setLastBuildTree(oldTree);
                info.setInterestingProjects(builder.getInterestingProjects());
            }
            if (info != null) {
                newInfos.put(builderName, info);
            }
            ++i;
        }
        return newInfos;
    }

    protected String debugBuilder() {
        return this.currentBuilder == null ? "<no builder>" : this.currentBuilder.getClass().getName();
    }

    protected String debugProject() {
        if (this.currentBuilder == null) {
            return "<no project>";
        }
        return this.currentBuilder.getProject().getFullPath().toString();
    }

    protected IncrementalProjectBuilder getBuilder(String builderName, IProject project, MultiStatus status) throws CoreException {
        Hashtable builders = this.getBuilders(project);
        IncrementalProjectBuilder result = (IncrementalProjectBuilder)builders.get(builderName);
        if (result != null) {
            return result;
        }
        result = this.initializeBuilder(builderName, project, status);
        builders.put(builderName, result);
        result.setProject(project);
        ((InternalBuilder)result).startupOnInitialize();
        return result;
    }

    protected Hashtable getBuilders(IProject project) {
        ProjectInfo info = (ProjectInfo)this.workspace.getResourceInfo(project.getFullPath(), false, false);
        Assert.isNotNull(info, Policy.bind("events.noProject", project.getName()));
        return info.getBuilders();
    }

    public Map getBuildersPersistentInfo(IProject project) throws CoreException {
        return (Map)project.getSessionProperty(ICoreConstants.K_BUILD_MAP);
    }

    protected IResourceDelta getDelta(IProject project) {
        if (this.currentTree == null) {
            if (Policy.DEBUG_BUILD_FAILURE) {
                Policy.debug(true, "Build: no tree for delta " + this.debugBuilder() + " [" + this.debugProject() + "]");
            }
            return null;
        }
        if (!this.isInterestingProject(project)) {
            if (Policy.DEBUG_BUILD_FAILURE) {
                Policy.debug(true, "Build: project not interesting for this builder " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
            }
            return null;
        }
        if (this.currentDelta != null && this.currentDelta.findNodeAt(project.getFullPath()) == null) {
            if (!project.exists()) {
                return null;
            }
            return ResourceDeltaFactory.newEmptyDelta(project);
        }
        IResourceDelta result = this.deltaCache.getDelta(project.getFullPath(), this.lastBuiltTree, this.currentTree);
        if (result != null) {
            return result;
        }
        long startTime = 0L;
        if (Policy.DEBUG_BUILD_DELTA) {
            startTime = System.currentTimeMillis();
            Policy.debug(true, "Computing delta for project: " + project.getName());
        }
        result = ResourceDeltaFactory.computeDelta(this.workspace, this.lastBuiltTree, this.currentTree, project.getFullPath(), false);
        this.deltaCache.cache(project.getFullPath(), this.lastBuiltTree, this.currentTree, result);
        if (Policy.DEBUG_BUILD_FAILURE && result == null) {
            Policy.debug(true, "Build: no delta " + this.debugBuilder() + " [" + this.debugProject() + "] " + project.getFullPath());
        }
        if (Policy.DEBUG_BUILD_DELTA) {
            Policy.debug(true, "Finished computing delta, time: " + (System.currentTimeMillis() - startTime) + "ms");
        }
        return result;
    }

    protected ISafeRunnable getSafeRunnable(final int trigger, final Map args, final MultiStatus status, final IProgressMonitor monitor) {
        return new ISafeRunnable(){

            public void run() throws Exception {
                IProject[] builders = BuildManager.this.currentBuilder.build(trigger, args, monitor);
                if (builders == null) {
                    builders = new IProject[]{};
                }
                BuildManager.this.currentBuilder.setInterestingProjects((IProject[])builders.clone());
            }

            public void handleException(Throwable e) {
                if (e instanceof OperationCanceledException) {
                    throw (OperationCanceledException)e;
                }
                if (e instanceof CoreException) {
                    status.add(((CoreException)e).getStatus());
                } else {
                    String pluginId = BuildManager.this.currentBuilder.getPluginDescriptor().getUniqueIdentifier();
                    String message = e.getMessage();
                    if (message == null) {
                        message = Policy.bind("events.unknown", e.getClass().getName(), BuildManager.this.currentBuilder.getClass().getName());
                    }
                    status.add(new Status(2, pluginId, 75, message, e));
                }
            }
        };
    }

    public void handleEvent(LifecycleEvent event) {
        IProject project = null;
        switch (event.kind) {
            case 16: 
            case 64: {
                project = (IProject)event.resource;
                if (!project.isAccessible()) break;
                this.setBuildersPersistentInfo(project, null);
            }
        }
    }

    public boolean hasBeenBuilt(IProject project) {
        return this.builtProjects.contains(project);
    }

    private void hookStartBuild(IncrementalProjectBuilder builder, int trigger) {
        if (Policy.MONITOR_BUILDERS) {
            EventStats.startBuild(builder);
        }
        if (Policy.DEBUG_BUILD_INVOKING) {
            String type;
            this.timeStamp = System.currentTimeMillis();
            switch (trigger) {
                case 6: {
                    type = "FULL_BUILD";
                    break;
                }
                default: {
                    type = "INCREMENTAL_BUILD";
                }
            }
            Policy.debug(true, "Invoking (" + type + ") on builder: " + this.toString(builder));
        }
    }

    private void hookEndBuild(IncrementalProjectBuilder builder) {
        if (Policy.MONITOR_BUILDERS) {
            EventStats.endBuild();
        }
        if (!Policy.DEBUG_BUILD_INVOKING || this.timeStamp == -1L) {
            return;
        }
        Policy.debug(true, "Builder finished: " + this.toString(builder) + " time: " + (System.currentTimeMillis() - this.timeStamp) + "ms");
        this.timeStamp = -1L;
    }

    protected IncrementalProjectBuilder initializeBuilder(String builderName, IProject project, MultiStatus status) throws CoreException {
        Map infos;
        IncrementalProjectBuilder builder = null;
        try {
            builder = this.instantiateBuilder(builderName);
        }
        catch (CoreException e) {
            status.add(new ResourceStatus(75, project.getFullPath(), Policy.bind("events.instantiate.1", builderName), e));
            status.add(e.getStatus());
        }
        if (builder == null) {
            builder = new MissingBuilder(builderName);
        }
        if ((infos = this.getBuildersPersistentInfo(project)) != null) {
            BuilderPersistentInfo info = (BuilderPersistentInfo)infos.remove(builderName);
            if (info != null) {
                ElementTree tree = info.getLastBuiltTree();
                if (tree != null) {
                    builder.setLastBuiltTree(tree);
                }
                builder.setInterestingProjects(info.getInterestingProjects());
            }
            if (infos.size() == 0) {
                this.setBuildersPersistentInfo(project, null);
            }
        }
        return builder;
    }

    protected IncrementalProjectBuilder instantiateBuilder(String builderName) throws CoreException {
        IExtension extension = Platform.getPluginRegistry().getExtension("org.eclipse.core.resources", "builders", builderName);
        if (extension == null) {
            return null;
        }
        IConfigurationElement[] configs = extension.getConfigurationElements();
        if (configs.length == 0) {
            return null;
        }
        String hasNature = configs[0].getAttribute("hasNature");
        String natureId = null;
        if (hasNature != null && hasNature.equalsIgnoreCase(Boolean.TRUE.toString())) {
            String builderId = extension.getUniqueIdentifier();
            natureId = this.workspace.getNatureManager().findNatureForBuilder(builderId);
            if (natureId == null) {
                return null;
            }
        }
        InternalBuilder builder = (InternalBuilder)configs[0].createExecutableExtension("run");
        builder.setPluginDescriptor(extension.getDeclaringPluginDescriptor());
        builder.setLabel(extension.getLabel());
        builder.setNatureId(natureId);
        return (IncrementalProjectBuilder)builder;
    }

    protected boolean isInterestingProject(IProject project) {
        if (project.equals(this.currentBuilder.getProject())) {
            return true;
        }
        IProject[] interestingProjects = this.currentBuilder.getInterestingProjects();
        int i = 0;
        while (i < interestingProjects.length) {
            if (interestingProjects[i].equals(project)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean needsBuild(InternalBuilder builder) {
        ElementTree oldTree = builder.getLastBuiltTree();
        ElementTree newTree = this.workspace.getElementTree();
        long start = System.currentTimeMillis();
        if (Policy.DEBUG_NEEDS_BUILD) {
            String message = "Checking if need to build. Starting delta computation between: " + oldTree.toString() + " and " + newTree.toString();
            Policy.debug(true, message);
        }
        this.currentDelta = newTree.getDataTree().forwardDeltaWith(oldTree.getDataTree(), ResourceComparator.getComparator(false));
        if (Policy.DEBUG_NEEDS_BUILD) {
            Policy.debug(true, "End delta computation. (" + (System.currentTimeMillis() - start) + "ms).");
        }
        if (this.currentDelta.findNodeAt(builder.getProject().getFullPath()) != null) {
            if (Policy.DEBUG_NEEDS_BUILD) {
                Policy.debug(true, String.valueOf(this.toString(builder)) + " needs building because of changes in: " + builder.getProject().getName());
            }
            return true;
        }
        IProject[] projects = builder.getInterestingProjects();
        int i = 0;
        while (i < projects.length) {
            if (this.currentDelta.findNodeAt(projects[i].getFullPath()) != null) {
                if (Policy.DEBUG_NEEDS_BUILD) {
                    Policy.debug(true, String.valueOf(this.toString(builder)) + " needs building because of changes in: " + projects[i].getName());
                }
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void removeBuilders(IProject project, String builderId) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] oldSpec = desc.getBuildSpec();
        int oldLength = oldSpec.length;
        if (oldLength == 0) {
            return;
        }
        int remaining = 0;
        int i = 0;
        while (i < oldSpec.length) {
            if (oldSpec[i].getBuilderName().equals(builderId)) {
                oldSpec[i] = null;
            } else {
                ++remaining;
            }
            ++i;
        }
        if (remaining == oldSpec.length) {
            return;
        }
        ICommand[] newSpec = new ICommand[remaining];
        int i2 = 0;
        int newIndex = 0;
        while (i2 < oldLength) {
            if (oldSpec[i2] != null) {
                newSpec[newIndex++] = oldSpec[i2];
            }
            ++i2;
        }
        desc.setBuildSpec(newSpec);
        project.setDescription(desc, 0, null);
    }

    public void requestRebuild() {
        this.rebuildRequested = true;
    }

    public void setBuildersPersistentInfo(IProject project, Map map) {
        try {
            project.setSessionProperty(ICoreConstants.K_BUILD_MAP, map);
        }
        catch (CoreException coreException) {
            ResourceStatus error = new ResourceStatus(4, 1, project.getFullPath(), "Project missing in setBuildersPersistentInfo", null);
            ResourcesPlugin.getPlugin().getLog().log(error);
        }
    }

    public void shutdown(IProgressMonitor monitor) {
    }

    public void startup(IProgressMonitor monitor) {
        this.workspace.addLifecycleListener(this);
    }

    protected String toString(InternalBuilder builder) {
        String name = builder.getClass().getName();
        name = name.substring(name.lastIndexOf(46) + 1);
        return String.valueOf(name) + "(" + builder.getProject().getName() + ")";
    }

    protected boolean validateNature(InternalBuilder builder, String builderId) throws CoreException {
        String nature = builder.getNatureId();
        if (nature == null) {
            return true;
        }
        IProject project = builder.getProject();
        if (!project.hasNature(nature)) {
            this.removeBuilders(project, builderId);
            return false;
        }
        return project.isNatureEnabled(nature);
    }

    class DeltaCache {
        private ElementTree oldTree;
        private ElementTree newTree;
        private IPath projectPath;
        private IResourceDelta delta;

        DeltaCache() {
        }

        public IResourceDelta getDelta(IPath project, ElementTree oldTree, ElementTree newTree) {
            if (this.delta == null) {
                return null;
            }
            if (this.projectPath.equals(project) && this.oldTree == oldTree && this.newTree == newTree) {
                return this.delta;
            }
            return null;
        }

        public void cache(IPath project, ElementTree oldTree, ElementTree newTree, IResourceDelta delta) {
            this.projectPath = project;
            this.oldTree = oldTree;
            this.newTree = newTree;
            this.delta = delta;
        }

        public void flush() {
            this.projectPath = null;
            this.oldTree = null;
            this.newTree = null;
            this.delta = null;
        }
    }

    class MissingBuilder
    extends IncrementalProjectBuilder {
        private String name;
        private boolean hasBeenBuilt = false;

        MissingBuilder(String name) {
            this.name = name;
        }

        protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
            if (!this.hasBeenBuilt) {
                this.hasBeenBuilt = true;
                String msg = Policy.bind("events.skippingBuilder", new String[]{this.name, this.getProject().getName()});
                Status status = new Status(2, "org.eclipse.core.resources", 1, msg, null);
                ResourcesPlugin.getPlugin().getLog().log(status);
            }
            return null;
        }
    }
}

