/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.net.URL;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;
import org.eclipse.core.internal.boot.URLContentFilter;

public final class PlatformClassLoader
extends DelegatingURLClassLoader {
    private static PlatformClassLoader singleton = null;

    public PlatformClassLoader(URL[] searchPath, URLContentFilter[] filters, ClassLoader parent, URL base) {
        super(searchPath, filters, null, null, parent);
        this.base = base;
        if (singleton == null) {
            singleton = this;
        }
        this.debugConstruction();
    }

    protected String debugId() {
        return "PLATFORM";
    }

    public String getPrefixId() {
        return "org.eclipse.core.runtime";
    }

    protected Class internalFindClassParentsSelf(String name, boolean resolve, DelegatingURLClassLoader requestor, boolean checkParents) {
        Class result = null;
        PlatformClassLoader platformClassLoader = this;
        synchronized (platformClassLoader) {
            result = this.findLoadedClass(name);
            if (!(result == null || (result = this.checkClassVisibility(result, requestor, true)) == null && checkParents)) {
                return result;
            }
            if (checkParents && (result = this.findClassParents(name, resolve)) != null) {
                return result;
            }
            try {
                result = super.findClass(name);
                if (result == null) {
                    return null;
                }
                return this.checkClassVisibility(result, requestor, false);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }

    public static PlatformClassLoader getDefault() {
        return singleton;
    }

    public synchronized void setImports(DelegatingURLClassLoader[] loaders) {
        if (loaders == null) {
            this.imports = null;
            return;
        }
        DelegatingURLClassLoader.DelegateLoader[] delegates = new DelegatingURLClassLoader.DelegateLoader[loaders.length];
        int i = 0;
        while (i < loaders.length) {
            delegates[i] = new DelegatingURLClassLoader.DelegateLoader(loaders[i], false);
            ++i;
        }
        this.imports = delegates;
    }

    protected String getClassloaderId() {
        return "org.eclipse.core.runtime";
    }
}

