/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldGen;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.PUSH;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.Type;
import org.aspectj.util.CollectionUtil;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateInfo;
import org.aspectj.weaver.bcel.BcelAttributes;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelShadow;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyMethodGen;
import org.aspectj.weaver.bcel.Range;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.bcel.Utility;

public final class LazyClassGen {
    private BcelObjectType myType;
    private ClassGen myGen;
    private ConstantPoolGen constantPoolGen;
    private List methodGens = new ArrayList();
    private List classGens = new ArrayList();
    private int childCounter = 0;
    private InstructionFactory fact;
    Map tjpFields = new HashMap();
    public static final ObjectType tjpType = new ObjectType("org.aspectj.lang.JoinPoint");
    public static final ObjectType staticTjpType = new ObjectType("org.aspectj.lang.JoinPoint$StaticPart");
    private static final ObjectType sigType = new ObjectType("org.aspectj.lang.Signature");
    private static final ObjectType slType = new ObjectType("org.aspectj.lang.reflect.SourceLocation");
    private static final ObjectType factoryType = new ObjectType("org.aspectj.runtime.reflect.Factory");
    private static final ObjectType classType = new ObjectType("java.lang.Class");

    public static void disassemble(String path, String name, PrintStream out) throws IOException {
        if (null == out) {
            return;
        }
        BcelWorld world = new BcelWorld(path);
        LazyClassGen clazz = new LazyClassGen(BcelWorld.getBcelObjectType(world.resolve(name)));
        clazz.print(out);
        out.println();
    }

    public int getNewGeneratedNameTag() {
        return this.childCounter++;
    }

    public LazyClassGen(String class_name, String super_class_name, String file_name, int access_flags, String[] interfaces) {
        this.myGen = new ClassGen(class_name, super_class_name, file_name, access_flags, interfaces);
        this.constantPoolGen = this.myGen.getConstantPool();
        this.fact = new InstructionFactory(this.myGen, this.constantPoolGen);
    }

    public LazyClassGen(BcelObjectType myType) {
        this.myGen = new ClassGen(myType.getJavaClass());
        this.constantPoolGen = this.myGen.getConstantPool();
        this.fact = new InstructionFactory(this.myGen, this.constantPoolGen);
        this.myType = myType;
        Method[] methods = this.myGen.getMethods();
        int i = 0;
        while (i < methods.length) {
            this.addMethodGen(new LazyMethodGen(methods[i], this));
            ++i;
        }
    }

    public String getInternalClassName() {
        return this.getConstantPoolGen().getConstantPool().getConstantString(this.myGen.getClassNameIndex(), (byte)7);
    }

    public File getPackagePath(File root) {
        String str = this.getInternalClassName();
        int index = str.lastIndexOf(47);
        if (index == -1) {
            return root;
        }
        return new File(root, str.substring(0, index));
    }

    public String getClassId() {
        String str = this.getInternalClassName();
        int index = str.lastIndexOf(47);
        if (index == -1) {
            return str;
        }
        return str.substring(index + 1);
    }

    public void addMethodGen(LazyMethodGen gen) {
        this.methodGens.add(gen);
    }

    public List getMethodGens() {
        return this.methodGens;
    }

    private void writeBack() {
        if (this.myType != null && this.myType.getWeaverState() != null) {
            this.myGen.addAttribute(BcelAttributes.bcelAttribute(new AjAttribute.WeaverState(this.myType.getWeaverState()), this.getConstantPoolGen()));
        }
        this.addAjcInitializers();
        int len = this.methodGens.size();
        this.myGen.setMethods(new Method[0]);
        int i = 0;
        while (i < len) {
            LazyMethodGen gen = (LazyMethodGen)this.methodGens.get(i);
            if (!this.isEmptyClinit(gen)) {
                this.myGen.addMethod(gen.getMethod());
            }
            ++i;
        }
    }

    public JavaClass getJavaClass() {
        this.writeBack();
        return this.myGen.getJavaClass();
    }

    public void addGeneratedInner(LazyClassGen newClass) {
        this.classGens.add(newClass);
    }

    public void addInterface(TypeX typeX) {
        this.myGen.addInterface(typeX.getName());
    }

    public void setSuperClass(TypeX typeX) {
        this.myGen.setSuperclassName(typeX.getName());
    }

    private List getClassGens() {
        ArrayList<LazyClassGen> ret = new ArrayList<LazyClassGen>();
        ret.add(this);
        ret.addAll(this.classGens);
        return ret;
    }

    public List getChildClasses() {
        if (this.classGens.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<UnwovenClassFile.ChildClass> ret = new ArrayList<UnwovenClassFile.ChildClass>();
        Iterator i = this.classGens.iterator();
        while (i.hasNext()) {
            LazyClassGen clazz = (LazyClassGen)i.next();
            byte[] bytes = clazz.getJavaClass().getBytes();
            String name = clazz.getName();
            int index = name.lastIndexOf(36);
            name = name.substring(index + 1);
            ret.add(new UnwovenClassFile.ChildClass(name, bytes));
        }
        return ret;
    }

    public String toString() {
        return this.toShortString();
    }

    public String toShortString() {
        String s = org.apache.bcel.classfile.Utility.accessToString(this.myGen.getAccessFlags(), true);
        if (s != "") {
            s = s + " ";
        }
        s = s + org.apache.bcel.classfile.Utility.classOrInterface(this.myGen.getAccessFlags());
        s = s + " ";
        s = s + this.myGen.getClassName();
        return s;
    }

    public String toLongString() {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        this.print(new PrintStream(s));
        return new String(s.toByteArray());
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream out) {
        List classGens = this.getClassGens();
        Iterator iter = classGens.iterator();
        while (iter.hasNext()) {
            LazyClassGen element = (LazyClassGen)iter.next();
            element.printOne(out);
            if (!iter.hasNext()) continue;
            out.println();
        }
    }

    private void printOne(PrintStream out) {
        out.print(this.toShortString());
        out.print(" extends ");
        out.print(org.apache.bcel.classfile.Utility.compactClassName(this.myGen.getSuperclassName(), false));
        int size = this.myGen.getInterfaces().length;
        if (size > 0) {
            out.print(" implements ");
            int i = 0;
            while (i < size) {
                out.print(this.myGen.getInterfaceNames()[i]);
                if (i < size - 1) {
                    out.print(", ");
                }
                ++i;
            }
        }
        out.print(":");
        out.println();
        if (this.myType != null) {
            this.myType.printWackyStuff(out);
        }
        Field[] fields = this.myGen.getFields();
        int i = 0;
        int len = fields.length;
        while (i < len) {
            out.print("  ");
            out.println(fields[i]);
            ++i;
        }
        List methodGens = this.getMethodGens();
        Iterator iter = methodGens.iterator();
        while (iter.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)iter.next();
            if (this.isEmptyClinit(gen)) continue;
            gen.print(out);
            if (!iter.hasNext()) continue;
            out.println();
        }
        out.println("end " + this.toShortString());
    }

    private boolean isEmptyClinit(LazyMethodGen gen) {
        if (!gen.getName().equals("<clinit>")) {
            return false;
        }
        for (InstructionHandle start = gen.getBody().getStart(); start != null; start = start.getNext()) {
            if (Range.isRangeHandle(start) || start.getInstruction() instanceof RETURN) {
                continue;
            }
            return false;
        }
        return true;
    }

    public ConstantPoolGen getConstantPoolGen() {
        return this.constantPoolGen;
    }

    public String getName() {
        return this.myGen.getClassName();
    }

    public boolean isWoven() {
        return this.myType.getWeaverState() != null;
    }

    public WeaverStateInfo getOrCreateWeaverStateInfo() {
        WeaverStateInfo ret = this.myType.getWeaverState();
        if (ret != null) {
            return ret;
        }
        ret = new WeaverStateInfo();
        this.myType.setWeaverState(ret);
        return ret;
    }

    public InstructionFactory getFactory() {
        return this.fact;
    }

    public LazyMethodGen getStaticInitializer() {
        Iterator i = this.methodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)i.next();
            if (!gen.getName().equals("<clinit>")) continue;
            return gen;
        }
        LazyMethodGen clinit = new LazyMethodGen(8, Type.VOID, "<clinit>", new Type[0], CollectionUtil.NO_STRINGS, this);
        InstructionList instructionList = clinit.getBody();
        this.getFactory();
        instructionList.insert(InstructionConstants.RETURN);
        this.methodGens.add(clinit);
        return clinit;
    }

    public LazyMethodGen getAjcPreClinit() {
        Iterator i = this.methodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)i.next();
            if (!gen.getName().equals("ajc$preClinit")) continue;
            return gen;
        }
        LazyMethodGen ajcClinit = new LazyMethodGen(8, Type.VOID, "ajc$preClinit", new Type[0], CollectionUtil.NO_STRINGS, this);
        InstructionList instructionList = ajcClinit.getBody();
        this.getFactory();
        instructionList.insert(InstructionConstants.RETURN);
        this.methodGens.add(ajcClinit);
        this.getStaticInitializer().getBody().insert(Utility.createInvoke(this.getFactory(), ajcClinit));
        return ajcClinit;
    }

    public Field getTjpField(BcelShadow shadow) {
        Field ret = (Field)this.tjpFields.get(shadow);
        if (ret != null) {
            return ret;
        }
        ret = new FieldGen(25, staticTjpType, "ajc$tjp_" + this.tjpFields.size(), this.getConstantPoolGen()).getField();
        this.addField(ret);
        this.tjpFields.put(shadow, ret);
        return ret;
    }

    private void addAjcInitializers() {
        if (this.tjpFields.size() == 0) {
            return;
        }
        InstructionList il = this.initializeAllTjps();
        this.getStaticInitializer().getBody().insert(il);
    }

    private InstructionList initializeAllTjps() {
        InstructionList list = new InstructionList();
        InstructionFactory fact = this.getFactory();
        list.append(fact.createNew(factoryType));
        list.append(InstructionFactory.createDup(1));
        list.append(new PUSH(this.getConstantPoolGen(), this.getFileName()));
        list.append(new PUSH(this.getConstantPoolGen(), this.getClassName()));
        list.append(fact.createInvoke("java.lang.Class", "forName", classType, new Type[]{Type.STRING}, (short)184));
        list.append(fact.createInvoke(factoryType.getClassName(), "<init>", Type.VOID, new Type[]{Type.STRING, classType}, (short)183));
        list.append(InstructionFactory.createStore(factoryType, 0));
        ArrayList entries = new ArrayList(this.tjpFields.entrySet());
        Collections.sort(entries, new Comparator(){

            public int compare(Object a, Object b) {
                Map.Entry ae = (Map.Entry)a;
                Map.Entry be = (Map.Entry)b;
                return ((Field)ae.getValue()).getName().compareTo(((Field)be.getValue()).getName());
            }
        });
        Iterator i = entries.iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            this.initializeTjp(fact, list, (Field)entry.getValue(), (BcelShadow)entry.getKey());
        }
        return list;
    }

    private void initializeTjp(InstructionFactory fact, InstructionList list, Field field, BcelShadow shadow) {
        Member sig = shadow.getSignature();
        list.append(InstructionFactory.createLoad(factoryType, 0));
        list.append(new PUSH(this.getConstantPoolGen(), shadow.getKind().getName()));
        list.append(InstructionFactory.createLoad(factoryType, 0));
        list.append(new PUSH(this.getConstantPoolGen(), sig.getSignatureString(shadow.getWorld())));
        list.append(fact.createInvoke(factoryType.getClassName(), sig.getSignatureMakerName(), new ObjectType(sig.getSignatureType()), new Type[]{Type.STRING}, (short)182));
        list.append(Utility.createConstant(fact, shadow.getSourceLine()));
        list.append(fact.createInvoke(factoryType.getClassName(), "makeSJP", staticTjpType, new Type[]{Type.STRING, sigType, Type.INT}, (short)182));
        list.append(fact.createFieldAccess(this.getClassName(), field.getName(), staticTjpType, (short)179));
    }

    public ResolvedTypeX getType() {
        if (this.myType == null) {
            return null;
        }
        return this.myType.getResolvedTypeX();
    }

    public BcelObjectType getBcelObjectType() {
        return this.myType;
    }

    public String getFileName() {
        return this.myGen.getFileName();
    }

    public void addField(Field field) {
        this.myGen.addField(field);
    }

    public String getClassName() {
        return this.myGen.getClassName();
    }

    public boolean isInterface() {
        return this.myGen.isInterface();
    }

    public LazyMethodGen getLazyMethodGen(Member m) {
        return this.getLazyMethodGen(m.getName(), m.getSignature());
    }

    public LazyMethodGen getLazyMethodGen(String name, String signature) {
        Iterator i = this.methodGens.iterator();
        while (i.hasNext()) {
            LazyMethodGen gen = (LazyMethodGen)i.next();
            if (!gen.getName().equals(name) || !gen.getSignature().equals(signature)) continue;
            return gen;
        }
        throw new BCException("Class " + this.getName() + " does not have a method " + name + " with signature " + signature);
    }

    public void forcePublic() {
        this.myGen.setAccessFlags(Utility.makePublic(this.myGen.getAccessFlags()));
    }
}

