/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.bcel.BcelTypeMunger;

public class WeaverStateInfo {
    private List typeMungers;
    private boolean oldStyle;
    private static final int UNTOUCHED = 0;
    private static final int WOVEN = 2;
    private static final int EXTENDED = 3;

    public WeaverStateInfo() {
        this(new ArrayList(), false);
    }

    private WeaverStateInfo(List typeMungers, boolean oldStyle) {
        this.typeMungers = typeMungers;
        this.oldStyle = oldStyle;
    }

    public static final WeaverStateInfo read(DataInputStream s, ISourceContext context) throws IOException {
        byte b = s.readByte();
        switch (b) {
            case 0: {
                throw new RuntimeException("unexpected UNWOVEN");
            }
            case 2: {
                return new WeaverStateInfo(Collections.EMPTY_LIST, true);
            }
            case 3: {
                int n = s.readShort();
                ArrayList<Entry> l = new ArrayList<Entry>();
                int i = 0;
                while (i < n) {
                    TypeX aspectType = TypeX.read(s);
                    ResolvedTypeMunger typeMunger = ResolvedTypeMunger.read(s, context);
                    l.add(new Entry(aspectType, typeMunger));
                    ++i;
                }
                return new WeaverStateInfo(l, false);
            }
        }
        throw new RuntimeException("bad WeaverState.Kind: " + b);
    }

    public void write(DataOutputStream s) throws IOException {
        if (this.oldStyle) {
            throw new RuntimeException("shouldn't be writing this");
        }
        s.writeByte(3);
        int n = this.typeMungers.size();
        s.writeShort(n);
        int i = 0;
        while (i < n) {
            Entry e = (Entry)this.typeMungers.get(i);
            e.aspectType.write(s);
            e.typeMunger.write(s);
            ++i;
        }
    }

    public void addConcreteMunger(ConcreteTypeMunger munger) {
        this.typeMungers.add(new Entry(munger.getAspectType(), munger.getMunger()));
    }

    public String toString() {
        return "WeaverStateInfo(" + this.typeMungers + ", " + this.oldStyle + ")";
    }

    public List getTypeMungers(ResolvedTypeX onType) {
        World world = onType.getWorld();
        ArrayList<BcelTypeMunger> ret = new ArrayList<BcelTypeMunger>();
        Iterator i = this.typeMungers.iterator();
        while (i.hasNext()) {
            Entry entry = (Entry)i.next();
            ResolvedTypeX aspectType = world.resolve(entry.aspectType, true);
            if (aspectType == ResolvedTypeX.MISSING) {
                world.showMessage(IMessage.ERROR, "aspect " + entry.aspectType + " is needed when using type " + onType, onType.getSourceLocation(), null);
                continue;
            }
            ret.add(new BcelTypeMunger(entry.typeMunger, aspectType));
        }
        return ret;
    }

    public boolean isOldStyle() {
        return this.oldStyle;
    }

    private static class Entry {
        public TypeX aspectType;
        public ResolvedTypeMunger typeMunger;

        public Entry(TypeX aspectType, ResolvedTypeMunger typeMunger) {
            this.aspectType = aspectType;
            this.typeMunger = typeMunger;
        }

        public String toString() {
            return "<" + this.aspectType + ", " + this.typeMunger + ">";
        }
    }
}

