/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.util.PartialOrder;
import org.aspectj.util.TypeSafeEnum;
import org.aspectj.weaver.AsmRelationshipProvider;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Var;

public abstract class Shadow {
    private final Kind kind;
    private final Member signature;
    protected final Shadow enclosingShadow;
    protected List mungers = new ArrayList(1);
    public static final Kind MethodCall = new Kind("method-call", 1, true);
    public static final Kind ConstructorCall = new Kind("constructor-call", 2, true);
    public static final Kind MethodExecution = new Kind("method-execution", 3, false);
    public static final Kind ConstructorExecution = new Kind("constructor-execution", 4, false);
    public static final Kind FieldGet = new Kind("field-get", 5, true);
    public static final Kind FieldSet = new Kind("field-set", 6, true);
    public static final Kind StaticInitialization = new Kind("staticinitialization", 7, false);
    public static final Kind PreInitialization = new Kind("preinitialization", 8, false);
    public static final Kind AdviceExecution = new Kind("advice-execution", 9, false);
    public static final Kind Initialization = new Kind("initialization", 10, false);
    public static final Kind ExceptionHandler = new Kind("exception-handler", 11, true);

    protected Shadow(Kind kind, Member signature, Shadow enclosingShadow) {
        this.kind = kind;
        this.signature = signature;
        this.enclosingShadow = enclosingShadow;
    }

    public abstract World getIWorld();

    public final boolean hasThis() {
        if (this.getKind().neverHasThis()) {
            return false;
        }
        if (this.getKind().isEnclosingKind()) {
            return !this.getSignature().isStatic();
        }
        if (this.enclosingShadow == null) {
            return false;
        }
        return this.enclosingShadow.hasThis();
    }

    public final TypeX getThisType() {
        if (!this.hasThis()) {
            throw new IllegalStateException("no this");
        }
        if (this.getKind().isEnclosingKind()) {
            return this.getSignature().getDeclaringType();
        }
        return this.enclosingShadow.getThisType();
    }

    public abstract Var getThisVar();

    public final boolean hasTarget() {
        if (this.getKind().neverHasTarget()) {
            return false;
        }
        if (this.getKind().isTargetSameAsThis()) {
            return this.hasThis();
        }
        return !this.getSignature().isStatic();
    }

    public final TypeX getTargetType() {
        if (!this.hasTarget()) {
            throw new IllegalStateException("no target");
        }
        return this.getSignature().getDeclaringType();
    }

    public abstract Var getTargetVar();

    public TypeX[] getArgTypes() {
        if (this.getKind() == FieldSet) {
            return new TypeX[]{this.getSignature().getReturnType()};
        }
        return this.getSignature().getParameterTypes();
    }

    public TypeX getArgType(int arg) {
        if (this.getKind() == FieldSet) {
            return this.getSignature().getReturnType();
        }
        return this.getSignature().getParameterTypes()[arg];
    }

    public int getArgCount() {
        if (this.getKind() == FieldSet) {
            return 1;
        }
        return this.getSignature().getParameterTypes().length;
    }

    public abstract TypeX getEnclosingType();

    public abstract Var getArgVar(int var1);

    public abstract Var getThisJoinPointVar();

    public abstract Var getThisJoinPointStaticPartVar();

    public abstract Var getThisEnclosingJoinPointStaticPartVar();

    public abstract Member getEnclosingCodeSignature();

    public Kind getKind() {
        return this.kind;
    }

    public Member getSignature() {
        return this.signature;
    }

    public TypeX getReturnType() {
        if (this.kind == ConstructorCall) {
            return this.getSignature().getDeclaringType();
        }
        if (this.kind == FieldSet) {
            return ResolvedTypeX.VOID;
        }
        return this.getSignature().getReturnType();
    }

    protected boolean checkMunger(ShadowMunger munger) {
        Iterator i = munger.getThrownExceptions().iterator();
        while (i.hasNext()) {
            if (this.checkCanThrow(munger, (ResolvedTypeX)i.next())) continue;
            return false;
        }
        return true;
    }

    protected boolean checkCanThrow(ShadowMunger munger, ResolvedTypeX resolvedTypeX) {
        if (this.getKind() == ExceptionHandler) {
            return true;
        }
        if (!this.isDeclaredException(resolvedTypeX, this.getSignature())) {
            this.getIWorld().showMessage(IMessage.ERROR, "can't throw checked exception '" + resolvedTypeX + "' at this join point '" + this + "'", this.getSourceLocation(), munger.getSourceLocation());
        }
        return true;
    }

    private boolean isDeclaredException(ResolvedTypeX resolvedTypeX, Member member) {
        ResolvedTypeX[] excs = this.getIWorld().resolve(member.getExceptions(this.getIWorld()));
        int i = 0;
        int len = excs.length;
        while (i < len) {
            if (excs[i].isAssignableFrom(resolvedTypeX)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addMunger(ShadowMunger munger) {
        if (this.checkMunger(munger)) {
            this.mungers.add(munger);
        }
    }

    public final void implement() {
        this.sortMungers();
        if (this.mungers == null) {
            return;
        }
        this.prepareForMungers();
        this.implementMungers();
    }

    private void sortMungers() {
        List sorted = PartialOrder.sort(this.mungers);
        if (sorted == null) {
            Iterator i = this.mungers.iterator();
            while (i.hasNext()) {
                ShadowMunger m = (ShadowMunger)i.next();
                this.getIWorld().getMessageHandler().handleMessage(MessageUtil.error("circular dependency at " + this, m.getSourceLocation()));
            }
        }
        this.mungers = sorted;
    }

    protected void prepareForMungers() {
        throw new RuntimeException("Generic shadows cannot be prepared");
    }

    private void implementMungers() {
        World world = this.getIWorld();
        Iterator iter = this.mungers.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            munger.implementOn(this);
            if (world.getModel() == null) continue;
            AsmRelationshipProvider.adviceMunger(world.getModel(), this, munger);
        }
    }

    public String makeReflectiveFactoryString() {
        return null;
    }

    public abstract ISourceLocation getSourceLocation();

    public String toString() {
        return this.getKind() + "(" + this.getSignature() + ")";
    }

    public static final class Kind
    extends TypeSafeEnum {
        private boolean argsOnStack;

        public Kind(String name, int key, boolean argsOnStack) {
            super(name, key);
            this.argsOnStack = argsOnStack;
        }

        public String toLegalJavaIdentifier() {
            return this.getName().replace('-', '_');
        }

        public boolean argsOnStack() {
            return !this.isTargetSameAsThis();
        }

        public boolean allowsExtraction() {
            return true;
        }

        public boolean hasHighPriorityExceptions() {
            return !this.isTargetSameAsThis();
        }

        public boolean isEnclosingKind() {
            return this == MethodExecution || this == ConstructorExecution || this == AdviceExecution || this == StaticInitialization || this == Initialization;
        }

        public boolean isTargetSameAsThis() {
            return this == MethodExecution || this == ConstructorExecution || this == StaticInitialization || this == PreInitialization || this == AdviceExecution || this == Initialization;
        }

        public boolean neverHasTarget() {
            return this == ConstructorCall || this == ExceptionHandler || this == PreInitialization || this == StaticInitialization;
        }

        public boolean neverHasThis() {
            return this == PreInitialization || this == StaticInitialization;
        }

        public String getSimpleName() {
            int dash = this.getName().lastIndexOf(45);
            if (dash == -1) {
                return this.getName();
            }
            return this.getName().substring(dash + 1);
        }

        public static Kind read(DataInputStream s) throws IOException {
            byte key = s.readByte();
            switch (key) {
                case 1: {
                    return MethodCall;
                }
                case 2: {
                    return ConstructorCall;
                }
                case 3: {
                    return MethodExecution;
                }
                case 4: {
                    return ConstructorExecution;
                }
                case 5: {
                    return FieldGet;
                }
                case 6: {
                    return FieldSet;
                }
                case 7: {
                    return StaticInitialization;
                }
                case 8: {
                    return PreInitialization;
                }
                case 9: {
                    return AdviceExecution;
                }
                case 10: {
                    return Initialization;
                }
                case 11: {
                    return ExceptionHandler;
                }
            }
            throw new BCException("unknown kind: " + key);
        }
    }
}

