/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.weaver.World;

public class Lint {
    private Map kinds = new HashMap();
    private World world;
    public final Kind invalidAbsoluteTypeName = new Kind("invalidAbsoluteTypeName", "no match for this type name: {0}");
    public final Kind invalidWildcardTypeName = new Kind("invalidWildcardTypeName", "no match for this type pattern: {0}");
    public final Kind unresolvableMember = new Kind("unresolvableMember", "can not resolve this member: {0}");
    public final Kind typeNotExposedToWeaver = new Kind("typeNotExposedToWeaver", "this affected type is not exposed to the weaver: {0}");
    public final Kind shadowNotInStructure = new Kind("shadowNotInStructure", "the shadow for this join point is not exposed in the structure model: {0}");

    public Lint(World world) {
        this.world = world;
    }

    public void setAll(String messageKind) {
        this.setAll(this.getMessageKind(messageKind));
    }

    private void setAll(IMessage.Kind messageKind) {
        Iterator i = this.kinds.values().iterator();
        while (i.hasNext()) {
            Kind kind = (Kind)i.next();
            kind.setKind(messageKind);
        }
    }

    public void setFromProperties(File file) {
        try {
            FileInputStream s = new FileInputStream(file);
            this.setFromProperties(s);
        }
        catch (IOException ioe) {
            MessageUtil.error(this.world.getMessageHandler(), "problem loading Xlint properties file: " + file.getPath() + ", " + ioe.getMessage());
        }
    }

    public void loadDefaultProperties() {
        InputStream s = this.getClass().getResourceAsStream("XlintDefault.properties");
        if (s == null) {
            MessageUtil.warn(this.world.getMessageHandler(), "couldn't load XlintDefault.properties");
            return;
        }
        try {
            this.setFromProperties(s);
        }
        catch (IOException ioe) {
            MessageUtil.error(this.world.getMessageHandler(), "problem loading XlintDefault.properties, " + ioe.getMessage());
        }
    }

    private void setFromProperties(InputStream s) throws IOException {
        Properties p = new Properties();
        p.load(s);
        this.setFromProperties(p);
    }

    public void setFromProperties(Properties properties) {
        Iterator i = ((Hashtable)properties).entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Kind kind = (Kind)this.kinds.get(entry.getKey());
            if (kind == null) {
                MessageUtil.error(this.world.getMessageHandler(), "invalid Xlint key: " + entry.getKey());
                continue;
            }
            kind.setKind(this.getMessageKind((String)entry.getValue()));
        }
    }

    private IMessage.Kind getMessageKind(String v) {
        if (v.equals("ignore")) {
            return null;
        }
        if (v.equals("warning")) {
            return IMessage.WARNING;
        }
        if (v.equals("error")) {
            return IMessage.ERROR;
        }
        MessageUtil.error(this.world.getMessageHandler(), "invalid Xlint message kind (must be one of ignore, warning, error): " + v);
        return null;
    }

    public class Kind {
        private String name;
        private String message;
        private IMessage.Kind kind = IMessage.WARNING;

        public Kind(String name, String message) {
            this.name = name;
            this.message = message;
            Lint.this.kinds.put(this.name, this);
        }

        public boolean isEnabled() {
            return this.kind != null;
        }

        public IMessage.Kind getKind() {
            return this.kind;
        }

        public void setKind(IMessage.Kind kind) {
            this.kind = kind;
        }

        public void signal(String info, ISourceLocation location) {
            if (this.kind == null) {
                return;
            }
            String text = MessageFormat.format(this.message, info);
            text = text + " [Xlint:" + this.name + "]";
            Lint.this.world.getMessageHandler().handleMessage(new Message(text, this.kind, null, location));
        }
    }
}

