/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.util.ArrayList;
import java.util.Iterator;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;
import org.aspectj.asm.IRelationshipMap;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.Checker;
import org.aspectj.weaver.Lint;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;

public class AsmRelationshipProvider {
    public static final String ADVISES = "advises";
    public static final String ADVISED_BY = "advised by";
    public static final String DECLARES_ON = "declares on";
    public static final String DECLAREDY_BY = "declared by";
    public static final String MATCHED_BY = "matched by";
    public static final String MATCHES_DECLARE = "matches declare";

    public static void checkerMunger(IHierarchy model, Shadow shadow, Checker checker) {
        if (shadow.getSourceLocation() == null || checker.getSourceLocation() == null) {
            return;
        }
        String sourceHandle = ProgramElement.createHandleIdentifier(checker.getSourceLocation().getSourceFile(), checker.getSourceLocation().getLine(), checker.getSourceLocation().getColumn());
        String targetHandle = ProgramElement.createHandleIdentifier(shadow.getSourceLocation().getSourceFile(), shadow.getSourceLocation().getLine(), shadow.getSourceLocation().getColumn());
        IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
        if (sourceHandle != null && targetHandle != null) {
            IRelationship foreward = mapper.get(sourceHandle, IRelationship.Kind.DECLARE, MATCHED_BY);
            foreward.getTargets().add(targetHandle);
            IRelationship back = mapper.get(targetHandle, IRelationship.Kind.DECLARE, MATCHES_DECLARE);
            back.getTargets().add(sourceHandle);
        }
    }

    public static void adviceMunger(IHierarchy model, Shadow shadow, ShadowMunger munger) {
        if (munger instanceof Advice) {
            Advice advice = (Advice)munger;
            if (advice.getKind().isPerEntry() || advice.getKind().isCflow()) {
                return;
            }
            IRelationshipMap mapper = AsmManager.getDefault().getRelationshipMap();
            IProgramElement targetNode = AsmRelationshipProvider.getNode(AsmManager.getDefault().getHierarchy(), shadow);
            String adviceHandle = advice.getHandle();
            if (adviceHandle != null && targetNode != null && targetNode != null) {
                IRelationship back;
                String targetHandle = targetNode.getHandleIdentifier();
                IRelationship foreward = mapper.get(adviceHandle, IRelationship.Kind.ADVICE, ADVISES);
                if (foreward != null) {
                    foreward.getTargets().add(targetHandle);
                }
                if ((back = mapper.get(targetHandle, IRelationship.Kind.ADVICE, ADVISED_BY)) != null) {
                    back.getTargets().add(adviceHandle);
                }
            }
        }
    }

    private static IProgramElement getNode(IHierarchy model, Shadow shadow) {
        Member enclosingMember = shadow.getEnclosingCodeSignature();
        IProgramElement enclosingNode = AsmRelationshipProvider.lookupMember(model, enclosingMember);
        if (enclosingNode == null) {
            Lint.Kind err = shadow.getIWorld().getLint().shadowNotInStructure;
            if (err.isEnabled()) {
                err.signal(shadow.toString(), shadow.getSourceLocation());
            }
            return null;
        }
        Member shadowSig = shadow.getSignature();
        if (!shadowSig.equals(enclosingMember)) {
            IProgramElement bodyNode = AsmRelationshipProvider.findOrCreateCodeNode(enclosingNode, shadowSig, shadow);
            return bodyNode;
        }
        return enclosingNode;
    }

    private static IProgramElement findOrCreateCodeNode(IProgramElement enclosingNode, Member shadowSig, Shadow shadow) {
        Iterator it = enclosingNode.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (!shadowSig.getName().equals(node.getBytecodeName()) || !shadowSig.getSignature().equals(node.getBytecodeSignature())) continue;
            return node;
        }
        ISourceLocation sl = shadow.getSourceLocation();
        ProgramElement peNode = new ProgramElement(shadow.toString(), IProgramElement.Kind.CODE, new SourceLocation(enclosingNode.getSourceLocation().getSourceFile(), sl.getLine()), 0, "", new ArrayList());
        peNode.setBytecodeName(shadowSig.getName());
        peNode.setBytecodeSignature(shadowSig.getSignature());
        enclosingNode.addChild(peNode);
        return peNode;
    }

    private static IProgramElement lookupMember(IHierarchy model, Member member) {
        TypeX declaringType = member.getDeclaringType();
        IProgramElement classNode = model.findElementForType(declaringType.getPackageName(), declaringType.getClassName());
        return AsmRelationshipProvider.findMemberInClass(classNode, member);
    }

    private static IProgramElement findMemberInClass(IProgramElement classNode, Member member) {
        if (classNode == null) {
            return null;
        }
        Iterator it = classNode.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (!member.getName().equals(node.getBytecodeName()) || !member.getSignature().equals(node.getBytecodeSignature())) continue;
            return node;
        }
        return classNode;
    }
}

