/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.security.PrivilegedActionException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aspectj.util.FileUtil;

public class LangUtil {
    private static final Map VM_CLASSES;
    public static final String EOL;
    static /* synthetic */ Class class$java$lang$Object;

    public static final boolean supportsJava(String version) {
        LangUtil.throwIaxIfNull(version, "version");
        String className = (String)VM_CLASSES.get(version);
        if (null == className) {
            throw new IllegalArgumentException("unknown version: " + version);
        }
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static final void throwIaxIfNull(Object o, String name) {
        if (null == o) {
            String message = "null " + (null == name ? "input" : name);
            throw new IllegalArgumentException(message);
        }
    }

    public static final void throwIaxIfNotAssignable(Object[] ra, Class c, String name) {
        LangUtil.throwIaxIfNull(ra, name);
        String label = null == name ? "input" : name;
        int i = 0;
        while (i < ra.length) {
            Class<?> actualClass;
            if (null == ra[i]) {
                String m = " null " + label + "[" + i + "]";
                throw new IllegalArgumentException(m);
            }
            if (null != c && !c.isAssignableFrom(actualClass = ra[i].getClass())) {
                String message = label + " not assignable to " + c.getName();
                throw new IllegalArgumentException(message);
            }
            ++i;
        }
    }

    public static final void throwIaxIfNotAssignable(Object o, Class c, String name) {
        Class<?> actualClass;
        LangUtil.throwIaxIfNull(o, name);
        if (null != c && !c.isAssignableFrom(actualClass = o.getClass())) {
            String message = name + " not assignable to " + c.getName();
            throw new IllegalArgumentException(message);
        }
    }

    public static final void throwIaxIfNotAllAssignable(Collection collection, Class c, String name) {
        LangUtil.throwIaxIfNull(collection, name);
        if (null != c) {
            Iterator iter = collection.iterator();
            while (iter.hasNext()) {
                LangUtil.throwIaxIfNotAssignable(iter.next(), c, name);
            }
        }
    }

    public static final void throwIaxIfFalse(boolean test, String message) {
        if (!test) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isEmptyTrimmed(String s) {
        return null == s || 0 == s.length() || 0 == s.trim().length();
    }

    public static boolean isEmpty(String s) {
        return null == s || 0 == s.length();
    }

    public static boolean isEmpty(Object[] ra) {
        return null == ra || 0 == ra.length;
    }

    public static boolean isEmpty(Collection collection) {
        return null == collection || 0 == collection.size();
    }

    public static String[] split(String text) {
        return LangUtil.strings(text).toArray(new String[0]);
    }

    public static List commaSplit(String input) {
        return LangUtil.anySplit(input, ",");
    }

    public static String[] splitClasspath(String classpath) {
        if (LangUtil.isEmpty(classpath)) {
            return new String[0];
        }
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        ArrayList<String> result = new ArrayList<String>(st.countTokens());
        while (st.hasMoreTokens()) {
            String entry = st.nextToken();
            if (LangUtil.isEmpty(entry)) continue;
            result.add(entry);
        }
        return result.toArray(new String[0]);
    }

    public static List anySplit(String input, String delim) {
        if (null == input) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> result = new ArrayList<String>();
        if (LangUtil.isEmpty(delim) || -1 == input.indexOf(delim)) {
            result.add(input.trim());
        } else {
            StringTokenizer st = new StringTokenizer(input, delim);
            while (st.hasMoreTokens()) {
                result.add(st.nextToken().trim());
            }
        }
        return result;
    }

    public static List strings(String text) {
        if (LangUtil.isEmpty(text)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> strings = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(text);
        while (tok.hasMoreTokens()) {
            strings.add(tok.nextToken());
        }
        return strings;
    }

    public static List safeList(List list) {
        return null == list ? Collections.EMPTY_LIST : Collections.unmodifiableList(list);
    }

    public static String[] endsWith(String[] inputs, String[] suffixes, boolean ignoreCase) {
        int i;
        if (LangUtil.isEmpty(inputs) || LangUtil.isEmpty(suffixes)) {
            return new String[0];
        }
        if (ignoreCase) {
            String[] temp = new String[suffixes.length];
            i = 0;
            while (i < temp.length) {
                String suff = suffixes[i];
                temp[i] = null == suff ? null : suff.toLowerCase();
                ++i;
            }
            suffixes = temp;
        }
        ArrayList<String> result = new ArrayList<String>();
        i = 0;
        while (i < inputs.length) {
            String input = inputs[i];
            if (null != input) {
                if (!ignoreCase) {
                    input = input.toLowerCase();
                }
                int j = 0;
                while (j < suffixes.length) {
                    String suffix = suffixes[j];
                    if (null != suffix && input.endsWith(suffix)) {
                        result.add(input);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String[][] copyStrings(String[][] in) {
        String[][] out = new String[in.length][];
        int i = 0;
        while (i < out.length) {
            out[i] = new String[in[i].length];
            System.arraycopy(in[i], 0, out[i], 0, out[i].length);
            ++i;
        }
        return out;
    }

    public static String[] extractOptions(String[] args, String[][] options) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty((Object[])options)) {
            return args;
        }
        BitSet foundSet = new BitSet();
        String[] result = new String[args.length];
        int resultIndex = 0;
        int j = 0;
        while (j < args.length) {
            boolean found = false;
            int i = 0;
            while (!found && i < options.length) {
                Object[] option = options[i];
                LangUtil.throwIaxIfFalse(!LangUtil.isEmpty(option), "options");
                Object sought = option[0];
                found = ((String)sought).equals(args[j]);
                if (found) {
                    foundSet.set(i);
                    int doMore = option.length - 1;
                    if (0 < doMore) {
                        int MAX = j + doMore;
                        if (MAX >= args.length) {
                            String s = "expecting " + doMore + " args after ";
                            throw new IllegalArgumentException(s + args[j]);
                        }
                        int k = 1;
                        while (k < option.length) {
                            option[k] = args[++j];
                            ++k;
                        }
                    }
                }
                ++i;
            }
            if (!found) {
                result[resultIndex++] = args[j];
            }
            ++j;
        }
        int i = 0;
        while (i < options.length) {
            if (!foundSet.get(i)) {
                options[i][0] = null;
            }
            ++i;
        }
        if (resultIndex < args.length) {
            String[] temp = new String[resultIndex];
            System.arraycopy(result, 0, temp, 0, resultIndex);
            args = temp;
        }
        return args;
    }

    public static String[] extractOptions(String[] args, String[] validOptions, int[] optionArgs, List extracted) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty(validOptions)) {
            return args;
        }
        if (null != optionArgs && optionArgs.length != validOptions.length) {
            throw new IllegalArgumentException("args must match options");
        }
        String[] result = new String[args.length];
        int resultIndex = 0;
        int j = 0;
        while (j < args.length) {
            boolean found = false;
            int i = 0;
            while (!found && i < validOptions.length) {
                int doMore;
                String sought = validOptions[i];
                int n = doMore = null == optionArgs ? 0 : optionArgs[i];
                if (!LangUtil.isEmpty(sought) && (found = sought.equals(args[j]))) {
                    if (null != extracted) {
                        extracted.add(sought);
                    }
                    if (0 >= doMore) break;
                    int MAX = j + doMore;
                    if (MAX >= args.length) {
                        String s = "expecting " + doMore + " args after ";
                        throw new IllegalArgumentException(s + args[j]);
                    }
                    if (null != extracted) {
                        while (j < MAX) {
                            extracted.add(args[++j]);
                        }
                        break;
                    }
                    j = MAX;
                    break;
                }
                ++i;
            }
            if (!found) {
                result[resultIndex++] = args[j];
            }
            ++j;
        }
        if (resultIndex < args.length) {
            String[] temp = new String[resultIndex];
            System.arraycopy(result, 0, temp, 0, resultIndex);
            args = temp;
        }
        return args;
    }

    public static String[] selectOptions(String[] args, String[] validOptions) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty(validOptions)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < validOptions.length) {
            String sought = validOptions[i];
            if (!LangUtil.isEmpty(sought)) {
                int j = 0;
                while (j < args.length) {
                    if (sought.equals(args[j])) {
                        result.add(sought);
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String[] selectOptions(List args, String[] validOptions) {
        if (LangUtil.isEmpty(args) || LangUtil.isEmpty(validOptions)) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int i = 0;
        while (i < validOptions.length) {
            String sought = validOptions[i];
            if (!LangUtil.isEmpty(sought)) {
                Iterator iter = args.iterator();
                while (iter.hasNext()) {
                    String arg = (String)iter.next();
                    if (!sought.equals(arg)) continue;
                    result.add(sought);
                    break;
                }
            }
            ++i;
        }
        return result.toArray(new String[0]);
    }

    public static String[][] optionVariants(String[] options) {
        if (null == options || 0 == options.length) {
            return new String[][]{new String[0]};
        }
        String[] temp = new String[options.length];
        System.arraycopy(options, 0, temp, 0, temp.length);
        options = temp;
        boolean[] dup = new boolean[options.length];
        int numDups = 0;
        int i = 0;
        while (i < options.length) {
            String option = options[i];
            if (LangUtil.isEmpty(option)) {
                throw new IllegalArgumentException("empty option at " + i);
            }
            if (option.endsWith("-")) {
                options[i] = option.substring(0, option.length() - 1);
                dup[i] = true;
                ++numDups;
            }
            ++i;
        }
        String[] NONE = new String[]{};
        int variants = LangUtil.exp(2, numDups);
        String[][] result = new String[variants][];
        int variant = 0;
        while (variant < variants) {
            ArrayList<String> next = new ArrayList<String>();
            int nextOption = 0;
            int k = 0;
            while (k < options.length) {
                if (!dup[k] || 0 != (variant & 1 << nextOption++)) {
                    next.add(options[k]);
                }
                ++k;
            }
            result[variant] = next.toArray(NONE);
            ++variant;
        }
        return result;
    }

    private static int exp(int base, int power) {
        if (0 > power) {
            throw new IllegalArgumentException("negative power: " + power);
        }
        int result = 1;
        while (0 < power--) {
            result *= base;
        }
        return result;
    }

    public static final Object[] copy(Object[] source) {
        LangUtil.throwIaxIfNull(source, "source");
        Class<?> c = source.getClass().getComponentType();
        Object[] result = (Object[])Array.newInstance(c, source.length);
        System.arraycopy(source, 0, result, 0, result.length);
        return result;
    }

    public static Object[] safeCopy(Object[] source, Object[] sink) {
        int resultSize;
        Class clazz = null == sink ? (class$java$lang$Object == null ? (class$java$lang$Object = LangUtil.class$("java.lang.Object")) : class$java$lang$Object) : sink.getClass().getComponentType();
        Class sinkType = clazz;
        int sourceLength = null == source ? 0 : source.length;
        int sinkLength = null == sink ? 0 : sink.length;
        ArrayList<Object> result = null;
        if (0 == sourceLength) {
            resultSize = 0;
        } else {
            result = new ArrayList<Object>(sourceLength);
            int i = 0;
            while (i < sourceLength) {
                if (null != source[i] && sinkType.isAssignableFrom(source[i].getClass())) {
                    result.add(source[i]);
                }
                ++i;
            }
            resultSize = result.size();
        }
        if (resultSize != sinkLength) {
            sink = (Object[])Array.newInstance(sinkType, result.size());
        }
        if (0 < resultSize) {
            sink = result.toArray(sink);
        }
        return sink;
    }

    public static String unqualifiedClassName(Class c) {
        if (null == c) {
            return "null";
        }
        String name = c.getName();
        int loc = name.lastIndexOf(".");
        if (-1 != loc) {
            name = name.substring(1 + loc);
        }
        return name;
    }

    public static String unqualifiedClassName(Object o) {
        return LangUtil.unqualifiedClassName(null == o ? null : o.getClass());
    }

    /*
     * WARNING - void declaration
     */
    public static String replace(String in, String sought, String replace) {
        int loc;
        if (LangUtil.isEmpty(in) || LangUtil.isEmpty(sought)) {
            return in;
        }
        StringBuffer result = new StringBuffer();
        int len = sought.length();
        int start = 0;
        while (-1 != (loc = in.indexOf(sought, start))) {
            void var6_6;
            result.append(in.substring(start, (int)var6_6));
            if (!LangUtil.isEmpty(replace)) {
                result.append(in.substring(start, (int)var6_6));
            }
            start = var6_6 + len;
        }
        result.append(in.substring(start));
        return result.toString();
    }

    public static String toSizedString(long i, int width) {
        String result = "" + i;
        int size = result.length();
        if (width > size) {
            String pad = "                                              ";
            int padLength = "                                              ".length();
            if (width > padLength) {
                width = padLength;
            }
            int topad = width - size;
            result = "                                              ".substring(0, topad) + result;
        }
        return result;
    }

    static String clipBuffer(StringBuffer buffer, int maxLines) {
        if (null == buffer || 1 > buffer.length()) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        int j = 0;
        int MAX = maxLines;
        int N = buffer.length();
        int i = 0;
        int srcBegin = 0;
        while (i < MAX) {
            char[] chars = new char[128];
            int srcEnd = srcBegin + chars.length;
            if (srcEnd >= N) {
                srcEnd = N - 1;
            }
            if (srcBegin == srcEnd) break;
            buffer.getChars(srcBegin, srcEnd, chars, 0);
            j = 0;
            while (j < srcEnd - srcBegin) {
                char c = chars[j];
                if (c == '\n') {
                    ++i;
                    ++j;
                    break;
                }
                ++j;
            }
            try {
                result.append(chars, 0, j);
            }
            catch (Throwable t) {
                // empty catch block
            }
            srcBegin += j;
        }
        return result.toString();
    }

    public static String renderExceptionShort(Throwable e) {
        if (null == e) {
            return "(Throwable) null";
        }
        return "(" + LangUtil.unqualifiedClassName(e) + ") " + e.getMessage();
    }

    public static String renderException(Throwable t) {
        return LangUtil.renderException(t, true);
    }

    public static String renderException(Throwable t, boolean elide) {
        if (null == t) {
            return "null throwable";
        }
        t = LangUtil.unwrapException(t);
        StringBuffer stack = LangUtil.stackToString(t, false);
        if (elide) {
            LangUtil.elideEndingLines(StringChecker.TEST_PACKAGES, stack, 100);
        }
        return stack.toString();
    }

    static void elideEndingLines(StringChecker checker, StringBuffer stack, int maxLines) {
        if (null == checker || null == stack || 0 == stack.length()) {
            return;
        }
        LinkedList<String> lines = new LinkedList<String>();
        StringTokenizer st = new StringTokenizer(stack.toString(), "\n\r");
        while (st.hasMoreTokens() && 0 < --maxLines) {
            lines.add(st.nextToken());
        }
        st = null;
        int elided = 0;
        while (!lines.isEmpty()) {
            String line = (String)lines.getLast();
            if (!checker.acceptString(line)) break;
            ++elided;
            lines.removeLast();
        }
        if (elided > 0 || maxLines < 1) {
            int EOL_LEN = EOL.length();
            int totalLength = 0;
            while (!lines.isEmpty()) {
                totalLength += EOL_LEN + ((String)lines.getFirst()).length();
                lines.removeFirst();
            }
            if (stack.length() > totalLength) {
                stack.setLength(totalLength);
                if (elided > 0) {
                    stack.append("    (... " + elided + " lines...)");
                }
            }
        }
    }

    public static StringBuffer stackToString(Throwable throwable, boolean skipMessage) {
        if (null == throwable) {
            return new StringBuffer();
        }
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        if (!skipMessage) {
            writer.println(throwable.getMessage());
        }
        throwable.printStackTrace(writer);
        try {
            buf.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return buf.getBuffer();
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable current = t;
        Throwable next = null;
        while (current != null) {
            if (current instanceof InvocationTargetException) {
                next = ((InvocationTargetException)current).getTargetException();
            } else if (current instanceof ClassNotFoundException) {
                next = ((ClassNotFoundException)current).getException();
            } else if (current instanceof ExceptionInInitializerError) {
                next = ((ExceptionInInitializerError)current).getException();
            } else if (current instanceof PrivilegedActionException) {
                next = ((PrivilegedActionException)current).getException();
            } else if (current instanceof SQLException) {
                next = ((SQLException)current).getNextException();
            }
            if (null == next) break;
            current = next;
            next = null;
        }
        return current;
    }

    public static List arrayAsList(Object[] array) {
        if (null == array || 1 > array.length) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.addAll(Arrays.asList(array));
        return list;
    }

    public static String makeClasspath(String bootclasspath, String classpath, String classesDir, String outputJar) {
        StringBuffer sb = new StringBuffer();
        LangUtil.addIfNotEmpty(bootclasspath, sb, File.pathSeparator);
        LangUtil.addIfNotEmpty(classpath, sb, File.pathSeparator);
        if (!LangUtil.addIfNotEmpty(classesDir, sb, File.pathSeparator)) {
            LangUtil.addIfNotEmpty(outputJar, sb, File.pathSeparator);
        }
        return sb.toString();
    }

    private static boolean addIfNotEmpty(String input, StringBuffer sink, String delimiter) {
        if (LangUtil.isEmpty(input) || null == sink) {
            return false;
        }
        sink.append(input);
        if (!LangUtil.isEmpty(delimiter)) {
            sink.append(delimiter);
        }
        return true;
    }

    public static ProcessController makeProcess(ProcessController controller, String classpath, String mainClass, String[] args) {
        File java = LangUtil.getJavaExecutable(classpath);
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(java.getAbsolutePath());
        cmd.add("-classpath");
        cmd.add(classpath);
        cmd.add(mainClass);
        if (!LangUtil.isEmpty(args)) {
            cmd.addAll(Arrays.asList(args));
        }
        String[] command = cmd.toArray(new String[0]);
        if (null == controller) {
            controller = new ProcessController();
        }
        controller.init(command, mainClass);
        return controller;
    }

    public static ProcessController makeProcess(ProcessController controller, String[] command, String label) {
        if (null == controller) {
            controller = new ProcessController();
        }
        controller.init(command, label);
        return controller;
    }

    public static File getJavaExecutable(String classpath) {
        File binDir;
        String javaHome = null;
        File result = null;
        try {
            javaHome = System.getProperty("java.home");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (null != javaHome && (binDir = new File(javaHome, "bin")).isDirectory() && binDir.canRead()) {
            String[] execs = new String[]{"java", "java.exe"};
            int i = 0;
            while (i < execs.length) {
                result = new File(binDir, execs[i]);
                if (result.canRead()) break;
                ++i;
            }
        }
        return result;
    }

    public static boolean sleep(long milliseconds) {
        if (milliseconds == 0L) {
            return true;
        }
        if (milliseconds < 0L) {
            throw new IllegalArgumentException("negative: " + milliseconds);
        }
        return LangUtil.sleepUntil(milliseconds + System.currentTimeMillis());
    }

    public static boolean sleepUntil(long time) {
        if (time == 0L) {
            return true;
        }
        if (time < 0L) {
            throw new IllegalArgumentException("negative: " + time);
        }
        Thread thread = Thread.currentThread();
        long curTime = System.currentTimeMillis();
        int i = 0;
        while (i < 100 && curTime < time) {
            try {
                Thread.sleep(time - curTime);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            curTime = System.currentTimeMillis();
            ++i;
        }
        return curTime >= time;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println("");
        String eol = "\n";
        try {
            buf.close();
            StringBuffer sb = buf.getBuffer();
            if (null != sb || 0 < sb.length()) {
                eol = buf.toString();
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        EOL = eol;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("1.2", "java.lang.ref.Reference");
        map.put("1.3", "java.lang.reflect.Proxy");
        map.put("1.4", "java.nio.Buffer");
        VM_CLASSES = Collections.unmodifiableMap(map);
    }

    public static class ProcessController {
        private String[] command;
        private String[] envp;
        private String label;
        private boolean init;
        private boolean started;
        private boolean completed;
        private boolean userStopped;
        private Process process;
        private FileUtil.Pipe errStream;
        private FileUtil.Pipe outStream;
        private FileUtil.Pipe inStream;
        private ByteArrayOutputStream errSnoop;
        private ByteArrayOutputStream outSnoop;
        private int result;
        private Thrown thrown;

        public final void reinit() {
            if (!this.init) {
                throw new IllegalStateException("must init(..) before reinit()");
            }
            if (this.started && !this.completed) {
                throw new IllegalStateException("not completed - do stop()");
            }
            this.started = false;
            this.completed = false;
            this.result = Integer.MIN_VALUE;
            this.thrown = null;
            this.process = null;
            this.errStream = null;
            this.outStream = null;
            this.inStream = null;
        }

        public final void init(String classpath, String mainClass, String[] args) {
            this.init(LangUtil.getJavaExecutable(classpath), classpath, mainClass, args);
        }

        public final void init(File java, String classpath, String mainClass, String[] args) {
            LangUtil.throwIaxIfNull(java, "java");
            LangUtil.throwIaxIfNull(mainClass, "mainClass");
            LangUtil.throwIaxIfNull(args, "args");
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(java.getAbsolutePath());
            cmd.add("-classpath");
            cmd.add(classpath);
            cmd.add(mainClass);
            if (!LangUtil.isEmpty(args)) {
                cmd.addAll(Arrays.asList(args));
            }
            this.init(cmd.toArray(new String[0]), mainClass);
        }

        public final void init(String[] command, String label) {
            this.command = (String[])LangUtil.safeCopy(command, new String[0]);
            if (1 > this.command.length) {
                throw new IllegalArgumentException("empty command");
            }
            this.label = LangUtil.isEmpty(label) ? command[0] : label;
            this.init = true;
            this.reinit();
        }

        public final void setEnvp(String[] envp) {
            this.envp = (String[])LangUtil.safeCopy(envp, new String[0]);
            if (1 > this.envp.length) {
                throw new IllegalArgumentException("empty envp");
            }
        }

        public final void setErrSnoop(ByteArrayOutputStream snoop) {
            this.errSnoop = snoop;
            if (null != this.errStream) {
                this.errStream.setSnoop(this.errSnoop);
            }
        }

        public final void setOutSnoop(ByteArrayOutputStream snoop) {
            this.outSnoop = snoop;
            if (null != this.outStream) {
                this.outStream.setSnoop(this.outSnoop);
            }
        }

        public final Thread start() {
            if (!this.init) {
                throw new IllegalStateException("not initialized");
            }
            ProcessController processController = this;
            synchronized (processController) {
                if (this.started) {
                    throw new IllegalStateException("already started");
                }
                this.started = true;
            }
            try {
                this.process = Runtime.getRuntime().exec(this.command);
            }
            catch (IOException e) {
                this.stop(e, Integer.MIN_VALUE);
                return null;
            }
            this.errStream = new FileUtil.Pipe(this.process.getErrorStream(), System.err);
            if (null != this.errSnoop) {
                this.errStream.setSnoop(this.errSnoop);
            }
            this.outStream = new FileUtil.Pipe(this.process.getInputStream(), System.out);
            this.inStream = new FileUtil.Pipe(System.in, this.process.getOutputStream());
            Runnable processRunner = new Runnable(this){
                private final /* synthetic */ ProcessController this$0;
                {
                    this.this$0 = this$0;
                }

                /*
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public void run() {
                    Throwable thrown = null;
                    int result = Integer.MIN_VALUE;
                    try {
                        try {
                            new Thread(ProcessController.access$000(this.this$0)).start();
                            new Thread(ProcessController.access$100(this.this$0)).start();
                            new Thread(ProcessController.access$200(this.this$0)).start();
                            ProcessController.access$300(this.this$0).waitFor();
                            result = ProcessController.access$300(this.this$0).exitValue();
                        }
                        catch (Throwable e) {
                            thrown = e;
                            Object var5_4 = null;
                            ProcessController.access$400(this.this$0, thrown, result);
                            return;
                        }
                        Object var5_3 = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_5 = null;
                        ProcessController.access$400(this.this$0, thrown, result);
                        throw throwable;
                    }
                    ProcessController.access$400(this.this$0, thrown, result);
                }
            };
            Thread result = new Thread(processRunner, this.label);
            result.start();
            return result;
        }

        public final synchronized void stop() {
            if (this.completed) {
                return;
            }
            this.userStopped = true;
            this.stop(null, Integer.MIN_VALUE);
        }

        public final String[] getCommand() {
            Object[] toCopy = this.command;
            if (LangUtil.isEmpty(toCopy)) {
                return new String[0];
            }
            String[] result = new String[toCopy.length];
            System.arraycopy(toCopy, 0, result, 0, result.length);
            return result;
        }

        public final boolean completed() {
            return this.completed;
        }

        public final boolean started() {
            return this.started;
        }

        public final boolean userStopped() {
            return this.userStopped;
        }

        public final Thrown getThrown() {
            return this.makeThrown(null);
        }

        public final int getResult() {
            return this.result;
        }

        protected void doCompleting(Thrown thrown, int result) {
        }

        private final synchronized void stop(Throwable thrown, int result) {
            if (this.completed) {
                throw new IllegalStateException("already completed");
            }
            if (null != this.thrown) {
                throw new IllegalStateException("already set thrown: " + thrown);
            }
            this.thrown = this.makeThrown(thrown);
            if (null != this.process) {
                this.process.destroy();
            }
            if (null != this.inStream) {
                this.inStream.halt(false, true);
                this.inStream = null;
            }
            if (null != this.outStream) {
                this.outStream.halt(true, true);
                this.outStream = null;
            }
            if (null != this.errStream) {
                this.errStream.halt(true, true);
                this.errStream = null;
            }
            if (Integer.MIN_VALUE != result) {
                this.result = result;
            }
            this.completed = true;
            this.doCompleting(this.thrown, result);
        }

        private final synchronized Thrown makeThrown(Throwable processThrown) {
            if (null != this.thrown) {
                return this.thrown;
            }
            return new Thrown(processThrown, null == this.outStream ? null : this.outStream.getThrown(), null == this.errStream ? null : this.errStream.getThrown(), null == this.inStream ? null : this.inStream.getThrown());
        }

        static /* synthetic */ FileUtil.Pipe access$000(ProcessController x0) {
            return x0.errStream;
        }

        static /* synthetic */ FileUtil.Pipe access$100(ProcessController x0) {
            return x0.outStream;
        }

        static /* synthetic */ FileUtil.Pipe access$200(ProcessController x0) {
            return x0.inStream;
        }

        static /* synthetic */ Process access$300(ProcessController x0) {
            return x0.process;
        }

        static /* synthetic */ void access$400(ProcessController x0, Throwable x1, int x2) {
            x0.stop(x1, x2);
        }

        public static class Thrown {
            public final Throwable fromProcess;
            public final Throwable fromErrPipe;
            public final Throwable fromOutPipe;
            public final Throwable fromInPipe;
            public final boolean thrown;

            private Thrown(Throwable fromProcess, Throwable fromOutPipe, Throwable fromErrPipe, Throwable fromInPipe) {
                this.fromProcess = fromProcess;
                this.fromErrPipe = fromErrPipe;
                this.fromOutPipe = fromOutPipe;
                this.fromInPipe = fromInPipe;
                this.thrown = null != fromProcess || null != fromInPipe || null != fromOutPipe || null != fromErrPipe;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer();
                this.append(sb, this.fromProcess, "process");
                this.append(sb, this.fromOutPipe, " stdout");
                this.append(sb, this.fromErrPipe, " stderr");
                this.append(sb, this.fromInPipe, "  stdin");
                if (0 == sb.length()) {
                    return "Thrown (none)";
                }
                return sb.toString();
            }

            private void append(StringBuffer sb, Throwable thrown, String label) {
                if (null != thrown) {
                    sb.append("from " + label + ": ");
                    sb.append(LangUtil.renderExceptionShort(thrown));
                    sb.append(EOL);
                }
            }
        }
    }

    public static class StringChecker {
        static StringChecker TEST_PACKAGES = new StringChecker(new String[]{"org.aspectj.testing", "org.eclipse.jdt.internal.junit", "junit.framework.", "org.apache.tools.ant.taskdefs.optional.junit.JUnitTestRunner"});
        String[] infixes;

        StringChecker(String[] infixes) {
            this.infixes = infixes;
        }

        public boolean acceptString(String input) {
            boolean result = false;
            if (!LangUtil.isEmpty(input)) {
                int i = 0;
                while (!result && i < this.infixes.length) {
                    result = -1 != input.indexOf(this.infixes[i]);
                    ++i;
                }
            }
            return result;
        }
    }
}

