/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ant.taskdefs;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Javac;
import org.apache.tools.ant.taskdefs.compilers.CompilerAdapter;
import org.aspectj.tools.ant.taskdefs.AjcTask;
import org.aspectj.util.FileUtil;

public class Ajc11CompilerAdapter
implements CompilerAdapter {
    public static final String CLEAN = "build.compiler.clean";
    Javac javac;

    public void setJavac(Javac javac) {
        this.javac = javac;
    }

    public boolean execute() throws BuildException {
        this.checkJavac();
        if (this.recurse()) {
            this.javac.execute();
        } else {
            try {
                AjcTask ajc = new AjcTask();
                String err = ajc.setupAjc(this.javac);
                if (null != err) {
                    throw new BuildException(err, this.javac.getLocation());
                }
                ajc.execute();
                Object var4_3 = null;
                this.doneRecursing();
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.doneRecursing();
                throw throwable;
            }
        }
        return true;
    }

    protected void checkJavac() {
        if (null == this.javac) {
            throw new IllegalStateException("null javac");
        }
    }

    protected File getDestDir(String client) {
        this.checkJavac();
        File destDir = this.javac.getDestdir();
        if (null == destDir) {
            throw new BuildException("require destDir for " + client);
        }
        return destDir;
    }

    protected File getTagFile() {
        return new File(this.getDestDir("getting tag file directory"), "Ajc11CompilerAdapter.tag");
    }

    protected boolean recurse() {
        this.checkJavac();
        String cleanDirs = this.javac.getProject().getProperty(CLEAN);
        if (null == cleanDirs) {
            return false;
        }
        File destDir = this.getDestDir("recursing to clean");
        File tagFile = this.getTagFile();
        if (tagFile.exists()) {
            return false;
        }
        try {
            this.javac.log("build.compiler.clean cleaning .class files from " + destDir, 3);
            FileUtil.deleteContents(destDir, FileUtil.DIRS_AND_WRITABLE_CLASSES, true);
            FileWriter fw = new FileWriter(tagFile);
            fw.write("Ajc11CompilerAdapter.recursing");
            fw.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    protected void doneRecursing() {
        File tagFile = this.getTagFile();
        if (tagFile.exists()) {
            tagFile.delete();
        }
    }
}

