/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajc;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import org.aspectj.bridge.AbortException;
import org.aspectj.bridge.ICommand;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IMessageHandler;
import org.aspectj.bridge.IMessageHolder;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.Message;
import org.aspectj.bridge.MessageHandler;
import org.aspectj.bridge.MessageUtil;
import org.aspectj.bridge.ReflectionFactory;
import org.aspectj.util.FileUtil;
import org.aspectj.util.LangUtil;

public class Main {
    public static final String THROWN_PREFIX = "Exception thrown from AspectJ 1.1.1" + LangUtil.EOL + "" + LangUtil.EOL + "This might be logged as a bug already -- find current bugs at" + LangUtil.EOL + "  http://bugs.eclipse.org/bugs/buglist.cgi?product=AspectJ&component=Compiler" + LangUtil.EOL + "" + LangUtil.EOL + "Bugs for exceptions thrown have titles File:line from the top stack, " + LangUtil.EOL + "e.g., \"SomeFile.java:243\"" + LangUtil.EOL + "" + LangUtil.EOL + "If you don't find the exception below in a bug, please add a new bug" + LangUtil.EOL + "at http://bugs.eclipse.org/bugs/enter_bug.cgi?product=AspectJ" + LangUtil.EOL + "To make the bug a priority, please include a test program" + LangUtil.EOL + "that can reproduce this exception." + LangUtil.EOL;
    protected CommandController controller = new CommandController();
    protected String commandName = "org.aspectj.ajdt.ajc.AjdtCommand";
    private IMessageHolder clientHolder;
    protected final MessageHandler ourHandler = new MessageHandler(true);
    private int lastFails;
    private int lastErrors;
    private Runnable completionRunner;

    public static void main(String[] args) throws IOException {
        new Main().runMain(args, true);
    }

    public static String renderExceptionForUser(Throwable thrown) {
        String m = thrown.getMessage();
        return THROWN_PREFIX + (null != m ? m + "\n" : "") + LangUtil.renderException(thrown, true);
    }

    private static void appendNLabel(StringBuffer sink, String label, int numItems) {
        if (0 == numItems) {
            return;
        }
        if (0 < sink.length()) {
            sink.append(", ");
        }
        sink.append(numItems + " ");
        if (!LangUtil.isEmpty(label)) {
            sink.append(label);
        }
        if (1 < numItems) {
            sink.append("s");
        }
    }

    public void runMain(String[] args, boolean useSystemExit) {
        boolean verbose = -1 != ("" + LangUtil.arrayAsList(args)).indexOf("-verbose");
        IMessageHolder holder = this.clientHolder;
        if (null == holder) {
            holder = this.ourHandler;
            if (verbose) {
                this.ourHandler.setInterceptor(MessagePrinter.VERBOSE);
            } else {
                this.ourHandler.ignore(IMessage.INFO);
                this.ourHandler.setInterceptor(MessagePrinter.TERSE);
            }
        }
        this.run(args, holder);
        boolean skipExit = false;
        if (useSystemExit && !LangUtil.isEmpty(args)) {
            int i = 0;
            while (i < args.length) {
                if ("-noExit".equals(args[i])) {
                    skipExit = true;
                    break;
                }
                ++i;
            }
        }
        if (useSystemExit && !skipExit) {
            this.systemExit(holder);
        }
    }

    public void run(String[] args, IMessageHolder holder) {
        block20: {
            if (LangUtil.isEmpty(args)) {
                args = new String[]{"-help"};
            } else {
                if (Arrays.asList(args).contains("-version")) {
                    System.out.println("AspectJ Compiler 1.1.1");
                    System.out.println();
                    return;
                }
                if (this.controller.running()) {
                    Main.fail(holder, "already running with controller: " + this.controller, null);
                    return;
                }
            }
            args = this.controller.init(args, holder);
            if (0 < holder.numMessages(IMessage.ERROR, true)) {
                return;
            }
            ICommand command = ReflectionFactory.makeCommand(this.commandName, holder);
            if (0 < holder.numMessages(IMessage.ERROR, true)) {
                return;
            }
            try {
                boolean passed;
                boolean verbose;
                boolean bl = verbose = -1 != ("" + Arrays.asList(args)).indexOf("-verbose");
                block3: while (this.report(passed = command.runCommand(args, holder), holder) && this.controller.incremental()) {
                    boolean onCommandLine = this.controller.commandLineIncremental();
                    while (this.controller.doRepeatCommand()) {
                        holder.clearMessages();
                        if (this.controller.buildFresh()) continue block3;
                        passed = command.repeatCommand(holder);
                        if (this.report(passed, holder)) {
                            continue;
                        }
                        break block20;
                    }
                    break;
                }
            }
            catch (AbortException ae) {
                if (ae.isSilent()) {
                    this.quit();
                } else {
                    IMessage message = ae.getIMessage();
                    Throwable thrown = ae.getThrown();
                    if (null == thrown) {
                        if (null != message) {
                            holder.handleMessage(message);
                        } else {
                            Main.fail(holder, "abort without message", ae);
                        }
                    } else if (null == message) {
                        Main.fail(holder, "aborted", thrown);
                    } else {
                        String mssg = MessageUtil.MESSAGE_MOST.renderToString(message);
                        Main.fail(holder, mssg, thrown);
                    }
                }
            }
            catch (Throwable t) {
                Main.fail(holder, "unexpected exception", t);
            }
        }
    }

    public void quit() {
        this.controller.quit();
    }

    public void setHolder(IMessageHolder holder) {
        this.clientHolder = holder;
    }

    public void setCompletionRunner(Runnable runner) {
        this.completionRunner = runner;
    }

    protected void systemExit(IMessageHolder messages) {
        int num = this.lastFails;
        if (0 < num) {
            System.exit(-num);
        }
        if (0 < (num = this.lastErrors)) {
            System.exit(num);
        }
        System.exit(0);
    }

    protected void outMessage(String message) {
        System.out.print(message);
        System.out.flush();
    }

    protected boolean report(boolean pass, IMessageHolder holder) {
        this.lastFails = holder.numMessages(IMessage.FAIL, true);
        boolean result = 0 == this.lastFails;
        Runnable runner = this.completionRunner;
        if (null != runner) {
            runner.run();
        }
        if (holder == this.ourHandler) {
            this.lastErrors = holder.numMessages(IMessage.ERROR, false);
            int warnings = holder.numMessages(IMessage.WARNING, false);
            StringBuffer sb = new StringBuffer();
            Main.appendNLabel(sb, "fail|abort", this.lastFails);
            Main.appendNLabel(sb, "error", this.lastErrors);
            Main.appendNLabel(sb, "warning", warnings);
            if (0 < sb.length()) {
                PrintStream out = 0 < this.lastErrors + this.lastFails ? System.err : System.out;
                out.println("");
                out.println(sb.toString());
            }
        }
        return result;
    }

    protected static void fail(IMessageHandler handler, String message, Throwable thrown) {
        handler.handleMessage(new Message(message, IMessage.FAIL, thrown, null));
    }

    public static class CommandController {
        public static String TAG_FILE_OPTION = "-XincrementalFile";
        public static String INCREMENTAL_OPTION = "-incremental";
        public static long MAX_DELAY = 600000L;
        public static long DEFAULT_DELAY = 5000L;
        private static String[][] OPTIONS = new String[][]{{INCREMENTAL_OPTION}, {TAG_FILE_OPTION, null}};
        private boolean running;
        private boolean quit;
        private boolean incremental;
        private File tagFile;
        private long fileModTime;
        private long delay = DEFAULT_DELAY;
        private boolean buildFresh;

        public String[] init(String[] args, IMessageHandler sink) {
            this.running = true;
            if (!LangUtil.isEmpty(args)) {
                String[][] options = LangUtil.copyStrings(OPTIONS);
                String[] unused = LangUtil.extractOptions(args, options);
                boolean bl = this.incremental = null != options[0][0];
                if (null != options[1][0]) {
                    File file = new File(options[1][1]);
                    if (!file.exists()) {
                        MessageUtil.abort(sink, "tag file does not exist: " + file);
                    } else {
                        this.tagFile = file;
                        this.fileModTime = this.tagFile.lastModified();
                    }
                }
            }
            return args;
        }

        public boolean running() {
            return this.running;
        }

        public void setDelay(long delay) {
            if (delay > -1L && delay < MAX_DELAY) {
                this.delay = delay;
            }
        }

        public boolean incremental() {
            return this.incremental || null != this.tagFile;
        }

        public boolean commandLineIncremental() {
            return this.incremental;
        }

        public void quit() {
            if (!this.quit) {
                this.quit = true;
            }
        }

        boolean buildFresh() {
            return this.buildFresh;
        }

        boolean doRepeatCommand() {
            boolean result;
            block16: {
                if (!this.running) {
                    return false;
                }
                result = false;
                if (this.quit) {
                    result = false;
                } else if (this.incremental) {
                    try {
                        int input;
                        if (this.buildFresh) {
                            this.buildFresh = false;
                        }
                        System.out.println(" press enter to recompile, r to rebuild, q to quit: ");
                        System.out.flush();
                        boolean doMore = false;
                        while (113 != (input = System.in.read())) {
                            if (114 == input) {
                                this.buildFresh = true;
                                result = true;
                            } else if (10 == input || 13 == input) {
                                result = true;
                            }
                            if (!result) continue;
                        }
                        System.in.skip(Integer.MAX_VALUE);
                    }
                    catch (IOException e) {
                        result = false;
                    }
                } else if (null != this.tagFile) {
                    long curModTime;
                    while (true) {
                        if (!this.tagFile.exists()) {
                            result = false;
                            break block16;
                        }
                        curModTime = this.tagFile.lastModified();
                        if (this.fileModTime != curModTime) break;
                        this.fileCheckDelay();
                    }
                    this.fileModTime = curModTime;
                    result = true;
                }
            }
            if (!result && this.running) {
                this.running = false;
            }
            return result;
        }

        protected void fileCheckDelay() {
            long curTime;
            Thread thread = Thread.currentThread();
            long targetTime = System.currentTimeMillis() + this.delay;
            while (targetTime > (curTime = System.currentTimeMillis())) {
                if (this.quit) {
                    return;
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }
    }

    public static class MessagePrinter
    implements IMessageHandler {
        public static final IMessageHandler VERBOSE = new MessagePrinter(true);
        public static final IMessageHandler TERSE = new MessagePrinter(false);
        final boolean verbose;

        protected MessagePrinter(boolean verbose) {
            this.verbose = verbose;
        }

        public boolean handleMessage(IMessage message) {
            PrintStream out;
            if (null != message && null != (out = this.getStreamFor(message.getKind()))) {
                out.println(this.render(message));
            }
            return false;
        }

        protected String render(IMessage message) {
            Throwable thrown;
            boolean toString;
            IMessage.Kind kind = message.getKind();
            StringBuffer sb = new StringBuffer();
            String text = message.getMessage();
            if (text.equals("AbortException (no message)")) {
                text = null;
            }
            if (toString = LangUtil.isEmpty(text)) {
                text = message.toString();
            }
            ISourceLocation loc = message.getSourceLocation();
            String context = null;
            if (null != loc) {
                File file = loc.getSourceFile();
                if (null != file) {
                    String name = file.getName();
                    if (!toString || -1 == text.indexOf(name)) {
                        sb.append(FileUtil.getBestPath(file));
                        sb.append(":" + loc.getLine());
                        int col = loc.getColumn();
                        if (0 < col) {
                            sb.append(":" + col);
                        }
                        sb.append(" ");
                    }
                }
                context = loc.getContext();
            }
            sb.append(text);
            if (null != context) {
                sb.append(LangUtil.EOL);
                sb.append(context);
            }
            if (null != (thrown = message.getThrown())) {
                sb.append(LangUtil.EOL);
                sb.append(Main.renderExceptionForUser(thrown));
            }
            return sb.toString();
        }

        public boolean isIgnoring(IMessage.Kind kind) {
            return null != this.getStreamFor(kind);
        }

        protected PrintStream getStreamFor(IMessage.Kind kind) {
            if (IMessage.WARNING.isSameOrLessThan(kind)) {
                return System.err;
            }
            if (this.verbose && IMessage.INFO.equals(kind)) {
                return System.out;
            }
            return null;
        }
    }
}

