/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajbrowser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.EditorAdapter;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.tools.ajbrowser.BrowserManager;

public class BasicEditor
implements EditorAdapter {
    private String NO_FILE;
    private String filePath;
    private JPanel editor_panel;
    private int currHighlightStart;
    private int currHighlightEnd;
    private BorderLayout borderLayout1;
    private JScrollPane jScrollPane1;
    private JEditorPane editorPane;

    public BasicEditor() {
        this.filePath = this.NO_FILE = "<no file selected>";
        this.editor_panel = new JPanel();
        this.currHighlightStart = 0;
        this.currHighlightEnd = 0;
        this.borderLayout1 = new BorderLayout();
        this.jScrollPane1 = new JScrollPane();
        this.editorPane = new JEditorPane();
        try {
            this.editorPane.setEditable(true);
            this.editorPane.setContentType("text/plain");
            this.editorPane.setFont(new Font("Monospaced", 0, 11));
            this.editor_panel.add(this.editorPane);
            this.jbInit();
        }
        catch (Exception e) {
            Ajde.getDefault().getErrorHandler().handleError("Could not initialize GUI.", e);
        }
    }

    public String getCurrFile() {
        return this.filePath;
    }

    public void showSourceLine(ISourceLocation sourceLocation, boolean highlight) {
        this.showSourceLine(sourceLocation.getSourceFile().getAbsolutePath(), sourceLocation.getLine(), highlight);
    }

    public void showSourceLine(int lineNumber, boolean highlight) {
        this.showSourceLine(this.filePath, lineNumber, highlight);
    }

    public void pasteToCaretPos(String text) {
        if (this.currHighlightEnd < 1) {
            return;
        }
        String contents = this.editorPane.getText();
        String pasted = contents.substring(0, this.currHighlightEnd) + text + contents.substring(this.currHighlightEnd, contents.length());
        this.editorPane.setText(pasted);
    }

    public void showSourceLine(String filePath, int lineNumber, boolean highlight) {
        String oldPath = this.filePath;
        this.filePath = filePath;
        this.currHighlightStart = 0;
        this.currHighlightEnd = 0;
        this.editorPane.setText(this.readFile(filePath, lineNumber));
        try {
            this.editorPane.getHighlighter().addHighlight(this.currHighlightStart, this.currHighlightEnd, DefaultHighlighter.DefaultPainter);
            this.editorPane.setCaretPosition(this.currHighlightStart);
        }
        catch (BadLocationException ble) {
            Ajde.getDefault().getErrorHandler().handleError("Could not highlight location.", ble);
        }
        BrowserManager.getDefault().getEditorManager().notifyCurrentFileChanged(filePath);
    }

    public void showSourcelineAnnotation(String filePath, int lineNumber, List items) {
    }

    public void addEditorViewForSourceLine(String filePath, int lineNumber) {
    }

    public void saveContents() throws IOException {
        if (this.filePath != this.NO_FILE && this.filePath != "" && this.editorPane.getText() != "") {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.filePath));
            writer.write(this.editorPane.getText());
            writer.flush();
        }
    }

    public JPanel getPanel() {
        return this.editor_panel;
    }

    public void showSourceForFile(String filePath) {
    }

    public void showSourceForLine(int lineNumber, boolean highlight) {
    }

    public void showSourceForSourceLine(String filePath, int lineNumber, boolean highlight) {
    }

    public String getCurrSourceFilePath() {
        return null;
    }

    public void setBreakpointRequest(String filePath, int lineNumber, boolean isDeferred) {
    }

    public void clearBreakpointRequest(String filePath, int lineNumber) {
    }

    private String readFile(String filePath, int lineNumber) {
        try {
            URL url = ClassLoader.getSystemResource(filePath);
            File file = new File(filePath);
            if (!file.exists()) {
                return "ERROR: file \"" + filePath + "\" does not exist.";
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuffer contents = new StringBuffer();
            String line = reader.readLine();
            boolean numChars = false;
            int numLines = 0;
            while (line != null) {
                if (++numLines < lineNumber) {
                    this.currHighlightStart += line.length() + 1;
                }
                if (numLines == lineNumber) {
                    this.currHighlightEnd = this.currHighlightStart + line.length();
                }
                contents.append(line);
                contents.append('\n');
                line = reader.readLine();
            }
            return contents.toString();
        }
        catch (IOException ioe) {
            return "ERROR: could not read file \"" + filePath + "\", make sure that you have mounted /project/aop on X:\\";
        }
    }

    private void jbInit() throws Exception {
        this.editor_panel.setFont(new Font("DialogInput", 1, 12));
        this.editor_panel.setLayout(this.borderLayout1);
        this.editor_panel.add((Component)this.jScrollPane1, "Center");
        this.jScrollPane1.getViewport().add((Component)this.editorPane, null);
    }
}

