/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.bridge;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.ISourceLocation;

public class Message
implements IMessage {
    private final String message;
    private final IMessage.Kind kind;
    private final Throwable thrown;
    private final ISourceLocation sourceLocation;
    private final String details;

    public static Message fail(String message, Throwable thrown) {
        return new Message(message, IMessage.FAIL, thrown, null);
    }

    public Message(String message, ISourceLocation location, boolean isError) {
        this(message, isError ? IMessage.ERROR : IMessage.WARNING, null, location);
    }

    public Message(String message, String details, IMessage.Kind kind, ISourceLocation sourceLocation) {
        this.details = details;
        this.message = message;
        this.kind = kind;
        this.sourceLocation = sourceLocation;
        this.thrown = null;
        if (null == message) {
            if (null != this.thrown) {
                message = this.thrown.getMessage();
            }
            if (null == message) {
                throw new IllegalArgumentException("null message");
            }
        }
        if (null == kind) {
            throw new IllegalArgumentException("null kind");
        }
    }

    public Message(String message, IMessage.Kind kind, Throwable thrown, ISourceLocation sourceLocation) {
        this.message = message;
        this.kind = kind;
        this.thrown = thrown;
        this.sourceLocation = sourceLocation;
        this.details = "";
        if (null == message) {
            if (null != thrown) {
                message = thrown.getMessage();
            }
            if (null == message) {
                throw new IllegalArgumentException("null message");
            }
        }
        if (null == kind) {
            throw new IllegalArgumentException("null kind");
        }
    }

    public IMessage.Kind getKind() {
        return this.kind;
    }

    public boolean isError() {
        return this.kind == IMessage.ERROR;
    }

    public boolean isWarning() {
        return this.kind == IMessage.WARNING;
    }

    public boolean isDebug() {
        return this.kind == IMessage.DEBUG;
    }

    public boolean isInfo() {
        return this.kind == IMessage.INFO;
    }

    public boolean isAbort() {
        return this.kind == IMessage.ABORT;
    }

    public boolean isFailed() {
        return this.kind == IMessage.FAIL;
    }

    public final String getMessage() {
        return this.message;
    }

    public final Throwable getThrown() {
        return this.thrown;
    }

    public final ISourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    public String toString() {
        return Message.renderToString(this);
    }

    public static String renderToString(IMessage message) {
        ISourceLocation loc = message.getSourceLocation();
        String locString = null == loc ? "" : " at " + loc;
        Throwable thrown = message.getThrown();
        return message.getKind() + locString + ": " + message.getMessage() + (null == thrown ? "" : Message.render(thrown));
    }

    public static String render(Throwable thrown) {
        if (null == thrown) {
            return "null throwable";
        }
        Throwable t = null;
        if (thrown instanceof InvocationTargetException) {
            t = ((InvocationTargetException)thrown).getTargetException();
        } else if (thrown instanceof ClassNotFoundException) {
            t = ((ClassNotFoundException)thrown).getException();
        }
        if (null != t) {
            return Message.render(t);
        }
        StringWriter buf = new StringWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println(" Message rendering thrown=" + thrown.getClass().getName());
        writer.println(thrown.getMessage());
        thrown.printStackTrace(writer);
        try {
            buf.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return buf.getBuffer().toString();
    }

    public String getDetails() {
        return this.details;
    }
}

