/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm.internal;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;

public class AspectJElementHierarchy
implements IHierarchy {
    protected IProgramElement root = null;
    protected String configFile = null;
    private Map fileMap = null;
    private Map handleMap = null;
    private Map typeMap = null;

    public IProgramElement getElement(String handle) {
        throw new RuntimeException("unimplemented");
    }

    public IProgramElement getRoot() {
        return this.root;
    }

    public void setRoot(IProgramElement root) {
        this.root = root;
        this.handleMap = new HashMap();
        this.typeMap = new HashMap();
    }

    public void addToFileMap(Object key, Object value) {
        this.fileMap.put(key, value);
    }

    public void setFileMap(HashMap fileMap) {
        this.fileMap = fileMap;
    }

    public Object findInFileMap(Object key) {
        return this.fileMap.get(key);
    }

    public Set getFileMapEntrySet() {
        return this.fileMap.entrySet();
    }

    public boolean isValid() {
        return this.root != null && this.fileMap != null;
    }

    public IProgramElement findElementForSignature(IProgramElement parent, IProgramElement.Kind kind, String signature) {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (node.getKind() == kind && signature.equals(node.toSignatureString())) {
                return node;
            }
            IProgramElement childSearch = this.findElementForSignature(node, kind, signature);
            if (childSearch == null) continue;
            return childSearch;
        }
        return null;
    }

    public IProgramElement findElementForLabel(IProgramElement parent, IProgramElement.Kind kind, String label) {
        Iterator it = parent.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement node = (IProgramElement)it.next();
            if (node.getKind() == kind && label.equals(node.toLabelString())) {
                return node;
            }
            IProgramElement childSearch = this.findElementForSignature(node, kind, label);
            if (childSearch == null) continue;
            return childSearch;
        }
        return null;
    }

    public IProgramElement findElementForType(String packageName, String typeName) {
        StringBuffer keyb = packageName == null ? new StringBuffer() : new StringBuffer(packageName);
        keyb.append(".");
        keyb.append(typeName);
        String key = keyb.toString();
        IProgramElement ret = (IProgramElement)this.typeMap.get(key);
        if (ret == null) {
            Iterator it;
            IProgramElement packageNode = null;
            if (packageName == null) {
                packageNode = this.root;
            } else {
                it = this.root.getChildren().iterator();
                while (it.hasNext()) {
                    IProgramElement node = (IProgramElement)it.next();
                    if (!packageName.equals(node.getName())) continue;
                    packageNode = node;
                }
                if (packageNode == null) {
                    return null;
                }
            }
            it = packageNode.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement fileNode = (IProgramElement)it.next();
                IProgramElement cNode = this.findClassInNodes(fileNode.getChildren(), typeName);
                if (cNode == null) continue;
                ret = cNode;
                this.typeMap.put(key, ret);
            }
        }
        return ret;
    }

    private IProgramElement findClassInNodes(Collection nodes, String name) {
        String innerName;
        String baseName;
        int dollar = name.indexOf(36);
        if (dollar == -1) {
            baseName = name;
            innerName = null;
        } else {
            baseName = name.substring(0, dollar);
            innerName = name.substring(dollar + 1);
        }
        Iterator j = nodes.iterator();
        while (j.hasNext()) {
            IProgramElement classNode = (IProgramElement)j.next();
            if (baseName.equals(classNode.getName())) {
                if (innerName == null) {
                    return classNode;
                }
                return this.findClassInNodes(classNode.getChildren(), innerName);
            }
            if (!name.equals(classNode.getName())) continue;
            return classNode;
        }
        return null;
    }

    public IProgramElement findElementForSourceFile(String sourceFile) {
        try {
            if (!this.isValid() || sourceFile == null) {
                return IHierarchy.NO_STRUCTURE;
            }
            String correctedPath = AsmManager.getDefault().getCanonicalFilePath(new File(sourceFile));
            IProgramElement node = (IProgramElement)this.findInFileMap(correctedPath);
            if (node != null) {
                return node;
            }
            return this.createFileStructureNode(correctedPath);
        }
        catch (Exception e) {
            return IHierarchy.NO_STRUCTURE;
        }
    }

    public IProgramElement findElementForSourceLine(ISourceLocation location) {
        try {
            return this.findElementForSourceLine(AsmManager.getDefault().getCanonicalFilePath(location.getSourceFile()), location.getLine());
        }
        catch (Exception e) {
            return null;
        }
    }

    public IProgramElement findElementForSourceLine(String sourceFilePath, int lineNumber) {
        String canonicalSFP = AsmManager.getDefault().getCanonicalFilePath(new File(sourceFilePath));
        IProgramElement node = this.findNodeForSourceLineHelper(this.root, canonicalSFP, lineNumber);
        if (node != null) {
            return node;
        }
        return this.createFileStructureNode(sourceFilePath);
    }

    private IProgramElement createFileStructureNode(String sourceFilePath) {
        String fileName = new File(sourceFilePath).getName();
        ProgramElement fileNode = new ProgramElement(fileName, IProgramElement.Kind.FILE_JAVA, null);
        fileNode.setSourceLocation(new SourceLocation(new File(sourceFilePath), 1, 1));
        fileNode.addChild(IHierarchy.NO_STRUCTURE);
        return fileNode;
    }

    private IProgramElement findNodeForSourceLineHelper(IProgramElement node, String sourceFilePath, int lineNumber) {
        if (this.matches(node, sourceFilePath, lineNumber) && !this.hasMoreSpecificChild(node, sourceFilePath, lineNumber)) {
            return node;
        }
        if (node != null && node.getChildren() != null) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement foundNode = this.findNodeForSourceLineHelper((IProgramElement)it.next(), sourceFilePath, lineNumber);
                if (foundNode == null) continue;
                return foundNode;
            }
        }
        return null;
    }

    private boolean matches(IProgramElement node, String sourceFilePath, int lineNumber) {
        return node != null && node.getSourceLocation() != null && node.getSourceLocation().getSourceFile().getAbsolutePath().equals(sourceFilePath) && (node.getSourceLocation().getLine() <= lineNumber && node.getSourceLocation().getEndLine() >= lineNumber || lineNumber <= 1 && node.getKind().isSourceFileKind());
    }

    private boolean hasMoreSpecificChild(IProgramElement node, String sourceFilePath, int lineNumber) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement child = (IProgramElement)it.next();
            if (!this.matches(child, sourceFilePath, lineNumber)) continue;
            return true;
        }
        return false;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public IProgramElement findElementForHandle(String handle) {
        IProgramElement ret = (IProgramElement)this.handleMap.get(handle);
        if (ret != null) {
            return ret;
        }
        StringTokenizer st = new StringTokenizer(handle, "|");
        String file = st.nextToken();
        int line = new Integer(st.nextToken());
        int col = new Integer(st.nextToken());
        ret = this.findElementForSourceLine(file, line);
        if (ret != null) {
            this.cache(handle, (ProgramElement)ret);
        }
        return ret;
    }

    protected void cache(String handle, ProgramElement pe) {
        this.handleMap.put(handle, pe);
    }
}

