/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.IRelationship;

public class EmacsStructureModelManager {
    private static final String EXTERN_FILE_SUFFIX = ".ajesym";

    public void externalizeModel() {
        if (!AsmManager.getDefault().getHierarchy().isValid()) {
            return;
        }
        try {
            Set fileSet = AsmManager.getDefault().getHierarchy().getFileMapEntrySet();
            Iterator it = fileSet.iterator();
            while (it.hasNext()) {
                IProgramElement peNode = (IProgramElement)((Map.Entry)it.next()).getValue();
                this.dumpStructureToFile(peNode);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dumpStructureToFile(IProgramElement node) throws IOException {
        String s = node.getKind().toString();
        if (!s.equals(IProgramElement.Kind.FILE_ASPECTJ.toString()) && !s.equals(IProgramElement.Kind.FILE_JAVA.toString())) {
            throw new IllegalArgumentException("externalize file, not " + node);
        }
        String sourceName = node.getSourceLocation().getSourceFile().getAbsolutePath();
        String fileName = sourceName.substring(0, sourceName.lastIndexOf(".")) + EXTERN_FILE_SUFFIX;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(fileName)));
            new SExpressionPrinter(writer).printDecls(node);
            writer.flush();
            Object var7_6 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            writer.close();
            return;
        }
        catch (IOException e) {}
    }

    private static class SExpressionPrinter {
        private BufferedWriter writer = null;

        public SExpressionPrinter(BufferedWriter writer) {
            this.writer = writer;
        }

        private void printDecls(IProgramElement node) {
            this.print("(");
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                Object nodeObject = it.next();
                IProgramElement child = (IProgramElement)nodeObject;
                this.printDecl(child, true);
            }
            this.print(") ");
        }

        private void printDecls(IRelationship node) {
        }

        private void printDecl(IProgramElement node, boolean recurse) {
            if (node == null || node.getSourceLocation() == null) {
                return;
            }
            String kind = node.getKind().toString().toLowerCase();
            this.print("(");
            this.print("(" + node.getSourceLocation().getLine() + " . " + node.getSourceLocation().getColumn() + ") ");
            this.print("(" + node.getSourceLocation().getLine() + " . " + node.getSourceLocation().getColumn() + ") ");
            this.print(kind + " ");
            String displayName = node.toString().replace('\"', ' ');
            this.print("\"" + displayName + "\" ");
            if (node.getSourceLocation().getSourceFile().getAbsolutePath() != null) {
                this.print("\"" + this.fixFilename(node.getSourceLocation().getSourceFile().getAbsolutePath()) + "\"");
            } else {
                this.print("nil");
            }
            if (node.getName() != null) {
                this.print("\"" + node.getDeclaringType() + "\" ");
            } else {
                this.print("nil");
            }
            if (!recurse) {
                this.print("nil");
                this.print("nil");
                this.print("nil");
            } else {
                this.print("(");
                this.print(") ");
                this.print("(");
                this.print(") ");
                this.print("(");
                Iterator it3 = node.getChildren().iterator();
                if (it3.hasNext()) {
                    while (it3.hasNext()) {
                        IProgramElement currNode;
                        Object nodeObject = it3.next();
                        if (!(nodeObject instanceof IProgramElement) || (currNode = (IProgramElement)nodeObject).getKind().equals("<undefined>")) continue;
                        this.printDecl(currNode, true);
                    }
                }
                this.print(") ");
            }
            this.print(node.getKind().equals("class") ? "t " : "nil ");
            this.print(node.getKind().equals("introduction") ? "nil " : "nil ");
            this.print("nil ");
            this.print("nil ");
            this.print(")");
        }

        String fixFilename(String filename) {
            return this.subst("\\\\", "\\", filename);
        }

        private void print(String string) {
            try {
                this.writer.write(string + "\n");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private String subst(String n, String o, String in) {
            int pos = in.indexOf(o);
            if (pos == -1) {
                return in;
            }
            return in.substring(0, pos) + n + this.subst(n, o, in.substring(pos + o.length()));
        }

        private void lose(Error e) {
            try {
                this.print("(ERROR \"" + e.toString() + "\")");
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }
}

