/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.AsmElementFormatter;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;
import org.aspectj.asm.internal.ProgramElement;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.bridge.SourceLocation;
import org.aspectj.util.LangUtil;
import org.aspectj.weaver.ResolvedMember;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AbstractVariableDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AnonymousLocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.LocalTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberTypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.problem.ProblemHandler;

public class AsmHierarchyBuilder
extends AbstractSyntaxTreeVisitorAdapter {
    private final Stack stack;
    private final CompilationResult currCompilationResult;
    private AsmElementFormatter formatter = new AsmElementFormatter();
    private Initializer inInitializer = null;

    public static void build(CompilationUnitDeclaration unit, IHierarchy structureModel) {
        LangUtil.throwIaxIfNull(unit, "unit");
        new AsmHierarchyBuilder(unit.compilationResult()).internalBuild(unit, structureModel);
    }

    protected AsmHierarchyBuilder(CompilationResult result) {
        LangUtil.throwIaxIfNull(result, "result");
        this.currCompilationResult = result;
        this.stack = new Stack();
    }

    private void internalBuild(CompilationUnitDeclaration unit, IHierarchy structureModel) {
        LangUtil.throwIaxIfNull(structureModel, "structureModel");
        if (!this.currCompilationResult.equals(unit.compilationResult())) {
            throw new IllegalArgumentException("invalid unit: " + unit);
        }
        File file = new File(new String(unit.getFileName()));
        int startLine = this.getStartLine(unit);
        int endLine = this.getEndLine(unit);
        SourceLocation sourceLocation = new SourceLocation(file, startLine, endLine);
        ProgramElement cuNode = new ProgramElement(new String(file.getName()), IProgramElement.Kind.FILE_JAVA, sourceLocation, 0, "", new ArrayList());
        cuNode.addChild(new ProgramElement("import declarations", IProgramElement.Kind.IMPORT_REFERENCE, null, 0, "", new ArrayList()));
        IProgramElement addToNode = this.genAddToNode(unit, structureModel);
        ListIterator itt = addToNode.getChildren().listIterator();
        while (itt.hasNext()) {
            IProgramElement child = (IProgramElement)itt.next();
            ISourceLocation childLoc = child.getSourceLocation();
            if (null == childLoc || !childLoc.getSourceFile().equals(file)) continue;
            itt.remove();
        }
        addToNode.addChild(cuNode);
        this.stack.push(cuNode);
        unit.traverse((IAbstractSyntaxTreeVisitor)this, unit.scope);
        try {
            structureModel.addToFileMap(file.getCanonicalPath(), cuNode);
        }
        catch (IOException e) {
            System.err.println("IOException " + e.getMessage() + " creating path for " + file);
        }
    }

    private IProgramElement genAddToNode(CompilationUnitDeclaration unit, IHierarchy structureModel) {
        IProgramElement addToNode;
        ImportReference currentPackage = unit.currentPackage;
        if (null == currentPackage) {
            addToNode = structureModel.getRoot();
        } else {
            StringBuffer nameBuffer = new StringBuffer();
            char[][] importName = currentPackage.getImportName();
            int last = importName.length - 1;
            int i = 0;
            while (i < importName.length) {
                nameBuffer.append(new String(importName[i]));
                if (i < last) {
                    nameBuffer.append('.');
                }
                ++i;
            }
            String pkgName = nameBuffer.toString();
            IProgramElement pkgNode = null;
            Iterator it = structureModel.getRoot().getChildren().iterator();
            while (it.hasNext()) {
                IProgramElement currNode = (IProgramElement)it.next();
                if (!pkgName.equals(currNode.getName())) continue;
                pkgNode = currNode;
                break;
            }
            if (pkgNode == null) {
                pkgNode = new ProgramElement(pkgName, IProgramElement.Kind.PACKAGE, new ArrayList());
                structureModel.getRoot().addChild(pkgNode);
            }
            addToNode = pkgNode;
        }
        return addToNode;
    }

    public boolean visit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        String name = new String(typeDeclaration.name);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (typeDeclaration instanceof AspectDeclaration) {
            kind = IProgramElement.Kind.ASPECT;
        } else if (typeDeclaration.isInterface()) {
            kind = IProgramElement.Kind.INTERFACE;
        }
        ProgramElement peNode = new ProgramElement(name, kind, this.makeLocation(typeDeclaration), typeDeclaration.modifiers, "", new ArrayList());
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(TypeDeclaration typeDeclaration, CompilationUnitScope scope) {
        this.stack.pop();
    }

    public boolean visit(MemberTypeDeclaration memberTypeDeclaration, ClassScope scope) {
        String name = new String(memberTypeDeclaration.name);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (memberTypeDeclaration instanceof AspectDeclaration) {
            kind = IProgramElement.Kind.ASPECT;
        } else if (memberTypeDeclaration.isInterface()) {
            kind = IProgramElement.Kind.INTERFACE;
        }
        ProgramElement peNode = new ProgramElement(name, kind, this.makeLocation(memberTypeDeclaration), memberTypeDeclaration.modifiers, "", new ArrayList());
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(MemberTypeDeclaration memberTypeDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(LocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        String name = new String(memberTypeDeclaration.name);
        String fullName = "<undefined>";
        if (memberTypeDeclaration.binding != null && memberTypeDeclaration.binding.constantPoolName() != null) {
            fullName = new String(memberTypeDeclaration.binding.constantPoolName());
        }
        int dollar = fullName.indexOf(36);
        fullName = fullName.substring(dollar + 1);
        IProgramElement.Kind kind = IProgramElement.Kind.CLASS;
        if (memberTypeDeclaration.isInterface()) {
            kind = IProgramElement.Kind.INTERFACE;
        }
        ProgramElement peNode = new ProgramElement(fullName, kind, this.makeLocation(memberTypeDeclaration), memberTypeDeclaration.modifiers, "", new ArrayList());
        this.findEnclosingClass(this.stack).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(LocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        this.stack.pop();
    }

    public boolean visit(AnonymousLocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        return this.visit((LocalTypeDeclaration)memberTypeDeclaration, scope);
    }

    public void endVisit(AnonymousLocalTypeDeclaration memberTypeDeclaration, BlockScope scope) {
        this.stack.pop();
    }

    private IProgramElement findEnclosingClass(Stack stack) {
        int i = stack.size() - 1;
        while (i >= 0) {
            IProgramElement pe = (IProgramElement)stack.get(i);
            if (pe.getKind() == IProgramElement.Kind.CLASS) {
                return pe;
            }
            --i;
        }
        return (IProgramElement)stack.peek();
    }

    public boolean visit(MethodDeclaration methodDeclaration, ClassScope scope) {
        ProgramElement peNode = new ProgramElement("", IProgramElement.Kind.ERROR, this.makeLocation(methodDeclaration), methodDeclaration.modifiers, "", new ArrayList());
        this.formatter.genLabelAndKind(methodDeclaration, peNode);
        this.genBytecodeInfo(methodDeclaration, peNode);
        peNode.setModifiers(methodDeclaration.modifiers);
        if (peNode.getKind().equals(IProgramElement.Kind.METHOD) && peNode.toLabelString().equals("main(String[])") && peNode.getModifiers().contains(IProgramElement.Modifiers.STATIC) && peNode.getAccessibility().equals(IProgramElement.Accessibility.PUBLIC)) {
            ((IProgramElement)this.stack.peek()).setRunnable(true);
        }
        this.stack.push(peNode);
        return true;
    }

    private void genBytecodeInfo(MethodDeclaration methodDeclaration, IProgramElement peNode) {
        if (methodDeclaration.binding != null) {
            String memberName = "";
            String memberBytecodeSignature = "";
            try {
                ResolvedMember member = EclipseFactory.makeResolvedMember(methodDeclaration.binding);
                memberName = member.getName();
                memberBytecodeSignature = member.getSignature();
            }
            catch (NullPointerException npe) {
                memberName = "<undefined>";
            }
            peNode.setBytecodeName(memberName);
            peNode.setBytecodeSignature(memberBytecodeSignature);
        }
        ((IProgramElement)this.stack.peek()).addChild(peNode);
    }

    public void endVisit(MethodDeclaration methodDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(ImportReference importRef, CompilationUnitScope scope) {
        int dotIndex = importRef.toString().lastIndexOf(46);
        String currPackageImport = "";
        if (dotIndex != -1) {
            currPackageImport = importRef.toString().substring(0, dotIndex);
        }
        if (!((ProgramElement)this.stack.peek()).getPackageName().equals(currPackageImport)) {
            ProgramElement peNode = new ProgramElement(new String(importRef.toString()), IProgramElement.Kind.IMPORT_REFERENCE, this.makeLocation(importRef), 0, "", new ArrayList());
            ProgramElement imports = (ProgramElement)((ProgramElement)this.stack.peek()).getChildren().get(0);
            imports.addChild(0, peNode);
            this.stack.push(peNode);
        }
        return true;
    }

    public void endVisit(ImportReference importRef, CompilationUnitScope scope) {
        int dotIndex = importRef.toString().lastIndexOf(46);
        String currPackageImport = "";
        if (dotIndex != -1) {
            currPackageImport = importRef.toString().substring(0, dotIndex);
        }
        if (!((ProgramElement)this.stack.peek()).getPackageName().equals(currPackageImport)) {
            this.stack.pop();
        }
    }

    public boolean visit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        ProgramElement peNode = new ProgramElement(new String(fieldDeclaration.name), IProgramElement.Kind.FIELD, this.makeLocation(fieldDeclaration), fieldDeclaration.modifiers, "", new ArrayList());
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(FieldDeclaration fieldDeclaration, MethodScope scope) {
        this.stack.pop();
    }

    public boolean visit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        if (constructorDeclaration.isDefaultConstructor) {
            this.stack.push(null);
            return true;
        }
        ProgramElement peNode = new ProgramElement(new String(constructorDeclaration.selector), IProgramElement.Kind.CONSTRUCTOR, this.makeLocation(constructorDeclaration), constructorDeclaration.modifiers, "", new ArrayList());
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        return true;
    }

    public void endVisit(ConstructorDeclaration constructorDeclaration, ClassScope scope) {
        this.stack.pop();
    }

    public boolean visit(Initializer initializer, MethodScope scope) {
        if (initializer == this.inInitializer) {
            return false;
        }
        this.inInitializer = initializer;
        ProgramElement peNode = new ProgramElement("...", IProgramElement.Kind.INITIALIZER, this.makeLocation(initializer), initializer.modifiers, "", new ArrayList());
        ((IProgramElement)this.stack.peek()).addChild(peNode);
        this.stack.push(peNode);
        initializer.block.traverse(this, scope);
        this.stack.pop();
        return false;
    }

    private ISourceLocation makeLocation(AstNode node) {
        String fileName = "";
        if (this.currCompilationResult.getFileName() != null) {
            fileName = new String(this.currCompilationResult.getFileName());
        }
        int startLine = this.getStartLine(node);
        int endLine = this.getEndLine(node);
        SourceLocation loc = null;
        loc = startLine <= endLine ? new SourceLocation(new File(fileName), startLine, endLine) : new SourceLocation(new File(fileName), startLine);
        return loc;
    }

    private int getStartLine(AstNode n) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, n.sourceStart);
    }

    private int getEndLine(AstNode n) {
        if (n instanceof AbstractVariableDeclaration) {
            return this.getEndLine((AbstractVariableDeclaration)n);
        }
        if (n instanceof AbstractMethodDeclaration) {
            return this.getEndLine((AbstractMethodDeclaration)n);
        }
        if (n instanceof TypeDeclaration) {
            return this.getEndLine((TypeDeclaration)n);
        }
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, n.sourceEnd);
    }

    private int getStartLine(AbstractVariableDeclaration avd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, avd.declarationSourceStart);
    }

    private int getEndLine(AbstractVariableDeclaration avd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, avd.declarationSourceEnd);
    }

    private int getStartLine(AbstractMethodDeclaration amd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, amd.declarationSourceStart);
    }

    private int getEndLine(AbstractMethodDeclaration amd) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, amd.declarationSourceEnd);
    }

    private int getStartLine(TypeDeclaration td) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, td.declarationSourceStart);
    }

    private int getEndLine(TypeDeclaration td) {
        return ProblemHandler.searchLineNumber(this.currCompilationResult.lineSeparatorPositions, td.declarationSourceEnd);
    }
}

