/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ProceedVisitor
extends AbstractSyntaxTreeVisitorAdapter {
    boolean needsDynamic = false;
    boolean needsStatic = false;
    boolean needsStaticEnclosing = false;
    boolean hasEffectivelyStaticRef = false;
    LocalVariableBinding thisJoinPointDec;
    LocalVariableBinding thisJoinPointStaticPartDec;
    LocalVariableBinding thisEnclosingJoinPointStaticPartDec;
    LocalVariableBinding thisJoinPointDecLocal;
    LocalVariableBinding thisJoinPointStaticPartDecLocal;
    LocalVariableBinding thisEnclosingJoinPointStaticPartDecLocal;
    boolean replaceEffectivelyStaticRefs = false;
    AbstractMethodDeclaration method;
    boolean inBlockThatCantRun = false;

    ProceedVisitor(AbstractMethodDeclaration method) {
        this.method = method;
        int index = method.arguments.length - 3;
        this.thisJoinPointStaticPartDecLocal = method.scope.locals[index];
        this.thisJoinPointStaticPartDec = method.arguments[index++].binding;
        this.thisJoinPointDecLocal = method.scope.locals[index];
        this.thisJoinPointDec = method.arguments[index++].binding;
        this.thisEnclosingJoinPointStaticPartDecLocal = method.scope.locals[index];
        this.thisEnclosingJoinPointStaticPartDec = method.arguments[index++].binding;
    }

    public void computeJoinPointParams() {
        this.method.traverse((IAbstractSyntaxTreeVisitor)this, (ClassScope)null);
        if (this.hasEffectivelyStaticRef && !this.needsDynamic) {
            this.replaceEffectivelyStaticRefs = true;
            this.needsStatic = true;
            this.method.traverse((IAbstractSyntaxTreeVisitor)this, (ClassScope)null);
        }
    }

    boolean isRef(NameReference ref, Binding binding) {
        return ref.binding == binding;
    }

    boolean isRef(Expression expr, Binding binding) {
        return expr != null && expr instanceof NameReference && this.isRef((NameReference)expr, binding);
    }

    public void endVisit(SingleNameReference ref, BlockScope scope) {
        if (this.isRef(ref, (Binding)this.thisJoinPointDec)) {
            this.needsDynamic = true;
        } else if (this.isRef(ref, (Binding)this.thisJoinPointStaticPartDec)) {
            this.needsStatic = true;
        } else if (this.isRef(ref, (Binding)this.thisEnclosingJoinPointStaticPartDec)) {
            this.needsStaticEnclosing = true;
        }
    }

    boolean canTreatAsStatic(String id) {
        return id.equals("toString") || id.equals("toShortString") || id.equals("toLongString") || id.equals("getKind") || id.equals("getSignature") || id.equals("getSourceLocation") || id.equals("getStaticPart");
    }

    public boolean visit(MessageSend call, BlockScope scope) {
        Expression receiver = call.receiver;
        if (this.isRef(receiver, (Binding)this.thisJoinPointDec) && this.canTreatAsStatic(new String(call.selector))) {
            if (this.replaceEffectivelyStaticRefs) {
                this.replaceEffectivelyStaticRef(call);
            } else {
                this.hasEffectivelyStaticRef = true;
                if (call.arguments != null) {
                    int argumentsLength = call.arguments.length;
                    int i = 0;
                    while (i < argumentsLength) {
                        call.arguments[i].traverse(this, scope);
                        ++i;
                    }
                }
                return false;
            }
        }
        return super.visit(call, scope);
    }

    private void replaceEffectivelyStaticRef(MessageSend call) {
        NameReference receiver = (NameReference)call.receiver;
        receiver.binding = this.thisJoinPointStaticPartDecLocal;
        receiver.codegenBinding = this.thisJoinPointStaticPartDecLocal;
        call.binding.declaringClass = (ReferenceBinding)this.thisJoinPointStaticPartDec.type;
    }

    public int removeUnusedExtraArguments() {
        int extraArgumentFlags = 0;
        this.computeJoinPointParams();
        MethodBinding binding = this.method.binding;
        int index = binding.parameters.length - 3;
        if (this.needsStaticEnclosing) {
            extraArgumentFlags |= 8;
        } else {
            this.removeParameter(index + 2);
        }
        if (this.needsDynamic) {
            extraArgumentFlags |= 2;
        } else {
            this.removeParameter(index + 1);
        }
        if (this.needsStatic) {
            extraArgumentFlags |= 4;
        } else {
            this.removeParameter(index + 0);
        }
        return extraArgumentFlags;
    }

    private void removeParameter(int indexToRemove) {
        TypeBinding[] parameters = this.method.binding.parameters;
        this.method.scope.locals = ProceedVisitor.removeLocalBinding(indexToRemove, this.method.scope.locals);
        this.method.binding.parameters = ProceedVisitor.removeParameter(indexToRemove, this.method.binding.parameters);
    }

    private static TypeBinding[] removeParameter(int index, TypeBinding[] bindings) {
        int len = bindings.length;
        TypeBinding[] ret = new TypeBinding[len - 1];
        System.arraycopy(bindings, 0, ret, 0, index);
        System.arraycopy(bindings, index + 1, ret, index, len - index - 1);
        return ret;
    }

    private static LocalVariableBinding[] removeLocalBinding(int index, LocalVariableBinding[] bindings) {
        int len = bindings.length;
        LocalVariableBinding[] ret = new LocalVariableBinding[len - 1];
        System.arraycopy(bindings, 0, ret, 0, index);
        System.arraycopy(bindings, index + 1, ret, index, len - index - 1);
        return ret;
    }
}

