/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import java.lang.reflect.Modifier;
import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.PointcutDesignator;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.core.builder.EclipseSourceContext;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.patterns.Pointcut;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class PointcutDeclaration
extends MethodDeclaration {
    public static final char[] mangledPrefix = "ajc$pointcut$".toCharArray();
    public PointcutDesignator pointcutDesignator;
    private int declaredModifiers;
    private String declaredName;
    private ResolvedPointcutDefinition resolvedPointcutDeclaration = null;

    public PointcutDeclaration(CompilationResult compilationResult) {
        super(compilationResult);
        this.returnType = TypeReference.baseTypeReference(6, 0);
    }

    private Pointcut getPointcut() {
        if (this.pointcutDesignator == null) {
            return Pointcut.makeMatchesNothing(Pointcut.RESOLVED);
        }
        return this.pointcutDesignator.getPointcut();
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
    }

    public void postParse(TypeDeclaration typeDec) {
        if (this.arguments == null) {
            this.arguments = new Argument[0];
        }
        this.declaredModifiers = this.modifiers;
        this.declaredName = new String(this.selector);
        this.selector = CharOperation.concat(mangledPrefix, '$', this.selector, '$', Integer.toHexString(this.sourceStart).toCharArray());
        if (Modifier.isAbstract(this.declaredModifiers) && !(typeDec instanceof AspectDeclaration)) {
            typeDec.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "The abstract pointcut " + new String(this.declaredName) + " can only be defined in an aspect");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.pointcutDesignator != null) {
            this.pointcutDesignator.postParse(typeDec, this);
        }
    }

    public void resolve(ClassScope upperScope) {
    }

    public void resolvePointcut(ClassScope upperScope) {
        super.resolve(upperScope);
    }

    public void resolveStatements() {
        if (this.isAbstract()) {
            this.modifiers |= 0x1000000;
        }
        if (this.binding == null || this.ignoreFurtherInvestigation) {
            return;
        }
        if (Modifier.isAbstract(this.declaredModifiers) && this.pointcutDesignator != null) {
            this.scope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "abstract pointcut can't have body");
            this.ignoreFurtherInvestigation = true;
            return;
        }
        if (this.pointcutDesignator != null) {
            this.pointcutDesignator.finishResolveTypes(this, this.binding, this.arguments.length, this.scope.enclosingSourceType());
        }
        this.makeResolvedPointcutDefinition();
        this.resolvedPointcutDeclaration.setPointcut(this.getPointcut());
        super.resolveStatements();
    }

    public ResolvedPointcutDefinition makeResolvedPointcutDefinition() {
        if (this.resolvedPointcutDeclaration != null) {
            return this.resolvedPointcutDeclaration;
        }
        this.resolvedPointcutDeclaration = new ResolvedPointcutDefinition(EclipseFactory.fromBinding(this.binding.declaringClass), this.declaredModifiers, this.declaredName, EclipseFactory.fromBindings(this.binding.parameters), this.getPointcut());
        this.resolvedPointcutDeclaration.setPosition(this.sourceStart, this.sourceEnd);
        this.resolvedPointcutDeclaration.setSourceContext(new EclipseSourceContext(this.compilationResult));
        return this.resolvedPointcutDeclaration;
    }

    public AjAttribute makeAttribute() {
        return new AjAttribute.PointcutDeclarationAttribute(this.makeResolvedPointcutDefinition());
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute()));
    }

    public String toString(int tab) {
        StringBuffer buf = new StringBuffer();
        buf.append(AstNode.tabString(tab));
        if (this.modifiers != 0) {
            buf.append(AstNode.modifiersString(this.modifiers));
        }
        buf.append("pointcut ");
        buf.append(new String(this.selector));
        buf.append("(");
        if (this.arguments != null) {
            int i = 0;
            while (i < this.arguments.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(this.arguments[i].toString(0));
                ++i;
            }
        }
        buf.append("): ");
        buf.append(this.getPointcut());
        buf.append(";");
        return buf.toString();
    }
}

