/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.EclipseAttributeAdapter;
import org.aspectj.ajdt.internal.compiler.ast.InterTypeDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.KnownMessageSend;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseTypeMunger;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeScope;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.NewConstructorTypeMunger;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ArrayAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.AstNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ExplicitConstructorCall;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.ast.ReturnStatement;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.parser.Parser;

public class InterTypeConstructorDeclaration
extends InterTypeDeclaration {
    private MethodDeclaration preMethod;
    private ExplicitConstructorCall explicitConstructorCall = null;

    public InterTypeConstructorDeclaration(CompilationResult result, TypeReference onType) {
        super(result, onType);
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        parser.parseAsConstructor(this, unit);
    }

    public void resolve(ClassScope upperScope) {
        if (this.munger == null || this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        this.explicitConstructorCall = null;
        if (this.statements != null && this.statements.length > 0 && this.statements[0] instanceof ExplicitConstructorCall) {
            this.explicitConstructorCall = (ExplicitConstructorCall)this.statements[0];
            this.statements = AstUtil.remove(0, this.statements);
        }
        this.preMethod = this.makePreMethod(upperScope, this.explicitConstructorCall);
        this.binding.parameters = AstUtil.insert(this.onTypeBinding, this.binding.parameters);
        this.arguments = AstUtil.insert(AstUtil.makeFinalArgument("ajc$this_".toCharArray(), this.onTypeBinding), this.arguments);
        super.resolve(upperScope);
    }

    private MethodDeclaration makePreMethod(ClassScope scope, ExplicitConstructorCall explicitConstructorCall) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(scope);
        TypeX aspectTypeX = EclipseFactory.fromBinding(this.binding.declaringClass);
        TypeX targetTypeX = EclipseFactory.fromBinding(this.onTypeBinding);
        ArrayBinding objectArrayBinding = scope.createArray(scope.getJavaLangObject(), 1);
        MethodDeclaration pre = new MethodDeclaration(this.compilationResult);
        pre.modifiers = 9;
        pre.returnType = AstUtil.makeTypeReference(objectArrayBinding);
        pre.selector = NameMangler.postIntroducedConstructor(aspectTypeX, targetTypeX).toCharArray();
        pre.arguments = AstUtil.copyArguments(this.arguments);
        pre.scope = new MethodScope(scope, pre, true);
        pre.binding = world.makeMethodBinding(AjcMemberMaker.preIntroducedConstructor(aspectTypeX, targetTypeX, EclipseFactory.fromBindings(this.binding.parameters)));
        pre.bindArguments();
        pre.bindThrownExceptions();
        pre.statements = explicitConstructorCall == null ? new Statement[0] : new Statement[]{explicitConstructorCall};
        InterTypeScope newParent = new InterTypeScope((Scope)scope, this.onTypeBinding);
        pre.scope.parent = newParent;
        pre.resolveStatements();
        int nParams = pre.arguments.length;
        MethodBinding explicitConstructor = null;
        if (explicitConstructorCall != null && (explicitConstructor = explicitConstructorCall.binding).alwaysNeedsAccessMethod()) {
            explicitConstructor = explicitConstructor.getAccessMethod(true);
        }
        int nExprs = explicitConstructor == null ? 0 : explicitConstructor.parameters.length;
        ArrayInitializer init = new ArrayInitializer();
        init.expressions = new Expression[nExprs + nParams];
        int index = 0;
        int i = 0;
        while (i < nExprs) {
            if (i >= explicitConstructorCall.arguments.length) {
                init.expressions[index++] = new NullLiteral(0, 0);
            } else {
                Expression arg = explicitConstructorCall.arguments[i];
                ResolvedMember conversionMethod = AjcMemberMaker.toObjectConversionMethod(EclipseFactory.fromBinding(explicitConstructorCall.binding.parameters[i]));
                if (conversionMethod != null) {
                    arg = new KnownMessageSend(world.makeMethodBindingForCall(conversionMethod), new CastExpression(new NullLiteral(0, 0), AstUtil.makeTypeReference(world.makeTypeBinding(AjcMemberMaker.CONVERSIONS_TYPE))), new Expression[]{arg});
                }
                init.expressions[index++] = arg;
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < nParams) {
            LocalVariableBinding binding = pre.arguments[i2].binding;
            Expression arg = AstUtil.makeResolvedLocalVariableReference(binding);
            ResolvedMember conversionMethod = AjcMemberMaker.toObjectConversionMethod(EclipseFactory.fromBinding(binding.type));
            if (conversionMethod != null) {
                arg = new KnownMessageSend(world.makeMethodBindingForCall(conversionMethod), new CastExpression(new NullLiteral(0, 0), AstUtil.makeTypeReference(world.makeTypeBinding(AjcMemberMaker.CONVERSIONS_TYPE))), new Expression[]{arg});
            }
            init.expressions[index++] = arg;
            ++i2;
        }
        init.binding = objectArrayBinding;
        ArrayAllocationExpression newArray = new ArrayAllocationExpression();
        newArray.initializer = init;
        newArray.type = AstUtil.makeTypeReference(scope.getJavaLangObject());
        newArray.dimensions = new Expression[1];
        newArray.constant = AstNode.NotAConstant;
        pre.statements = new Statement[]{new ReturnStatement(newArray, 0, 0)};
        return pre;
    }

    public EclipseTypeMunger build(ClassScope classScope) {
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        this.binding = classScope.referenceContext.binding.resolveTypesFor(this.binding);
        this.resolveOnType(classScope);
        if (this.ignoreFurtherInvestigation) {
            return null;
        }
        if (this.onTypeBinding.isInterface()) {
            this.ignoreFurtherInvestigation = true;
            return null;
        }
        if (this.onTypeBinding.isNestedType()) {
            classScope.problemReporter().signalError(this.sourceStart, this.sourceEnd, "can't define constructors on nested types (compiler limitation)");
            this.ignoreFurtherInvestigation = true;
            return null;
        }
        ResolvedTypeX declaringTypeX = world.fromEclipse(this.onTypeBinding);
        ResolvedTypeX aspectType = world.fromEclipse(classScope.referenceContext.binding);
        ResolvedMember bindingAsMember = EclipseFactory.makeResolvedMember(this.binding);
        ResolvedMember signature = new ResolvedMember(Member.CONSTRUCTOR, declaringTypeX, this.declaredModifiers, ResolvedTypeX.VOID, "<init>", bindingAsMember.getParameterTypes(), world.fromEclipse(this.binding.thrownExceptions));
        ResolvedMember syntheticInterMember = AjcMemberMaker.interConstructor(declaringTypeX, signature, aspectType);
        NewConstructorTypeMunger myMunger = new NewConstructorTypeMunger(signature, syntheticInterMember, null, null);
        this.setMunger(myMunger);
        myMunger.check(world.getWorld());
        this.binding.selector = NameMangler.postIntroducedConstructor(EclipseFactory.fromBinding(this.binding.declaringClass), declaringTypeX).toCharArray();
        this.selector = this.binding.selector;
        return new EclipseTypeMunger(world, myMunger, aspectType, this);
    }

    private AjAttribute makeAttribute(EclipseFactory world) {
        if (this.explicitConstructorCall != null && !(this.explicitConstructorCall.binding instanceof ProblemMethodBinding)) {
            MethodBinding explicitConstructor = this.explicitConstructorCall.binding;
            if (explicitConstructor.alwaysNeedsAccessMethod()) {
                explicitConstructor = explicitConstructor.getAccessMethod(true);
            }
            ((NewConstructorTypeMunger)this.munger).setExplicitConstructor(EclipseFactory.makeResolvedMember(explicitConstructor));
        } else {
            ((NewConstructorTypeMunger)this.munger).setExplicitConstructor(new ResolvedMember(Member.CONSTRUCTOR, EclipseFactory.fromBinding(this.onTypeBinding.superclass()), 0, ResolvedTypeX.VOID, "<init>", TypeX.NONE));
        }
        return new AjAttribute.TypeMunger(this.munger);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        EclipseFactory world = EclipseFactory.fromScopeLookupEnvironment(classScope);
        classFile.extraAttributes.add(new EclipseAttributeAdapter(this.makeAttribute(world)));
        super.generateCode(classScope, classFile);
        this.preMethod.generateCode(classScope, classFile);
    }

    protected Shadow.Kind getShadowKindForBody() {
        return Shadow.ConstructorExecution;
    }
}

