/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.compiler.ast;

import org.aspectj.ajdt.internal.compiler.ast.AspectDeclaration;
import org.aspectj.ajdt.internal.compiler.ast.AstUtil;
import org.aspectj.ajdt.internal.compiler.ast.Proceed;
import org.aspectj.ajdt.internal.compiler.lookup.EclipseFactory;
import org.aspectj.ajdt.internal.compiler.lookup.InlineAccessFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.InterTypeMethodBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedFieldBinding;
import org.aspectj.ajdt.internal.compiler.lookup.PrivilegedHandler;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ResolvedMember;
import org.eclipse.jdt.internal.compiler.AbstractSyntaxTreeVisitorAdapter;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.AssertStatement;
import org.eclipse.jdt.internal.compiler.ast.ClassLiteralAccess;
import org.eclipse.jdt.internal.compiler.ast.FieldReference;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class AccessForInlineVisitor
extends AbstractSyntaxTreeVisitorAdapter {
    PrivilegedHandler handler;
    AspectDeclaration inAspect;
    EclipseFactory world;
    public boolean isInlinable = true;

    public AccessForInlineVisitor(AspectDeclaration inAspect, PrivilegedHandler handler) {
        this.inAspect = inAspect;
        this.world = inAspect.factory;
        this.handler = handler;
    }

    public void endVisit(SingleNameReference ref, BlockScope scope) {
        if (ref.binding instanceof FieldBinding) {
            ref.binding = this.getAccessibleField((FieldBinding)ref.binding);
        }
    }

    public void endVisit(QualifiedNameReference ref, BlockScope scope) {
        if (ref.binding instanceof FieldBinding) {
            ref.binding = this.getAccessibleField((FieldBinding)ref.binding);
        }
        if (ref.otherBindings != null) {
            int i = 0;
            int len = ref.otherBindings.length;
            while (i < len) {
                if (ref.otherBindings[i] instanceof FieldBinding) {
                    ref.otherBindings[i] = this.getAccessibleField(ref.otherBindings[i]);
                }
                ++i;
            }
        }
    }

    public void endVisit(FieldReference ref, BlockScope scope) {
        if (ref.binding instanceof FieldBinding) {
            ref.binding = this.getAccessibleField(ref.binding);
        }
    }

    public void endVisit(MessageSend send, BlockScope scope) {
        if (send instanceof Proceed) {
            return;
        }
        if (send.binding == null || !send.binding.isValidBinding()) {
            return;
        }
        if (send.isSuperAccess() && !send.binding.isStatic()) {
            send.receiver = new ThisReference(send.sourceStart, send.sourceEnd);
            send.binding = send.codegenBinding = this.getSuperAccessMethod(send.binding);
        } else if (!this.isPublic(send.binding)) {
            send.syntheticAccessor = this.getAccessibleMethod(send.binding);
        }
    }

    public void endVisit(AllocationExpression send, BlockScope scope) {
        if (send.binding == null || !send.binding.isValidBinding()) {
            return;
        }
        if (this.isPublic(send.binding)) {
            return;
        }
        this.makePublic(send.binding.declaringClass);
        send.binding = this.handler.getPrivilegedAccessMethod(send.binding, send);
    }

    public void endVisit(QualifiedTypeReference ref, BlockScope scope) {
        this.makePublic(ref.resolvedType);
    }

    public void endVisit(SingleTypeReference ref, BlockScope scope) {
        this.makePublic(ref.resolvedType);
    }

    private FieldBinding getAccessibleField(FieldBinding binding) {
        ResolvedMember m;
        if (!binding.isValidBinding()) {
            return binding;
        }
        this.makePublic(binding.declaringClass);
        if (this.isPublic(binding)) {
            return binding;
        }
        if (binding instanceof PrivilegedFieldBinding) {
            return binding;
        }
        if (binding instanceof InterTypeFieldBinding) {
            return binding;
        }
        if (binding.isPrivate() && binding.declaringClass != this.inAspect.binding) {
            binding.modifiers = AstUtil.makePackageVisible(binding.modifiers);
        }
        if (this.inAspect.accessForInline.containsKey(m = EclipseFactory.makeResolvedMember(binding))) {
            return (FieldBinding)this.inAspect.accessForInline.get(m);
        }
        InlineAccessFieldBinding ret = new InlineAccessFieldBinding(this.inAspect, binding);
        this.inAspect.accessForInline.put(m, ret);
        return ret;
    }

    private MethodBinding getAccessibleMethod(MethodBinding binding) {
        ResolvedMember m;
        if (!binding.isValidBinding()) {
            return binding;
        }
        this.makePublic(binding.declaringClass);
        if (this.isPublic(binding)) {
            return binding;
        }
        if (binding instanceof InterTypeMethodBinding) {
            return binding;
        }
        if (binding.isPrivate() && binding.declaringClass != this.inAspect.binding) {
            binding.modifiers = AstUtil.makePackageVisible(binding.modifiers);
        }
        if (this.inAspect.accessForInline.containsKey(m = EclipseFactory.makeResolvedMember(binding))) {
            return (MethodBinding)this.inAspect.accessForInline.get(m);
        }
        MethodBinding ret = this.world.makeMethodBinding(AjcMemberMaker.inlineAccessMethodForMethod(this.inAspect.typeX, m));
        this.inAspect.accessForInline.put(m, ret);
        return ret;
    }

    private MethodBinding getSuperAccessMethod(MethodBinding binding) {
        ResolvedMember m = EclipseFactory.makeResolvedMember(binding);
        if (this.inAspect.superAccessForInline.containsKey(m)) {
            return (MethodBinding)this.inAspect.superAccessForInline.get(m);
        }
        MethodBinding ret = this.world.makeMethodBinding(AjcMemberMaker.superAccessMethod(this.inAspect.typeX, m));
        this.inAspect.superAccessForInline.put(m, ret);
        return ret;
    }

    private boolean isPublic(FieldBinding fieldBinding) {
        if (fieldBinding instanceof InterTypeFieldBinding) {
            return true;
        }
        return fieldBinding.isPublic();
    }

    private boolean isPublic(MethodBinding methodBinding) {
        if (methodBinding instanceof InterTypeMethodBinding) {
            return true;
        }
        return methodBinding.isPublic();
    }

    private void makePublic(TypeBinding binding) {
        if (binding == null || !binding.isValidBinding()) {
            return;
        }
        if (binding instanceof ReferenceBinding) {
            ReferenceBinding rb = (ReferenceBinding)binding;
            if (!rb.isPublic()) {
                this.handler.notePrivilegedTypeAccess(rb, null);
            }
        } else if (binding instanceof ArrayBinding) {
            this.makePublic(((ArrayBinding)binding).leafComponentType);
        } else {
            return;
        }
    }

    public void endVisit(AssertStatement assertStatement, BlockScope scope) {
        this.isInlinable = false;
    }

    public void endVisit(ClassLiteralAccess classLiteral, BlockScope scope) {
        this.isInlinable = false;
    }
}

