/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.ajde.Ajde;
import org.aspectj.asm.AsmManager;
import org.aspectj.asm.IHierarchy;
import org.aspectj.asm.IProgramElement;

public class StructureModelUtil {
    public static Map getLinesToAspectMap(String sourceFilePath) {
        HashMap annotationsMap = AsmManager.getDefault().getInlineAnnotations(sourceFilePath, true, true);
        HashMap aspectMap = new HashMap();
        Set keys = annotationsMap.keySet();
        return aspectMap;
    }

    public static Set getAspectsAffectingPackage(IProgramElement packageNode) {
        List files = StructureModelUtil.getFilesInPackage(packageNode);
        HashSet aspects = new HashSet();
        Iterator it = files.iterator();
        while (it.hasNext()) {
            IProgramElement fileNode = (IProgramElement)it.next();
            Map adviceMap = StructureModelUtil.getLinesToAspectMap(fileNode.getSourceLocation().getSourceFile().getAbsolutePath());
            Collection values = adviceMap.values();
            Iterator it2 = values.iterator();
            while (it2.hasNext()) {
                aspects.add(it2.next());
            }
        }
        return aspects;
    }

    public static List getPackagesInModel() {
        ArrayList packages = new ArrayList();
        IHierarchy model = Ajde.getDefault().getStructureModelManager().getHierarchy();
        if (model.equals(IHierarchy.NO_STRUCTURE)) {
            return null;
        }
        return StructureModelUtil.getPackagesHelper(model.getRoot(), IProgramElement.Kind.PACKAGE, null, packages);
    }

    private static List getPackagesHelper(IProgramElement node, IProgramElement.Kind kind, String prename, List matches) {
        if (kind == null || node.getKind().equals(kind)) {
            prename = prename == null ? new String(node.toString()) : new String(prename + "." + node);
            Object[] o = new Object[]{node, prename};
            matches.add(o);
        }
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            IProgramElement nextNode = (IProgramElement)it.next();
            if (!(nextNode instanceof IProgramElement)) continue;
            StructureModelUtil.getPackagesHelper(nextNode, kind, prename, matches);
        }
        return matches;
    }

    private List sortElements(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortingComparator comparator = new SortingComparator();
        Arrays.sort(temp, comparator);
        List<Object> newResources = Arrays.asList(temp);
        return newResources;
    }

    private static List sortArray(List oldElements) {
        Object[] temp = oldElements.toArray();
        SortArrayComparator comparator = new SortArrayComparator();
        Arrays.sort(temp, comparator);
        List<Object> newElements = Arrays.asList(temp);
        return newElements;
    }

    public static List getFilesInPackage(IProgramElement packageNode) {
        if (packageNode == null) {
            return null;
        }
        List packageContents = packageNode.getChildren();
        ArrayList<IProgramElement> files = new ArrayList<IProgramElement>();
        Iterator it = packageContents.iterator();
        while (it.hasNext()) {
            IProgramElement packageItem = (IProgramElement)it.next();
            if (packageItem.getKind() != IProgramElement.Kind.FILE_JAVA && packageItem.getKind() != IProgramElement.Kind.FILE_ASPECTJ) continue;
            files.add(packageItem);
        }
        return files;
    }

    private static class SortArrayComparator
    implements Comparator {
        private SortArrayComparator() {
        }

        public int compare(Object o1, Object o2) {
            Object[] array1 = (Object[])o1;
            Object[] array2 = (Object[])o2;
            IProgramElement p1 = (IProgramElement)array1[1];
            IProgramElement p2 = (IProgramElement)array2[1];
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }

    private class SortingComparator
    implements Comparator {
        private SortingComparator() {
        }

        public int compare(Object o1, Object o2) {
            IProgramElement p1 = (IProgramElement)o1;
            IProgramElement p2 = (IProgramElement)o2;
            String name1 = p1.getName();
            String name2 = p2.getName();
            return name1.compareTo(name2);
        }
    }
}

