/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajde.internal;

import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.aspectj.ajde.Ajde;
import org.aspectj.ajde.BuildListener;
import org.aspectj.ajde.BuildManager;
import org.aspectj.ajde.BuildOptionsAdapter;
import org.aspectj.ajde.BuildProgressMonitor;
import org.aspectj.ajde.ProjectPropertiesAdapter;
import org.aspectj.ajde.TaskListManager;
import org.aspectj.ajde.internal.CompilerAdapter;
import org.aspectj.util.ConfigParser;

public class AspectJBuildManager
implements BuildManager {
    private CompilerAdapter compilerAdapter = null;
    private TaskListManager compilerMessages = null;
    private BuildProgressMonitor progressMonitor = null;
    private BuildOptionsAdapter buildOptions = null;
    private ArrayList compilerListeners = new ArrayList();
    private String configFile = "";
    private String lastConfigFile = null;
    private int lastCompileTime = 50;
    private boolean buildStructureOnly = false;
    private boolean buildModelMode = true;

    public AspectJBuildManager(TaskListManager compilerMessages, BuildProgressMonitor progressMonitor, BuildOptionsAdapter buildOptions) {
        this.compilerMessages = compilerMessages;
        this.progressMonitor = progressMonitor;
        this.buildOptions = buildOptions;
        this.compilerAdapter = new CompilerAdapter();
    }

    public void buildFresh() {
        this.dobuild(true);
    }

    public void buildStructure() {
        this.dobuild(true);
    }

    public void build() {
        this.dobuild(false);
    }

    protected void dobuild(boolean fresh) {
        this.dobuild(Ajde.getDefault().getConfigurationManager().getActiveConfigFile(), fresh);
    }

    public void buildFresh(String configFile) {
        this.dobuild(configFile, true);
    }

    public void build(String configFile) {
        this.dobuild(configFile, false);
    }

    protected void dobuild(String configFile, boolean fresh) {
        if (configFile == null) {
            Ajde.getDefault().getErrorHandler().handleWarning("Please select a build configuration file.");
        } else {
            this.lastConfigFile = this.configFile;
            this.configFile = configFile;
            if (!fresh && !configFile.equals(this.lastConfigFile)) {
                fresh = true;
            }
            if (fresh) {
                this.compilerAdapter.nextBuildFresh();
            }
            CompilerThread compilerThread = new CompilerThread();
            compilerThread.start();
        }
    }

    public void abortBuild() {
        if (this.compilerAdapter != null) {
            this.compilerAdapter.requestCompileExit();
        }
    }

    public boolean isStructureDirty() {
        if (this.compilerAdapter != null) {
            return this.compilerAdapter.isStructureDirty();
        }
        return false;
    }

    public void setStructureDirty(boolean structureDirty) {
        if (this.compilerAdapter != null) {
            this.compilerAdapter.setStructureDirty(structureDirty);
        }
    }

    public void addListener(BuildListener compilerListener) {
        this.compilerListeners.add(compilerListener);
    }

    public void removeListener(BuildListener compilerListener) {
        ((AbstractCollection)this.compilerListeners).remove(compilerListener);
    }

    private void notifyCompileFinished(String configFile, int buildTime, boolean succeeded, boolean warnings) {
        Ajde.getDefault().logEvent("build finished, succeeded: " + succeeded);
        Iterator it = ((AbstractList)this.compilerListeners).iterator();
        while (it.hasNext()) {
            ((BuildListener)it.next()).compileFinished(configFile, buildTime, succeeded, warnings);
        }
    }

    private void notifyCompileStarted(String configFile) {
        Ajde.getDefault().logEvent("build started: " + configFile);
        Iterator it = ((AbstractList)this.compilerListeners).iterator();
        while (it.hasNext()) {
            ((BuildListener)it.next()).compileStarted(configFile);
        }
    }

    private void notifyCompileAborted(String configFile, String message) {
        Iterator it = ((AbstractList)this.compilerListeners).iterator();
        while (it.hasNext()) {
            ((BuildListener)it.next()).compileAborted(configFile, message);
        }
    }

    public BuildOptionsAdapter getBuildOptions() {
        return this.buildOptions;
    }

    public void setBuildModelMode(boolean b) {
        this.buildModelMode = b;
    }

    public class CompilerThread
    extends Thread {
        public void run() {
            boolean warnings;
            boolean succeeded;
            block5: {
                succeeded = true;
                warnings = false;
                try {
                    try {
                        long timeStart = System.currentTimeMillis();
                        AspectJBuildManager.this.notifyCompileStarted(AspectJBuildManager.this.configFile);
                        AspectJBuildManager.this.progressMonitor.start(AspectJBuildManager.this.configFile);
                        AspectJBuildManager.this.compilerMessages.clearTasks();
                        Ajde.getDefault().logEvent("building with options: " + this.getFormattedOptionsString(AspectJBuildManager.this.buildOptions, Ajde.getDefault().getProjectProperties()));
                        succeeded = AspectJBuildManager.this.compilerAdapter.compile(AspectJBuildManager.this.configFile, AspectJBuildManager.this.progressMonitor, AspectJBuildManager.this.buildModelMode);
                        long timeEnd = System.currentTimeMillis();
                        AspectJBuildManager.this.lastCompileTime = (int)(timeEnd - timeStart);
                    }
                    catch (ConfigParser.ParseException pe) {
                        Ajde.getDefault().getErrorHandler().handleWarning("Config file entry invalid, file: " + pe.getFile().getPath() + ", line number: " + pe.getLine());
                        Object var8_7 = null;
                        warnings = AspectJBuildManager.this.compilerMessages.hasWarning();
                        AspectJBuildManager.this.progressMonitor.finish();
                        break block5;
                    }
                    catch (Throwable e) {
                        Ajde.getDefault().getErrorHandler().handleError("Compile error, caught Throwable: " + e.toString(), e);
                        Object var8_8 = null;
                        warnings = AspectJBuildManager.this.compilerMessages.hasWarning();
                        AspectJBuildManager.this.progressMonitor.finish();
                    }
                    Object var8_6 = null;
                    warnings = AspectJBuildManager.this.compilerMessages.hasWarning();
                    AspectJBuildManager.this.progressMonitor.finish();
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    warnings = AspectJBuildManager.this.compilerMessages.hasWarning();
                    AspectJBuildManager.this.progressMonitor.finish();
                    throw throwable;
                }
            }
            AspectJBuildManager.this.notifyCompileFinished(AspectJBuildManager.this.configFile, AspectJBuildManager.this.lastCompileTime, succeeded, warnings);
        }

        private String getFormattedOptionsString(BuildOptionsAdapter buildOptions, ProjectPropertiesAdapter properties) {
            return "Building with settings: \n-> output path: " + properties.getOutputPath() + "\n-> classpath: " + properties.getClasspath() + "\n-> bootclasspath: " + properties.getBootClasspath() + "\n-> -injars " + this.formatSet(properties.getInJars()) + "\n-> -outjar " + this.formatOptionalString(properties.getOutJar()) + "\n-> -sourceroots " + this.formatSet(properties.getSourceRoots()) + "\n-> -aspectpath " + this.formatSet(properties.getAspectPath()) + "\n-> -" + buildOptions.getComplianceLevel() + "\n-> -source " + buildOptions.getSourceCompatibilityLevel() + "\n-> -g:" + this.formatSet(buildOptions.getDebugLevel()) + "\n-> -warn:" + this.formatSet(buildOptions.getWarnings()) + "\n-> noImportError: " + buildOptions.getNoImportError() + "\n-> preserveAllLocals:" + buildOptions.getPreserveAllLocals() + "\n-> non-standard options: " + buildOptions.getNonStandardOptions() + "\n-> [ignored-deprecated in AspectJ1.1] porting mode: " + buildOptions.getPortingMode() + "\n-> [ignored-deprecated in AspectJ1.1] source 1.4 mode: " + buildOptions.getSourceOnePointFourMode() + "\n-> [ignored-deprecated in AspectJ1.1] strict spec mode: " + buildOptions.getStrictSpecMode() + "\n-> [ignored-deprecated in AspectJ1.1] lenient spec mode: " + buildOptions.getLenientSpecMode() + "\n-> [ignored-deprecated in AspectJ1.1] use javac mode: " + buildOptions.getUseJavacMode() + "\n-> [ignored-deprecated in AspectJ1.1] preprocess mode: " + buildOptions.getPreprocessMode() + "\n-> [ignored-deprecated in AspectJ1.1] working dir: " + buildOptions.getWorkingOutputPath();
        }

        private String formatSet(Set options) {
            if (options == null) {
                return "<default>";
            }
            if (options.isEmpty()) {
                return "none";
            }
            StringBuffer formattedOptions = new StringBuffer();
            Iterator it = options.iterator();
            while (it.hasNext()) {
                String o = it.next().toString();
                if (formattedOptions.length() > 0) {
                    formattedOptions.append(", ");
                }
                formattedOptions.append(o);
            }
            return formattedOptions.toString();
        }

        private String formatOptionalString(String s) {
            if (s == null) {
                return "";
            }
            return s;
        }
    }
}

