/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search;

import java.io.IOException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.internal.core.index.IIndex;
import org.eclipse.jdt.internal.core.search.IIndexSearchRequestor;
import org.eclipse.jdt.internal.core.search.IndexSelector;
import org.eclipse.jdt.internal.core.search.indexing.IndexManager;
import org.eclipse.jdt.internal.core.search.indexing.ReadWriteMonitor;
import org.eclipse.jdt.internal.core.search.matching.SearchPattern;
import org.eclipse.jdt.internal.core.search.processing.IJob;
import org.eclipse.jdt.internal.core.search.processing.JobManager;

public class PatternSearchJob
implements IJob {
    protected SearchPattern pattern;
    protected IJavaSearchScope scope;
    protected IJavaElement focus;
    protected IIndexSearchRequestor requestor;
    protected IndexManager indexManager;
    protected int detailLevel;
    protected IndexSelector indexSelector;
    protected boolean isPolymorphicSearch;
    protected long executionTime = 0L;

    public PatternSearchJob(SearchPattern pattern, IJavaSearchScope scope, int detailLevel, IIndexSearchRequestor requestor, IndexManager indexManager) {
        this(pattern, scope, null, false, detailLevel, requestor, indexManager);
    }

    public PatternSearchJob(SearchPattern pattern, IJavaSearchScope scope, IJavaElement focus, boolean isPolymorphicSearch, int detailLevel, IIndexSearchRequestor requestor, IndexManager indexManager) {
        this.pattern = pattern;
        this.scope = scope;
        this.focus = focus;
        this.isPolymorphicSearch = isPolymorphicSearch;
        this.detailLevel = detailLevel;
        this.requestor = requestor;
        this.indexManager = indexManager;
    }

    public boolean belongsTo(String jobFamily) {
        return true;
    }

    public void cancel() {
    }

    public boolean execute(IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        boolean isComplete = true;
        this.executionTime = 0L;
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(this.scope, this.focus, this.isPolymorphicSearch, this.indexManager);
        }
        IIndex[] searchIndexes = this.indexSelector.getIndexes();
        try {
            int max = searchIndexes.length;
            if (progressMonitor != null) {
                progressMonitor.beginTask("", max);
            }
            int i = 0;
            while (i < max) {
                isComplete &= this.search(searchIndexes[i], progressMonitor);
                if (progressMonitor != null) {
                    if (progressMonitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    progressMonitor.worked(1);
                }
                ++i;
            }
            if (JobManager.VERBOSE) {
                JobManager.verbose("-> execution time: " + this.executionTime + "ms - " + this);
            }
            boolean bl = isComplete;
            Object var6_7 = null;
            if (progressMonitor != null) {
                progressMonitor.done();
            }
            return bl;
        }
        catch (Throwable throwable) {
            block10: {
                Object var6_8 = null;
                if (progressMonitor == null) break block10;
                progressMonitor.done();
            }
            throw throwable;
        }
    }

    public boolean isReadyToRun() {
        if (this.indexSelector == null) {
            this.indexSelector = new IndexSelector(this.scope, this.focus, this.isPolymorphicSearch, this.indexManager);
            this.indexSelector.getIndexes();
        }
        return true;
    }

    public boolean search(IIndex index, IProgressMonitor progressMonitor) {
        if (progressMonitor != null && progressMonitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (index == null) {
            return true;
        }
        ReadWriteMonitor monitor = this.indexManager.getMonitorFor(index);
        if (monitor == null) {
            return true;
        }
        try {
            try {
                monitor.enterRead();
                if (index.hasChanged()) {
                    try {
                        try {
                            monitor.exitRead();
                            monitor.enterWrite();
                            this.indexManager.saveIndex(index);
                        }
                        catch (IOException e) {
                            Object var5_7 = null;
                            monitor.exitWriteEnterRead();
                            Object var7_10 = null;
                            monitor.exitRead();
                            return false;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var5_8 = null;
                        monitor.exitWriteEnterRead();
                        throw throwable;
                    }
                    Object var5_9 = null;
                    monitor.exitWriteEnterRead();
                }
                long start = System.currentTimeMillis();
                this.pattern.findIndexMatches(index, this.requestor, this.detailLevel, progressMonitor, this.scope);
                this.executionTime += System.currentTimeMillis() - start;
                Object var7_11 = null;
                monitor.exitRead();
                return true;
            }
            catch (IOException e) {
                Object var7_12 = null;
                monitor.exitRead();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            monitor.exitRead();
            throw throwable;
        }
    }

    public String toString() {
        return "searching " + this.pattern.toString();
    }
}

