/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.hierarchy;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.IWorkingCopy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.IGenericType;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BasicCompilationUnit;
import org.eclipse.jdt.internal.core.BinaryType;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.CompilationUnit;
import org.eclipse.jdt.internal.core.CreateTypeHierarchyOperation;
import org.eclipse.jdt.internal.core.JarPackageFragmentRoot;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.SourceTypeElementInfo;
import org.eclipse.jdt.internal.core.hierarchy.HierarchyResolver;
import org.eclipse.jdt.internal.core.hierarchy.IHierarchyRequestor;
import org.eclipse.jdt.internal.core.hierarchy.TypeHierarchy;

public abstract class HierarchyBuilder
implements IHierarchyRequestor {
    protected TypeHierarchy hierarchy;
    protected SearchableEnvironment searchableEnvironment;
    protected NameLookup nameLookup;
    protected HierarchyResolver hierarchyResolver;
    protected Map infoToHandle;

    public HierarchyBuilder(TypeHierarchy hierarchy) throws JavaModelException {
        this.hierarchy = hierarchy;
        JavaProject project = (JavaProject)hierarchy.javaProject();
        this.searchableEnvironment = (SearchableEnvironment)project.getSearchableNameEnvironment();
        this.nameLookup = project.getNameLookup();
        this.hierarchyResolver = new HierarchyResolver(this.searchableEnvironment, project.getOptions(true), this, new DefaultProblemFactory());
        this.infoToHandle = new HashMap(5);
    }

    public abstract void build(boolean var1) throws JavaModelException, CoreException;

    protected void buildSupertypes() {
        IGenericType type;
        IType focusType = this.getType();
        if (focusType == null) {
            return;
        }
        try {
            type = (IGenericType)((JavaElement)((Object)focusType)).getElementInfo();
        }
        catch (JavaModelException e) {
            return;
        }
        org.eclipse.jdt.core.ICompilationUnit unitToLookInside = focusType.getCompilationUnit();
        if (this.nameLookup != null) {
            NameLookup nameLookup = this.nameLookup;
            synchronized (nameLookup) {
                IWorkingCopy[] unitsToLookInside;
                IWorkingCopy[] workingCopies = this.getWokingCopies();
                if (unitToLookInside != null) {
                    int wcLength;
                    int n = wcLength = workingCopies == null ? 0 : workingCopies.length;
                    if (wcLength == 0) {
                        unitsToLookInside = new IWorkingCopy[]{unitToLookInside};
                    } else {
                        unitsToLookInside = new IWorkingCopy[wcLength + 1];
                        unitsToLookInside[0] = unitToLookInside;
                        System.arraycopy(workingCopies, 0, unitsToLookInside, 1, wcLength);
                    }
                } else {
                    unitsToLookInside = workingCopies;
                }
                try {
                    this.nameLookup.setUnitsToLookInside(unitsToLookInside);
                    this.hierarchyResolver.resolve(type);
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    this.nameLookup.setUnitsToLookInside(null);
                    throw throwable;
                }
                Object var7_9 = null;
                this.nameLookup.setUnitsToLookInside(null);
            }
        }
        this.hierarchyResolver.resolve(type);
        if (!this.hierarchy.contains(focusType)) {
            this.hierarchy.addRootClass(focusType);
        }
    }

    public void connect(IGenericType suppliedType, IGenericType superclass, IGenericType[] superinterfaces) {
        IType typeHandle = this.getHandle(suppliedType);
        if (typeHandle == null) {
            return;
        }
        IType superHandle = null;
        if (superclass != null) {
            if (superclass instanceof HierarchyResolver.MissingType) {
                this.hierarchy.missingTypes.add(((HierarchyResolver.MissingType)superclass).simpleName);
            } else {
                superHandle = this.getHandle(superclass);
            }
        }
        IType[] interfaceHandles = null;
        if (superinterfaces != null && superinterfaces.length > 0) {
            int length = superinterfaces.length;
            IType[] resolvedInterfaceHandles = new IType[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                IGenericType superInterface = superinterfaces[i];
                if (superInterface != null) {
                    if (superInterface instanceof HierarchyResolver.MissingType) {
                        this.hierarchy.missingTypes.add(((HierarchyResolver.MissingType)superInterface).simpleName);
                    } else {
                        resolvedInterfaceHandles[index] = this.getHandle(superInterface);
                        if (resolvedInterfaceHandles[index] != null) {
                            ++index;
                        }
                    }
                }
                ++i;
            }
            interfaceHandles = new IType[index];
            System.arraycopy(resolvedInterfaceHandles, 0, interfaceHandles, 0, index);
        }
        if (TypeHierarchy.DEBUG) {
            System.out.println("Connecting: " + ((JavaElement)((Object)typeHandle)).toStringWithAncestors());
            System.out.println("  to superclass: " + (superHandle == null ? "<None>" : ((JavaElement)((Object)superHandle)).toStringWithAncestors()));
            System.out.print("  and superinterfaces:");
            if (interfaceHandles == null || interfaceHandles.length == 0) {
                System.out.println(" <None>");
            } else {
                System.out.println();
                int i = 0;
                int length = interfaceHandles.length;
                while (i < length) {
                    System.out.println("    " + ((JavaElement)((Object)interfaceHandles[i])).toStringWithAncestors());
                    ++i;
                }
            }
        }
        if (suppliedType.isClass()) {
            if (superHandle == null) {
                this.hierarchy.addRootClass(typeHandle);
            } else {
                this.hierarchy.cacheSuperclass(typeHandle, superHandle);
            }
        } else {
            this.hierarchy.addInterface(typeHandle);
        }
        if (interfaceHandles == null) {
            interfaceHandles = TypeHierarchy.NO_TYPE;
        }
        this.hierarchy.cacheSuperInterfaces(typeHandle, interfaceHandles);
        this.hierarchy.cacheFlags(typeHandle, suppliedType.getModifiers());
    }

    protected IType getHandle(IGenericType genericType) {
        if (genericType == null) {
            return null;
        }
        if (genericType.isBinaryType()) {
            IClassFile classFile = (IClassFile)this.infoToHandle.get(genericType);
            if (classFile == null) {
                IType handle = this.lookupBinaryHandle((IBinaryType)genericType);
                if (handle == null) {
                    return null;
                }
                this.infoToHandle.put(genericType, handle.getParent());
                return handle;
            }
            try {
                return classFile.getType();
            }
            catch (JavaModelException e) {
                return null;
            }
        }
        if (genericType instanceof SourceTypeElementInfo) {
            return ((SourceTypeElementInfo)genericType).getHandle();
        }
        return null;
    }

    protected IType getType() {
        return this.hierarchy.getType();
    }

    protected IWorkingCopy[] getWokingCopies() {
        if (this.hierarchy.progressMonitor instanceof CreateTypeHierarchyOperation) {
            return ((CreateTypeHierarchyOperation)this.hierarchy.progressMonitor).workingCopies;
        }
        return null;
    }

    protected IType lookupBinaryHandle(IBinaryType typeInfo) {
        int flag = typeInfo.isClass() ? 2 : 4;
        char[] bName = typeInfo.getName();
        String qualifiedName = new String(ClassFile.translatedName(bName));
        return this.nameLookup.findType(qualifiedName, false, flag);
    }

    protected void worked(IProgressMonitor monitor, int work) {
        if (monitor != null) {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(work);
        }
    }

    protected ICompilationUnit createCompilationUnitFromPath(Openable handle, String osPath) throws JavaModelException {
        String encoding = handle.getJavaProject().getOption("org.eclipse.jdt.core.encoding", true);
        return new BasicCompilationUnit(null, null, osPath, encoding);
    }

    protected IGenericType createInfoFromClassFile(Openable handle, String osPath) throws JavaModelException {
        ClassFileReader info = null;
        try {
            info = ClassFileReader.read(osPath);
        }
        catch (ClassFormatException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        this.infoToHandle.put(info, handle);
        return info;
    }

    protected IGenericType createInfoFromClassFileInJar(Openable classFile) throws JavaModelException {
        IJavaElement pkg = classFile.getParent();
        String classFilePath = String.valueOf(pkg.getElementName().replace('.', '/')) + "/" + classFile.getElementName();
        ClassFileReader info = null;
        ZipFile zipFile = null;
        try {
            try {
                zipFile = ((JarPackageFragmentRoot)pkg.getParent()).getJar();
                info = ClassFileReader.read(zipFile, classFilePath);
            }
            catch (ClassFormatException e) {
                e.printStackTrace();
                IGenericType iGenericType = null;
                Object var7_12 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iGenericType;
            }
            catch (IOException e) {
                e.printStackTrace();
                IGenericType iGenericType = null;
                Object var7_13 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iGenericType;
            }
            catch (CoreException e) {
                e.printStackTrace();
                IGenericType iGenericType = null;
                Object var7_14 = null;
                JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
                return iGenericType;
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
            throw throwable;
        }
        Object var7_16 = null;
        JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
        this.infoToHandle.put(info, classFile);
        return info;
    }

    protected void addInfoFromClosedElement(Openable handle, ArrayList infos, ArrayList units, String resourcePath) throws JavaModelException {
        IJavaElement pkg = handle.getParent();
        PackageFragmentRoot root = (PackageFragmentRoot)pkg.getParent();
        if (root.isArchive()) {
            IGenericType info = this.createInfoFromClassFileInJar(handle);
            if (info != null) {
                infos.add(info);
            }
        } else {
            Path path = new Path(resourcePath);
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            IPath location = file.getLocation();
            if (location != null) {
                IGenericType info;
                String osPath = location.toOSString();
                if (handle instanceof CompilationUnit) {
                    ICompilationUnit unit = this.createCompilationUnitFromPath(handle, osPath);
                    if (unit != null) {
                        units.add(unit);
                    }
                } else if (handle instanceof ClassFile && (info = this.createInfoFromClassFile(handle, osPath)) != null) {
                    infos.add(info);
                }
            }
        }
    }

    protected void addInfoFromOpenCU(CompilationUnit cu, ArrayList infos) throws JavaModelException {
        IType[] types = cu.getTypes();
        int j = 0;
        while (j < types.length) {
            SourceType type = (SourceType)types[j];
            this.addInfoFromOpenSourceType(type, infos);
            ++j;
        }
    }

    protected void addInfoFromOpenSourceType(SourceType type, ArrayList infos) throws JavaModelException {
        IGenericType info = (IGenericType)type.getElementInfo();
        infos.add(info);
        this.infoToHandle.put(info, type);
        IType[] members = type.getTypes();
        int i = 0;
        while (i < members.length) {
            this.addInfoFromOpenSourceType((SourceType)members[i], infos);
            ++i;
        }
    }

    protected void addInfoFromOpenClassFile(ClassFile classFile, ArrayList infos) throws JavaModelException {
        IType type = classFile.getType();
        IGenericType info = (IGenericType)((BinaryType)type).getElementInfo();
        infos.add(info);
        this.infoToHandle.put(info, classFile);
    }

    protected void addInfoFromElement(Openable handle, ArrayList infos, ArrayList units, String resourcePath) throws JavaModelException {
        if (handle.isOpen()) {
            if (handle instanceof CompilationUnit) {
                this.addInfoFromOpenCU((CompilationUnit)handle, infos);
            } else if (handle instanceof ClassFile) {
                this.addInfoFromOpenClassFile((ClassFile)handle, infos);
            }
        } else {
            this.addInfoFromClosedElement(handle, infos, units, resourcePath);
        }
    }
}

