/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Comparator;
import java.util.Stack;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.PrimitiveType;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.compiler.SourceElementRequestorAdapter;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.core.SortJavaElement;

public class SortElementBuilder
extends SourceElementRequestorAdapter {
    SortElement currentElement;
    Stack stack;
    SortCompilationUnit compilationUnit;
    Scanner scanner;
    AST ast;
    char[] source;
    int[] lineEnds;
    Comparator comparator;
    int[] positionsToMap;
    int positionsToMapIndex;

    public SortElementBuilder(char[] source, int[] positionsToMap, Comparator comparator) {
        this.source = source;
        this.comparator = comparator;
        this.positionsToMap = positionsToMap;
        this.scanner = new Scanner(false, false, false, false, null, null);
        this.ast = new AST();
    }

    public void acceptLineSeparatorPositions(int[] positions) {
        this.lineEnds = positions;
    }

    public String getSource() {
        StringBuffer buffer = new StringBuffer();
        this.positionsToMapIndex = 0;
        this.compilationUnit.generateSource(buffer);
        if (this.positionsToMap != null) {
            this.compilationUnit.mapPositions();
        }
        return buffer.toString();
    }

    private static int searchLineNumber(int[] startLineIndexes, int position) {
        int length = startLineIndexes.length;
        if (length == 0) {
            return 1;
        }
        int g = 0;
        int d = length - 1;
        int m = 0;
        while (g <= d) {
            m = (g + d) / 2;
            if (position < startLineIndexes[m]) {
                d = m - 1;
                continue;
            }
            if (position > startLineIndexes[m]) {
                g = m + 1;
                continue;
            }
            return m + 1;
        }
        if (position < startLineIndexes[m]) {
            return m + 1;
        }
        return m + 2;
    }

    void sort() {
        this.compilationUnit.sort();
    }

    void mapNextPosition(SortJavaElement node, int start, int end) {
        int i = this.positionsToMapIndex;
        while (i < this.positionsToMap.length) {
            int nextPosition = this.positionsToMap[i];
            if (nextPosition < start || nextPosition > end) break;
            int n = i++;
            this.positionsToMap[n] = this.positionsToMap[n] + (node.newSourceStart - node.sourceStart);
        }
        this.positionsToMapIndex = i;
    }

    public void enterClass(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[] superclass, char[][] superinterfaces) {
        SortClassDeclaration type = new SortClassDeclaration(declarationStart, modifiers, name, superclass, superinterfaces);
        this.currentElement.addChild(type);
        this.push(type);
    }

    public void enterCompilationUnit() {
        this.stack = new Stack();
        this.compilationUnit = new SortCompilationUnit(0);
        this.push(this.compilationUnit);
    }

    public void enterConstructor(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        if ((this.currentElement.id & 2) != 0) {
            SortConstructorDeclaration constructorDeclaration = new SortConstructorDeclaration(declarationStart, modifiers, name, parameterNames, parameterTypes, exceptionTypes);
            this.currentElement.addChild(constructorDeclaration);
            this.push(constructorDeclaration);
        }
    }

    public void enterField(int declarationStart, int modifiers, char[] type, char[] name, int nameSourceStart, int nameSourceEnd) {
        if ((this.currentElement.id & 2) != 0) {
            SortFieldDeclaration fieldDeclaration = new SortFieldDeclaration(declarationStart, modifiers, type, name, nameSourceStart);
            SortElement[] currentElementChildren = this.currentElement.children;
            if (currentElementChildren != null) {
                SortElement previousElement = this.currentElement.children[this.currentElement.children_count - 1];
                if (previousElement.id == 16 && ((SortFieldDeclaration)previousElement).declarationStart == declarationStart) {
                    SortMultipleFieldDeclaration multipleFielDeclaration = new SortMultipleFieldDeclaration((SortFieldDeclaration)previousElement);
                    multipleFielDeclaration.addField(fieldDeclaration);
                    this.currentElement.children[this.currentElement.children_count - 1] = multipleFielDeclaration;
                } else if (previousElement.id == 256 && ((SortMultipleFieldDeclaration)previousElement).declarationStart == declarationStart) {
                    ((SortMultipleFieldDeclaration)previousElement).addField(fieldDeclaration);
                } else {
                    this.currentElement.addChild(fieldDeclaration);
                }
            } else {
                this.currentElement.addChild(fieldDeclaration);
            }
            this.push(fieldDeclaration);
        }
    }

    public void enterInitializer(int declarationStart, int modifiers) {
        if ((this.currentElement.id & 2) != 0) {
            SortInitializer initializer = new SortInitializer(declarationStart, modifiers);
            this.currentElement.addChild(initializer);
            this.push(initializer);
        }
    }

    public void enterInterface(int declarationStart, int modifiers, char[] name, int nameSourceStart, int nameSourceEnd, char[][] superinterfaces) {
        SortInterfaceDeclaration type = new SortInterfaceDeclaration(declarationStart, modifiers, name, superinterfaces);
        this.currentElement.addChild(type);
        this.push(type);
    }

    public void enterMethod(int declarationStart, int modifiers, char[] returnType, char[] name, int nameSourceStart, int nameSourceEnd, char[][] parameterTypes, char[][] parameterNames, char[][] exceptionTypes) {
        if ((this.currentElement.id & 2) != 0) {
            SortMethodDeclaration methodDeclaration = new SortMethodDeclaration(declarationStart, modifiers, name, parameterNames, parameterTypes, exceptionTypes, returnType);
            this.currentElement.addChild(methodDeclaration);
            this.push(methodDeclaration);
        }
    }

    public void exitClass(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void exitCompilationUnit(int declarationEnd) {
        this.pop(declarationEnd);
        this.sort();
    }

    public void exitConstructor(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void exitField(int initializationStart, int declarationEnd, int declarationSourceEnd) {
        int normalizedDeclarationSourceEnd = this.normalizeSourceEnd(declarationSourceEnd);
        if (this.currentElement.id == 16) {
            SortFieldDeclaration fieldDeclaration = (SortFieldDeclaration)this.currentElement;
            fieldDeclaration.declarationSourceEnd = normalizedDeclarationSourceEnd;
        }
        this.pop(declarationEnd);
        if (this.currentElement.children != null) {
            SortElement element = this.currentElement.children[this.currentElement.children_count - 1];
            switch (element.id) {
                case 256: {
                    SortMultipleFieldDeclaration multipleFielDeclaration = (SortMultipleFieldDeclaration)element;
                    multipleFielDeclaration.innerFields[multipleFielDeclaration.fieldCounter - 1].declarationSourceEnd = normalizedDeclarationSourceEnd;
                    multipleFielDeclaration.sourceEnd = normalizedDeclarationSourceEnd;
                    break;
                }
                case 16: {
                    SortFieldDeclaration fieldDeclaration = (SortFieldDeclaration)element;
                    fieldDeclaration.previousSourceEnd = fieldDeclaration.sourceEnd;
                    fieldDeclaration.sourceEnd = normalizedDeclarationSourceEnd;
                }
            }
        }
    }

    public void exitInitializer(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void exitInterface(int declarationEnd) {
        this.pop(declarationEnd);
    }

    public void exitMethod(int declarationEnd) {
        this.pop(declarationEnd);
    }

    final int normalizeSourceStart(int position) {
        int newLineNumber;
        if (position == 0) {
            return 0;
        }
        int index = position - 1;
        while (index >= 0 && Character.isWhitespace(this.source[index])) {
            --index;
        }
        int originalLineNumber = SortElementBuilder.searchLineNumber(this.lineEnds, position);
        if (originalLineNumber == (newLineNumber = SortElementBuilder.searchLineNumber(this.lineEnds, index))) {
            return index + 1;
        }
        return this.lineEnds[newLineNumber - 1] + 1;
    }

    final int normalizeSourceEnd(int position) {
        int lineNumber = SortElementBuilder.searchLineNumber(this.lineEnds, position);
        if (lineNumber == 1) {
            return position;
        }
        int normalizeSourceEnd = 0;
        normalizeSourceEnd = lineNumber - 1 >= this.lineEnds.length ? this.source.length - 1 : this.lineEnds[lineNumber - 1];
        int index = position + 1;
        while (index < normalizeSourceEnd && Character.isWhitespace(this.source[index])) {
            ++index;
        }
        if (index == normalizeSourceEnd) {
            return normalizeSourceEnd;
        }
        return position;
    }

    private void pop(int declarationEnd) {
        this.currentElement.sourceEnd = this.normalizeSourceEnd(declarationEnd);
        this.currentElement.closeCollections();
        this.stack.pop();
        if (!this.stack.isEmpty()) {
            this.currentElement = (SortElement)this.stack.peek();
        }
    }

    private void push(SortElement sortElement) {
        this.currentElement = sortElement;
        this.stack.push(sortElement);
    }

    abstract class SortElement
    extends SortJavaElement {
        SortElement(int sourceStart, int modifiers) {
            super(SortElementBuilder.this);
            this.sourceStart = SortElementBuilder.this.normalizeSourceStart(sourceStart);
            modifiers &= 0xFFFFFDFF;
            this.modifiers = modifiers &= 0xFFFF;
            this.children_count = 0;
        }

        protected void setParameters(MethodDeclaration methodDeclaration, String[] parameterNames, String[] parameterTypes) {
            int i = 0;
            int max = parameterNames.length;
            while (i < max) {
                int indexOfArrayBrace;
                String type = parameterTypes[i];
                SingleVariableDeclaration singleVariableDeclaration = SortElementBuilder.this.ast.newSingleVariableDeclaration();
                singleVariableDeclaration.setName(SortElementBuilder.this.ast.newSimpleName(parameterNames[i]));
                if (type.indexOf(46) != -1) {
                    int length;
                    String[] typeParts = this.splitOn('.', type);
                    indexOfArrayBrace = typeParts[(length = typeParts.length) - 1].indexOf(91);
                    if (indexOfArrayBrace != -1) {
                        int dimensions = this.occurencesOf('[', typeParts[length - 1]);
                        typeParts[length - 1] = typeParts[length - 1].substring(0, indexOfArrayBrace);
                        String[] typeSubstrings = new String[length];
                        int j = 0;
                        while (j < length) {
                            typeSubstrings[j] = new String(typeParts[j]);
                            ++j;
                        }
                        singleVariableDeclaration.setType(SortElementBuilder.this.ast.newArrayType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(typeSubstrings)), dimensions));
                    } else {
                        String[] typeSubstrings = new String[length];
                        int j = 0;
                        while (j < length) {
                            typeSubstrings[j] = new String(typeParts[j]);
                            ++j;
                        }
                        singleVariableDeclaration.setType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(typeSubstrings)));
                    }
                } else {
                    indexOfArrayBrace = type.indexOf(91);
                    if (indexOfArrayBrace != -1) {
                        int dimensions = this.occurencesOf('[', type);
                        type = type.substring(0, indexOfArrayBrace);
                        singleVariableDeclaration.setType(SortElementBuilder.this.ast.newArrayType(this.newType(type), dimensions));
                    } else {
                        singleVariableDeclaration.setType(this.newType(type));
                    }
                }
                methodDeclaration.parameters().add(singleVariableDeclaration);
                ++i;
            }
        }

        protected String[] splitOn(char divider, String stringToSplit) {
            int length;
            int n = length = stringToSplit == null ? 0 : stringToSplit.length();
            if (length == 0) {
                return new String[]{stringToSplit};
            }
            int wordCount = 1;
            int i = 0;
            while (i < length) {
                if (stringToSplit.charAt(i) == divider) {
                    ++wordCount;
                }
                ++i;
            }
            String[] split = new String[wordCount];
            int last = 0;
            int currentWord = 0;
            int i2 = 0;
            while (i2 < length) {
                if (stringToSplit.charAt(i2) == divider) {
                    split[currentWord++] = stringToSplit.substring(last, i2);
                    last = i2 + 1;
                }
                ++i2;
            }
            split[currentWord] = stringToSplit.substring(last, length);
            return split;
        }

        protected int occurencesOf(char toBeFound, String s) {
            if (s == null) {
                return 0;
            }
            int count = 0;
            int i = 0;
            int max = s.length();
            while (i < max) {
                if (toBeFound == s.charAt(i)) {
                    ++count;
                }
                ++i;
            }
            return count;
        }

        protected Type newType(String type) {
            SortElementBuilder.this.scanner.setSource(type.toCharArray());
            SortElementBuilder.this.scanner.resetTo(0, type.length());
            int token = 0;
            try {
                token = SortElementBuilder.this.scanner.getNextToken();
            }
            catch (InvalidInputException e) {
                return null;
            }
            if (token == 6) {
                return SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newSimpleName(new String(type)));
            }
            switch (token) {
                case 30: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.INT);
                }
                case 26: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.BYTE);
                }
                case 25: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.BOOLEAN);
                }
                case 27: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.CHAR);
                }
                case 28: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.DOUBLE);
                }
                case 29: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.FLOAT);
                }
                case 31: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.LONG);
                }
                case 32: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.SHORT);
                }
                case 33: {
                    return SortElementBuilder.this.ast.newPrimitiveType(PrimitiveType.VOID);
                }
            }
            return null;
        }

        abstract ASTNode convert();
    }

    abstract class SortAbstractMethodDeclaration
    extends SortElement {
        SortAbstractMethodDeclaration(int sourceStart, int modifiers, char[] name, char[][] parametersNames, char[][] parametersTypes, char[][] thrownExceptions) {
            super(sourceStart, modifiers);
            int i;
            int length;
            this.name = new String(name);
            if (parametersNames != null) {
                length = parametersNames.length;
                this.parametersNames = new String[length];
                this.parametersTypes = new String[length];
                i = 0;
                while (i < length) {
                    this.parametersNames[i] = new String(parametersNames[i]);
                    this.parametersTypes[i] = new String(parametersTypes[i]);
                    ++i;
                }
            }
            if (thrownExceptions != null) {
                length = thrownExceptions.length;
                this.thrownExceptions = new String[length];
                i = 0;
                while (i < length) {
                    this.thrownExceptions[i] = new String(thrownExceptions[i]);
                    ++i;
                }
            }
        }

        public String decodeSignature() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("(");
            if (this.parametersNames != null) {
                int length = this.parametersNames.length;
                int i = 0;
                while (i < length - 1) {
                    buffer.append(String.valueOf(this.parametersTypes[i]) + " " + this.parametersNames[i] + ", ");
                    ++i;
                }
                buffer.append(String.valueOf(this.parametersTypes[length - 1]) + " " + this.parametersNames[length - 1]);
            }
            buffer.append(")");
            return buffer.toString();
        }

        protected void generateSource(StringBuffer buffer) {
            super.generateSource(buffer);
            int length = this.children_count;
            if (length != 0) {
                int start = this.sourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    buffer.append(SortElementBuilder.this.source, start, end - start + 1);
                    this.children[i].generateSource(buffer);
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.sourceEnd;
                    ++i;
                }
                buffer.append(SortElementBuilder.this.source, start, end - start + 1);
            } else {
                buffer.append(SortElementBuilder.this.source, this.sourceStart, this.sourceEnd - this.sourceStart + 1);
            }
        }

        protected void mapPositions() {
            int length = this.children_count;
            if (length != 0) {
                int start = this.sourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    SortElementBuilder.this.mapNextPosition(this, start, end);
                    this.children[i].mapPositions();
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.sourceEnd;
                    ++i;
                }
                SortElementBuilder.this.mapNextPosition(this, start, end);
            } else {
                SortElementBuilder.this.mapNextPosition(this, this.sourceStart, this.sourceEnd);
            }
        }
    }

    class SortMethodDeclaration
    extends SortAbstractMethodDeclaration {
        SortMethodDeclaration(int sourceStart, int modifiers, char[] name, char[][] parametersNames, char[][] parametersTypes, char[][] thrownExceptions, char[] returnType) {
            super(sourceStart, modifiers, name, parametersNames, parametersTypes, thrownExceptions);
            this.id = 64;
            this.returnType = new String(returnType);
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("method ").append(this.name).append(this.decodeSignature()).append(" " + this.returnType + SortJavaElement.LINE_SEPARATOR);
        }

        ASTNode convert() {
            int indexOfArrayBrace;
            String currentReturnType;
            MethodDeclaration methodDeclaration = SortElementBuilder.this.ast.newMethodDeclaration();
            methodDeclaration.setConstructor(false);
            methodDeclaration.setModifiers(this.modifiers);
            methodDeclaration.setName(SortElementBuilder.this.ast.newSimpleName(new String(this.name)));
            methodDeclaration.setProperty("relativeOrder", new Integer(this.sourceStart));
            if (this.parametersNames != null) {
                this.setParameters(methodDeclaration, this.parametersNames, this.parametersTypes);
            }
            if (this.thrownExceptions != null) {
                int j = 0;
                int max2 = this.thrownExceptions.length;
                while (j < max2) {
                    String currentException = this.thrownExceptions[j];
                    Name exceptionName = currentException.indexOf(46) == -1 ? SortElementBuilder.this.ast.newSimpleName(currentException) : SortElementBuilder.this.ast.newName(this.splitOn('.', currentException));
                    methodDeclaration.thrownExceptions().add(exceptionName);
                    ++j;
                }
            }
            if ((currentReturnType = this.returnType).indexOf(46) != -1) {
                int length;
                String[] returnTypeSubstrings = this.splitOn('.', currentReturnType);
                indexOfArrayBrace = returnTypeSubstrings[(length = returnTypeSubstrings.length) - 1].indexOf(91);
                if (indexOfArrayBrace != -1) {
                    int dimensions = this.occurencesOf('[', returnTypeSubstrings[length - 1]);
                    returnTypeSubstrings[length - 1] = returnTypeSubstrings[length - 1].substring(0, indexOfArrayBrace);
                    methodDeclaration.setReturnType(SortElementBuilder.this.ast.newArrayType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(returnTypeSubstrings)), dimensions));
                } else {
                    methodDeclaration.setReturnType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(returnTypeSubstrings)));
                }
            } else {
                indexOfArrayBrace = currentReturnType.indexOf(91);
                if (indexOfArrayBrace != -1) {
                    int dimensions = this.occurencesOf('[', currentReturnType);
                    currentReturnType = currentReturnType.substring(0, indexOfArrayBrace);
                    methodDeclaration.setReturnType(SortElementBuilder.this.ast.newArrayType(this.newType(currentReturnType), dimensions));
                } else {
                    methodDeclaration.setReturnType(this.newType(currentReturnType));
                }
            }
            return methodDeclaration;
        }
    }

    class SortConstructorDeclaration
    extends SortAbstractMethodDeclaration {
        SortConstructorDeclaration(int sourceStart, int modifiers, char[] name, char[][] parametersNames, char[][] parametersTypes, char[][] thrownExceptions) {
            super(sourceStart, modifiers, name, parametersNames, parametersTypes, thrownExceptions);
            this.id = 128;
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("constructor ").append(String.valueOf(this.decodeSignature()) + SortJavaElement.LINE_SEPARATOR);
        }

        ASTNode convert() {
            MethodDeclaration methodDeclaration = SortElementBuilder.this.ast.newMethodDeclaration();
            methodDeclaration.setConstructor(true);
            methodDeclaration.setModifiers(this.modifiers);
            methodDeclaration.setName(SortElementBuilder.this.ast.newSimpleName(new String(this.name)));
            methodDeclaration.setProperty("relativeOrder", new Integer(this.sourceStart));
            if (this.parametersNames != null) {
                this.setParameters(methodDeclaration, this.parametersNames, this.parametersTypes);
            }
            if (this.thrownExceptions != null) {
                int j = 0;
                int max2 = this.thrownExceptions.length;
                while (j < max2) {
                    String currentException = this.thrownExceptions[j];
                    Name exceptionName = currentException.indexOf(46) == -1 ? SortElementBuilder.this.ast.newSimpleName(currentException) : SortElementBuilder.this.ast.newName(this.splitOn('.', currentException));
                    methodDeclaration.thrownExceptions().add(exceptionName);
                    ++j;
                }
            }
            return methodDeclaration;
        }
    }

    public class SortFieldDeclaration
    extends SortElement {
        int previousSourceEnd;

        SortFieldDeclaration(int sourceStart, int modifiers, char[] type, char[] name, int nameSourceStart) {
            super(sourceStart, modifiers);
            this.declarationStart = sourceStart;
            this.id = 16;
            this.type = new String(type);
            this.name = new String(name);
            this.nameSourceStart = nameSourceStart;
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("field ").append(String.valueOf(this.type) + " " + this.name + SortJavaElement.LINE_SEPARATOR);
        }

        ASTNode convert() {
            VariableDeclarationFragment variableDeclarationFragment = SortElementBuilder.this.ast.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(SortElementBuilder.this.ast.newSimpleName(new String(this.name)));
            FieldDeclaration fieldDeclaration = SortElementBuilder.this.ast.newFieldDeclaration(variableDeclarationFragment);
            String currentFieldType = this.type;
            if (currentFieldType.indexOf(46) != -1) {
                int length;
                String[] typeParts = this.splitOn('.', currentFieldType);
                int indexOfArrayBrace = typeParts[(length = typeParts.length) - 1].indexOf(91);
                if (indexOfArrayBrace != -1) {
                    int dimensions = this.occurencesOf('[', typeParts[length - 1]);
                    typeParts[length - 1] = typeParts[length - 1].substring(0, indexOfArrayBrace);
                    fieldDeclaration.setType(SortElementBuilder.this.ast.newArrayType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(typeParts)), dimensions));
                } else {
                    fieldDeclaration.setType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(typeParts)));
                }
            } else {
                int indexOfArrayBrace = currentFieldType.indexOf(91);
                if (indexOfArrayBrace != -1) {
                    int dimensions = this.occurencesOf('[', currentFieldType);
                    currentFieldType = currentFieldType.substring(0, indexOfArrayBrace);
                    fieldDeclaration.setType(SortElementBuilder.this.ast.newArrayType(this.newType(currentFieldType), dimensions));
                } else {
                    fieldDeclaration.setType(this.newType(currentFieldType));
                }
            }
            fieldDeclaration.setModifiers(this.modifiers);
            fieldDeclaration.setProperty("relativeOrder", new Integer(this.sourceStart));
            return fieldDeclaration;
        }

        protected void generateSource(StringBuffer buffer) {
            super.generateSource(buffer);
            int length = this.children_count;
            if (length != 0) {
                int start = this.sourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    buffer.append(SortElementBuilder.this.source, start, end - start + 1);
                    this.children[i].generateSource(buffer);
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.declarationSourceEnd;
                    ++i;
                }
                buffer.append(SortElementBuilder.this.source, start, end - start + 1);
            } else {
                buffer.append(SortElementBuilder.this.source, this.sourceStart, this.declarationSourceEnd - this.sourceStart + 1);
            }
        }

        protected void generateReduceSource(StringBuffer buffer) {
            int length = this.children_count;
            if (length != 0) {
                int start = this.nameSourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    buffer.append(SortElementBuilder.this.source, start, end - start + 1);
                    this.children[i].generateSource(buffer);
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.sourceEnd;
                    ++i;
                }
                buffer.append(SortElementBuilder.this.source, start, end - start + 1);
            } else {
                buffer.append(SortElementBuilder.this.source, this.nameSourceStart, this.sourceEnd - this.nameSourceStart + 1);
            }
        }

        protected void mapReducedPositions() {
            int length = this.children_count;
            if (length != 0) {
                int start = this.nameSourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                SortElementBuilder.this.mapNextPosition(this, start, end);
                int i = 0;
                while (i < length) {
                    this.children[i].mapPositions();
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.sourceEnd;
                    ++i;
                }
                SortElementBuilder.this.mapNextPosition(this, start, end);
            } else {
                SortElementBuilder.this.mapNextPosition(this, this.nameSourceStart, this.sourceEnd);
            }
        }

        protected void mapPositions() {
            int length = this.children_count;
            if (length != 0) {
                int start = this.sourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    SortElementBuilder.this.mapNextPosition(this, start, end);
                    this.children[i].mapPositions();
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.declarationSourceEnd;
                    ++i;
                }
                SortElementBuilder.this.mapNextPosition(this, start, end);
            } else {
                SortElementBuilder.this.mapNextPosition(this, this.sourceStart, this.declarationSourceEnd);
            }
        }
    }

    class SortMultipleFieldDeclaration
    extends SortElement {
        int declarationStart;

        SortMultipleFieldDeclaration(SortFieldDeclaration fieldDeclaration) {
            super(fieldDeclaration.declarationStart, fieldDeclaration.modifiers);
            this.declarationStart = fieldDeclaration.declarationStart;
            this.id = 256;
            this.innerFields = new SortFieldDeclaration[1];
            this.fieldCounter = 0;
            this.innerFields[this.fieldCounter++] = fieldDeclaration;
            this.type = fieldDeclaration.type;
            this.sourceStart = fieldDeclaration.sourceStart;
            fieldDeclaration.sourceEnd = fieldDeclaration.previousSourceEnd;
        }

        void addField(SortFieldDeclaration fieldDeclaration) {
            this.innerFields = new SortFieldDeclaration[this.fieldCounter + 1];
            System.arraycopy(this.innerFields, 0, this.innerFields, 0, this.fieldCounter);
            this.innerFields[this.fieldCounter++] = fieldDeclaration;
            fieldDeclaration.sourceEnd = fieldDeclaration.previousSourceEnd;
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("multiple fields ").append(SortJavaElement.LINE_SEPARATOR);
            if (this.innerFields != null) {
                buffer.append(this.tab(tab + 1)).append("INNER FIELDS ------------------------------" + SortJavaElement.LINE_SEPARATOR);
                int i = 0;
                while (i < this.fieldCounter) {
                    buffer.append(this.innerFields[i].toString(tab + 2));
                    buffer.append(SortJavaElement.LINE_SEPARATOR);
                    ++i;
                }
            }
        }

        ASTNode convert() {
            int indexOfArrayBrace;
            VariableDeclarationFragment variableDeclarationFragment = SortElementBuilder.this.ast.newVariableDeclarationFragment();
            variableDeclarationFragment.setName(SortElementBuilder.this.ast.newSimpleName(new String(this.innerFields[0].name)));
            FieldDeclaration fieldDeclaration = SortElementBuilder.this.ast.newFieldDeclaration(variableDeclarationFragment);
            int j = 1;
            int max2 = this.innerFields.length;
            while (j < max2) {
                VariableDeclarationFragment fragment = SortElementBuilder.this.ast.newVariableDeclarationFragment();
                fragment.setName(SortElementBuilder.this.ast.newSimpleName(new String(this.innerFields[j].name)));
                ++j;
            }
            String currentFieldType = this.type;
            if (currentFieldType.indexOf(46) != -1) {
                int length;
                String[] typeParts = this.splitOn('.', currentFieldType);
                indexOfArrayBrace = typeParts[(length = typeParts.length) - 1].indexOf(91);
                if (indexOfArrayBrace != -1) {
                    int dimensions = this.occurencesOf('[', typeParts[length - 1]);
                    typeParts[length - 1] = typeParts[length - 1].substring(0, indexOfArrayBrace);
                    fieldDeclaration.setType(SortElementBuilder.this.ast.newArrayType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(typeParts)), dimensions));
                } else {
                    fieldDeclaration.setType(SortElementBuilder.this.ast.newSimpleType(SortElementBuilder.this.ast.newName(typeParts)));
                }
            } else {
                indexOfArrayBrace = currentFieldType.indexOf(91);
                if (indexOfArrayBrace != -1) {
                    int dimensions = this.occurencesOf('[', currentFieldType);
                    currentFieldType = currentFieldType.substring(0, indexOfArrayBrace);
                    fieldDeclaration.setType(SortElementBuilder.this.ast.newArrayType(this.newType(currentFieldType), dimensions));
                } else {
                    fieldDeclaration.setType(this.newType(currentFieldType));
                }
            }
            fieldDeclaration.setProperty("relativeOrder", new Integer(this.sourceStart));
            fieldDeclaration.setModifiers(this.modifiers);
            return fieldDeclaration;
        }

        protected void generateSource(StringBuffer buffer) {
            super.generateSource(buffer);
            int length = this.fieldCounter;
            int start = this.innerFields[0].sourceStart;
            int end = this.innerFields[0].nameSourceStart - 1;
            buffer.append(SortElementBuilder.this.source, start, end - start + 1);
            int i = 0;
            while (i < length) {
                this.innerFields[i].newSourceStart = this.newSourceStart;
                this.innerFields[i].generateReduceSource(buffer);
                if (i < length - 1) {
                    start = this.innerFields[i].sourceEnd + 1;
                    end = this.innerFields[i + 1].nameSourceStart - 1;
                    buffer.append(SortElementBuilder.this.source, start, end - start + 1);
                }
                ++i;
            }
            start = this.innerFields[length - 1].sourceEnd + 1;
            end = this.innerFields[length - 1].declarationSourceEnd;
            buffer.append(SortElementBuilder.this.source, start, end - start + 1);
        }

        protected void mapPositions() {
            int length = this.fieldCounter;
            int start = this.innerFields[0].sourceStart;
            int end = this.innerFields[0].nameSourceStart - 1;
            SortElementBuilder.this.mapNextPosition(this, start, end);
            int i = 0;
            while (i < length) {
                this.innerFields[i].newSourceStart = this.newSourceStart;
                this.innerFields[i].mapReducedPositions();
                if (i < length - 1) {
                    start = this.innerFields[i].sourceEnd + 1;
                    end = this.innerFields[i + 1].nameSourceStart - 1;
                    SortElementBuilder.this.mapNextPosition(this, start, end);
                }
                ++i;
            }
            start = this.innerFields[length - 1].sourceEnd + 1;
            end = this.innerFields[length - 1].declarationSourceEnd;
            SortElementBuilder.this.mapNextPosition(this, start, end);
        }

        protected void sort() {
            int i = 0;
            int max = this.fieldCounter;
            while (i < max) {
                this.innerFields[i].sort();
                ++i;
            }
        }
    }

    class SortInitializer
    extends SortElement {
        SortInitializer(int sourceStart, int modifiers) {
            super(sourceStart, modifiers);
            this.id = 32;
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("initializer " + SortJavaElement.LINE_SEPARATOR);
        }

        ASTNode convert() {
            Initializer initializer = SortElementBuilder.this.ast.newInitializer();
            initializer.setModifiers(this.modifiers);
            initializer.setProperty("relativeOrder", new Integer(this.sourceStart));
            return initializer;
        }

        protected void generateSource(StringBuffer buffer) {
            super.generateSource(buffer);
            int length = this.children_count;
            if (length != 0) {
                int start = this.sourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    buffer.append(SortElementBuilder.this.source, start, end - start + 1);
                    this.children[i].generateSource(buffer);
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.sourceEnd;
                    ++i;
                }
                buffer.append(SortElementBuilder.this.source, start, end - start + 1);
            } else {
                buffer.append(SortElementBuilder.this.source, this.sourceStart, this.sourceEnd - this.sourceStart + 1);
            }
        }

        protected void mapPositions() {
            int length = this.children_count;
            if (length != 0) {
                int start = this.sourceStart;
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                int i = 0;
                while (i < length) {
                    SortElementBuilder.this.mapNextPosition(this, start, end);
                    this.children[i].mapPositions();
                    start = i < length - 1 ? this.children[i].sourceEnd + 1 : this.lastChildBeforeSorting.sourceEnd + 1;
                    end = i < length - 1 ? this.children[i + 1].sourceStart - 1 : this.sourceEnd;
                    ++i;
                }
                SortElementBuilder.this.mapNextPosition(this, start, end);
            } else {
                SortElementBuilder.this.mapNextPosition(this, this.sourceStart, this.sourceEnd);
            }
        }
    }

    class SortClassDeclaration
    extends SortType {
        SortClassDeclaration(int sourceStart, int modifiers, char[] name, char[] superclass, char[][] superinterfaces) {
            super(sourceStart, modifiers, name, superinterfaces);
            this.id = 6;
            if (superclass != null) {
                this.superclass = new String(superclass);
            }
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("class ").append(this.name);
            if (this.superclass != null) {
                buffer.append(" extends " + this.superclass);
            }
            if (this.superInterfaces != null) {
                int length = this.superInterfaces.length;
                buffer.append(" implements ");
                int i = 0;
                while (i < length - 1) {
                    buffer.append(String.valueOf(this.superInterfaces[i]) + ", ");
                    ++i;
                }
                buffer.append(this.superInterfaces[length - 1]);
            }
            buffer.append(SortJavaElement.LINE_SEPARATOR);
        }

        ASTNode convert() {
            TypeDeclaration typeDeclaration = SortElementBuilder.this.ast.newTypeDeclaration();
            typeDeclaration.setInterface(false);
            typeDeclaration.setModifiers(this.modifiers);
            typeDeclaration.setName(SortElementBuilder.this.ast.newSimpleName(this.name));
            if (this.superclass != null) {
                if (this.superclass.indexOf(46) == -1) {
                    typeDeclaration.setSuperclass(SortElementBuilder.this.ast.newSimpleName(this.superclass));
                } else {
                    String[] superclassNames = this.splitOn('.', this.superclass);
                    typeDeclaration.setSuperclass(SortElementBuilder.this.ast.newName(superclassNames));
                }
            }
            if (this.superInterfaces != null) {
                int j = 0;
                int max2 = this.superInterfaces.length;
                while (j < max2) {
                    Name interfaceName;
                    String currentInterfaceName = this.superInterfaces[j];
                    if (currentInterfaceName.indexOf(46) == -1) {
                        interfaceName = SortElementBuilder.this.ast.newSimpleName(currentInterfaceName);
                    } else {
                        String[] interfaceNames = this.splitOn('.', currentInterfaceName);
                        interfaceName = SortElementBuilder.this.ast.newName(interfaceNames);
                    }
                    typeDeclaration.superInterfaces().add(interfaceName);
                    ++j;
                }
            }
            typeDeclaration.setProperty("relativeOrder", new Integer(this.sourceStart));
            return typeDeclaration;
        }
    }

    abstract class SortType
    extends SortElement {
        SortType(int sourceStart, int modifier, char[] name, char[][] superinterfaces) {
            super(sourceStart, modifier);
            this.name = new String(name);
            if (superinterfaces != null) {
                int length = superinterfaces.length;
                this.superInterfaces = new String[length];
                int i = 0;
                while (i < length) {
                    this.superInterfaces[i] = new String(superinterfaces[i]);
                    ++i;
                }
            }
        }

        protected void generateSource(StringBuffer buffer) {
            super.generateSource(buffer);
            int length = this.children_count;
            int start = this.sourceStart;
            if (length != 0) {
                int end = this.firstChildBeforeSorting.sourceStart;
                buffer.append(SortElementBuilder.this.source, start, end - start);
                int i = 0;
                while (i < length) {
                    ((SortElement)this.astNodes[i].getProperty("corresponding_element")).generateSource(buffer);
                    ++i;
                }
                start = this.lastChildBeforeSorting.sourceEnd + 1;
                buffer.append(SortElementBuilder.this.source, start, this.sourceEnd - start + 1);
            } else {
                buffer.append(SortElementBuilder.this.source, start, this.sourceEnd - start + 1);
            }
        }

        protected void mapPositions() {
            int length = this.children_count;
            int start = this.sourceStart;
            if (length != 0) {
                int end = this.firstChildBeforeSorting.sourceStart - 1;
                SortElementBuilder.this.mapNextPosition(this, start, end);
                int i = 0;
                while (i < length) {
                    this.children[i].mapPositions();
                    ++i;
                }
                start = this.lastChildBeforeSorting.sourceEnd + 1;
                SortElementBuilder.this.mapNextPosition(this, start, this.sourceEnd);
            } else {
                SortElementBuilder.this.mapNextPosition(this, start, this.sourceEnd);
            }
        }
    }

    class SortInterfaceDeclaration
    extends SortType {
        SortInterfaceDeclaration(int sourceStart, int modifiers, char[] name, char[][] superinterfaces) {
            super(sourceStart, modifiers, name, superinterfaces);
            this.id = 10;
        }

        void display(StringBuffer buffer, int tab) {
            buffer.append(this.tab(tab)).append("interface ").append(this.name);
            if (this.superInterfaces != null) {
                int length = this.superInterfaces.length;
                buffer.append(" implements ");
                int i = 0;
                while (i < length - 1) {
                    buffer.append(String.valueOf(this.superInterfaces[i]) + ", ");
                    ++i;
                }
                buffer.append(this.superInterfaces[length - 1]);
            }
            buffer.append(SortJavaElement.LINE_SEPARATOR);
        }

        ASTNode convert() {
            TypeDeclaration typeDeclaration = SortElementBuilder.this.ast.newTypeDeclaration();
            typeDeclaration.setInterface(true);
            typeDeclaration.setModifiers(this.modifiers);
            typeDeclaration.setName(SortElementBuilder.this.ast.newSimpleName(this.name));
            if (this.superInterfaces != null) {
                int j = 0;
                int max2 = this.superInterfaces.length;
                while (j < max2) {
                    Name interfaceName;
                    String currentInterfaceName = this.superInterfaces[j];
                    if (currentInterfaceName.indexOf(46) == -1) {
                        interfaceName = SortElementBuilder.this.ast.newSimpleName(currentInterfaceName);
                    } else {
                        String[] interfaceNames = this.splitOn('.', currentInterfaceName);
                        interfaceName = SortElementBuilder.this.ast.newName(interfaceNames);
                    }
                    typeDeclaration.superInterfaces().add(interfaceName);
                    ++j;
                }
            }
            typeDeclaration.setProperty("relativeOrder", new Integer(this.sourceStart));
            return typeDeclaration;
        }
    }

    class SortCompilationUnit
    extends SortElement {
        SortCompilationUnit(int sourceStart) {
            super(sourceStart, 0);
            this.id = 1;
        }

        void display(StringBuffer buffer, int tab) {
        }

        ASTNode convert() {
            return SortElementBuilder.this.ast.newCompilationUnit();
        }

        protected void generateSource(StringBuffer buffer) {
            super.generateSource(buffer);
            int length = this.children_count;
            if (length != 0) {
                int end = this.firstChildBeforeSorting.sourceStart;
                int start = this.lastChildBeforeSorting.sourceEnd + 1;
                buffer.append(SortElementBuilder.this.source, 0, end);
                int i = 0;
                while (i < length) {
                    ((SortElement)this.astNodes[i].getProperty("corresponding_element")).generateSource(buffer);
                    ++i;
                }
                buffer.append(SortElementBuilder.this.source, start, this.sourceEnd - start + 1);
            }
        }

        protected void mapPositions() {
            int length = this.children_count;
            if (length != 0) {
                int end = this.firstChildBeforeSorting.sourceStart;
                int start = this.lastChildBeforeSorting.sourceEnd + 1;
                SortElementBuilder.this.mapNextPosition(this, 0, end);
                int i = 0;
                while (i < length) {
                    this.children[i].mapPositions();
                    ++i;
                }
                SortElementBuilder.this.mapNextPosition(this, start, this.sourceEnd);
            } else {
                SortElementBuilder.this.mapNextPosition(this, this.sourceStart, this.sourceEnd);
            }
        }
    }
}

