/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.BufferChangedEvent;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferChangedListener;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICodeCompletionRequestor;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.codeassist.CompletionEngine;
import org.eclipse.jdt.internal.codeassist.ISearchableNameEnvironment;
import org.eclipse.jdt.internal.codeassist.ISelectionRequestor;
import org.eclipse.jdt.internal.codeassist.SelectionEngine;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.CompletionRequestorWrapper;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.NameLookup;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SearchableEnvironment;
import org.eclipse.jdt.internal.core.SelectionRequestor;
import org.eclipse.jdt.internal.core.Util;

public abstract class Openable
extends JavaElement
implements IOpenable,
IBufferChangedListener {
    protected Openable(int type, IJavaElement parent, String name) {
        super(type, parent, name);
    }

    public void bufferChanged(BufferChangedEvent event) {
        if (event.getBuffer().isClosed()) {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
            this.getBufferManager().removeBuffer(event.getBuffer());
        } else {
            JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().put(this, this);
        }
    }

    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws JavaModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        Iterator iter = newElements.keySet().iterator();
        while (iter.hasNext()) {
            IJavaElement key = (IJavaElement)iter.next();
            Object value = newElements.get(key);
            JavaModelManager.getJavaModelManager().putInfo(key, value);
        }
        JavaModelManager.getJavaModelManager().putInfo(this, info);
    }

    protected void closeBuffer(OpenableElementInfo info) {
        if (!this.hasBuffer()) {
            return;
        }
        IBuffer buffer = null;
        buffer = this.getBufferManager().getBuffer(this);
        if (buffer != null) {
            buffer.close();
            buffer.removeBufferChangedListener(this);
        }
    }

    protected void closing(Object info) throws JavaModelException {
        OpenableElementInfo openableInfo = (OpenableElementInfo)info;
        this.closeBuffer(openableInfo);
        super.closing(info);
    }

    protected void codeComplete(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, ICompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            throw new IllegalArgumentException(Util.bind("codeAssist.nullRequestor"));
        }
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        if (position < -1 || position > buffer.getLength()) {
            throw new JavaModelException(new JavaModelStatus(980));
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        SearchableEnvironment environment = (SearchableEnvironment)project.getSearchableNameEnvironment();
        NameLookup nameLookup = project.getNameLookup();
        environment.unitToSkip = unitToSkip;
        CompletionEngine engine = new CompletionEngine(environment, new CompletionRequestorWrapper(requestor, nameLookup), project.getOptions(true), project);
        engine.complete(cu, position, 0);
        environment.unitToSkip = null;
    }

    protected IJavaElement[] codeSelect(ICompilationUnit cu, int offset, int length) throws JavaModelException {
        SelectionRequestor requestor = new SelectionRequestor(((JavaProject)this.getJavaProject()).getNameLookup(), this);
        this.codeSelect(cu, offset, length, requestor);
        return requestor.getElements();
    }

    protected void codeSelect(ICompilationUnit cu, int offset, int length, ISelectionRequestor requestor) throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return;
        }
        int end = buffer.getLength();
        if (offset < 0 || length < 0 || offset + length > end) {
            throw new JavaModelException(new JavaModelStatus(980));
        }
        JavaProject project = (JavaProject)this.getJavaProject();
        ISearchableNameEnvironment environment = project.getSearchableNameEnvironment();
        SelectionEngine engine = new SelectionEngine(environment, requestor, project.getOptions(true));
        engine.select(cu, offset, offset + length - 1);
    }

    protected OpenableElementInfo createElementInfo() {
        return new OpenableElementInfo();
    }

    protected abstract boolean generateInfos(OpenableElementInfo var1, IProgressMonitor var2, Map var3, IResource var4) throws JavaModelException;

    public IBuffer getBuffer() throws JavaModelException {
        if (this.hasBuffer()) {
            IBuffer buffer;
            if (!this.isOpen()) {
                this.getElementInfo();
            }
            if ((buffer = this.getBufferManager().getBuffer(this)) == null) {
                buffer = this.openBuffer(null);
            }
            return buffer;
        }
        return null;
    }

    public IBufferFactory getBufferFactory() {
        return this.getBufferManager().getDefaultBufferFactory();
    }

    protected BufferManager getBufferManager() {
        return BufferManager.getDefaultBufferManager();
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        return this.getUnderlyingResource();
    }

    public IOpenable getOpenable() {
        return this;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        IResource parentResource = this.fParent.getUnderlyingResource();
        if (parentResource == null) {
            return null;
        }
        int type = parentResource.getType();
        if (type == 2 || type == 4) {
            IContainer folder = (IContainer)parentResource;
            IResource resource = folder.findMember(this.fName);
            if (resource == null) {
                throw this.newNotPresentException();
            }
            return resource;
        }
        return parentResource;
    }

    public boolean exists() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root == null || root == this || !root.isArchive()) {
            return this.parentExists() && this.resourceExists();
        }
        return super.exists();
    }

    protected boolean hasBuffer() {
        return false;
    }

    public boolean hasChildren() throws JavaModelException {
        return this.getChildren().length > 0;
    }

    public boolean hasUnsavedChanges() throws JavaModelException {
        if (this.isReadOnly() || !this.isOpen()) {
            return false;
        }
        IBuffer buf = this.getBuffer();
        if (buf != null && buf.hasUnsavedChanges()) {
            return true;
        }
        if (this.fLEType == 4 || this.fLEType == 3 || this.fLEType == 2 || this.fLEType == 1) {
            Enumeration openBuffers = this.getBufferManager().getOpenBuffers();
            while (openBuffers.hasMoreElements()) {
                IJavaElement owner;
                IBuffer buffer = (IBuffer)openBuffers.nextElement();
                if (!buffer.hasUnsavedChanges() || !this.isAncestorOf(owner = (IJavaElement)((Object)buffer.getOwner()))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isConsistent() throws JavaModelException {
        return true;
    }

    public boolean isOpen() {
        JavaModelManager javaModelManager = JavaModelManager.getJavaModelManager();
        synchronized (javaModelManager) {
            return JavaModelManager.getJavaModelManager().getInfo(this) != null;
        }
    }

    protected boolean isSourceElement() {
        return false;
    }

    public void makeConsistent(IProgressMonitor pm) throws JavaModelException {
        if (!this.isConsistent()) {
            this.buildStructure((OpenableElementInfo)this.getElementInfo(), pm);
        }
    }

    public void open(IProgressMonitor pm) throws JavaModelException {
        if (!this.isOpen()) {
            this.openWhenClosed(pm);
        }
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws JavaModelException {
        return null;
    }

    protected void openParent(IProgressMonitor pm) throws JavaModelException {
        Openable openableParent = (Openable)this.getOpenableParent();
        if (openableParent != null && !openableParent.isOpen()) {
            openableParent.openWhenClosed(pm);
        }
    }

    protected void openWhenClosed(IProgressMonitor pm) throws JavaModelException {
        try {
            if (JavaModelManager.VERBOSE) {
                System.out.println("OPENING Element (" + Thread.currentThread() + "): " + this.toStringWithAncestors());
            }
            this.openParent(pm);
            OpenableElementInfo info = this.createElementInfo();
            if (this.isSourceElement()) {
                this.openBuffer(pm);
            }
            this.buildStructure(info, pm);
            this.opening(info);
            if (JavaModelManager.VERBOSE) {
                System.out.println("-> Package cache size = " + JavaModelManager.getJavaModelManager().cache.pkgSize());
                System.out.println("-> Openable cache filling ratio = " + JavaModelManager.getJavaModelManager().cache.openableFillingRatio() + "%");
            }
        }
        catch (JavaModelException e) {
            JavaModelManager.getJavaModelManager().removeInfo(this);
            throw e;
        }
    }

    protected boolean parentExists() {
        IJavaElement parent = this.getParent();
        if (parent == null) {
            return true;
        }
        return parent.exists();
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return JavaModel.getTarget(workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    public void save(IProgressMonitor pm, boolean force) throws JavaModelException {
        if (this.isReadOnly() || this.getResource().isReadOnly()) {
            throw new JavaModelException(new JavaModelStatus(976, this));
        }
        IBuffer buf = this.getBuffer();
        if (buf != null) {
            buf.save(pm, force);
            this.makeConsistent(pm);
        }
    }

    public PackageFragmentRoot getPackageFragmentRoot() {
        IJavaElement current = this;
        do {
            if (!(current instanceof PackageFragmentRoot)) continue;
            return (PackageFragmentRoot)current;
        } while ((current = current.getParent()) != null);
        return null;
    }

    protected void codeComplete(ICompilationUnit cu, ICompilationUnit unitToSkip, int position, final ICodeCompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            this.codeComplete(cu, unitToSkip, position, (ICompletionRequestor)null);
            return;
        }
        this.codeComplete(cu, unitToSkip, position, new ICompletionRequestor(){

            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptError(IProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptField(declaringTypePackageName, declaringTypeName, name, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptKeyword(keywordName, completionStart, completionEnd);
            }

            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptLabel(labelName, completionStart, completionEnd);
            }

            public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptModifier(modifierName, completionStart, completionEnd);
            }

            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptPackage(packageName, completionName, completionStart, completionEnd);
            }

            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd);
            }

            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int completionStart, int completionEnd, int relevance) {
            }
        });
    }
}

