/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IBufferFactory;
import org.eclipse.jdt.core.ICodeCompletionRequestor;
import org.eclipse.jdt.core.ICompletionRequestor;
import org.eclipse.jdt.core.IImportContainer;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.jdom.IDOMNode;
import org.eclipse.jdt.internal.compiler.IAbstractSyntaxTreeVisitor;
import org.eclipse.jdt.internal.compiler.SourceElementParser;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblemFactory;
import org.eclipse.jdt.internal.core.BufferManager;
import org.eclipse.jdt.internal.core.CompilationUnitElementInfo;
import org.eclipse.jdt.internal.core.CompilationUnitStructureRequestor;
import org.eclipse.jdt.internal.core.CompilationUnitVisitor;
import org.eclipse.jdt.internal.core.CreateCompilationUnitOperation;
import org.eclipse.jdt.internal.core.CreateImportOperation;
import org.eclipse.jdt.internal.core.CreatePackageDeclarationOperation;
import org.eclipse.jdt.internal.core.CreateTypeOperation;
import org.eclipse.jdt.internal.core.CreateWorkingCopyOperation;
import org.eclipse.jdt.internal.core.ImportContainer;
import org.eclipse.jdt.internal.core.ImportDeclaration;
import org.eclipse.jdt.internal.core.JarPackageFragment;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;
import org.eclipse.jdt.internal.core.Openable;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageDeclaration;
import org.eclipse.jdt.internal.core.PackageFragmentRoot;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.jdt.internal.core.Util;
import org.eclipse.jdt.internal.core.WorkingCopy;

public class CompilationUnit
extends Openable
implements org.eclipse.jdt.core.ICompilationUnit,
ICompilationUnit {
    public static boolean SHARED_WC_VERBOSE = false;
    public static final boolean FIX_BUG25184 = true;

    protected CompilationUnit(IPackageFragment parent, String name) {
        super(5, parent, name);
        if (!Util.isJavaFileName(name)) {
            throw new IllegalArgumentException(Util.bind("convention.unit.notJavaName"));
        }
    }

    public void accept(IAbstractSyntaxTreeVisitor visitor) throws JavaModelException {
        CompilationUnitVisitor.visit(this, visitor);
    }

    protected void buildStructure(OpenableElementInfo info, IProgressMonitor monitor) throws JavaModelException {
        if (monitor != null && monitor.isCanceled()) {
            return;
        }
        this.removeInfo();
        HashMap newElements = new HashMap(11);
        info.setIsStructureKnown(this.generateInfos(info, monitor, newElements, this.getResource()));
        JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().remove(this);
        Iterator iter = newElements.keySet().iterator();
        while (iter.hasNext()) {
            IJavaElement key = (IJavaElement)iter.next();
            Object value = newElements.get(key);
            JavaModelManager.getJavaModelManager().putInfo(key, value);
        }
        JavaModelManager.getJavaModelManager().putInfo(this, info);
    }

    public void codeComplete(int offset, ICompletionRequestor requestor) throws JavaModelException {
        this.codeComplete((ICompilationUnit)this, this.isWorkingCopy() ? (ICompilationUnit)((Object)this.getOriginalElement()) : this, offset, requestor);
    }

    public IJavaElement[] codeSelect(int offset, int length) throws JavaModelException {
        return super.codeSelect(this, offset, length);
    }

    public void commit(boolean force, IProgressMonitor monitor) throws JavaModelException {
        throw new JavaModelException(new JavaModelStatus(967, this));
    }

    public void copy(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (container == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullContainer"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] containers = new IJavaElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaModel().copy(elements, containers, null, renamings, force, monitor);
    }

    protected OpenableElementInfo createElementInfo() {
        return new CompilationUnitElementInfo();
    }

    public IImportDeclaration createImport(String name, IJavaElement sibling, IProgressMonitor monitor) throws JavaModelException {
        CreateImportOperation op = new CreateImportOperation(name, this);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        JavaElement.runOperation(op, monitor);
        return this.getImport(name);
    }

    public IPackageDeclaration createPackageDeclaration(String name, IProgressMonitor monitor) throws JavaModelException {
        CreatePackageDeclarationOperation op = new CreatePackageDeclarationOperation(name, this);
        JavaElement.runOperation(op, monitor);
        return this.getPackageDeclaration(name);
    }

    public IType createType(String content, IJavaElement sibling, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (!this.exists()) {
            IPackageFragment pkg = (IPackageFragment)this.getParent();
            String source = "";
            if (pkg.getElementName().length() > 0) {
                source = "package " + pkg.getElementName() + ";" + org.eclipse.jdt.internal.compiler.util.Util.LINE_SEPARATOR + org.eclipse.jdt.internal.compiler.util.Util.LINE_SEPARATOR;
            }
            CreateCompilationUnitOperation op = new CreateCompilationUnitOperation(pkg, this.fName, source, force);
            JavaElement.runOperation(op, monitor);
        }
        CreateTypeOperation op = new CreateTypeOperation(this, content, force);
        if (sibling != null) {
            op.createBefore(sibling);
        }
        JavaElement.runOperation(op, monitor);
        return (IType)op.getResultElements()[0];
    }

    public void delete(boolean force, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] elements = new IJavaElement[]{this};
        this.getJavaModel().delete(elements, force, monitor);
    }

    public void destroy() {
    }

    public boolean equals(Object o) {
        return super.equals(o) && !((org.eclipse.jdt.core.ICompilationUnit)o).isWorkingCopy();
    }

    protected boolean equalsDOMNode(IDOMNode node) throws JavaModelException {
        String name = this.getElementName();
        if (node.getNodeType() == 1 && name != null) {
            String nodeName = node.getName();
            if (nodeName == null) {
                return false;
            }
            if (name.equals(nodeName)) {
                return true;
            }
            IType[] types = this.getTypes();
            String typeNodeName = nodeName.substring(0, nodeName.indexOf(".java"));
            int i = 0;
            int max = types.length;
            while (i < max) {
                if (types[i].getElementName().equals(typeNodeName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public IJavaElement[] findElements(IJavaElement element) {
        ArrayList<IJavaElement> children = new ArrayList<IJavaElement>();
        while (element != null && element.getElementType() != 5) {
            children.add(element);
            element = element.getParent();
        }
        if (element == null) {
            return null;
        }
        ISourceReference currentElement = this;
        int i = children.size() - 1;
        while (i >= 0) {
            IJavaElement child = (IJavaElement)children.get(i);
            switch (child.getElementType()) {
                case 11: {
                    currentElement = ((org.eclipse.jdt.core.ICompilationUnit)currentElement).getPackageDeclaration(child.getElementName());
                    break;
                }
                case 12: {
                    currentElement = ((org.eclipse.jdt.core.ICompilationUnit)currentElement).getImportContainer();
                    break;
                }
                case 13: {
                    currentElement = ((IImportContainer)currentElement).getImport(child.getElementName());
                    break;
                }
                case 7: {
                    if (currentElement.getElementType() == 5) {
                        currentElement = ((org.eclipse.jdt.core.ICompilationUnit)currentElement).getType(child.getElementName());
                        break;
                    }
                    currentElement = ((IType)currentElement).getType(child.getElementName());
                    break;
                }
                case 10: {
                    currentElement = ((IType)currentElement).getInitializer(((JavaElement)child).getOccurrenceCount());
                    break;
                }
                case 8: {
                    currentElement = ((IType)currentElement).getField(child.getElementName());
                    break;
                }
                case 9: {
                    return ((IType)currentElement).findMethods((IMethod)child);
                }
            }
            --i;
        }
        if (currentElement != null && currentElement.exists()) {
            return new IJavaElement[]{currentElement};
        }
        return null;
    }

    public IType findPrimaryType() {
        String typeName = Signature.getQualifier(this.getElementName());
        IType primaryType = this.getType(typeName);
        if (primaryType.exists()) {
            return primaryType;
        }
        return null;
    }

    public IJavaElement findSharedWorkingCopy(IBufferFactory factory) {
        Map sharedWorkingCopies;
        Map perFactoryWorkingCopies;
        if (factory == null) {
            factory = this.getBufferManager().getDefaultBufferFactory();
        }
        if ((perFactoryWorkingCopies = (Map)(sharedWorkingCopies = JavaModelManager.getJavaModelManager().sharedWorkingCopies).get(factory)) == null) {
            return null;
        }
        return (WorkingCopy)perFactoryWorkingCopies.get(this);
    }

    protected boolean generateInfos(OpenableElementInfo info, IProgressMonitor pm, Map newElements, IResource underlyingResource) throws JavaModelException {
        if (this.getParent() instanceof JarPackageFragment) {
            throw this.newNotPresentException();
        }
        JavaModelManager.getJavaModelManager().putInfo(this, info);
        CompilationUnitElementInfo unitInfo = (CompilationUnitElementInfo)info;
        CompilationUnitStructureRequestor requestor = new CompilationUnitStructureRequestor(this, unitInfo, newElements);
        DefaultProblemFactory factory = new DefaultProblemFactory();
        SourceElementParser parser = new SourceElementParser(requestor, factory, new CompilerOptions(this.getJavaProject().getOptions(true)));
        requestor.parser = parser;
        parser.parseCompilationUnit(this, false);
        if (this.isWorkingCopy()) {
            CompilationUnit original = (CompilationUnit)this.getOriginalElement();
            unitInfo.fTimestamp = ((IFile)original.getResource()).getModificationStamp();
        }
        return unitInfo.isStructureKnown();
    }

    public IType[] getAllTypes() throws JavaModelException {
        IType[] types = this.getTypes();
        ArrayList<IType> allTypes = new ArrayList<IType>(types.length);
        ArrayList<IType> typesToTraverse = new ArrayList<IType>(types.length);
        int i = 0;
        while (i < types.length) {
            typesToTraverse.add(types[i]);
            ++i;
        }
        while (!typesToTraverse.isEmpty()) {
            IType type = (IType)typesToTraverse.get(0);
            ((AbstractCollection)typesToTraverse).remove(type);
            allTypes.add(type);
            types = type.getTypes();
            i = 0;
            while (i < types.length) {
                typesToTraverse.add(types[i]);
                ++i;
            }
        }
        IType[] arrayOfAllTypes = new IType[allTypes.size()];
        allTypes.toArray(arrayOfAllTypes);
        return arrayOfAllTypes;
    }

    public org.eclipse.jdt.core.ICompilationUnit getCompilationUnit() {
        return this;
    }

    public char[] getContents() {
        try {
            IBuffer buffer = this.getBuffer();
            return buffer == null ? null : buffer.getCharacters();
        }
        catch (JavaModelException e) {
            return CharOperation.NO_CHAR;
        }
    }

    public IResource getCorrespondingResource() throws JavaModelException {
        IPackageFragmentRoot root = (IPackageFragmentRoot)this.getParent().getParent();
        if (root.isArchive()) {
            return null;
        }
        return this.getUnderlyingResource();
    }

    public IJavaElement getElementAt(int position) throws JavaModelException {
        IJavaElement e = this.getSourceElementAt(position);
        if (e == this) {
            return null;
        }
        return e;
    }

    public char[] getFileName() {
        return this.getElementName().toCharArray();
    }

    protected char getHandleMementoDelimiter() {
        return '{';
    }

    public IImportDeclaration getImport(String name) {
        return new ImportDeclaration(this.getImportContainer(), name);
    }

    public IImportContainer getImportContainer() {
        return new ImportContainer(this);
    }

    public IImportDeclaration[] getImports() throws JavaModelException {
        IImportContainer container = this.getImportContainer();
        if (container.exists()) {
            IJavaElement[] elements = container.getChildren();
            IImportDeclaration[] imprts = new IImportDeclaration[elements.length];
            System.arraycopy(elements, 0, imprts, 0, elements.length);
            return imprts;
        }
        if (!this.exists()) {
            throw this.newNotPresentException();
        }
        return new IImportDeclaration[0];
    }

    public char[] getMainTypeName() {
        String name = this.getElementName();
        name = name.substring(0, name.length() - 5);
        return name.toCharArray();
    }

    public IJavaElement getOriginal(IJavaElement workingCopyElement) {
        return null;
    }

    public IJavaElement getOriginalElement() {
        return null;
    }

    public IPackageDeclaration getPackageDeclaration(String name) {
        return new PackageDeclaration(this, name);
    }

    public IPackageDeclaration[] getPackageDeclarations() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(11);
        IPackageDeclaration[] array = new IPackageDeclaration[list.size()];
        list.toArray(array);
        return array;
    }

    public char[][] getPackageName() {
        return null;
    }

    public IPath getPath() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getPath();
        }
        return this.getParent().getPath().append(this.getElementName());
    }

    public IResource getResource() {
        PackageFragmentRoot root = this.getPackageFragmentRoot();
        if (root.isArchive()) {
            return root.getResource();
        }
        return ((IContainer)this.getParent().getResource()).getFile(new Path(this.getElementName()));
    }

    public String getSource() throws JavaModelException {
        IBuffer buffer = this.getBuffer();
        if (buffer == null) {
            return "";
        }
        return buffer.getContents();
    }

    public ISourceRange getSourceRange() throws JavaModelException {
        return ((CompilationUnitElementInfo)this.getElementInfo()).getSourceRange();
    }

    public IType getType(String name) {
        return new SourceType(this, name);
    }

    public IType[] getTypes() throws JavaModelException {
        ArrayList list = this.getChildrenOfType(7);
        IType[] array = new IType[list.size()];
        list.toArray(array);
        return array;
    }

    public IResource getUnderlyingResource() throws JavaModelException {
        return super.getUnderlyingResource();
    }

    public IJavaElement getSharedWorkingCopy(IProgressMonitor pm, IBufferFactory factory, IProblemRequestor problemRequestor) throws JavaModelException {
        WorkingCopy workingCopy;
        if (factory == null) {
            factory = this.getBufferManager().getDefaultBufferFactory();
        }
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        Map sharedWorkingCopies = manager.sharedWorkingCopies;
        HashMap perFactoryWorkingCopies = (HashMap)sharedWorkingCopies.get(factory);
        if (perFactoryWorkingCopies == null) {
            perFactoryWorkingCopies = new HashMap();
            sharedWorkingCopies.put(factory, perFactoryWorkingCopies);
        }
        if ((workingCopy = (WorkingCopy)perFactoryWorkingCopies.get(this)) != null) {
            ++workingCopy.useCount;
            if (SHARED_WC_VERBOSE) {
                System.out.println("Incrementing use count of shared working copy " + workingCopy.toStringWithAncestors());
            }
            return workingCopy;
        }
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, perFactoryWorkingCopies, factory, problemRequestor);
        JavaElement.runOperation(op, pm);
        return op.getResultElements()[0];
    }

    public IJavaElement getWorkingCopy() throws JavaModelException {
        return this.getWorkingCopy(null, null, null);
    }

    public IJavaElement getWorkingCopy(IProgressMonitor pm, IBufferFactory factory, IProblemRequestor problemRequestor) throws JavaModelException {
        CreateWorkingCopyOperation op = new CreateWorkingCopyOperation(this, null, factory, problemRequestor);
        JavaElement.runOperation(op, pm);
        return op.getResultElements()[0];
    }

    protected boolean hasBuffer() {
        return true;
    }

    public boolean hasChildren() throws JavaModelException {
        if (this.isOpen()) {
            return this.getChildren().length > 0;
        }
        return true;
    }

    public boolean isBasedOn(IResource resource) {
        return false;
    }

    public boolean isConsistent() throws JavaModelException {
        return JavaModelManager.getJavaModelManager().getElementsOutOfSynchWithBuffers().get(this) == null;
    }

    protected boolean isSourceElement() {
        return true;
    }

    public boolean isWorkingCopy() {
        return false;
    }

    public void makeConsistent(IProgressMonitor monitor) throws JavaModelException {
        if (!this.isConsistent()) {
            OpenableElementInfo info = this.createElementInfo();
            this.buildStructure(info, monitor);
        }
    }

    public void move(IJavaElement container, IJavaElement sibling, String rename, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (container == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullContainer"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] containers = new IJavaElement[]{container};
        String[] renamings = null;
        if (rename != null) {
            renamings = new String[]{rename};
        }
        this.getJavaModel().move(elements, containers, null, renamings, force, monitor);
    }

    protected IBuffer openBuffer(IProgressMonitor pm) throws JavaModelException {
        BufferManager bufManager = this.getBufferManager();
        IBuffer buffer = this.getBufferFactory().createBuffer(this);
        if (buffer == null) {
            return null;
        }
        if (buffer.getCharacters() == null) {
            IFile file = (IFile)this.getResource();
            if (file == null || !file.exists()) {
                throw this.newNotPresentException();
            }
            buffer.setContents(Util.getResourceContentsAsCharArray(file));
        }
        bufManager.addBuffer(buffer);
        buffer.addBufferChangedListener(this);
        return buffer;
    }

    protected void openParent(IProgressMonitor pm) throws JavaModelException {
        super.openParent(pm);
    }

    protected boolean parentExists() {
        return super.parentExists();
    }

    public IMarker[] reconcile() throws JavaModelException {
        return null;
    }

    public void reconcile(boolean forceProblemDetection, IProgressMonitor monitor) throws JavaModelException {
    }

    public void rename(String name, boolean force, IProgressMonitor monitor) throws JavaModelException {
        if (name == null) {
            throw new IllegalArgumentException(Util.bind("operation.nullName"));
        }
        IJavaElement[] elements = new IJavaElement[]{this};
        IJavaElement[] dests = new IJavaElement[]{this.getParent()};
        String[] renamings = new String[]{name};
        this.getJavaModel().rename(elements, dests, renamings, force, monitor);
    }

    public void restore() throws JavaModelException {
    }

    public void codeComplete(int offset, final ICodeCompletionRequestor requestor) throws JavaModelException {
        if (requestor == null) {
            this.codeComplete(offset, (ICompletionRequestor)null);
            return;
        }
        this.codeComplete(offset, new ICompletionRequestor(){

            public void acceptAnonymousType(char[] superTypePackageName, char[] superTypeName, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptClass(char[] packageName, char[] className, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptClass(packageName, className, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptError(IProblem error) {
            }

            public void acceptField(char[] declaringTypePackageName, char[] declaringTypeName, char[] name, char[] typePackageName, char[] typeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptField(declaringTypePackageName, declaringTypeName, name, typePackageName, typeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptInterface(char[] packageName, char[] interfaceName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptInterface(packageName, interfaceName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptKeyword(char[] keywordName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptKeyword(keywordName, completionStart, completionEnd);
            }

            public void acceptLabel(char[] labelName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptLabel(labelName, completionStart, completionEnd);
            }

            public void acceptLocalVariable(char[] name, char[] typePackageName, char[] typeName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptMethod(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
                requestor.acceptMethod(declaringTypePackageName, declaringTypeName, selector, parameterPackageNames, parameterTypeNames, returnTypePackageName, returnTypeName, completionName, modifiers, completionStart, completionEnd);
            }

            public void acceptMethodDeclaration(char[] declaringTypePackageName, char[] declaringTypeName, char[] selector, char[][] parameterPackageNames, char[][] parameterTypeNames, char[][] parameterNames, char[] returnTypePackageName, char[] returnTypeName, char[] completionName, int modifiers, int completionStart, int completionEnd, int relevance) {
            }

            public void acceptModifier(char[] modifierName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptModifier(modifierName, completionStart, completionEnd);
            }

            public void acceptPackage(char[] packageName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptPackage(packageName, completionName, completionStart, completionEnd);
            }

            public void acceptType(char[] packageName, char[] typeName, char[] completionName, int completionStart, int completionEnd, int relevance) {
                requestor.acceptType(packageName, typeName, completionName, completionStart, completionEnd);
            }

            public void acceptVariableName(char[] typePackageName, char[] typeName, char[] name, char[] completionName, int completionStart, int completionEnd, int relevance) {
            }
        });
    }

    public IJavaElement rootedAt(IJavaProject project) {
        return new CompilationUnit((IPackageFragment)((JavaElement)this.fParent).rootedAt(project), this.fName);
    }
}

