/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaModelStatus;
import org.eclipse.jdt.internal.core.JavaModelStatus;

public class JavaModelException
extends CoreException {
    CoreException nestedCoreException;

    public JavaModelException(Throwable e, int code) {
        this(new JavaModelStatus(code, e));
    }

    public JavaModelException(CoreException exception) {
        super(exception.getStatus());
        this.nestedCoreException = exception;
    }

    public JavaModelException(IJavaModelStatus status) {
        super(status);
    }

    public Throwable getException() {
        if (this.nestedCoreException == null) {
            return this.getStatus().getException();
        }
        return this.nestedCoreException;
    }

    public IJavaModelStatus getJavaModelStatus() {
        IStatus status = this.getStatus();
        if (status instanceof IJavaModelStatus) {
            return (IJavaModelStatus)status;
        }
        return new JavaModelStatus(this.nestedCoreException);
    }

    public boolean isDoesNotExist() {
        IJavaModelStatus javaModelStatus = this.getJavaModelStatus();
        return javaModelStatus != null && javaModelStatus.isDoesNotExist();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Java Model Exception: ");
        if (this.getException() != null) {
            if (this.getException() instanceof CoreException) {
                CoreException c = (CoreException)this.getException();
                buffer.append("Core Exception [code ");
                buffer.append(c.getStatus().getCode());
                buffer.append("] ");
                buffer.append(c.getStatus().getMessage());
            } else {
                buffer.append(this.getException().toString());
            }
        } else {
            buffer.append(this.getStatus().toString());
        }
        return buffer.toString();
    }
}

