/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class PreferenceExporter {
    private static final char PLUGIN_SEPARATOR = '/';

    public static void exportPreferences(IPath file) throws CoreException {
        Properties globalPreferences = new Properties();
        IPluginDescriptor[] descriptors = Platform.getPluginRegistry().getPluginDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            IPluginDescriptor descriptor = descriptors[i];
            if (descriptor.isPluginActivated()) {
                descriptor.getPlugin().savePluginPreferences();
            }
            if (PreferenceExporter.mergePluginPreferences(descriptor, globalPreferences)) {
                ((Hashtable)globalPreferences).put(descriptor.getUniqueIdentifier(), descriptor.getVersionIdentifier().toString());
            }
            ++i;
        }
        PreferenceExporter.storePreferences(file, globalPreferences);
    }

    public static void importPreferences(IPath file) throws CoreException {
        if (!file.toFile().exists()) {
            String msg = Policy.bind("preferences.fileNotFound", file.toOSString());
            throw new CoreException(new Status(4, "org.eclipse.core.runtime", 1, msg, null));
        }
        Map idsToProperties = PreferenceExporter.splitPreferences(file);
        IPluginDescriptor[] descriptors = Platform.getPluginRegistry().getPluginDescriptors();
        int i = 0;
        while (i < descriptors.length) {
            PreferenceExporter.setPluginPreferences(descriptors[i], (Properties)idsToProperties.get(descriptors[i].getUniqueIdentifier()));
            ++i;
        }
    }

    private static Preferences loadPreferences(IPath properties, Preferences preferences) throws CoreException {
        block12: {
            File propertiesFile = properties.toFile();
            if (!propertiesFile.exists()) break block12;
            BufferedInputStream in = null;
            try {
                try {
                    in = new BufferedInputStream(new FileInputStream(propertiesFile));
                    preferences.load(in);
                }
                catch (IOException e) {
                    String msg = Policy.bind("preferences.errorReading", propertiesFile.toString(), e.getMessage());
                    throw new CoreException(new Status(4, "org.eclipse.core.runtime", 1, msg, e));
                }
                catch (IllegalArgumentException e) {
                    String msg = Policy.bind("preferences.errorReading", propertiesFile.toString(), e.getMessage());
                    throw new CoreException(new Status(4, "org.eclipse.core.runtime", 1, msg, e));
                }
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            Object var6_10 = null;
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return preferences;
    }

    private static boolean mergePluginPreferences(IPluginDescriptor descriptor, Properties globalProperties) throws CoreException {
        boolean found = false;
        IPath propertiesFile = InternalPlatform.getMetaArea().getPluginPreferenceLocation(descriptor, false);
        if (propertiesFile.toFile().exists()) {
            Preferences pluginPreferences = PreferenceExporter.loadPreferences(propertiesFile, new Preferences());
            String pluginId = descriptor.getUniqueIdentifier();
            String[] keys = pluginPreferences.propertyNames();
            found = keys.length > 0;
            int i = 0;
            while (i < keys.length) {
                String longKey = String.valueOf(pluginId) + '/' + keys[i];
                ((Hashtable)globalProperties).put(longKey, pluginPreferences.getString(keys[i]));
                ++i;
            }
        }
        return found;
    }

    private static void setPluginPreferences(IPluginDescriptor descriptor, Properties newProperties) throws CoreException {
        IPath location = InternalPlatform.getMetaArea().getPluginPreferenceLocation(descriptor, false);
        if (descriptor.isPluginActivated()) {
            Plugin plugin = descriptor.getPlugin();
            if (plugin != null) {
                Preferences oldPreferences = plugin.getPluginPreferences();
                String[] keys = oldPreferences.propertyNames();
                int i = 0;
                while (i < keys.length) {
                    keys[i] = keys[i].intern();
                    oldPreferences.setToDefault(keys[i]);
                    ++i;
                }
                if (newProperties != null) {
                    Enumeration<?> e = newProperties.propertyNames();
                    while (e.hasMoreElements()) {
                        String key = ((String)e.nextElement()).intern();
                        oldPreferences.setValue(key, newProperties.getProperty(key));
                    }
                }
                PreferenceExporter.storePreferences(location, oldPreferences);
            }
        } else {
            PreferenceExporter.storePreferences(location, newProperties);
        }
    }

    private static Map splitPreferences(IPath file) throws CoreException {
        Preferences globalPreferences = PreferenceExporter.loadPreferences(file, new Preferences());
        PreferenceExporter.validatePreferenceFileFormat(globalPreferences);
        HashMap<String, Properties> idsToProperties = new HashMap<String, Properties>();
        String[] keys = globalPreferences.propertyNames();
        int i = 0;
        while (i < keys.length) {
            String longKey = keys[i];
            int index = longKey.indexOf(47);
            if (index >= 0) {
                String pluginId = longKey.substring(0, index);
                String key = longKey.substring(index + 1);
                Properties properties = (Properties)idsToProperties.get(pluginId);
                if (properties == null) {
                    properties = new Properties();
                    idsToProperties.put(pluginId, properties);
                }
                ((Hashtable)properties).put(key, globalPreferences.getString(longKey));
            }
            ++i;
        }
        return idsToProperties;
    }

    private static void storePreferences(IPath destination, Object preferences) throws CoreException {
        block14: {
            File propertiesFile = destination.toFile();
            if (preferences == null || preferences instanceof Properties && ((Hashtable)((Properties)preferences)).size() == 0 || preferences instanceof Preferences && ((Preferences)preferences).propertyNames().length == 0) {
                propertiesFile.delete();
                return;
            }
            File parent = propertiesFile.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            BufferedOutputStream out = null;
            try {
                try {
                    out = new BufferedOutputStream(new FileOutputStream(propertiesFile));
                    if (preferences instanceof Properties) {
                        ((Properties)preferences).store(out, null);
                    } else {
                        ((Preferences)preferences).store(out, null);
                    }
                }
                catch (IOException e) {
                    String msg = Policy.bind("preferences.errorWriting", propertiesFile.toString(), e.getMessage());
                    throw new CoreException(new Status(4, "org.eclipse.core.runtime", 1, msg, e));
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (out != null) {
                    try {
                        ((OutputStream)out).close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                throw throwable;
            }
            Object var7_9 = null;
            if (out == null) break block14;
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static void validatePluginVersions(String pluginId, PluginVersionIdentifier pref, PluginVersionIdentifier installed, MultiStatus result) {
        if (installed.getMajorComponent() == pref.getMajorComponent() && installed.getMinorComponent() == pref.getMinorComponent()) {
            return;
        }
        int severity = installed.getMajorComponent() < pref.getMajorComponent() ? 4 : 2;
        String msg = Policy.bind("preferences.incompatible", new String[]{pref.toString(), pluginId, installed.toString()});
        result.add(new Status(severity, "org.eclipse.core.runtime", 1, msg, null));
    }

    private static void validatePreferenceFileFormat(Preferences preferences) throws CoreException {
        String[] names = preferences.propertyNames();
        int i = 0;
        while (i < names.length) {
            String versionId;
            String pluginId = null;
            int separator = names[i].indexOf(47);
            if (separator >= 0) {
                pluginId = names[i].substring(0, separator);
                versionId = preferences.getString(pluginId);
                if (versionId == null || versionId.length() == 0) {
                    String msg = Policy.bind("preferences.invalidProperty", names[i], preferences.getString(names[i]));
                    throw new CoreException(new Status(4, "org.eclipse.core.runtime", 0, msg, null));
                }
            } else {
                pluginId = names[i];
                versionId = preferences.getString(pluginId);
                if (!PluginVersionIdentifier.validateVersion(versionId).isOK()) {
                    String msg = Policy.bind("preferences.invalidProperty", names[i], preferences.getString(names[i]));
                    throw new CoreException(new Status(4, "org.eclipse.core.runtime", 0, msg, null));
                }
            }
            ++i;
        }
    }

    public static IStatus validatePreferenceVersions(IPath file) {
        String msg = Policy.bind("preferences.validate");
        MultiStatus result = new MultiStatus("org.eclipse.core.runtime", 1, msg, null);
        Preferences globalPreferences = null;
        try {
            globalPreferences = PreferenceExporter.loadPreferences(file, new Preferences());
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        IPluginRegistry registry = Platform.getPluginRegistry();
        String[] keys = globalPreferences.propertyNames();
        int i = 0;
        while (i < keys.length) {
            String version;
            IPluginDescriptor descriptor;
            String pluginId = keys[i];
            if (pluginId.indexOf(47) < 0 && (descriptor = registry.getPluginDescriptor(pluginId)) != null && PluginVersionIdentifier.validateVersion(version = globalPreferences.getString(pluginId)).isOK()) {
                PluginVersionIdentifier preferenceVersion = new PluginVersionIdentifier(version);
                PluginVersionIdentifier installedVersion = descriptor.getVersionIdentifier();
                PreferenceExporter.validatePluginVersions(pluginId, preferenceVersion, installedVersion, result);
            }
            ++i;
        }
        return result;
    }
}

