/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.plugins;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.internal.plugins.Extension;
import org.eclipse.core.internal.plugins.IPluginVisitor;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.internal.plugins.PluginPrerequisite;
import org.eclipse.core.internal.plugins.RegistryCacheReader;
import org.eclipse.core.internal.plugins.RegistryCacheWriter;
import org.eclipse.core.internal.plugins.RegistryWriter;
import org.eclipse.core.internal.runtime.InternalPlatform;
import org.eclipse.core.internal.runtime.Policy;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.model.ConfigurationElementModel;
import org.eclipse.core.runtime.model.ExtensionPointModel;
import org.eclipse.core.runtime.model.PluginDescriptorModel;
import org.eclipse.core.runtime.model.PluginPrerequisiteModel;
import org.eclipse.core.runtime.model.PluginRegistryModel;

public class PluginRegistry
extends PluginRegistryModel
implements IPluginRegistry {
    private static final String URL_PROTOCOL_FILE = "file";
    private static final String F_DEBUG_REGISTRY = ".debugregistry";
    private static final int STARTUP = 0;
    private static final int SHUTDOWN = 1;
    private RegistryCacheReader registryCacheReader;
    private final File registryCacheFile = InternalPlatform.getMetaArea().getRegistryPath().toFile();

    public void accept(IPluginVisitor visitor, boolean activeOnly) {
        Map dependents = this.getDependentCounts(activeOnly);
        while (!dependents.isEmpty()) {
            PluginDescriptor[] keys = dependents.keySet().toArray(new PluginDescriptor[dependents.size()]);
            int i = 0;
            while (i < keys.length) {
                PluginDescriptor descriptor = keys[i];
                Integer entry = (Integer)dependents.get(descriptor);
                if (entry != null && entry <= 0) {
                    visitor.visit(descriptor);
                    dependents.remove(descriptor);
                    PluginPrerequisiteModel[] requires = descriptor.getRequires();
                    int reqSize = requires == null ? 0 : requires.length;
                    int j = 0;
                    while (j < reqSize) {
                        String id = ((PluginPrerequisite)requires[j]).getUniqueIdentifier();
                        PluginDescriptor prereq = (PluginDescriptor)this.getPlugin(id);
                        Integer count = (Integer)dependents.get(prereq);
                        if (count != null) {
                            dependents.put(prereq, new Integer(count - 1));
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public IConfigurationElement[] getConfigurationElementsFor(String uniqueId) {
        IExtensionPoint point = this.getExtensionPoint(uniqueId);
        if (point == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] result = point.getConfigurationElements();
        return result == null ? new IConfigurationElement[]{} : result;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String pointId) {
        IExtensionPoint point = this.getExtensionPoint(pluginId, pointId);
        if (point == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] result = point.getConfigurationElements();
        return result == null ? new IConfigurationElement[]{} : result;
    }

    public IConfigurationElement[] getConfigurationElementsFor(String pluginId, String pointId, String extensionId) {
        IExtension extension = this.getExtension(pluginId, pointId, extensionId);
        if (extension == null) {
            return new IConfigurationElement[0];
        }
        IConfigurationElement[] result = extension.getConfigurationElements();
        return result == null ? new IConfigurationElement[]{} : result;
    }

    private Map getDependentCounts(boolean activeOnly) {
        IPluginDescriptor[] descriptors = this.getPluginDescriptors();
        int descSize = descriptors == null ? 0 : descriptors.length;
        HashMap<IPluginDescriptor, Integer> dependents = new HashMap<IPluginDescriptor, Integer>(5);
        int i = 0;
        while (i < descSize) {
            if (!activeOnly || descriptors[i].isPluginActivated()) {
                PluginPrerequisiteModel[] requires;
                Integer entry = (Integer)dependents.get(descriptors[i]);
                if (entry == null) {
                    dependents.put(descriptors[i], new Integer(0));
                }
                int reqSize = (requires = ((PluginDescriptor)descriptors[i]).getRequires()) == null ? 0 : requires.length;
                int j = 0;
                while (j < reqSize) {
                    String id = ((PluginPrerequisite)requires[j]).getUniqueIdentifier();
                    PluginDescriptor prereq = (PluginDescriptor)this.getPlugin(id);
                    if (prereq != null && (!activeOnly || prereq.isPluginActivated())) {
                        entry = (Integer)dependents.get(prereq);
                        entry = entry == null ? new Integer(1) : new Integer(entry + 1);
                        dependents.put(prereq, entry);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return dependents;
    }

    public IExtension getExtension(String xptUniqueId, String extUniqueId) {
        int lastdot = xptUniqueId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtension(xptUniqueId.substring(0, lastdot), xptUniqueId.substring(lastdot + 1), extUniqueId);
    }

    public IExtension getExtension(String pluginId, String xptSimpleId, String extId) {
        IExtensionPoint xpt = this.getExtensionPoint(pluginId, xptSimpleId);
        if (xpt == null) {
            return null;
        }
        return xpt.getExtension(extId);
    }

    public IExtensionPoint getExtensionPoint(String xptUniqueId) {
        int lastdot = xptUniqueId.lastIndexOf(46);
        if (lastdot == -1) {
            return null;
        }
        return this.getExtensionPoint(xptUniqueId.substring(0, lastdot), xptUniqueId.substring(lastdot + 1));
    }

    public IExtensionPoint getExtensionPoint(String plugin, String xpt) {
        IPluginDescriptor pd = this.getPluginDescriptor(plugin);
        if (pd == null) {
            return null;
        }
        return pd.getExtensionPoint(xpt);
    }

    public IExtensionPoint[] getExtensionPoints() {
        PluginDescriptorModel[] list = this.getPlugins();
        if (list == null) {
            return new IExtensionPoint[0];
        }
        ArrayList<ExtensionPointModel> result = new ArrayList<ExtensionPointModel>();
        int i = 0;
        while (i < list.length) {
            ExtensionPointModel[] pointList = list[i].getDeclaredExtensionPoints();
            if (pointList != null) {
                int j = 0;
                while (j < pointList.length) {
                    result.add(pointList[j]);
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new IExtensionPoint[result.size()]);
    }

    public IPluginDescriptor getPluginDescriptor(String plugin) {
        return (IPluginDescriptor)((Object)this.getPlugin(plugin));
    }

    public IPluginDescriptor getPluginDescriptor(String pluginId, PluginVersionIdentifier version) {
        PluginDescriptorModel[] plugins = this.getPlugins(pluginId);
        if (plugins == null || plugins.length == 0) {
            return null;
        }
        if (version == null) {
            return (IPluginDescriptor)((Object)plugins[0]);
        }
        int i = 0;
        while (i < plugins.length) {
            IPluginDescriptor element = (IPluginDescriptor)((Object)plugins[i]);
            if (element.getVersionIdentifier().equals(version)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public IPluginDescriptor[] getPluginDescriptors() {
        PluginDescriptorModel[] plugins = this.getPlugins();
        if (plugins == null) {
            return new IPluginDescriptor[0];
        }
        IPluginDescriptor[] result = new IPluginDescriptor[plugins.length];
        int i = 0;
        while (i < plugins.length) {
            result[i] = (IPluginDescriptor)((Object)plugins[i]);
            ++i;
        }
        return result;
    }

    public IPluginDescriptor[] getPluginDescriptors(String plugin) {
        PluginDescriptorModel[] plugins = this.getPlugins(plugin);
        if (plugins == null) {
            return new IPluginDescriptor[0];
        }
        IPluginDescriptor[] result = new IPluginDescriptor[plugins.length];
        System.arraycopy(plugins, 0, result, 0, plugins.length);
        return result;
    }

    void logError(IStatus status) {
        InternalPlatform.getRuntimePlugin().getLog().log(status);
        if (InternalPlatform.DEBUG) {
            System.out.println(status.getMessage());
        }
    }

    public void saveRegistry() throws IOException {
        IPath path = InternalPlatform.getMetaArea().getRegistryPath();
        if (path.toFile().exists()) {
            return;
        }
        DataOutputStream output = null;
        try {
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path.toFile())));
        }
        catch (IOException ioe) {
            String message = Policy.bind("meta.unableToCreateCache");
            Status status = new Status(4, "org.eclipse.core.runtime", 2, message, ioe);
            this.logError(status);
        }
        try {
            long start = System.currentTimeMillis();
            RegistryCacheWriter cacheWriter = new RegistryCacheWriter();
            cacheWriter.writePluginRegistry(this, output);
            if (InternalPlatform.DEBUG) {
                System.out.println("Wrote registry: " + (System.currentTimeMillis() - start) + "ms");
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            output.close();
            throw throwable;
        }
        Object var6_9 = null;
        output.close();
    }

    public void flushRegistry() {
        IPath path = InternalPlatform.getMetaArea().getRegistryPath();
        IPath tempPath = InternalPlatform.getMetaArea().getBackupFilePathFor(path);
        path.toFile().delete();
        tempPath.toFile().delete();
    }

    public void debugRegistry(String filename) {
        Path path = new Path(filename);
        if (!(path = (Path)path.makeAbsolute()).isValidPath(path.toOSString())) {
            String message = Policy.bind("meta.invalidRegDebug", path.toOSString());
            Status status = new Status(4, "org.eclipse.core.runtime", 2, message, null);
            this.logError(status);
            return;
        }
        try {
            FileOutputStream fs = new FileOutputStream(path.toOSString());
            PrintWriter w = new PrintWriter(fs);
            try {
                RegistryWriter regWriter = new RegistryWriter();
                System.out.println(Policy.bind("meta.infoRegDebug", path.toOSString()));
                regWriter.writePluginRegistry(this, w, 0);
                w.flush();
            }
            catch (Throwable throwable) {
                Object var6_12 = null;
                w.close();
                throw throwable;
            }
            Object var6_13 = null;
            w.close();
        }
        catch (IOException ioe) {
            String message = Policy.bind("meta.unableToCreateRegDebug", path.toOSString());
            Status status = new Status(4, "org.eclipse.core.runtime", 2, message, ioe);
            this.logError(status);
        }
    }

    public void flushDebugRegistry() {
        IPath path = InternalPlatform.getMetaArea().getLocation().append(F_DEBUG_REGISTRY);
        path.toFile().delete();
    }

    public void shutdown(IProgressMonitor progress) {
        this.shutdownPlugins();
        if (progress != null) {
            progress.worked(1);
        }
    }

    private void shutdownPlugins() {
        IPluginVisitor visitor = new IPluginVisitor(){

            public void visit(IPluginDescriptor descriptor) {
                ISafeRunnable code = new ISafeRunnable(descriptor){
                    private final /* synthetic */ IPluginDescriptor val$descriptor;
                    {
                        this.val$descriptor = iPluginDescriptor;
                    }

                    public void run() throws Exception {
                        if (!this.val$descriptor.isPluginActivated()) {
                            return;
                        }
                        try {
                            Plugin plugin = this.val$descriptor.getPlugin();
                            long time = 0L;
                            if (InternalPlatform.DEBUG_SHUTDOWN) {
                                time = System.currentTimeMillis();
                                System.out.println("Shutting down plugin: " + plugin.getDescriptor().getUniqueIdentifier());
                            }
                            plugin.shutdown();
                            if (InternalPlatform.DEBUG_SHUTDOWN) {
                                time = System.currentTimeMillis() - time;
                                System.out.println("Finished plugin shutdown for " + plugin.getDescriptor().getUniqueIdentifier() + " time: " + time + "ms");
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_4 = null;
                            ((PluginDescriptor)this.val$descriptor).doPluginDeactivation();
                            throw throwable;
                        }
                        Object var4_5 = null;
                        ((PluginDescriptor)this.val$descriptor).doPluginDeactivation();
                    }

                    public void handleException(Throwable e) {
                    }
                };
                InternalPlatform.run(code);
            }
        };
        this.accept(visitor, true);
    }

    public void startup(IProgressMonitor progress) {
    }

    final void loadConfigurationElements(Extension extension) {
        FilterInputStream input = null;
        try {
            try {
                input = new DataInputStream(new BufferedInputStream(new FileInputStream(this.registryCacheFile)));
                ((DataInputStream)input).skipBytes(extension.getSubElementsCacheOffset());
                ConfigurationElementModel[] subElements = this.registryCacheReader.readSubElements((DataInputStream)input, extension, InternalPlatform.DEBUG);
                extension.setSubElements(subElements);
                extension.setFullyLoaded(true);
                if (extension.isReadOnly()) {
                    extension.markReadOnly();
                }
            }
            catch (IOException e) {
                if (InternalPlatform.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (RegistryCacheReader.InvalidRegistryCacheException e) {
                if (InternalPlatform.DEBUG) {
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        Object var4_8 = null;
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {}
    }

    void setCacheReader(RegistryCacheReader registryCacheReader) {
        this.registryCacheReader = registryCacheReader;
    }
}

