/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.events;

import org.eclipse.core.internal.events.EventStats;
import org.eclipse.core.internal.events.ILifecycleListener;
import org.eclipse.core.internal.events.LifecycleEvent;
import org.eclipse.core.internal.events.ResourceChangeEvent;
import org.eclipse.core.internal.events.ResourceChangeListenerList;
import org.eclipse.core.internal.events.ResourceComparator;
import org.eclipse.core.internal.events.ResourceDelta;
import org.eclipse.core.internal.events.ResourceDeltaFactory;
import org.eclipse.core.internal.resources.IManager;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;

public class NotificationManager
implements IManager,
ILifecycleListener {
    protected ResourceChangeListenerList listeners;
    protected Workspace workspace;
    protected ElementTree oldState;
    protected ElementTree lastDeltaState;
    protected ResourceDelta lastDelta;
    protected long lastMarkerChangeId = 0L;
    public static final String extensionId = "org.eclipse.core.runtime.notification";

    public NotificationManager(Workspace workspace) {
        this.workspace = workspace;
        this.listeners = new ResourceChangeListenerList();
    }

    public void addListener(IResourceChangeListener listener, int eventMask) {
        ResourceChangeListenerList resourceChangeListenerList = this.listeners;
        synchronized (resourceChangeListenerList) {
            this.listeners.add(listener, eventMask);
        }
        EventStats.listenerAdded(listener);
    }

    public void broadcastChanges(IResourceChangeListener listener, int type, IResourceDelta delta, boolean lockTree) {
        ResourceChangeListenerList.ListenerEntry[] listeners = new ResourceChangeListenerList.ListenerEntry[]{new ResourceChangeListenerList.ListenerEntry(listener, type)};
        this.notify(listeners, new ResourceChangeEvent((Object)this.workspace, type, delta), lockTree);
    }

    public void broadcastChanges(ElementTree lastState, int type, boolean lockTree, boolean updateState) {
        block10: {
            block7: {
                try {
                    ResourceDelta delta;
                    block9: {
                        block8: {
                            if (!this.listeners.hasListenerFor(type)) break block7;
                            delta = this.getDelta(lastState);
                            if (delta == null) break block8;
                            if (delta.getKind() != 0) break block9;
                        }
                        Object var6_6 = null;
                        if (updateState) {
                            lastState.immutable();
                            this.oldState = lastState;
                            this.lastDelta = null;
                            this.lastDeltaState = lastState;
                            this.lastMarkerChangeId = 0L;
                        }
                        return;
                    }
                    this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, type, delta), lockTree);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    if (updateState) {
                        lastState.immutable();
                        this.oldState = lastState;
                        this.lastDelta = null;
                        this.lastDeltaState = lastState;
                        this.lastMarkerChangeId = 0L;
                    }
                    throw throwable;
                }
            }
            Object var6_8 = null;
            if (!updateState) break block10;
            lastState.immutable();
            this.oldState = lastState;
            this.lastDelta = null;
            this.lastDeltaState = lastState;
            this.lastMarkerChangeId = 0L;
        }
    }

    protected ResourceDelta getDelta(ElementTree tree) {
        long id = this.workspace.getMarkerManager().getChangeId();
        if (this.lastDelta != null && !ElementTree.hasChanges(tree, this.lastDeltaState, ResourceComparator.getComparator(true), true)) {
            if (id != this.lastMarkerChangeId) {
                this.lastDelta.updateMarkers(this.workspace.getMarkerManager().getMarkerDeltas());
            }
        } else {
            this.lastDelta = ResourceDeltaFactory.computeDelta(this.workspace, this.oldState, tree, Path.ROOT, true);
        }
        this.lastMarkerChangeId = id;
        this.lastDeltaState = tree;
        return this.lastDelta;
    }

    protected ResourceChangeListenerList.ListenerEntry[] getListeners() {
        ResourceChangeListenerList.ListenerEntry[] result;
        ResourceChangeListenerList resourceChangeListenerList = this.listeners;
        synchronized (resourceChangeListenerList) {
            result = this.listeners.getListeners();
        }
        return result;
    }

    public void handleEvent(LifecycleEvent event) {
        switch (event.kind) {
            case 1: {
                if (!this.listeners.hasListenerFor(2)) {
                    return;
                }
                IProject project = (IProject)event.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, 2, project), true);
                break;
            }
            case 64: {
                if (event.resource.equals(event.newResource)) {
                    return;
                }
            }
            case 16: {
                if (!this.listeners.hasListenerFor(4)) {
                    return;
                }
                IProject project = (IProject)event.resource;
                this.notify(this.getListeners(), new ResourceChangeEvent((Object)this.workspace, 4, project), true);
            }
        }
    }

    private void notify(ResourceChangeListenerList.ListenerEntry[] resourceListeners, final IResourceChangeEvent event, boolean lockTree) {
        int type = event.getType();
        int i = 0;
        while (i < resourceListeners.length) {
            if ((type & resourceListeners[i].eventMask) != 0) {
                Object var10_10;
                final IResourceChangeListener listener = resourceListeners[i].listener;
                if (Policy.MONITOR_LISTENERS) {
                    EventStats.startNotify(listener);
                }
                ISafeRunnable code = new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.resourceChanged(event);
                    }

                    public void handleException(Throwable e) {
                    }
                };
                boolean oldLock = this.workspace.isTreeLocked();
                boolean immutable = this.workspace.getElementTree().isImmutable();
                if (lockTree) {
                    this.workspace.setTreeLocked(true);
                } else if (immutable) {
                    this.workspace.newWorkingTree();
                }
                try {
                    Platform.run(code);
                }
                catch (Throwable throwable) {
                    var10_10 = null;
                    if (lockTree) {
                        this.workspace.setTreeLocked(oldLock);
                    } else if (immutable) {
                        this.workspace.getElementTree().immutable();
                    }
                    throw throwable;
                }
                var10_10 = null;
                if (lockTree) {
                    this.workspace.setTreeLocked(oldLock);
                } else if (immutable) {
                    this.workspace.getElementTree().immutable();
                }
                if (Policy.MONITOR_LISTENERS) {
                    EventStats.endNotify();
                }
            }
            ++i;
        }
    }

    public void removeListener(IResourceChangeListener listener) {
        ResourceChangeListenerList resourceChangeListenerList = this.listeners;
        synchronized (resourceChangeListenerList) {
            this.listeners.remove(listener);
        }
        EventStats.listenerRemoved(listener);
    }

    public void shutdown(IProgressMonitor monitor) {
    }

    public void startup(IProgressMonitor monitor) {
        this.oldState = this.workspace.getElementTree();
        this.workspace.addLifecycleListener(this);
    }
}

