/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.core.internal.boot.DelegatingURLClassLoader;

public class URLContentFilter {
    private Hashtable filterTable = null;
    private boolean isPublic = false;
    private boolean isExported = false;

    public URLContentFilter(String[] filter) {
        if (filter == null || filter.length == 0) {
            return;
        }
        int i = 0;
        while (i < filter.length) {
            String entry = filter[i].trim();
            if (!entry.equals("")) {
                this.isExported = true;
                if (entry.equals("*")) {
                    this.isPublic = true;
                } else {
                    this.addMask(entry);
                }
            }
            ++i;
        }
    }

    public URLContentFilter(boolean isPublic) {
        if (isPublic) {
            this.isExported = true;
            this.isPublic = true;
        }
    }

    private void addMask(String name) {
        if (this.filterTable == null) {
            this.filterTable = new Hashtable();
        }
        this.filterTable.put(name, this);
    }

    private boolean classMatchesFilter(String name) {
        int i = name.lastIndexOf(".");
        if (i != -1 && this.filterTable.get(String.valueOf(name.substring(0, i)) + ".*") != null) {
            return true;
        }
        return this.filterTable.get(name) != null;
    }

    boolean isClassVisible(Class clazz, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor) {
        return this.isClassVisible(clazz.getName(), current, requestor);
    }

    boolean isClassVisible(String className, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor) {
        if (requestor == current) {
            return true;
        }
        if (this.isPublic) {
            return true;
        }
        if (!this.isExported) {
            return false;
        }
        return this.classMatchesFilter(className);
    }

    boolean isResourceVisible(String resName, DelegatingURLClassLoader current, DelegatingURLClassLoader requestor) {
        if (requestor == current) {
            return true;
        }
        if (this.isPublic) {
            return true;
        }
        if (!this.isExported) {
            return false;
        }
        return this.resourceMatchesFilter(resName);
    }

    private boolean resourceMatchesFilter(String name) {
        int i = name.lastIndexOf("/");
        String tmp = name.replace('/', '.');
        if (i != -1 && this.filterTable.get(String.valueOf(tmp.substring(0, i)) + ".*") != null) {
            return true;
        }
        return this.filterTable.get(tmp) != null;
    }

    public String toString() {
        if (this.isPublic) {
            return "*";
        }
        if (!this.isExported) {
            return "<private>";
        }
        Enumeration keys = this.filterTable.keys();
        String mask = "";
        String sep = "";
        while (keys.hasMoreElements()) {
            mask = String.valueOf(mask) + sep + (String)keys.nextElement();
            sep = " + ";
        }
        return mask;
    }
}

