/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.boot;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;

public class BundleStats {
    private String pluginId;
    private String fileName;
    private int keyCount = 0;
    private int keySize = 0;
    private int valueSize = 0;
    private long hashSize = 0L;
    private long fileSize = 0L;

    private static int sizeOf(String value) {
        return 44 + 2 * value.length();
    }

    private static int sizeOf(Properties value) {
        return (int)Math.round(44.0 + (16.0 + (double)((Hashtable)value).size() * 1.25 * 4.0) + (double)(24 * ((Hashtable)value).size()));
    }

    public BundleStats(String pluginId, String fileName, InputStream input) {
        this.pluginId = pluginId;
        this.fileName = fileName;
        this.initialize(input);
    }

    public BundleStats(String pluginId, String fileName, ResourceBundle bundle) {
        this.pluginId = pluginId;
        this.fileName = fileName;
        this.initialize(bundle);
    }

    private void initialize(ResourceBundle bundle) {
        Enumeration<String> enumeration = bundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String key = enumeration.nextElement();
            this.keySize += BundleStats.sizeOf(key);
            this.valueSize += BundleStats.sizeOf(bundle.getString(key));
            ++this.keyCount;
        }
    }

    private void initialize(InputStream stream) {
        Properties props = new Properties();
        try {
            try {
                this.fileSize = stream.available();
                props.load(stream);
                Iterator iter = ((Hashtable)props).keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    this.keySize += BundleStats.sizeOf(key);
                    this.valueSize += BundleStats.sizeOf(props.getProperty(key));
                    ++this.keyCount;
                }
                this.hashSize = BundleStats.sizeOf(props);
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                stream.close();
                throw throwable;
            }
            Object var5_7 = null;
            stream.close();
        }
        catch (IOException iOException) {}
    }

    public long getHashSize() {
        return this.hashSize;
    }

    public int getKeyCount() {
        return this.keyCount;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public int getValueSize() {
        return this.valueSize;
    }

    public long getTotalSize() {
        return (long)(this.keySize + this.valueSize) + this.hashSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public long getFileSize() {
        return this.fileSize;
    }
}

