/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AjcMemberMaker;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.PerObjectInterfaceTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Expr;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.ast.Var;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public class PerObject
extends PerClause {
    private boolean isThis;
    private Pointcut entry;

    public PerObject(Pointcut entry, boolean isThis) {
        this.entry = entry;
        this.isThis = isThis;
    }

    public FuzzyBoolean fastMatch(ResolvedTypeX type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        if (this.isThis) {
            return FuzzyBoolean.fromBoolean(shadow.hasThis());
        }
        return FuzzyBoolean.fromBoolean(shadow.hasTarget());
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        this.entry.resolve(scope);
    }

    private Var getVar(Shadow shadow) {
        return this.isThis ? shadow.getThisVar() : shadow.getTargetVar();
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        Expr myInstance = Expr.makeCallExpr(AjcMemberMaker.perObjectAspectOfMethod(this.inAspect), new Expr[]{this.getVar(shadow)}, this.inAspect);
        state.setAspectInstance(myInstance);
        return Test.makeCall(AjcMemberMaker.perObjectHasAspectMethod(this.inAspect), new Expr[]{this.getVar(shadow)});
    }

    public PerClause concretize(ResolvedTypeX inAspect) {
        PerObject ret = new PerObject(this.entry, this.isThis);
        ret.inAspect = inAspect;
        if (inAspect.isAbstract()) {
            return ret;
        }
        World world = inAspect.getWorld();
        Pointcut concreteEntry = this.entry.concretize(inAspect, 0, null);
        inAspect.crosscuttingMembers.addConcreteShadowMunger(Advice.makePerObjectEntry(world, concreteEntry, this.isThis, inAspect));
        PerObjectInterfaceTypeMunger munger = new PerObjectInterfaceTypeMunger(inAspect, concreteEntry);
        inAspect.crosscuttingMembers.addTypeMunger(world.concreteTypeMunger(munger, inAspect));
        return ret;
    }

    public void write(DataOutputStream s) throws IOException {
        PerClause.PEROBJECT.write(s);
        this.entry.write(s);
        s.writeBoolean(this.isThis);
        this.writeLocation(s);
    }

    public static PerClause readPerClause(DataInputStream s, ISourceContext context) throws IOException {
        PerObject ret = new PerObject(Pointcut.read(s, context), s.readBoolean());
        ret.readLocation(context, s);
        return ret;
    }

    public PerClause.Kind getKind() {
        return PerClause.PEROBJECT;
    }

    public String toString() {
        return "per" + (this.isThis ? "this" : "target") + "(" + this.entry + ")";
    }
}

