/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.patterns;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.aspectj.util.FileUtil;
import org.aspectj.util.FuzzyBoolean;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.CrosscuttingMembers;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.IntMap;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.NameMangler;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;
import org.aspectj.weaver.ast.Test;
import org.aspectj.weaver.patterns.Bindings;
import org.aspectj.weaver.patterns.ConcreteCflowPointcut;
import org.aspectj.weaver.patterns.ExposedState;
import org.aspectj.weaver.patterns.IScope;
import org.aspectj.weaver.patterns.Pointcut;

public class CflowPointcut
extends Pointcut {
    private Pointcut entry;
    private boolean isBelow;
    private int[] freeVars;
    public static final ResolvedPointcutDefinition CFLOW_MARKER = new ResolvedPointcutDefinition(null, 0, null, TypeX.NONE, Pointcut.makeMatchesNothing(Pointcut.RESOLVED));

    public CflowPointcut(Pointcut entry, boolean isBelow, int[] freeVars) {
        this.entry = entry;
        this.isBelow = isBelow;
        this.freeVars = freeVars;
    }

    public FuzzyBoolean fastMatch(ResolvedTypeX type) {
        return FuzzyBoolean.MAYBE;
    }

    public FuzzyBoolean match(Shadow shadow) {
        return FuzzyBoolean.MAYBE;
    }

    public void write(DataOutputStream s) throws IOException {
        s.writeByte(10);
        this.entry.write(s);
        s.writeBoolean(this.isBelow);
        FileUtil.writeIntArray(this.freeVars, s);
        this.writeLocation(s);
    }

    public static Pointcut read(DataInputStream s, ISourceContext context) throws IOException {
        CflowPointcut ret = new CflowPointcut(Pointcut.read(s, context), s.readBoolean(), FileUtil.readIntArray(s));
        ret.readLocation(context, s);
        return ret;
    }

    public void resolveBindings(IScope scope, Bindings bindings) {
        if (bindings == null) {
            this.entry.resolveBindings(scope, null);
            this.entry.state = Pointcut.RESOLVED;
            this.freeVars = new int[0];
        } else {
            Bindings entryBindings = new Bindings(bindings.size());
            this.entry.resolveBindings(scope, entryBindings);
            this.entry.state = Pointcut.RESOLVED;
            this.freeVars = entryBindings.getUsedFormals();
            bindings.mergeIn(entryBindings, scope);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof CflowPointcut)) {
            return false;
        }
        CflowPointcut o = (CflowPointcut)other;
        return o.entry.equals(this.entry) && o.isBelow == this.isBelow;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.entry.hashCode();
        result = 37 * result + (this.isBelow ? 0 : 1);
        return result;
    }

    public String toString() {
        return "cflow" + (this.isBelow ? "below" : "") + "(" + this.entry + ")";
    }

    public Test findResidue(Shadow shadow, ExposedState state) {
        throw new RuntimeException("unimplemented");
    }

    public Pointcut concretize1(ResolvedTypeX inAspect, IntMap bindings) {
        Pointcut concreteEntry;
        IntMap entryBindings = new IntMap();
        int i = 0;
        int len = this.freeVars.length;
        while (i < len) {
            int freeVar = this.freeVars[i];
            entryBindings.put(freeVar, i);
            ++i;
        }
        entryBindings.copyContext(bindings);
        World world = inAspect.getWorld();
        CrosscuttingMembers xcut = bindings.getConcreteAspect().crosscuttingMembers;
        Collection previousCflowEntries = xcut.getCflowEntries();
        entryBindings.pushEnclosingDefinition(CFLOW_MARKER);
        try {
            concreteEntry = this.entry.concretize(inAspect, entryBindings);
            Object var11_11 = null;
            entryBindings.popEnclosingDefinitition();
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            entryBindings.popEnclosingDefinitition();
            throw throwable;
        }
        ArrayList innerCflowEntries = new ArrayList(xcut.getCflowEntries());
        innerCflowEntries.removeAll(previousCflowEntries);
        ResolvedMember cflowField = new ResolvedMember(Member.FIELD, inAspect, 25, NameMangler.cflowStack(xcut), TypeX.forName("org.aspectj.runtime.internal.CFlowStack").getSignature());
        bindings.getConcreteAspect().crosscuttingMembers.addConcreteShadowMunger(Advice.makeCflowEntry(world, concreteEntry, this.isBelow, cflowField, this.freeVars.length, innerCflowEntries));
        bindings.getConcreteAspect().crosscuttingMembers.addTypeMunger(world.makeCflowStackFieldAdder(cflowField));
        ArrayList<ConcreteCflowPointcut.Slot> slots = new ArrayList<ConcreteCflowPointcut.Slot>();
        int i2 = 0;
        int len2 = this.freeVars.length;
        while (i2 < len2) {
            int freeVar = this.freeVars[i2];
            if (bindings.hasKey(freeVar)) {
                int formalIndex = bindings.get(freeVar);
                ResolvedTypeX formalType = bindings.getAdviceSignature().getParameterTypes()[formalIndex].resolve(world);
                ConcreteCflowPointcut.Slot slot = new ConcreteCflowPointcut.Slot(formalIndex, formalType, i2);
                slots.add(slot);
            }
            ++i2;
        }
        return new ConcreteCflowPointcut(cflowField, slots);
    }
}

