/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver.bcel;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.aspectj.bridge.IMessage;
import org.aspectj.bridge.IProgressListener;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.CrosscuttingMembersSet;
import org.aspectj.weaver.IWeaver;
import org.aspectj.weaver.NewParentTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.bcel.BcelClassWeaver;
import org.aspectj.weaver.bcel.BcelObjectType;
import org.aspectj.weaver.bcel.BcelTypeMunger;
import org.aspectj.weaver.bcel.BcelWorld;
import org.aspectj.weaver.bcel.LazyClassGen;
import org.aspectj.weaver.bcel.UnwovenClassFile;
import org.aspectj.weaver.patterns.DeclareParents;

public class BcelWeaver
implements IWeaver {
    private BcelWorld world;
    private CrosscuttingMembersSet xcutSet;
    private IProgressListener progressListener = null;
    private double progressMade;
    private double progressPerClassFile;
    private Map sourceJavaClasses = new HashMap();
    private List addedClasses = new ArrayList();
    private List deletedTypenames = new ArrayList();
    private boolean needToReweaveWorld = false;
    private List shadowMungerList = null;
    private List typeMungerList = null;
    private List declareParentsList = null;
    private ZipOutputStream zipOutputStream;

    public BcelWeaver(BcelWorld world) {
        this.world = world;
        this.xcutSet = world.getCrosscuttingMembersSet();
    }

    public BcelWeaver() {
        this(new BcelWorld());
    }

    public void setShadowMungers(List l) {
        this.shadowMungerList = l;
    }

    public void addLibraryAspect(String aspectName) {
        ResolvedTypeX type = this.world.resolve(aspectName);
        if (!type.isAspect()) {
            throw new RuntimeException("unimplemented");
        }
        this.xcutSet.addOrReplaceAspect(type);
    }

    public void addLibraryJarFile(File inFile) throws IOException {
        ZipEntry entry;
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(inFile));
        ArrayList<ResolvedTypeX.Name> addedAspects = new ArrayList<ResolvedTypeX.Name>();
        while ((entry = inStream.getNextEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            ClassParser parser = new ClassParser(new ByteArrayInputStream(FileUtil.readAsByteArray(inStream)), entry.getName());
            JavaClass jc = parser.parse();
            inStream.closeEntry();
            ResolvedTypeX.Name type = this.world.addSourceObjectType(jc).getResolvedTypeX();
            if (!((ResolvedTypeX)type).isAspect()) continue;
            addedAspects.add(type);
        }
        inStream.close();
        Iterator i = addedAspects.iterator();
        while (i.hasNext()) {
            ResolvedTypeX aspectX = (ResolvedTypeX)i.next();
            this.xcutSet.addOrReplaceAspect(aspectX);
        }
    }

    public void addJarFile(File inFile, File outDir) throws IOException {
        ZipEntry entry;
        this.needToReweaveWorld = true;
        ZipInputStream inStream = new ZipInputStream(new FileInputStream(inFile));
        while ((entry = inStream.getNextEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            byte[] bytes = FileUtil.readAsByteArray(inStream);
            String filename = entry.getName();
            UnwovenClassFile classFile = new UnwovenClassFile(new File(outDir, filename).getAbsolutePath(), bytes);
            inStream.closeEntry();
            this.addClassFile(classFile);
        }
        inStream.close();
    }

    public void addClassFile(UnwovenClassFile classFile) {
        this.addedClasses.add(classFile);
        this.sourceJavaClasses.put(classFile.getClassName(), classFile);
        this.world.addSourceObjectType(classFile.getJavaClass());
    }

    public void deleteClassFile(String typename) {
        this.deletedTypenames.add(typename);
        this.sourceJavaClasses.remove(typename);
        this.world.deleteSourceObjectType(TypeX.forName(typename));
    }

    public void prepareForWeave() {
        String name;
        this.needToReweaveWorld = false;
        Iterator i = this.addedClasses.iterator();
        while (i.hasNext()) {
            UnwovenClassFile jc = (UnwovenClassFile)i.next();
            name = jc.getClassName();
            ResolvedTypeX type = this.world.resolve(name);
            if (!type.isAspect()) continue;
            this.needToReweaveWorld |= this.xcutSet.addOrReplaceAspect(type);
        }
        Iterator i2 = this.deletedTypenames.iterator();
        while (i2.hasNext()) {
            name = (String)i2.next();
            if (!this.xcutSet.deleteAspect(TypeX.forName(name))) continue;
            this.needToReweaveWorld = true;
        }
        this.shadowMungerList = this.xcutSet.getShadowMungers();
        this.typeMungerList = this.xcutSet.getTypeMungers();
        this.declareParentsList = this.xcutSet.getDeclareParents();
        Collections.sort(this.shadowMungerList, new Comparator(){

            public int compare(Object o1, Object o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
    }

    public void dumpUnwoven(File file) throws IOException {
        BufferedOutputStream os = FileUtil.makeOutputStream(file);
        this.zipOutputStream = new ZipOutputStream(os);
        this.dumpUnwoven();
        this.zipOutputStream.close();
    }

    public void dumpUnwoven() throws IOException {
        HashSet filesToDump = new HashSet(this.sourceJavaClasses.values());
        Iterator i = filesToDump.iterator();
        while (i.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i.next();
            this.dumpUnchanged(classFile);
        }
    }

    public Collection weave(File file) throws IOException {
        BufferedOutputStream os = FileUtil.makeOutputStream(file);
        this.zipOutputStream = new ZipOutputStream(os);
        Collection c = this.weave();
        this.zipOutputStream.close();
        return c;
    }

    public Collection weave() throws IOException {
        this.prepareForWeave();
        Collection<Object> filesToWeave = this.needToReweaveWorld ? this.sourceJavaClasses.values() : this.addedClasses;
        ArrayList<String> wovenClassNames = new ArrayList<String>();
        this.world.showMessage(IMessage.INFO, "might need to weave " + filesToWeave + "(world=" + this.needToReweaveWorld + ")", null, null);
        Iterator<Object> i = filesToWeave.iterator();
        while (i.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i.next();
            String className = classFile.getClassName();
            BcelObjectType classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            classType.resetState();
        }
        Iterator<Object> i2 = filesToWeave.iterator();
        while (i2.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i2.next();
            String className = classFile.getClassName();
            ResolvedTypeX onType = this.world.resolve(className);
            this.weave(onType);
        }
        Iterator<Object> i3 = filesToWeave.iterator();
        while (i3.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i3.next();
            String className = classFile.getClassName();
            BcelObjectType classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            if (!classType.isAspect()) continue;
            this.weave(classFile, classType);
            wovenClassNames.add(className);
        }
        Iterator<Object> i4 = filesToWeave.iterator();
        while (i4.hasNext()) {
            UnwovenClassFile classFile = (UnwovenClassFile)i4.next();
            String className = classFile.getClassName();
            BcelObjectType classType = BcelWorld.getBcelObjectType(this.world.resolve(className));
            if (classType.isAspect()) continue;
            this.weave(classFile, classType);
            wovenClassNames.add(className);
        }
        if (this.zipOutputStream != null && !this.needToReweaveWorld) {
            HashSet filesToDump = new HashSet(this.sourceJavaClasses.values());
            filesToDump.removeAll(filesToWeave);
            Iterator i5 = filesToDump.iterator();
            while (i5.hasNext()) {
                UnwovenClassFile classFile = (UnwovenClassFile)i5.next();
                this.dumpUnchanged(classFile);
            }
        }
        this.addedClasses = new ArrayList();
        this.deletedTypenames = new ArrayList();
        return wovenClassNames;
    }

    public void weave(ResolvedTypeX onType) {
        onType.clearInterTypeMungers();
        Iterator i = this.declareParentsList.iterator();
        while (i.hasNext()) {
            DeclareParents p = (DeclareParents)i.next();
            List newParents = p.findMatchingNewParents(onType);
            if (newParents.isEmpty()) continue;
            BcelObjectType classType = BcelWorld.getBcelObjectType(onType);
            Iterator j = newParents.iterator();
            while (j.hasNext()) {
                ResolvedTypeX newParent = (ResolvedTypeX)j.next();
                if (newParent.isClass()) {
                    this.world.showMessage(IMessage.ERROR, "can't use declare parents to change superclass of binary form '" + onType.getName() + "' (implementation limitation)", p.getSourceLocation(), null);
                    continue;
                }
                classType.addParent(newParent);
                NewParentTypeMunger newParentMunger = new NewParentTypeMunger(newParent);
                onType.addInterTypeMunger(new BcelTypeMunger(newParentMunger, null));
            }
        }
        Iterator i2 = this.typeMungerList.iterator();
        while (i2.hasNext()) {
            ConcreteTypeMunger m = (ConcreteTypeMunger)i2.next();
            if (!m.matches(onType)) continue;
            onType.addInterTypeMunger(m);
        }
    }

    public LazyClassGen weaveWithoutDump(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        return this.weave(classFile, classType, false);
    }

    LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType) throws IOException {
        LazyClassGen ret = this.weave(classFile, classType, true);
        if (this.progressListener != null) {
            this.progressMade += this.progressPerClassFile;
            this.progressListener.setProgress(this.progressMade);
            this.progressListener.setText("woven: " + classFile.getFilename());
        }
        return ret;
    }

    private LazyClassGen weave(UnwovenClassFile classFile, BcelObjectType classType, boolean dump) throws IOException {
        if (classType.isSynthetic()) {
            if (dump) {
                this.dumpUnchanged(classFile);
            }
            return null;
        }
        JavaClass javaClass = classType.getJavaClass();
        List shadowMungers = this.fastMatch(this.shadowMungerList, classType.getResolvedTypeX());
        List typeMungers = classType.getResolvedTypeX().getInterTypeMungers();
        LazyClassGen clazz = null;
        if (shadowMungers.size() > 0 || typeMungers.size() > 0 || classType.isAspect()) {
            clazz = classType.getLazyClassGen();
            try {
                boolean isChanged = BcelClassWeaver.weave(this.world, clazz, shadowMungers, typeMungers);
                if (isChanged) {
                    if (dump) {
                        this.dump(classFile, clazz);
                    }
                    return clazz;
                }
            }
            catch (RuntimeException re) {
                System.err.println("trouble in: ");
                clazz.print(System.err);
                throw re;
            }
            catch (Error re) {
                System.err.println("trouble in: ");
                clazz.print(System.err);
                throw re;
            }
        }
        if (dump) {
            this.dumpUnchanged(classFile);
            return clazz;
        }
        return null;
    }

    private void dumpUnchanged(UnwovenClassFile classFile) throws IOException {
        if (this.zipOutputStream != null) {
            this.writeZipEntry(this.getEntryName(classFile.getJavaClass().getClassName()), classFile.getBytes());
        } else {
            classFile.writeUnchangedBytes();
        }
    }

    private String getEntryName(String className) {
        return className.replace('.', '/') + ".class";
    }

    private void dump(UnwovenClassFile classFile, LazyClassGen clazz) throws IOException {
        if (this.zipOutputStream != null) {
            String mainClassName = classFile.getJavaClass().getClassName();
            this.writeZipEntry(this.getEntryName(mainClassName), clazz.getJavaClass().getBytes());
            if (!clazz.getChildClasses().isEmpty()) {
                Iterator i = clazz.getChildClasses().iterator();
                while (i.hasNext()) {
                    UnwovenClassFile.ChildClass c = (UnwovenClassFile.ChildClass)i.next();
                    this.writeZipEntry(this.getEntryName(mainClassName + "$" + c.name), c.bytes);
                }
            }
        } else {
            classFile.writeWovenBytes(clazz.getJavaClass().getBytes(), clazz.getChildClasses());
        }
    }

    private void writeZipEntry(String name, byte[] bytes) throws IOException {
        ZipEntry newEntry = new ZipEntry(name);
        this.zipOutputStream.putNextEntry(newEntry);
        this.zipOutputStream.write(bytes);
        this.zipOutputStream.closeEntry();
    }

    private List fastMatch(List list, ResolvedTypeX type) {
        if (list == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<ShadowMunger> result = new ArrayList<ShadowMunger>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ShadowMunger munger = (ShadowMunger)iter.next();
            if (!munger.getPointcut().fastMatch(type).maybeTrue()) continue;
            result.add(munger);
        }
        return result;
    }

    public void setProgressListener(IProgressListener listener, double previousProgress, double progressPerClassFile) {
        this.progressListener = listener;
        this.progressMade = previousProgress;
        this.progressPerClassFile = progressPerClassFile;
    }
}

