/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import org.aspectj.bridge.ISourceLocation;
import org.aspectj.weaver.AjAttribute;
import org.aspectj.weaver.IHasPosition;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.ShadowMunger;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.World;

public class ResolvedMember
extends Member
implements IHasPosition {
    protected String[] parameterNames = null;
    protected TypeX[] checkedExceptions = TypeX.NONE;
    protected int start;
    protected int end;
    protected ISourceContext sourceContext = null;
    public static final ResolvedMember[] NONE = new ResolvedMember[0];

    public ResolvedMember(Member.Kind kind, TypeX declaringType, int modifiers, TypeX returnType, String name, TypeX[] parameterTypes) {
        super(kind, declaringType, modifiers, returnType, name, parameterTypes);
    }

    public ResolvedMember(Member.Kind kind, TypeX declaringType, int modifiers, String name, String signature) {
        super(kind, declaringType, modifiers, name, signature);
    }

    public final int getModifiers(World world) {
        return this.modifiers;
    }

    public final int getModifiers() {
        return this.modifiers;
    }

    public final TypeX[] getExceptions(World world) {
        return this.getExceptions();
    }

    public TypeX[] getExceptions() {
        return this.checkedExceptions;
    }

    public ShadowMunger getAssociatedShadowMunger() {
        return null;
    }

    public boolean isAjSynthetic() {
        return true;
    }

    public void write(DataOutputStream s) throws IOException {
        this.getKind().write(s);
        this.getDeclaringType().write(s);
        s.writeInt(this.modifiers);
        s.writeUTF(this.getName());
        s.writeUTF(this.getSignature());
        TypeX.writeArray(this.getExceptions(), s);
        s.writeInt(this.getStart());
        s.writeInt(this.getEnd());
    }

    public static void writeArray(ResolvedMember[] members, DataOutputStream s) throws IOException {
        s.writeInt(members.length);
        int i = 0;
        int len = members.length;
        while (i < len) {
            members[i].write(s);
            ++i;
        }
    }

    public static ResolvedMember readResolvedMember(DataInputStream s, ISourceContext sourceContext) throws IOException {
        ResolvedMember m = new ResolvedMember(Member.Kind.read(s), TypeX.read(s), s.readInt(), s.readUTF(), s.readUTF());
        m.checkedExceptions = TypeX.readArray(s);
        m.start = s.readInt();
        m.end = s.readInt();
        m.sourceContext = sourceContext;
        return m;
    }

    public static ResolvedMember[] readResolvedMemberArray(DataInputStream s, ISourceContext context) throws IOException {
        int len = s.readInt();
        ResolvedMember[] members = new ResolvedMember[len];
        int i = 0;
        while (i < len) {
            members[i] = ResolvedMember.readResolvedMember(s, context);
            ++i;
        }
        return members;
    }

    public ResolvedMember resolve(World world) {
        return this;
    }

    public ISourceContext getSourceContext(World world) {
        return this.getDeclaringType().resolve(world).getSourceContext();
    }

    public final String[] getParameterNames() {
        return this.parameterNames;
    }

    public final String[] getParameterNames(World world) {
        return this.getParameterNames();
    }

    public AjAttribute.EffectiveSignatureAttribute getEffectiveSignature() {
        return null;
    }

    public ISourceLocation getSourceLocation() {
        if (this.sourceContext == null) {
            return null;
        }
        return this.sourceContext.makeSourceLocation(this);
    }

    public int getEnd() {
        return this.end;
    }

    public ISourceContext getSourceContext() {
        return this.sourceContext;
    }

    public int getStart() {
        return this.start;
    }

    public void setPosition(int sourceStart, int sourceEnd) {
        this.start = sourceStart;
        this.end = sourceEnd;
    }

    public void setSourceContext(ISourceContext sourceContext) {
        this.sourceContext = sourceContext;
    }

    public boolean isAbstract() {
        return Modifier.isAbstract(this.modifiers);
    }

    public boolean isPublic() {
        return Modifier.isPublic(this.modifiers);
    }

    public boolean isVisible(ResolvedTypeX fromType) {
        World world = fromType.getWorld();
        return ResolvedTypeX.isVisible(this.getModifiers(), this.getDeclaringType().resolve(world), fromType);
    }

    public void setCheckedExceptions(TypeX[] checkedExceptions) {
        this.checkedExceptions = checkedExceptions;
    }
}

