/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.weaver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.util.FileUtil;
import org.aspectj.weaver.Advice;
import org.aspectj.weaver.AdviceKind;
import org.aspectj.weaver.BCException;
import org.aspectj.weaver.ConcreteTypeMunger;
import org.aspectj.weaver.ISourceContext;
import org.aspectj.weaver.Member;
import org.aspectj.weaver.ResolvedMember;
import org.aspectj.weaver.ResolvedPointcutDefinition;
import org.aspectj.weaver.ResolvedTypeMunger;
import org.aspectj.weaver.ResolvedTypeX;
import org.aspectj.weaver.Shadow;
import org.aspectj.weaver.TypeX;
import org.aspectj.weaver.WeaverStateKind;
import org.aspectj.weaver.World;
import org.aspectj.weaver.patterns.Declare;
import org.aspectj.weaver.patterns.PerClause;
import org.aspectj.weaver.patterns.Pointcut;

public abstract class AjAttribute {
    public static final String AttributePrefix = "org.aspectj.weaver";

    protected abstract void write(DataOutputStream var1) throws IOException;

    public abstract String getNameString();

    public char[] getNameChars() {
        return this.getNameString().toCharArray();
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream b0 = new ByteArrayOutputStream();
            DataOutputStream s0 = new DataOutputStream(b0);
            this.write(s0);
            return b0.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("sanity check");
        }
    }

    public byte[] getAllBytes(short nameIndex) {
        try {
            byte[] bytes = this.getBytes();
            ByteArrayOutputStream b0 = new ByteArrayOutputStream();
            DataOutputStream s0 = new DataOutputStream(b0);
            s0.writeShort(nameIndex);
            s0.writeInt(bytes.length);
            s0.write(bytes);
            return b0.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("sanity check");
        }
    }

    public static AjAttribute read(String name, byte[] bytes, ISourceContext context) {
        try {
            if (bytes == null) {
                bytes = new byte[]{};
            }
            DataInputStream s = new DataInputStream(new ByteArrayInputStream(bytes));
            if (name.equals("org.aspectj.weaver.Aspect")) {
                return new Aspect(PerClause.readPerClause(s, context));
            }
            if (name.equals("org.aspectj.weaver.WeaverState")) {
                return new WeaverState(WeaverStateKind.read(s));
            }
            if (name.equals("org.aspectj.weaver.Advice")) {
                return AdviceAttribute.read(s, context);
            }
            if (name.equals("org.aspectj.weaver.PointcutDeclaration")) {
                return new PointcutDeclarationAttribute(ResolvedPointcutDefinition.read(s, context));
            }
            if (name.equals("org.aspectj.weaver.TypeMunger")) {
                return new TypeMunger(ResolvedTypeMunger.read(s, context));
            }
            if (name.equals("org.aspectj.weaver.AjSynthetic")) {
                return new AjSynthetic();
            }
            if (name.equals("org.aspectj.weaver.Declare")) {
                return new DeclareAttribute(Declare.read(s, context));
            }
            if (name.equals("org.aspectj.weaver.Privileged")) {
                return PrivilegedAttribute.read(s, context);
            }
            if (name.equals("org.aspectj.weaver.SourceContext")) {
                return SourceContextAttribute.read(s);
            }
            if (name.equals("org.aspectj.weaver.EffectiveSignature")) {
                return EffectiveSignatureAttribute.read(s, context);
            }
            throw new BCException("unknown attribute" + name);
        }
        catch (IOException e) {
            throw new BCException("malformed " + name + " attribute " + e);
        }
    }

    public static class EffectiveSignatureAttribute
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.EffectiveSignature";
        private ResolvedMember effectiveSignature;
        private Shadow.Kind shadowKind;
        private boolean weaveBody;

        public String getNameString() {
            return AttributeName;
        }

        public EffectiveSignatureAttribute(ResolvedMember effectiveSignature, Shadow.Kind shadowKind, boolean weaveBody) {
            this.effectiveSignature = effectiveSignature;
            this.shadowKind = shadowKind;
            this.weaveBody = weaveBody;
        }

        public void write(DataOutputStream s) throws IOException {
            this.effectiveSignature.write(s);
            this.shadowKind.write(s);
            s.writeBoolean(this.weaveBody);
        }

        public static EffectiveSignatureAttribute read(DataInputStream s, ISourceContext context) throws IOException {
            return new EffectiveSignatureAttribute(ResolvedMember.readResolvedMember(s, context), Shadow.Kind.read(s), s.readBoolean());
        }

        public ResolvedMember getEffectiveSignature() {
            return this.effectiveSignature;
        }

        public String toString() {
            return "EffectiveSignatureAttribute(" + this.effectiveSignature + ", " + this.shadowKind + ")";
        }

        public Shadow.Kind getShadowKind() {
            return this.shadowKind;
        }

        public boolean isWeaveBody() {
            return this.weaveBody;
        }
    }

    public static class PrivilegedAttribute
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.Privileged";
        private ResolvedMember[] accessedMembers;

        public String getNameString() {
            return AttributeName;
        }

        public PrivilegedAttribute(ResolvedMember[] accessedMembers) {
            this.accessedMembers = accessedMembers;
        }

        public void write(DataOutputStream s) throws IOException {
            ResolvedMember.writeArray(this.accessedMembers, s);
        }

        public ResolvedMember[] getAccessedMembers() {
            return this.accessedMembers;
        }

        public static PrivilegedAttribute read(DataInputStream s, ISourceContext context) throws IOException {
            return new PrivilegedAttribute(ResolvedMember.readResolvedMemberArray(s, context));
        }
    }

    public static class Aspect
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.Aspect";
        private PerClause perClause;

        public String getNameString() {
            return AttributeName;
        }

        public Aspect(PerClause perClause) {
            this.perClause = perClause;
        }

        public PerClause reify(ResolvedTypeX inAspect) {
            return this.perClause;
        }

        public void write(DataOutputStream s) throws IOException {
            this.perClause.write(s);
        }
    }

    public static class AdviceAttribute
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.Advice";
        private AdviceKind kind;
        private Pointcut pointcut;
        private int extraParameterFlags;
        private int start;
        private int end;
        private ISourceContext sourceContext;
        private boolean proceedInInners;
        private ResolvedMember[] proceedCallSignatures;
        private boolean[] formalsUnchangedToProceed;
        private TypeX[] declaredExceptions;

        public String getNameString() {
            return AttributeName;
        }

        public AdviceAttribute(AdviceKind kind, Pointcut pointcut, int extraArgumentFlags, int start, int end, ISourceContext sourceContext) {
            this.kind = kind;
            this.pointcut = pointcut;
            this.extraParameterFlags = extraArgumentFlags;
            this.start = start;
            this.end = end;
            this.sourceContext = sourceContext;
        }

        public AdviceAttribute(AdviceKind kind, Pointcut pointcut, int extraArgumentFlags, int start, int end, ISourceContext sourceContext, boolean proceedInInners, ResolvedMember[] proceedCallSignatures, boolean[] formalsUnchangedToProceed, TypeX[] declaredExceptions) {
            this.kind = kind;
            this.pointcut = pointcut;
            this.extraParameterFlags = extraArgumentFlags;
            this.start = start;
            this.end = end;
            this.sourceContext = sourceContext;
            if (kind != AdviceKind.Around) {
                throw new IllegalArgumentException("only for around");
            }
            this.proceedInInners = proceedInInners;
            this.proceedCallSignatures = proceedCallSignatures;
            this.formalsUnchangedToProceed = formalsUnchangedToProceed;
            this.declaredExceptions = declaredExceptions;
        }

        public static AdviceAttribute read(DataInputStream s, ISourceContext context) throws IOException {
            AdviceKind kind = AdviceKind.read(s);
            if (kind == AdviceKind.Around) {
                return new AdviceAttribute(kind, Pointcut.read(s, context), s.readByte(), s.readInt(), s.readInt(), context, s.readBoolean(), ResolvedMember.readResolvedMemberArray(s, context), FileUtil.readBooleanArray(s), TypeX.readArray(s));
            }
            return new AdviceAttribute(kind, Pointcut.read(s, context), s.readByte(), s.readInt(), s.readInt(), context);
        }

        public void write(DataOutputStream s) throws IOException {
            this.kind.write(s);
            this.pointcut.write(s);
            s.writeByte(this.extraParameterFlags);
            s.writeInt(this.start);
            s.writeInt(this.end);
            if (this.kind == AdviceKind.Around) {
                s.writeBoolean(this.proceedInInners);
                ResolvedMember.writeArray(this.proceedCallSignatures, s);
                FileUtil.writeBooleanArray(this.formalsUnchangedToProceed, s);
                TypeX.writeArray(this.declaredExceptions, s);
            }
        }

        public Advice reify(Member signature, World world) {
            return world.concreteAdvice(this, this.pointcut, signature);
        }

        public String toString() {
            return "AdviceAttribute(" + this.kind + ", " + this.pointcut + ", " + this.extraParameterFlags + ", " + this.start + ")";
        }

        public int getExtraParameterFlags() {
            return this.extraParameterFlags;
        }

        public AdviceKind getKind() {
            return this.kind;
        }

        public Pointcut getPointcut() {
            return this.pointcut;
        }

        public TypeX[] getDeclaredExceptions() {
            return this.declaredExceptions;
        }

        public boolean[] getFormalsUnchangedToProceed() {
            return this.formalsUnchangedToProceed;
        }

        public ResolvedMember[] getProceedCallSignatures() {
            return this.proceedCallSignatures;
        }

        public boolean isProceedInInners() {
            return this.proceedInInners;
        }

        public int getEnd() {
            return this.end;
        }

        public ISourceContext getSourceContext() {
            return this.sourceContext;
        }

        public int getStart() {
            return this.start;
        }
    }

    public static class DeclareAttribute
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.Declare";
        private Declare declare;

        public String getNameString() {
            return AttributeName;
        }

        public DeclareAttribute(Declare declare) {
            this.declare = declare;
        }

        public void write(DataOutputStream s) throws IOException {
            this.declare.write(s);
        }

        public Declare getDeclare() {
            return this.declare;
        }
    }

    public static class PointcutDeclarationAttribute
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.PointcutDeclaration";
        private ResolvedPointcutDefinition pointcutDef;

        public String getNameString() {
            return AttributeName;
        }

        public PointcutDeclarationAttribute(ResolvedPointcutDefinition pointcutDef) {
            this.pointcutDef = pointcutDef;
        }

        public void write(DataOutputStream s) throws IOException {
            this.pointcutDef.write(s);
        }

        public ResolvedPointcutDefinition reify() {
            return this.pointcutDef;
        }
    }

    public static class SourceContextAttribute
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.SourceContext";
        private String sourceFileName;
        private int[] lineBreaks;

        public String getNameString() {
            return AttributeName;
        }

        public SourceContextAttribute(String sourceFileName, int[] lineBreaks) {
            this.sourceFileName = sourceFileName;
            this.lineBreaks = lineBreaks;
        }

        public void write(DataOutputStream s) throws IOException {
            s.writeUTF(this.sourceFileName);
            FileUtil.writeIntArray(this.lineBreaks, s);
        }

        public static SourceContextAttribute read(DataInputStream s) throws IOException {
            return new SourceContextAttribute(s.readUTF(), FileUtil.readIntArray(s));
        }

        public int[] getLineBreaks() {
            return this.lineBreaks;
        }

        public String getSourceFileName() {
            return this.sourceFileName;
        }
    }

    public static class WeaverState
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.WeaverState";
        private WeaverStateKind kind;

        public String getNameString() {
            return AttributeName;
        }

        public WeaverState(WeaverStateKind kind) {
            this.kind = kind;
        }

        public void write(DataOutputStream s) throws IOException {
            this.kind.write(s);
        }

        public WeaverStateKind reify() {
            return this.kind;
        }
    }

    public static class TypeMunger
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.TypeMunger";
        private ResolvedTypeMunger munger;

        public String getNameString() {
            return AttributeName;
        }

        public TypeMunger(ResolvedTypeMunger munger) {
            this.munger = munger;
        }

        public void write(DataOutputStream s) throws IOException {
            this.munger.write(s);
        }

        public ConcreteTypeMunger reify(World world, ResolvedTypeX aspectType) {
            return world.concreteTypeMunger(this.munger, aspectType);
        }
    }

    public static class AjSynthetic
    extends AjAttribute {
        public static final String AttributeName = "org.aspectj.weaver.AjSynthetic";
        private ResolvedTypeMunger munger;

        public String getNameString() {
            return AttributeName;
        }

        public void write(DataOutputStream s) throws IOException {
        }
    }
}

