/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.asm.StructureNode;
import org.aspectj.bridge.ISourceLocation;

public class ProgramElementNode
extends StructureNode {
    private List modifiers = new ArrayList();
    private List relations = new ArrayList();
    private Kind kind;
    private Accessibility accessibility;
    private String declaringType = "";
    private String formalComment = "";
    private String packageName = null;
    private boolean runnable = false;
    private boolean implementor = false;
    private boolean overrider = false;
    private String bytecodeName;
    private String bytecodeSignature;
    private static int AccPublic = 1;
    private static int AccPrivate = 2;
    private static int AccProtected = 4;
    private static int AccPrivileged = 6;
    private static int AccStatic = 8;
    private static int AccFinal = 16;
    private static int AccSynchronized = 32;
    private static int AccVolatile = 64;
    private static int AccTransient = 128;
    private static int AccNative = 256;
    private static int AccInterface = 512;
    private static int AccAbstract = 1024;
    private static int AccStrictfp = 2048;

    public ProgramElementNode() {
    }

    public ProgramElementNode(String signature, Kind kind, List children) {
        super(signature, kind.toString(), children);
        this.kind = kind;
    }

    public ProgramElementNode(String signature, Kind kind, ISourceLocation sourceLocation, int modifiers, String formalComment, List children) {
        super(signature, kind.toString(), children);
        this.sourceLocation = sourceLocation;
        this.kind = kind;
        this.formalComment = formalComment;
        this.modifiers = ProgramElementNode.genModifiers(modifiers);
        this.accessibility = ProgramElementNode.genAccessibility(modifiers);
    }

    public ProgramElementNode(String signature, Kind kind, List modifiers, Accessibility accessibility, String declaringType, String packageName, String formalComment, ISourceLocation sourceLocation, List relations, List children, boolean member) {
        super(signature, kind.toString(), children);
        this.sourceLocation = sourceLocation;
        this.kind = kind;
        this.modifiers = modifiers;
        this.accessibility = accessibility;
        this.declaringType = declaringType;
        this.packageName = packageName;
        this.formalComment = formalComment;
        this.relations = relations;
    }

    public Kind getProgramElementKind() {
        return this.kind;
    }

    public List getModifiers() {
        return this.modifiers;
    }

    public Accessibility getAccessibility() {
        return this.accessibility;
    }

    public String getDeclaringType() {
        return this.declaringType;
    }

    public String getPackageName() {
        if (this.kind == Kind.PACKAGE) {
            return this.getSignature();
        }
        if (this.getParent() == null || !(this.getParent() instanceof ProgramElementNode)) {
            return "";
        }
        return ((ProgramElementNode)this.getParent()).getPackageName();
    }

    public String getKind() {
        return ((StructureNode)this).kind;
    }

    public String getSignature() {
        return this.name;
    }

    public boolean isCode() {
        return this.kind.equals(Kind.CODE);
    }

    public boolean isMemberKind() {
        return this.kind.isMemberKind();
    }

    public void setRunnable(boolean value) {
        this.runnable = value;
    }

    public boolean isRunnable() {
        return this.runnable;
    }

    public boolean isImplementor() {
        return this.implementor;
    }

    public void setImplementor(boolean value) {
        this.implementor = value;
    }

    public boolean isOverrider() {
        return this.overrider;
    }

    public void setOverrider(boolean value) {
        this.overrider = value;
    }

    public List getRelations() {
        return this.relations;
    }

    public void setRelations(List relations) {
        if (relations.size() > 0) {
            this.relations = relations;
        }
    }

    public String getFormalComment() {
        return this.formalComment;
    }

    public String toString() {
        return this.name;
    }

    public static List genModifiers(int modifiers) {
        ArrayList<Modifiers> modifiersList = new ArrayList<Modifiers>();
        if ((modifiers & AccStatic) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        if ((modifiers & AccFinal) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        if ((modifiers & AccSynchronized) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        if ((modifiers & AccVolatile) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        if ((modifiers & AccTransient) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        if ((modifiers & AccNative) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        if ((modifiers & AccAbstract) != 0) {
            modifiersList.add(Modifiers.STATIC);
        }
        return modifiersList;
    }

    public static Accessibility genAccessibility(int modifiers) {
        if ((modifiers & AccPublic) != 0) {
            return Accessibility.PUBLIC;
        }
        if ((modifiers & AccPrivate) != 0) {
            return Accessibility.PRIVATE;
        }
        if ((modifiers & AccProtected) != 0) {
            return Accessibility.PROTECTED;
        }
        if ((modifiers & AccPrivileged) != 0) {
            return Accessibility.PRIVILEGED;
        }
        return Accessibility.PACKAGE;
    }

    public String getBytecodeName() {
        return this.bytecodeName;
    }

    public String getBytecodeSignature() {
        return this.bytecodeSignature;
    }

    public void setBytecodeName(String bytecodeName) {
        this.bytecodeName = bytecodeName;
    }

    public void setBytecodeSignature(String bytecodeSignature) {
        this.bytecodeSignature = bytecodeSignature;
    }

    public static class Kind
    implements Serializable {
        public static final Kind PROJECT = new Kind("project");
        public static final Kind PACKAGE = new Kind("package");
        public static final Kind FILE = new Kind("file");
        public static final Kind FILE_JAVA = new Kind("java source file");
        public static final Kind FILE_ASPECTJ = new Kind("aspect source file");
        public static final Kind FILE_LST = new Kind("build configuration file");
        public static final Kind CLASS = new Kind("class");
        public static final Kind INTERFACE = new Kind("interface");
        public static final Kind ASPECT = new Kind("aspect");
        public static final Kind INITIALIZER = new Kind("initializer");
        public static final Kind INTRODUCTION = new Kind("introduction");
        public static final Kind CONSTRUCTOR = new Kind("constructor");
        public static final Kind METHOD = new Kind("method");
        public static final Kind FIELD = new Kind("field");
        public static final Kind POINTCUT = new Kind("pointcut");
        public static final Kind ADVICE = new Kind("advice");
        public static final Kind DECLARE_PARENTS = new Kind("declare parents");
        public static final Kind DECLARE_WARNING = new Kind("declare warning");
        public static final Kind DECLARE_ERROR = new Kind("declare error");
        public static final Kind DECLARE_SOFT = new Kind("declare soft");
        public static final Kind CODE = new Kind("decBodyElement");
        public static final Kind ERROR = new Kind("error");
        public static final Kind[] ALL = new Kind[]{PROJECT, PACKAGE, FILE, FILE_JAVA, FILE_ASPECTJ, FILE_LST, CLASS, INTERFACE, ASPECT, INITIALIZER, INTRODUCTION, CONSTRUCTOR, METHOD, FIELD, POINTCUT, ADVICE, DECLARE_PARENTS, DECLARE_WARNING, DECLARE_ERROR, DECLARE_SOFT, CODE, ERROR};
        private final String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        public static Kind getKindForString(String kindString) {
            int i = 0;
            while (i < ALL.length) {
                if (ALL[i].toString().equals(kindString)) {
                    return ALL[i];
                }
                ++i;
            }
            return ERROR;
        }

        private Kind(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public static List getNonAJMemberKinds() {
            ArrayList<Kind> list = new ArrayList<Kind>();
            list.add(METHOD);
            list.add(FIELD);
            list.add(CONSTRUCTOR);
            return list;
        }

        public boolean isMemberKind() {
            return this == FIELD || this == METHOD || this == CONSTRUCTOR || this == POINTCUT || this == ADVICE;
        }

        public boolean isTypeKind() {
            return this == CLASS || this == INTERFACE || this == ASPECT;
        }

        public boolean isSourceFileKind() {
            return this == FILE_ASPECTJ || this == FILE_JAVA;
        }

        public boolean isDeclareKind() {
            return this.name.startsWith("declare");
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL[this.ordinal];
        }
    }

    public static class Accessibility
    implements Serializable {
        public static final Accessibility PUBLIC = new Accessibility("public");
        public static final Accessibility PACKAGE = new Accessibility("package");
        public static final Accessibility PROTECTED = new Accessibility("protected");
        public static final Accessibility PRIVATE = new Accessibility("private");
        public static final Accessibility PRIVILEGED = new Accessibility("privileged");
        public static final Accessibility[] ALL = new Accessibility[]{PUBLIC, PACKAGE, PROTECTED, PRIVATE, PRIVILEGED};
        private final String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Accessibility(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL[this.ordinal];
        }
    }

    public static class Modifiers
    implements Serializable {
        public static final Modifiers STATIC = new Modifiers("static");
        public static final Modifiers FINAL = new Modifiers("final");
        public static final Modifiers ABSTRACT = new Modifiers("abstract");
        public static final Modifiers SYNCHRONIZED = new Modifiers("synchronized");
        public static final Modifiers VOLATILE = new Modifiers("volatile");
        public static final Modifiers STRICTFP = new Modifiers("strictfp");
        public static final Modifiers TRANSIENT = new Modifiers("transient");
        public static final Modifiers NATIVE = new Modifiers("native");
        public static final Modifiers[] ALL = new Modifiers[]{STATIC, FINAL, ABSTRACT, SYNCHRONIZED, TRANSIENT, VOLATILE, STRICTFP, NATIVE};
        private final String name;
        private static int nextOrdinal = 0;
        private final int ordinal = nextOrdinal++;

        private Modifiers(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            return ALL[this.ordinal];
        }
    }
}

