/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.asm;

import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.StructureNode;

public class LinkNode
extends StructureNode {
    private ProgramElementNode programElementNode = null;

    public LinkNode() {
    }

    public LinkNode(ProgramElementNode node) {
        super(node.getSignature().toString(), "internal", null);
        this.programElementNode = node;
    }

    public ProgramElementNode getProgramElementNode() {
        return this.programElementNode;
    }

    public String toString() {
        String name = "";
        if (this.programElementNode.getProgramElementKind().equals(ProgramElementNode.Kind.ADVICE) || this.programElementNode.getProgramElementKind().equals(ProgramElementNode.Kind.INTRODUCTION) || this.programElementNode.getProgramElementKind().equals(ProgramElementNode.Kind.CODE)) {
            ProgramElementNode pe_grandparent;
            name = this.programElementNode.parent.toString() + ": " + this.programElementNode.getName();
            StructureNode grandparent = this.programElementNode.parent.parent;
            if (grandparent instanceof ProgramElementNode && ((pe_grandparent = (ProgramElementNode)grandparent).getProgramElementKind().equals(ProgramElementNode.Kind.CLASS) || pe_grandparent.getProgramElementKind().equals(ProgramElementNode.Kind.INTERFACE))) {
                name = pe_grandparent.toString() + "." + name;
            }
        } else {
            name = this.programElementNode.isMemberKind() ? this.programElementNode.parent.toString() + '.' + this.programElementNode.getName() : this.programElementNode.toString();
        }
        return name;
    }
}

