/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.ajdt.internal.core.builder;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.asm.LinkNode;
import org.aspectj.asm.ProgramElementNode;
import org.aspectj.asm.RelationNode;
import org.aspectj.asm.StructureModelManager;
import org.aspectj.asm.StructureNode;

public class EmacsStructureModelManager {
    private static final String EXTERN_FILE_SUFFIX = ".ajesym";

    public void externalizeModel() {
        if (!StructureModelManager.INSTANCE.getStructureModel().isValid()) {
            return;
        }
        try {
            Set fileSet = StructureModelManager.INSTANCE.getStructureModel().getFileMapEntrySet();
            Iterator it = fileSet.iterator();
            while (it.hasNext()) {
                ProgramElementNode peNode = (ProgramElementNode)((Map.Entry)it.next()).getValue();
                this.dumpStructureToFile(peNode);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void dumpStructureToFile(ProgramElementNode node) throws IOException {
        String s = node.getKind();
        if (!s.equals(ProgramElementNode.Kind.FILE_ASPECTJ.toString()) && !s.equals(ProgramElementNode.Kind.FILE_JAVA.toString())) {
            throw new IllegalArgumentException("externalize file, not " + node);
        }
        String sourceName = node.getSourceLocation().getSourceFile().getAbsolutePath();
        String fileName = sourceName.substring(0, sourceName.lastIndexOf(".")) + EXTERN_FILE_SUFFIX;
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(new File(fileName)));
            new SExpressionPrinter(writer).printDecls(node);
            writer.flush();
            Object var7_6 = null;
            if (writer == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (writer == null) throw throwable;
            try {
                writer.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            writer.close();
            return;
        }
        catch (IOException e) {}
    }

    private static class SExpressionPrinter {
        private BufferedWriter writer = null;

        public SExpressionPrinter(BufferedWriter writer) {
            this.writer = writer;
        }

        private void printDecls(ProgramElementNode node) {
            this.print("(");
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                StructureNode child;
                Object nodeObject = it.next();
                if (nodeObject instanceof ProgramElementNode) {
                    child = (ProgramElementNode)nodeObject;
                    this.printDecl((ProgramElementNode)child, true);
                    continue;
                }
                if (!(nodeObject instanceof LinkNode)) continue;
                child = (LinkNode)nodeObject;
                this.printDecl(((LinkNode)child).getProgramElementNode(), false);
            }
            this.print(") ");
        }

        private void printDecls(RelationNode node) {
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                LinkNode child;
                Object nodeObject = it.next();
                if (!(nodeObject instanceof LinkNode) || (child = (LinkNode)nodeObject).getProgramElementNode().getKind().equals("<undefined>")) continue;
                this.printDecl(child.getProgramElementNode(), false);
            }
        }

        private void printDecl(ProgramElementNode node, boolean recurse) {
            if (node == null || node.getSourceLocation() == null) {
                return;
            }
            String kind = node.getKind().toLowerCase();
            this.print("(");
            this.print("(" + node.getSourceLocation().getLine() + " . " + node.getSourceLocation().getColumn() + ") ");
            this.print("(" + node.getSourceLocation().getLine() + " . " + node.getSourceLocation().getColumn() + ") ");
            this.print(kind + " ");
            String displayName = node.toString().replace('\"', ' ');
            this.print("\"" + displayName + "\" ");
            if (node.getSourceLocation().getSourceFile().getAbsolutePath() != null) {
                this.print("\"" + this.fixFilename(node.getSourceLocation().getSourceFile().getAbsolutePath()) + "\"");
            } else {
                this.print("nil");
            }
            if (node.getSignature() != null) {
                this.print("\"" + node.getDeclaringType() + "\" ");
            } else {
                this.print("nil");
            }
            if (!recurse) {
                this.print("nil");
                this.print("nil");
                this.print("nil");
            } else {
                List relations;
                this.print("(");
                if (node instanceof ProgramElementNode && (relations = node.getRelations()) != null) {
                    Iterator it = relations.iterator();
                    while (it.hasNext()) {
                        RelationNode relNode = (RelationNode)it.next();
                        if (!relNode.getRelation().getAssociationName().equals("Advice") && !relNode.getRelation().getAssociationName().equals("Introduction")) continue;
                        this.printDecls(relNode);
                    }
                }
                this.print(") ");
                this.print("(");
                this.print(") ");
                this.print("(");
                Iterator it3 = node.getChildren().iterator();
                if (it3.hasNext()) {
                    while (it3.hasNext()) {
                        ProgramElementNode currNode;
                        Object nodeObject = it3.next();
                        if (!(nodeObject instanceof ProgramElementNode) || (currNode = (ProgramElementNode)nodeObject).getKind().equals("<undefined>")) continue;
                        this.printDecl(currNode, true);
                    }
                }
                this.print(") ");
            }
            this.print(node.getKind().equals("class") ? "t " : "nil ");
            this.print(node.getKind().equals("introduction") ? "nil " : "nil ");
            this.print("nil ");
            this.print("nil ");
            this.print(")");
        }

        String fixFilename(String filename) {
            return this.subst("\\\\", "\\", filename);
        }

        private void print(String string) {
            try {
                this.writer.write(string + "\n");
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }

        private String subst(String n, String o, String in) {
            int pos = in.indexOf(o);
            if (pos == -1) {
                return in;
            }
            return in.substring(0, pos) + n + this.subst(n, o, in.substring(pos + o.length()));
        }

        private void lose(Error e) {
            try {
                this.print("(ERROR \"" + e.toString() + "\")");
            }
            catch (Error error) {
                // empty catch block
            }
        }
    }
}

